// qtwebengine/browser/qtwebenginepage.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "qtwebengine/browser/qtwebenginepage.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "qtwebengine/browser/qtwebenginepage.mojom-params-data.h"
#include "qtwebengine/browser/qtwebenginepage.mojom-shared-message-ids.h"

#include "qtwebengine/browser/qtwebenginepage.mojom-import-headers.h"


#ifndef QTWEBENGINE_BROWSER_QTWEBENGINEPAGE_MOJOM_JUMBO_H_
#define QTWEBENGINE_BROWSER_QTWEBENGINEPAGE_MOJOM_JUMBO_H_
#endif
namespace qtwebenginepage {
namespace mojom {
const char WebEnginePageRenderFrame::Name_[] = "qtwebenginepage.mojom.WebEnginePageRenderFrame";

class WebEnginePageRenderFrame_FetchDocumentMarkup_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  WebEnginePageRenderFrame_FetchDocumentMarkup_ForwardToCallback(
      WebEnginePageRenderFrame::FetchDocumentMarkupCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  WebEnginePageRenderFrame::FetchDocumentMarkupCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(WebEnginePageRenderFrame_FetchDocumentMarkup_ForwardToCallback);
};

class WebEnginePageRenderFrame_FetchDocumentInnerText_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  WebEnginePageRenderFrame_FetchDocumentInnerText_ForwardToCallback(
      WebEnginePageRenderFrame::FetchDocumentInnerTextCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  WebEnginePageRenderFrame::FetchDocumentInnerTextCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(WebEnginePageRenderFrame_FetchDocumentInnerText_ForwardToCallback);
};

WebEnginePageRenderFrameProxy::WebEnginePageRenderFrameProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void WebEnginePageRenderFrameProxy::FetchDocumentMarkup(
    uint64_t in_requestId, FetchDocumentMarkupCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "qtwebenginepage::mojom::WebEnginePageRenderFrame::FetchDocumentMarkup", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("requestId"), in_requestId, 
                        "<value of type uint64_t>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kWebEnginePageRenderFrame_FetchDocumentMarkup_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::qtwebenginepage::mojom::internal::WebEnginePageRenderFrame_FetchDocumentMarkup_Params_Data> params(
          message);
  params.Allocate();
  params->requestId = in_requestId;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebEnginePageRenderFrame::Name_);
  message.set_method_name("FetchDocumentMarkup");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new WebEnginePageRenderFrame_FetchDocumentMarkup_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void WebEnginePageRenderFrameProxy::FetchDocumentInnerText(
    uint64_t in_requestId, FetchDocumentInnerTextCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "qtwebenginepage::mojom::WebEnginePageRenderFrame::FetchDocumentInnerText", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("requestId"), in_requestId, 
                        "<value of type uint64_t>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kWebEnginePageRenderFrame_FetchDocumentInnerText_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::qtwebenginepage::mojom::internal::WebEnginePageRenderFrame_FetchDocumentInnerText_Params_Data> params(
          message);
  params.Allocate();
  params->requestId = in_requestId;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebEnginePageRenderFrame::Name_);
  message.set_method_name("FetchDocumentInnerText");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new WebEnginePageRenderFrame_FetchDocumentInnerText_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void WebEnginePageRenderFrameProxy::SetBackgroundColor(
    uint32_t in_color) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "qtwebenginepage::mojom::WebEnginePageRenderFrame::SetBackgroundColor", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("color"), in_color, 
                        "<value of type uint32_t>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kWebEnginePageRenderFrame_SetBackgroundColor_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::qtwebenginepage::mojom::internal::WebEnginePageRenderFrame_SetBackgroundColor_Params_Data> params(
          message);
  params.Allocate();
  params->color = in_color;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebEnginePageRenderFrame::Name_);
  message.set_method_name("SetBackgroundColor");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}
class WebEnginePageRenderFrame_FetchDocumentMarkup_ProxyToResponder {
 public:
  static WebEnginePageRenderFrame::FetchDocumentMarkupCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<WebEnginePageRenderFrame_FetchDocumentMarkup_ProxyToResponder> proxy(
        new WebEnginePageRenderFrame_FetchDocumentMarkup_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&WebEnginePageRenderFrame_FetchDocumentMarkup_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~WebEnginePageRenderFrame_FetchDocumentMarkup_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  WebEnginePageRenderFrame_FetchDocumentMarkup_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "WebEnginePageRenderFrame::FetchDocumentMarkupCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      uint64_t in_requestId, const std::string& in_markup);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(WebEnginePageRenderFrame_FetchDocumentMarkup_ProxyToResponder);
};

bool WebEnginePageRenderFrame_FetchDocumentMarkup_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "qtwebenginepage::mojom::WebEnginePageRenderFrame::FetchDocumentMarkupCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::WebEnginePageRenderFrame_FetchDocumentMarkup_ResponseParams_Data* params =
      reinterpret_cast<
          internal::WebEnginePageRenderFrame_FetchDocumentMarkup_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  uint64_t p_requestId{};
  std::string p_markup{};
  WebEnginePageRenderFrame_FetchDocumentMarkup_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_requestId = input_data_view.requestId();
  if (success && !input_data_view.ReadMarkup(&p_markup))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        WebEnginePageRenderFrame::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_requestId), 
std::move(p_markup));
  return true;
}

void WebEnginePageRenderFrame_FetchDocumentMarkup_ProxyToResponder::Run(
    uint64_t in_requestId, const std::string& in_markup) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)qtwebenginepage::mojom::WebEnginePageRenderFrame::FetchDocumentMarkupCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("requestId"), in_requestId, 
                        "<value of type uint64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("markup"), in_markup, 
                        "<value of type const std::string&>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kWebEnginePageRenderFrame_FetchDocumentMarkup_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::qtwebenginepage::mojom::internal::WebEnginePageRenderFrame_FetchDocumentMarkup_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->requestId = in_requestId;
  mojo::internal::MessageFragment<
      typename decltype(params->markup)::BaseType> markup_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_markup, markup_fragment);
  params->markup.Set(
      markup_fragment.is_null() ? nullptr : markup_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->markup.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null markup in ");

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)qtwebenginepage::mojom::WebEnginePageRenderFrame::FetchDocumentMarkupCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebEnginePageRenderFrame::Name_);
  message.set_method_name("FetchDocumentMarkup");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class WebEnginePageRenderFrame_FetchDocumentInnerText_ProxyToResponder {
 public:
  static WebEnginePageRenderFrame::FetchDocumentInnerTextCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<WebEnginePageRenderFrame_FetchDocumentInnerText_ProxyToResponder> proxy(
        new WebEnginePageRenderFrame_FetchDocumentInnerText_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&WebEnginePageRenderFrame_FetchDocumentInnerText_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~WebEnginePageRenderFrame_FetchDocumentInnerText_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  WebEnginePageRenderFrame_FetchDocumentInnerText_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "WebEnginePageRenderFrame::FetchDocumentInnerTextCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      uint64_t in_requestId, const std::string& in_text);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(WebEnginePageRenderFrame_FetchDocumentInnerText_ProxyToResponder);
};

bool WebEnginePageRenderFrame_FetchDocumentInnerText_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "qtwebenginepage::mojom::WebEnginePageRenderFrame::FetchDocumentInnerTextCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::WebEnginePageRenderFrame_FetchDocumentInnerText_ResponseParams_Data* params =
      reinterpret_cast<
          internal::WebEnginePageRenderFrame_FetchDocumentInnerText_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  uint64_t p_requestId{};
  std::string p_text{};
  WebEnginePageRenderFrame_FetchDocumentInnerText_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_requestId = input_data_view.requestId();
  if (success && !input_data_view.ReadText(&p_text))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        WebEnginePageRenderFrame::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_requestId), 
std::move(p_text));
  return true;
}

void WebEnginePageRenderFrame_FetchDocumentInnerText_ProxyToResponder::Run(
    uint64_t in_requestId, const std::string& in_text) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)qtwebenginepage::mojom::WebEnginePageRenderFrame::FetchDocumentInnerTextCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("requestId"), in_requestId, 
                        "<value of type uint64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("text"), in_text, 
                        "<value of type const std::string&>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kWebEnginePageRenderFrame_FetchDocumentInnerText_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::qtwebenginepage::mojom::internal::WebEnginePageRenderFrame_FetchDocumentInnerText_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->requestId = in_requestId;
  mojo::internal::MessageFragment<
      typename decltype(params->text)::BaseType> text_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_text, text_fragment);
  params->text.Set(
      text_fragment.is_null() ? nullptr : text_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->text.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null text in ");

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)qtwebenginepage::mojom::WebEnginePageRenderFrame::FetchDocumentInnerTextCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebEnginePageRenderFrame::Name_);
  message.set_method_name("FetchDocumentInnerText");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool WebEnginePageRenderFrameStubDispatch::Accept(
    WebEnginePageRenderFrame* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kWebEnginePageRenderFrame_FetchDocumentMarkup_Name: {
      break;
    }
    case internal::kWebEnginePageRenderFrame_FetchDocumentInnerText_Name: {
      break;
    }
    case internal::kWebEnginePageRenderFrame_SetBackgroundColor_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)qtwebenginepage::mojom::WebEnginePageRenderFrame::SetBackgroundColor",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)qtwebenginepage::mojom::WebEnginePageRenderFrame::SetBackgroundColor");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::WebEnginePageRenderFrame_SetBackgroundColor_Params_Data* params =
          reinterpret_cast<internal::WebEnginePageRenderFrame_SetBackgroundColor_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      uint32_t p_color{};
      WebEnginePageRenderFrame_SetBackgroundColor_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_color = input_data_view.color();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebEnginePageRenderFrame::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetBackgroundColor(
std::move(p_color));
      return true;
    }
  }
  return false;
}

// static
bool WebEnginePageRenderFrameStubDispatch::AcceptWithResponder(
    WebEnginePageRenderFrame* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kWebEnginePageRenderFrame_FetchDocumentMarkup_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)qtwebenginepage::mojom::WebEnginePageRenderFrame::FetchDocumentMarkup",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)qtwebenginepage::mojom::WebEnginePageRenderFrame::FetchDocumentMarkup");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::WebEnginePageRenderFrame_FetchDocumentMarkup_Params_Data* params =
          reinterpret_cast<
              internal::WebEnginePageRenderFrame_FetchDocumentMarkup_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      uint64_t p_requestId{};
      WebEnginePageRenderFrame_FetchDocumentMarkup_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_requestId = input_data_view.requestId();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebEnginePageRenderFrame::Name_, 0, false);
        return false;
      }
      WebEnginePageRenderFrame::FetchDocumentMarkupCallback callback =
          WebEnginePageRenderFrame_FetchDocumentMarkup_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->FetchDocumentMarkup(
std::move(p_requestId), std::move(callback));
      return true;
    }
    case internal::kWebEnginePageRenderFrame_FetchDocumentInnerText_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)qtwebenginepage::mojom::WebEnginePageRenderFrame::FetchDocumentInnerText",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)qtwebenginepage::mojom::WebEnginePageRenderFrame::FetchDocumentInnerText");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::WebEnginePageRenderFrame_FetchDocumentInnerText_Params_Data* params =
          reinterpret_cast<
              internal::WebEnginePageRenderFrame_FetchDocumentInnerText_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      uint64_t p_requestId{};
      WebEnginePageRenderFrame_FetchDocumentInnerText_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_requestId = input_data_view.requestId();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebEnginePageRenderFrame::Name_, 1, false);
        return false;
      }
      WebEnginePageRenderFrame::FetchDocumentInnerTextCallback callback =
          WebEnginePageRenderFrame_FetchDocumentInnerText_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->FetchDocumentInnerText(
std::move(p_requestId), std::move(callback));
      return true;
    }
    case internal::kWebEnginePageRenderFrame_SetBackgroundColor_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kWebEnginePageRenderFrameValidationInfo[] = {
    {internal::kWebEnginePageRenderFrame_FetchDocumentMarkup_Name,
     {&internal::WebEnginePageRenderFrame_FetchDocumentMarkup_Params_Data::Validate,
      &internal::WebEnginePageRenderFrame_FetchDocumentMarkup_ResponseParams_Data::Validate}},
    {internal::kWebEnginePageRenderFrame_FetchDocumentInnerText_Name,
     {&internal::WebEnginePageRenderFrame_FetchDocumentInnerText_Params_Data::Validate,
      &internal::WebEnginePageRenderFrame_FetchDocumentInnerText_ResponseParams_Data::Validate}},
    {internal::kWebEnginePageRenderFrame_SetBackgroundColor_Name,
     {&internal::WebEnginePageRenderFrame_SetBackgroundColor_Params_Data::Validate,
      nullptr /* no response */}},
};

bool WebEnginePageRenderFrameRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::qtwebenginepage::mojom::WebEnginePageRenderFrame::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kWebEnginePageRenderFrameValidationInfo);
}

bool WebEnginePageRenderFrameResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::qtwebenginepage::mojom::WebEnginePageRenderFrame::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kWebEnginePageRenderFrameValidationInfo);

}
}  // namespace mojom
}  // namespace qtwebenginepage

namespace mojo {

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif