// Copyright 2022 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// GENERATED FROM THE API DEFINITION IN
//   qtwebengine/common/extensions/api/tabs.json
// DO NOT EDIT.

#include "tools/json_schema_compiler/util.h"
#include "base/check.h"
#include "base/check_op.h"
#include "base/notreached.h"
#include "base/strings/string_number_conversions.h"
#include "base/strings/utf_string_conversions.h"
#include "base/values.h"
#include "qtwebengine/common/extensions/api/tabs.h"
#include <set>
#include <utility>

using base::UTF8ToUTF16;

namespace extensions {
namespace api {
namespace tabs {
//
// Properties
//

const int TAB_ID_NONE = -1;

//
// Types
//

Tab::Tab()
: id(0),
index(0),
window_id(0),
selected(false),
highlighted(false),
active(false),
pinned(false),
incognito(false) {}

Tab::~Tab() = default;
Tab::Tab(Tab&& rhs) = default;
Tab& Tab::operator=(Tab&& rhs) = default;
// static
bool Tab::Populate(
    const base::Value& value, Tab* out) {
  if (!value.is_dict()) {
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* id_value = nullptr;
  if (!dict->GetWithoutPathExpansion("id", &id_value)) {
    return false;
  }
  {
    if (!id_value->GetAsInteger(&out->id)) {
      return false;
    }
  }

  const base::Value* index_value = nullptr;
  if (!dict->GetWithoutPathExpansion("index", &index_value)) {
    return false;
  }
  {
    if (!index_value->GetAsInteger(&out->index)) {
      return false;
    }
  }

  const base::Value* window_id_value = nullptr;
  if (!dict->GetWithoutPathExpansion("windowId", &window_id_value)) {
    return false;
  }
  {
    if (!window_id_value->GetAsInteger(&out->window_id)) {
      return false;
    }
  }

  const base::Value* selected_value = nullptr;
  if (!dict->GetWithoutPathExpansion("selected", &selected_value)) {
    return false;
  }
  {
    if (!selected_value->GetAsBoolean(&out->selected)) {
      return false;
    }
  }

  const base::Value* highlighted_value = nullptr;
  if (!dict->GetWithoutPathExpansion("highlighted", &highlighted_value)) {
    return false;
  }
  {
    if (!highlighted_value->GetAsBoolean(&out->highlighted)) {
      return false;
    }
  }

  const base::Value* active_value = nullptr;
  if (!dict->GetWithoutPathExpansion("active", &active_value)) {
    return false;
  }
  {
    if (!active_value->GetAsBoolean(&out->active)) {
      return false;
    }
  }

  const base::Value* pinned_value = nullptr;
  if (!dict->GetWithoutPathExpansion("pinned", &pinned_value)) {
    return false;
  }
  {
    if (!pinned_value->GetAsBoolean(&out->pinned)) {
      return false;
    }
  }

  const base::Value* url_value = nullptr;
  if (!dict->GetWithoutPathExpansion("url", &url_value)) {
    return false;
  }
  {
    if (!url_value->GetAsString(&out->url)) {
      return false;
    }
  }

  const base::Value* title_value = nullptr;
  if (dict->GetWithoutPathExpansion("title", &title_value)) {
    {
      std::string temp;
      if (!title_value->GetAsString(&temp)) {
        out->title.reset();
        return false;
      }
      else
        out->title = std::make_unique<std::string>(temp);
    }
  }

  const base::Value* fav_icon_url_value = nullptr;
  if (dict->GetWithoutPathExpansion("favIconUrl", &fav_icon_url_value)) {
    {
      std::string temp;
      if (!fav_icon_url_value->GetAsString(&temp)) {
        out->fav_icon_url.reset();
        return false;
      }
      else
        out->fav_icon_url = std::make_unique<std::string>(temp);
    }
  }

  const base::Value* status_value = nullptr;
  if (dict->GetWithoutPathExpansion("status", &status_value)) {
    {
      std::string temp;
      if (!status_value->GetAsString(&temp)) {
        out->status.reset();
        return false;
      }
      else
        out->status = std::make_unique<std::string>(temp);
    }
  }

  const base::Value* incognito_value = nullptr;
  if (!dict->GetWithoutPathExpansion("incognito", &incognito_value)) {
    return false;
  }
  {
    if (!incognito_value->GetAsBoolean(&out->incognito)) {
      return false;
    }
  }

  return true;
}

// static
std::unique_ptr<Tab> Tab::FromValue(const base::Value& value) {
  auto out = std::make_unique<Tab>();
  bool result = Populate(value, out.get());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> Tab::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  to_value_result->SetWithoutPathExpansion("id", std::make_unique<base::Value>(this->id));

  to_value_result->SetWithoutPathExpansion("index", std::make_unique<base::Value>(this->index));

  to_value_result->SetWithoutPathExpansion("windowId", std::make_unique<base::Value>(this->window_id));

  to_value_result->SetWithoutPathExpansion("selected", std::make_unique<base::Value>(this->selected));

  to_value_result->SetWithoutPathExpansion("highlighted", std::make_unique<base::Value>(this->highlighted));

  to_value_result->SetWithoutPathExpansion("active", std::make_unique<base::Value>(this->active));

  to_value_result->SetWithoutPathExpansion("pinned", std::make_unique<base::Value>(this->pinned));

  to_value_result->SetWithoutPathExpansion("url", std::make_unique<base::Value>(this->url));

  if (this->title.get()) {
    to_value_result->SetWithoutPathExpansion("title", std::make_unique<base::Value>(*this->title));

  }
  if (this->fav_icon_url.get()) {
    to_value_result->SetWithoutPathExpansion("favIconUrl", std::make_unique<base::Value>(*this->fav_icon_url));

  }
  if (this->status.get()) {
    to_value_result->SetWithoutPathExpansion("status", std::make_unique<base::Value>(*this->status));

  }
  to_value_result->SetWithoutPathExpansion("incognito", std::make_unique<base::Value>(this->incognito));


  return to_value_result;
}



//
// Functions
//

namespace Update {

Params::UpdateProperties::UpdateProperties()
 {}

Params::UpdateProperties::~UpdateProperties() = default;
Params::UpdateProperties::UpdateProperties(UpdateProperties&& rhs) = default;
Params::UpdateProperties& Params::UpdateProperties::operator=(UpdateProperties&& rhs) = default;
// static
bool Params::UpdateProperties::Populate(
    const base::Value& value, UpdateProperties* out) {
  if (!value.is_dict()) {
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* url_value = nullptr;
  if (dict->GetWithoutPathExpansion("url", &url_value)) {
    {
      std::string temp;
      if (!url_value->GetAsString(&temp)) {
        out->url.reset();
        return false;
      }
      else
        out->url = std::make_unique<std::string>(temp);
    }
  }

  const base::Value* active_value = nullptr;
  if (dict->GetWithoutPathExpansion("active", &active_value)) {
    {
      bool temp;
      if (!active_value->GetAsBoolean(&temp)) {
        out->active.reset();
        return false;
      }
      else
        out->active = std::make_unique<bool>(temp);
    }
  }

  const base::Value* highlighted_value = nullptr;
  if (dict->GetWithoutPathExpansion("highlighted", &highlighted_value)) {
    {
      bool temp;
      if (!highlighted_value->GetAsBoolean(&temp)) {
        out->highlighted.reset();
        return false;
      }
      else
        out->highlighted = std::make_unique<bool>(temp);
    }
  }

  const base::Value* selected_value = nullptr;
  if (dict->GetWithoutPathExpansion("selected", &selected_value)) {
    {
      bool temp;
      if (!selected_value->GetAsBoolean(&temp)) {
        out->selected.reset();
        return false;
      }
      else
        out->selected = std::make_unique<bool>(temp);
    }
  }

  const base::Value* pinned_value = nullptr;
  if (dict->GetWithoutPathExpansion("pinned", &pinned_value)) {
    {
      bool temp;
      if (!pinned_value->GetAsBoolean(&temp)) {
        out->pinned.reset();
        return false;
      }
      else
        out->pinned = std::make_unique<bool>(temp);
    }
  }

  const base::Value* muted_value = nullptr;
  if (dict->GetWithoutPathExpansion("muted", &muted_value)) {
    {
      bool temp;
      if (!muted_value->GetAsBoolean(&temp)) {
        out->muted.reset();
        return false;
      }
      else
        out->muted = std::make_unique<bool>(temp);
    }
  }

  const base::Value* opener_tab_id_value = nullptr;
  if (dict->GetWithoutPathExpansion("openerTabId", &opener_tab_id_value)) {
    {
      int temp;
      if (!opener_tab_id_value->GetAsInteger(&temp)) {
        out->opener_tab_id.reset();
        return false;
      }
      else
        out->opener_tab_id = std::make_unique<int>(temp);
    }
  }

  const base::Value* auto_discardable_value = nullptr;
  if (dict->GetWithoutPathExpansion("autoDiscardable", &auto_discardable_value)) {
    {
      bool temp;
      if (!auto_discardable_value->GetAsBoolean(&temp)) {
        out->auto_discardable.reset();
        return false;
      }
      else
        out->auto_discardable = std::make_unique<bool>(temp);
    }
  }

  return true;
}


Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args) {
  if (args.GetSize() < 1 || args.GetSize() > 2) {
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* tab_id_value = nullptr;
  if (args.Get(0, &tab_id_value) &&
      !tab_id_value->is_none()) {
    {
      int temp;
      if (!tab_id_value->GetAsInteger(&temp)) {
        params->tab_id.reset();
        return std::unique_ptr<Params>();
      }
      else
        params->tab_id = std::make_unique<int>(temp);
    }
  }

  const base::Value* update_properties_value = nullptr;
  if (args.Get(1, &update_properties_value) &&
      !update_properties_value->is_none()) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!update_properties_value->GetAsDictionary(&dictionary)) {
        return std::unique_ptr<Params>();
      }
      if (!UpdateProperties::Populate(*dictionary, &params->update_properties)) {
        return std::unique_ptr<Params>();
      }
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  return params;
}


std::unique_ptr<base::ListValue> Results::Create(const Tab& tab) {
  auto create_results = std::make_unique<base::ListValue>();
  create_results->Append((tab).ToValue());

  return create_results;
}
}  // namespace Update

}  // namespace tabs
}  // namespace api
}  // namespace extensions

