// services/audio/public/mojom/stream_factory.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/audio/public/mojom/stream_factory.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "services/audio/public/mojom/stream_factory.mojom-params-data.h"
#include "services/audio/public/mojom/stream_factory.mojom-shared-message-ids.h"

#include "services/audio/public/mojom/stream_factory.mojom-import-headers.h"


#ifndef SERVICES_AUDIO_PUBLIC_MOJOM_STREAM_FACTORY_MOJOM_JUMBO_H_
#define SERVICES_AUDIO_PUBLIC_MOJOM_STREAM_FACTORY_MOJOM_JUMBO_H_
#endif
namespace audio {
namespace mojom {
const char LocalMuter::Name_[] = "audio.mojom.LocalMuter";

LocalMuterProxy::LocalMuterProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

// static
bool LocalMuterStubDispatch::Accept(
    LocalMuter* impl,
    mojo::Message* message) {
  return false;
}

// static
bool LocalMuterStubDispatch::AcceptWithResponder(
    LocalMuter* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  return false;
}



bool LocalMuterRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::audio::mojom::LocalMuter::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, {});
}

const char StreamFactory::Name_[] = "audio.mojom.StreamFactory";

class StreamFactory_CreateInputStream_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  StreamFactory_CreateInputStream_ForwardToCallback(
      StreamFactory::CreateInputStreamCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  StreamFactory::CreateInputStreamCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(StreamFactory_CreateInputStream_ForwardToCallback);
};

class StreamFactory_CreateOutputStream_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  StreamFactory_CreateOutputStream_ForwardToCallback(
      StreamFactory::CreateOutputStreamCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  StreamFactory::CreateOutputStreamCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(StreamFactory_CreateOutputStream_ForwardToCallback);
};

class StreamFactory_CreateLoopbackStream_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  StreamFactory_CreateLoopbackStream_ForwardToCallback(
      StreamFactory::CreateLoopbackStreamCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  StreamFactory::CreateLoopbackStreamCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(StreamFactory_CreateLoopbackStream_ForwardToCallback);
};

StreamFactoryProxy::StreamFactoryProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void StreamFactoryProxy::CreateInputStream(
    ::mojo::PendingReceiver<::media::mojom::AudioInputStream> in_stream, ::mojo::PendingRemote<::media::mojom::AudioInputStreamClient> in_client, ::mojo::PendingRemote<::media::mojom::AudioInputStreamObserver> in_observer, ::mojo::PendingRemote<::media::mojom::AudioLog> in_log, const std::string& in_device_id, const ::media::AudioParameters& in_params, uint32_t in_shared_memory_count, bool in_enable_agc, ::base::ReadOnlySharedMemoryRegion in_key_press_count_buffer, CreateInputStreamCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "audio::mojom::StreamFactory::CreateInputStream", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("stream"), in_stream, 
                        "<value of type ::mojo::PendingReceiver<::media::mojom::AudioInputStream>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client"), in_client, 
                        "<value of type ::mojo::PendingRemote<::media::mojom::AudioInputStreamClient>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("observer"), in_observer, 
                        "<value of type ::mojo::PendingRemote<::media::mojom::AudioInputStreamObserver>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("log"), in_log, 
                        "<value of type ::mojo::PendingRemote<::media::mojom::AudioLog>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("device_id"), in_device_id, 
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("params"), in_params, 
                        "<value of type const ::media::AudioParameters&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("shared_memory_count"), in_shared_memory_count, 
                        "<value of type uint32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("enable_agc"), in_enable_agc, 
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("key_press_count_buffer"), in_key_press_count_buffer, 
                        "<value of type ::base::ReadOnlySharedMemoryRegion>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kStreamFactory_CreateInputStream_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::audio::mojom::internal::StreamFactory_CreateInputStream_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::media::mojom::AudioInputStreamInterfaceBase>>(
      in_stream, &params->stream, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->stream),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid stream in StreamFactory.CreateInputStream request");
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::media::mojom::AudioInputStreamClientInterfaceBase>>(
      in_client, &params->client, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->client),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid client in StreamFactory.CreateInputStream request");
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::media::mojom::AudioInputStreamObserverInterfaceBase>>(
      in_observer, &params->observer, &params.message());
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::media::mojom::AudioLogInterfaceBase>>(
      in_log, &params->log, &params.message());
  mojo::internal::MessageFragment<
      typename decltype(params->device_id)::BaseType> device_id_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_device_id, device_id_fragment);
  params->device_id.Set(
      device_id_fragment.is_null() ? nullptr : device_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->device_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null device_id in StreamFactory.CreateInputStream request");
  mojo::internal::MessageFragment<
      typename decltype(params->params)::BaseType> params_fragment(
          params.message());
  mojo::internal::Serialize<::media::mojom::AudioParametersDataView>(
      in_params, params_fragment);
  params->params.Set(
      params_fragment.is_null() ? nullptr : params_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->params.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null params in StreamFactory.CreateInputStream request");
  params->shared_memory_count = in_shared_memory_count;
  params->enable_agc = in_enable_agc;
  mojo::internal::MessageFragment<
      typename decltype(params->key_press_count_buffer)::BaseType> key_press_count_buffer_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::ReadOnlySharedMemoryRegionDataView>(
      in_key_press_count_buffer, key_press_count_buffer_fragment);
  params->key_press_count_buffer.Set(
      key_press_count_buffer_fragment.is_null() ? nullptr : key_press_count_buffer_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(StreamFactory::Name_);
  message.set_method_name("CreateInputStream");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new StreamFactory_CreateInputStream_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void StreamFactoryProxy::AssociateInputAndOutputForAec(
    const ::base::UnguessableToken& in_input_stream_id, const std::string& in_output_device_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "audio::mojom::StreamFactory::AssociateInputAndOutputForAec", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("input_stream_id"), in_input_stream_id, 
                        "<value of type const ::base::UnguessableToken&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("output_device_id"), in_output_device_id, 
                        "<value of type const std::string&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kStreamFactory_AssociateInputAndOutputForAec_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::audio::mojom::internal::StreamFactory_AssociateInputAndOutputForAec_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->input_stream_id)::BaseType> input_stream_id_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
      in_input_stream_id, input_stream_id_fragment);
  params->input_stream_id.Set(
      input_stream_id_fragment.is_null() ? nullptr : input_stream_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->input_stream_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null input_stream_id in StreamFactory.AssociateInputAndOutputForAec request");
  mojo::internal::MessageFragment<
      typename decltype(params->output_device_id)::BaseType> output_device_id_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_output_device_id, output_device_id_fragment);
  params->output_device_id.Set(
      output_device_id_fragment.is_null() ? nullptr : output_device_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->output_device_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null output_device_id in StreamFactory.AssociateInputAndOutputForAec request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(StreamFactory::Name_);
  message.set_method_name("AssociateInputAndOutputForAec");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void StreamFactoryProxy::CreateOutputStream(
    ::mojo::PendingReceiver<::media::mojom::AudioOutputStream> in_stream, ::mojo::PendingAssociatedRemote<::media::mojom::AudioOutputStreamObserver> in_observer, ::mojo::PendingRemote<::media::mojom::AudioLog> in_log, const std::string& in_device_id, const ::media::AudioParameters& in_params, const ::base::UnguessableToken& in_group_id, CreateOutputStreamCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "audio::mojom::StreamFactory::CreateOutputStream", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("stream"), in_stream, 
                        "<value of type ::mojo::PendingReceiver<::media::mojom::AudioOutputStream>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("observer"), in_observer, 
                        "<value of type ::mojo::PendingAssociatedRemote<::media::mojom::AudioOutputStreamObserver>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("log"), in_log, 
                        "<value of type ::mojo::PendingRemote<::media::mojom::AudioLog>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("device_id"), in_device_id, 
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("params"), in_params, 
                        "<value of type const ::media::AudioParameters&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("group_id"), in_group_id, 
                        "<value of type const ::base::UnguessableToken&>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kStreamFactory_CreateOutputStream_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::audio::mojom::internal::StreamFactory_CreateOutputStream_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::media::mojom::AudioOutputStreamInterfaceBase>>(
      in_stream, &params->stream, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->stream),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid stream in StreamFactory.CreateOutputStream request");
  mojo::internal::Serialize<::media::mojom::AudioOutputStreamObserverAssociatedPtrInfoDataView>(
      in_observer, &params->observer, &params.message());
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::media::mojom::AudioLogInterfaceBase>>(
      in_log, &params->log, &params.message());
  mojo::internal::MessageFragment<
      typename decltype(params->device_id)::BaseType> device_id_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_device_id, device_id_fragment);
  params->device_id.Set(
      device_id_fragment.is_null() ? nullptr : device_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->device_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null device_id in StreamFactory.CreateOutputStream request");
  mojo::internal::MessageFragment<
      typename decltype(params->params)::BaseType> params_fragment(
          params.message());
  mojo::internal::Serialize<::media::mojom::AudioParametersDataView>(
      in_params, params_fragment);
  params->params.Set(
      params_fragment.is_null() ? nullptr : params_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->params.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null params in StreamFactory.CreateOutputStream request");
  mojo::internal::MessageFragment<
      typename decltype(params->group_id)::BaseType> group_id_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
      in_group_id, group_id_fragment);
  params->group_id.Set(
      group_id_fragment.is_null() ? nullptr : group_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->group_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null group_id in StreamFactory.CreateOutputStream request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(StreamFactory::Name_);
  message.set_method_name("CreateOutputStream");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new StreamFactory_CreateOutputStream_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void StreamFactoryProxy::BindMuter(
    ::mojo::PendingAssociatedReceiver<LocalMuter> in_receiver, const ::base::UnguessableToken& in_group_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "audio::mojom::StreamFactory::BindMuter", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver, 
                        "<value of type ::mojo::PendingAssociatedReceiver<LocalMuter>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("group_id"), in_group_id, 
                        "<value of type const ::base::UnguessableToken&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kStreamFactory_BindMuter_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::audio::mojom::internal::StreamFactory_BindMuter_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::audio::mojom::LocalMuterAssociatedRequestDataView>(
      in_receiver, &params->receiver, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->receiver),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
      "invalid receiver in StreamFactory.BindMuter request");
  mojo::internal::MessageFragment<
      typename decltype(params->group_id)::BaseType> group_id_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
      in_group_id, group_id_fragment);
  params->group_id.Set(
      group_id_fragment.is_null() ? nullptr : group_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->group_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null group_id in StreamFactory.BindMuter request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(StreamFactory::Name_);
  message.set_method_name("BindMuter");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void StreamFactoryProxy::CreateLoopbackStream(
    ::mojo::PendingReceiver<::media::mojom::AudioInputStream> in_receiver, ::mojo::PendingRemote<::media::mojom::AudioInputStreamClient> in_client, ::mojo::PendingRemote<::media::mojom::AudioInputStreamObserver> in_observer, const ::media::AudioParameters& in_params, uint32_t in_shared_memory_count, const ::base::UnguessableToken& in_group_id, CreateLoopbackStreamCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "audio::mojom::StreamFactory::CreateLoopbackStream", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver, 
                        "<value of type ::mojo::PendingReceiver<::media::mojom::AudioInputStream>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client"), in_client, 
                        "<value of type ::mojo::PendingRemote<::media::mojom::AudioInputStreamClient>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("observer"), in_observer, 
                        "<value of type ::mojo::PendingRemote<::media::mojom::AudioInputStreamObserver>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("params"), in_params, 
                        "<value of type const ::media::AudioParameters&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("shared_memory_count"), in_shared_memory_count, 
                        "<value of type uint32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("group_id"), in_group_id, 
                        "<value of type const ::base::UnguessableToken&>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kStreamFactory_CreateLoopbackStream_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::audio::mojom::internal::StreamFactory_CreateLoopbackStream_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::media::mojom::AudioInputStreamInterfaceBase>>(
      in_receiver, &params->receiver, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->receiver),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid receiver in StreamFactory.CreateLoopbackStream request");
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::media::mojom::AudioInputStreamClientInterfaceBase>>(
      in_client, &params->client, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->client),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid client in StreamFactory.CreateLoopbackStream request");
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::media::mojom::AudioInputStreamObserverInterfaceBase>>(
      in_observer, &params->observer, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->observer),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid observer in StreamFactory.CreateLoopbackStream request");
  mojo::internal::MessageFragment<
      typename decltype(params->params)::BaseType> params_fragment(
          params.message());
  mojo::internal::Serialize<::media::mojom::AudioParametersDataView>(
      in_params, params_fragment);
  params->params.Set(
      params_fragment.is_null() ? nullptr : params_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->params.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null params in StreamFactory.CreateLoopbackStream request");
  params->shared_memory_count = in_shared_memory_count;
  mojo::internal::MessageFragment<
      typename decltype(params->group_id)::BaseType> group_id_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
      in_group_id, group_id_fragment);
  params->group_id.Set(
      group_id_fragment.is_null() ? nullptr : group_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->group_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null group_id in StreamFactory.CreateLoopbackStream request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(StreamFactory::Name_);
  message.set_method_name("CreateLoopbackStream");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new StreamFactory_CreateLoopbackStream_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
class StreamFactory_CreateInputStream_ProxyToResponder {
 public:
  static StreamFactory::CreateInputStreamCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<StreamFactory_CreateInputStream_ProxyToResponder> proxy(
        new StreamFactory_CreateInputStream_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&StreamFactory_CreateInputStream_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~StreamFactory_CreateInputStream_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  StreamFactory_CreateInputStream_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "StreamFactory::CreateInputStreamCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::media::mojom::ReadOnlyAudioDataPipePtr in_data_pipe, bool in_initially_muted, const base::Optional<::base::UnguessableToken>& in_stream_id);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(StreamFactory_CreateInputStream_ProxyToResponder);
};

bool StreamFactory_CreateInputStream_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "audio::mojom::StreamFactory::CreateInputStreamCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::StreamFactory_CreateInputStream_ResponseParams_Data* params =
      reinterpret_cast<
          internal::StreamFactory_CreateInputStream_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ::media::mojom::ReadOnlyAudioDataPipePtr p_data_pipe{};
  bool p_initially_muted{};
  base::Optional<::base::UnguessableToken> p_stream_id{};
  StreamFactory_CreateInputStream_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadDataPipe(&p_data_pipe))
    success = false;
  if (success)
    p_initially_muted = input_data_view.initially_muted();
  if (success && !input_data_view.ReadStreamId(&p_stream_id))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        StreamFactory::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_data_pipe), 
std::move(p_initially_muted), 
std::move(p_stream_id));
  return true;
}

void StreamFactory_CreateInputStream_ProxyToResponder::Run(
    ::media::mojom::ReadOnlyAudioDataPipePtr in_data_pipe, bool in_initially_muted, const base::Optional<::base::UnguessableToken>& in_stream_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)audio::mojom::StreamFactory::CreateInputStreamCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("data_pipe"), in_data_pipe, 
                        "<value of type ::media::mojom::ReadOnlyAudioDataPipePtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("initially_muted"), in_initially_muted, 
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("stream_id"), in_stream_id, 
                        "<value of type const base::Optional<::base::UnguessableToken>&>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kStreamFactory_CreateInputStream_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::audio::mojom::internal::StreamFactory_CreateInputStream_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->data_pipe)::BaseType> data_pipe_fragment(
          params.message());
  mojo::internal::Serialize<::media::mojom::ReadOnlyAudioDataPipeDataView>(
      in_data_pipe, data_pipe_fragment);
  params->data_pipe.Set(
      data_pipe_fragment.is_null() ? nullptr : data_pipe_fragment.data());
  params->initially_muted = in_initially_muted;
  mojo::internal::MessageFragment<
      typename decltype(params->stream_id)::BaseType> stream_id_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
      in_stream_id, stream_id_fragment);
  params->stream_id.Set(
      stream_id_fragment.is_null() ? nullptr : stream_id_fragment.data());

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)audio::mojom::StreamFactory::CreateInputStreamCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(StreamFactory::Name_);
  message.set_method_name("CreateInputStream");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class StreamFactory_CreateOutputStream_ProxyToResponder {
 public:
  static StreamFactory::CreateOutputStreamCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<StreamFactory_CreateOutputStream_ProxyToResponder> proxy(
        new StreamFactory_CreateOutputStream_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&StreamFactory_CreateOutputStream_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~StreamFactory_CreateOutputStream_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  StreamFactory_CreateOutputStream_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "StreamFactory::CreateOutputStreamCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::media::mojom::ReadWriteAudioDataPipePtr in_data_pipe);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(StreamFactory_CreateOutputStream_ProxyToResponder);
};

bool StreamFactory_CreateOutputStream_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "audio::mojom::StreamFactory::CreateOutputStreamCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::StreamFactory_CreateOutputStream_ResponseParams_Data* params =
      reinterpret_cast<
          internal::StreamFactory_CreateOutputStream_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ::media::mojom::ReadWriteAudioDataPipePtr p_data_pipe{};
  StreamFactory_CreateOutputStream_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadDataPipe(&p_data_pipe))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        StreamFactory::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_data_pipe));
  return true;
}

void StreamFactory_CreateOutputStream_ProxyToResponder::Run(
    ::media::mojom::ReadWriteAudioDataPipePtr in_data_pipe) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)audio::mojom::StreamFactory::CreateOutputStreamCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("data_pipe"), in_data_pipe, 
                        "<value of type ::media::mojom::ReadWriteAudioDataPipePtr>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kStreamFactory_CreateOutputStream_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::audio::mojom::internal::StreamFactory_CreateOutputStream_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->data_pipe)::BaseType> data_pipe_fragment(
          params.message());
  mojo::internal::Serialize<::media::mojom::ReadWriteAudioDataPipeDataView>(
      in_data_pipe, data_pipe_fragment);
  params->data_pipe.Set(
      data_pipe_fragment.is_null() ? nullptr : data_pipe_fragment.data());

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)audio::mojom::StreamFactory::CreateOutputStreamCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(StreamFactory::Name_);
  message.set_method_name("CreateOutputStream");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class StreamFactory_CreateLoopbackStream_ProxyToResponder {
 public:
  static StreamFactory::CreateLoopbackStreamCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<StreamFactory_CreateLoopbackStream_ProxyToResponder> proxy(
        new StreamFactory_CreateLoopbackStream_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&StreamFactory_CreateLoopbackStream_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~StreamFactory_CreateLoopbackStream_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  StreamFactory_CreateLoopbackStream_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "StreamFactory::CreateLoopbackStreamCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::media::mojom::ReadOnlyAudioDataPipePtr in_data_pipe);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(StreamFactory_CreateLoopbackStream_ProxyToResponder);
};

bool StreamFactory_CreateLoopbackStream_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "audio::mojom::StreamFactory::CreateLoopbackStreamCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::StreamFactory_CreateLoopbackStream_ResponseParams_Data* params =
      reinterpret_cast<
          internal::StreamFactory_CreateLoopbackStream_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ::media::mojom::ReadOnlyAudioDataPipePtr p_data_pipe{};
  StreamFactory_CreateLoopbackStream_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadDataPipe(&p_data_pipe))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        StreamFactory::Name_, 4, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_data_pipe));
  return true;
}

void StreamFactory_CreateLoopbackStream_ProxyToResponder::Run(
    ::media::mojom::ReadOnlyAudioDataPipePtr in_data_pipe) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)audio::mojom::StreamFactory::CreateLoopbackStreamCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("data_pipe"), in_data_pipe, 
                        "<value of type ::media::mojom::ReadOnlyAudioDataPipePtr>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kStreamFactory_CreateLoopbackStream_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::audio::mojom::internal::StreamFactory_CreateLoopbackStream_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->data_pipe)::BaseType> data_pipe_fragment(
          params.message());
  mojo::internal::Serialize<::media::mojom::ReadOnlyAudioDataPipeDataView>(
      in_data_pipe, data_pipe_fragment);
  params->data_pipe.Set(
      data_pipe_fragment.is_null() ? nullptr : data_pipe_fragment.data());

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)audio::mojom::StreamFactory::CreateLoopbackStreamCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(StreamFactory::Name_);
  message.set_method_name("CreateLoopbackStream");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool StreamFactoryStubDispatch::Accept(
    StreamFactory* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kStreamFactory_CreateInputStream_Name: {
      break;
    }
    case internal::kStreamFactory_AssociateInputAndOutputForAec_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)audio::mojom::StreamFactory::AssociateInputAndOutputForAec",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)audio::mojom::StreamFactory::AssociateInputAndOutputForAec");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::StreamFactory_AssociateInputAndOutputForAec_Params_Data* params =
          reinterpret_cast<internal::StreamFactory_AssociateInputAndOutputForAec_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::base::UnguessableToken p_input_stream_id{};
      std::string p_output_device_id{};
      StreamFactory_AssociateInputAndOutputForAec_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadInputStreamId(&p_input_stream_id))
        success = false;
      if (success && !input_data_view.ReadOutputDeviceId(&p_output_device_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            StreamFactory::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AssociateInputAndOutputForAec(
std::move(p_input_stream_id), 
std::move(p_output_device_id));
      return true;
    }
    case internal::kStreamFactory_CreateOutputStream_Name: {
      break;
    }
    case internal::kStreamFactory_BindMuter_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)audio::mojom::StreamFactory::BindMuter",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)audio::mojom::StreamFactory::BindMuter");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::StreamFactory_BindMuter_Params_Data* params =
          reinterpret_cast<internal::StreamFactory_BindMuter_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingAssociatedReceiver<LocalMuter> p_receiver{};
      ::base::UnguessableToken p_group_id{};
      StreamFactory_BindMuter_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (success && !input_data_view.ReadGroupId(&p_group_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            StreamFactory::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BindMuter(
std::move(p_receiver), 
std::move(p_group_id));
      return true;
    }
    case internal::kStreamFactory_CreateLoopbackStream_Name: {
      break;
    }
  }
  return false;
}

// static
bool StreamFactoryStubDispatch::AcceptWithResponder(
    StreamFactory* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kStreamFactory_CreateInputStream_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)audio::mojom::StreamFactory::CreateInputStream",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)audio::mojom::StreamFactory::CreateInputStream");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::StreamFactory_CreateInputStream_Params_Data* params =
          reinterpret_cast<
              internal::StreamFactory_CreateInputStream_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingReceiver<::media::mojom::AudioInputStream> p_stream{};
      ::mojo::PendingRemote<::media::mojom::AudioInputStreamClient> p_client{};
      ::mojo::PendingRemote<::media::mojom::AudioInputStreamObserver> p_observer{};
      ::mojo::PendingRemote<::media::mojom::AudioLog> p_log{};
      std::string p_device_id{};
      ::media::AudioParameters p_params{};
      uint32_t p_shared_memory_count{};
      bool p_enable_agc{};
      ::base::ReadOnlySharedMemoryRegion p_key_press_count_buffer{};
      StreamFactory_CreateInputStream_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_stream =
            input_data_view.TakeStream<decltype(p_stream)>();
      }
      if (success) {
        p_client =
            input_data_view.TakeClient<decltype(p_client)>();
      }
      if (success) {
        p_observer =
            input_data_view.TakeObserver<decltype(p_observer)>();
      }
      if (success) {
        p_log =
            input_data_view.TakeLog<decltype(p_log)>();
      }
      if (success && !input_data_view.ReadDeviceId(&p_device_id))
        success = false;
      if (success && !input_data_view.ReadParams(&p_params))
        success = false;
      if (success)
        p_shared_memory_count = input_data_view.shared_memory_count();
      if (success)
        p_enable_agc = input_data_view.enable_agc();
      if (success && !input_data_view.ReadKeyPressCountBuffer(&p_key_press_count_buffer))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            StreamFactory::Name_, 0, false);
        return false;
      }
      StreamFactory::CreateInputStreamCallback callback =
          StreamFactory_CreateInputStream_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateInputStream(
std::move(p_stream), 
std::move(p_client), 
std::move(p_observer), 
std::move(p_log), 
std::move(p_device_id), 
std::move(p_params), 
std::move(p_shared_memory_count), 
std::move(p_enable_agc), 
std::move(p_key_press_count_buffer), std::move(callback));
      return true;
    }
    case internal::kStreamFactory_AssociateInputAndOutputForAec_Name: {
      break;
    }
    case internal::kStreamFactory_CreateOutputStream_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)audio::mojom::StreamFactory::CreateOutputStream",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)audio::mojom::StreamFactory::CreateOutputStream");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::StreamFactory_CreateOutputStream_Params_Data* params =
          reinterpret_cast<
              internal::StreamFactory_CreateOutputStream_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingReceiver<::media::mojom::AudioOutputStream> p_stream{};
      ::mojo::PendingAssociatedRemote<::media::mojom::AudioOutputStreamObserver> p_observer{};
      ::mojo::PendingRemote<::media::mojom::AudioLog> p_log{};
      std::string p_device_id{};
      ::media::AudioParameters p_params{};
      ::base::UnguessableToken p_group_id{};
      StreamFactory_CreateOutputStream_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_stream =
            input_data_view.TakeStream<decltype(p_stream)>();
      }
      if (success) {
        p_observer =
            input_data_view.TakeObserver<decltype(p_observer)>();
      }
      if (success) {
        p_log =
            input_data_view.TakeLog<decltype(p_log)>();
      }
      if (success && !input_data_view.ReadDeviceId(&p_device_id))
        success = false;
      if (success && !input_data_view.ReadParams(&p_params))
        success = false;
      if (success && !input_data_view.ReadGroupId(&p_group_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            StreamFactory::Name_, 2, false);
        return false;
      }
      StreamFactory::CreateOutputStreamCallback callback =
          StreamFactory_CreateOutputStream_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateOutputStream(
std::move(p_stream), 
std::move(p_observer), 
std::move(p_log), 
std::move(p_device_id), 
std::move(p_params), 
std::move(p_group_id), std::move(callback));
      return true;
    }
    case internal::kStreamFactory_BindMuter_Name: {
      break;
    }
    case internal::kStreamFactory_CreateLoopbackStream_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)audio::mojom::StreamFactory::CreateLoopbackStream",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)audio::mojom::StreamFactory::CreateLoopbackStream");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::StreamFactory_CreateLoopbackStream_Params_Data* params =
          reinterpret_cast<
              internal::StreamFactory_CreateLoopbackStream_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingReceiver<::media::mojom::AudioInputStream> p_receiver{};
      ::mojo::PendingRemote<::media::mojom::AudioInputStreamClient> p_client{};
      ::mojo::PendingRemote<::media::mojom::AudioInputStreamObserver> p_observer{};
      ::media::AudioParameters p_params{};
      uint32_t p_shared_memory_count{};
      ::base::UnguessableToken p_group_id{};
      StreamFactory_CreateLoopbackStream_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (success) {
        p_client =
            input_data_view.TakeClient<decltype(p_client)>();
      }
      if (success) {
        p_observer =
            input_data_view.TakeObserver<decltype(p_observer)>();
      }
      if (success && !input_data_view.ReadParams(&p_params))
        success = false;
      if (success)
        p_shared_memory_count = input_data_view.shared_memory_count();
      if (success && !input_data_view.ReadGroupId(&p_group_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            StreamFactory::Name_, 4, false);
        return false;
      }
      StreamFactory::CreateLoopbackStreamCallback callback =
          StreamFactory_CreateLoopbackStream_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateLoopbackStream(
std::move(p_receiver), 
std::move(p_client), 
std::move(p_observer), 
std::move(p_params), 
std::move(p_shared_memory_count), 
std::move(p_group_id), std::move(callback));
      return true;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kStreamFactoryValidationInfo[] = {
    {internal::kStreamFactory_CreateInputStream_Name,
     {&internal::StreamFactory_CreateInputStream_Params_Data::Validate,
      &internal::StreamFactory_CreateInputStream_ResponseParams_Data::Validate}},
    {internal::kStreamFactory_AssociateInputAndOutputForAec_Name,
     {&internal::StreamFactory_AssociateInputAndOutputForAec_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kStreamFactory_CreateOutputStream_Name,
     {&internal::StreamFactory_CreateOutputStream_Params_Data::Validate,
      &internal::StreamFactory_CreateOutputStream_ResponseParams_Data::Validate}},
    {internal::kStreamFactory_BindMuter_Name,
     {&internal::StreamFactory_BindMuter_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kStreamFactory_CreateLoopbackStream_Name,
     {&internal::StreamFactory_CreateLoopbackStream_Params_Data::Validate,
      &internal::StreamFactory_CreateLoopbackStream_ResponseParams_Data::Validate}},
};

bool StreamFactoryRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::audio::mojom::StreamFactory::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kStreamFactoryValidationInfo);
}

bool StreamFactoryResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::audio::mojom::StreamFactory::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kStreamFactoryValidationInfo);

}
}  // namespace mojom
}  // namespace audio

namespace mojo {

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif