// services/data_decoder/public/mojom/gzipper.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/data_decoder/public/mojom/gzipper.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "services/data_decoder/public/mojom/gzipper.mojom-params-data.h"
#include "services/data_decoder/public/mojom/gzipper.mojom-shared-message-ids.h"

#include "services/data_decoder/public/mojom/gzipper.mojom-import-headers.h"


#ifndef SERVICES_DATA_DECODER_PUBLIC_MOJOM_GZIPPER_MOJOM_JUMBO_H_
#define SERVICES_DATA_DECODER_PUBLIC_MOJOM_GZIPPER_MOJOM_JUMBO_H_
#endif
namespace data_decoder {
namespace mojom {
const char Gzipper::Name_[] = "data_decoder.mojom.Gzipper";

class Gzipper_Compress_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Gzipper_Compress_ForwardToCallback(
      Gzipper::CompressCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  Gzipper::CompressCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(Gzipper_Compress_ForwardToCallback);
};

class Gzipper_Uncompress_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Gzipper_Uncompress_ForwardToCallback(
      Gzipper::UncompressCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  Gzipper::UncompressCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(Gzipper_Uncompress_ForwardToCallback);
};

GzipperProxy::GzipperProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void GzipperProxy::Compress(
    ::mojo_base::BigBuffer in_data, CompressCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "data_decoder::mojom::Gzipper::Compress", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("data"), in_data, 
                        "<value of type ::mojo_base::BigBuffer>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kGzipper_Compress_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::data_decoder::mojom::internal::Gzipper_Compress_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->data)>
      data_fragment(params.message());
  data_fragment.Claim(&params->data);
  mojo::internal::Serialize<::mojo_base::mojom::BigBufferDataView>(
      in_data, data_fragment, true);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->data.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null data in Gzipper.Compress request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Gzipper::Name_);
  message.set_method_name("Compress");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Gzipper_Compress_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void GzipperProxy::Uncompress(
    ::mojo_base::BigBuffer in_compressed_data, UncompressCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "data_decoder::mojom::Gzipper::Uncompress", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("compressed_data"), in_compressed_data, 
                        "<value of type ::mojo_base::BigBuffer>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kGzipper_Uncompress_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::data_decoder::mojom::internal::Gzipper_Uncompress_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->compressed_data)>
      compressed_data_fragment(params.message());
  compressed_data_fragment.Claim(&params->compressed_data);
  mojo::internal::Serialize<::mojo_base::mojom::BigBufferDataView>(
      in_compressed_data, compressed_data_fragment, true);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->compressed_data.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null compressed_data in Gzipper.Uncompress request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Gzipper::Name_);
  message.set_method_name("Uncompress");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Gzipper_Uncompress_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
class Gzipper_Compress_ProxyToResponder {
 public:
  static Gzipper::CompressCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<Gzipper_Compress_ProxyToResponder> proxy(
        new Gzipper_Compress_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&Gzipper_Compress_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Gzipper_Compress_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  Gzipper_Compress_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "Gzipper::CompressCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      base::Optional<::mojo_base::BigBuffer> in_compressed_data);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(Gzipper_Compress_ProxyToResponder);
};

bool Gzipper_Compress_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "data_decoder::mojom::Gzipper::CompressCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::Gzipper_Compress_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Gzipper_Compress_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  base::Optional<::mojo_base::BigBuffer> p_compressed_data{};
  Gzipper_Compress_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadCompressedData(&p_compressed_data))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Gzipper::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_compressed_data));
  return true;
}

void Gzipper_Compress_ProxyToResponder::Run(
    base::Optional<::mojo_base::BigBuffer> in_compressed_data) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)data_decoder::mojom::Gzipper::CompressCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("compressed_data"), in_compressed_data, 
                        "<value of type base::Optional<::mojo_base::BigBuffer>>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kGzipper_Compress_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::data_decoder::mojom::internal::Gzipper_Compress_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->compressed_data)>
      compressed_data_fragment(params.message());
  compressed_data_fragment.Claim(&params->compressed_data);
  mojo::internal::Serialize<::mojo_base::mojom::BigBufferDataView>(
      in_compressed_data, compressed_data_fragment, true);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)data_decoder::mojom::Gzipper::CompressCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Gzipper::Name_);
  message.set_method_name("Compress");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class Gzipper_Uncompress_ProxyToResponder {
 public:
  static Gzipper::UncompressCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<Gzipper_Uncompress_ProxyToResponder> proxy(
        new Gzipper_Uncompress_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&Gzipper_Uncompress_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Gzipper_Uncompress_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  Gzipper_Uncompress_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "Gzipper::UncompressCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      base::Optional<::mojo_base::BigBuffer> in_data);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(Gzipper_Uncompress_ProxyToResponder);
};

bool Gzipper_Uncompress_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "data_decoder::mojom::Gzipper::UncompressCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::Gzipper_Uncompress_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Gzipper_Uncompress_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  base::Optional<::mojo_base::BigBuffer> p_data{};
  Gzipper_Uncompress_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadData(&p_data))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Gzipper::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_data));
  return true;
}

void Gzipper_Uncompress_ProxyToResponder::Run(
    base::Optional<::mojo_base::BigBuffer> in_data) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)data_decoder::mojom::Gzipper::UncompressCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("data"), in_data, 
                        "<value of type base::Optional<::mojo_base::BigBuffer>>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kGzipper_Uncompress_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::data_decoder::mojom::internal::Gzipper_Uncompress_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->data)>
      data_fragment(params.message());
  data_fragment.Claim(&params->data);
  mojo::internal::Serialize<::mojo_base::mojom::BigBufferDataView>(
      in_data, data_fragment, true);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)data_decoder::mojom::Gzipper::UncompressCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Gzipper::Name_);
  message.set_method_name("Uncompress");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool GzipperStubDispatch::Accept(
    Gzipper* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kGzipper_Compress_Name: {
      break;
    }
    case internal::kGzipper_Uncompress_Name: {
      break;
    }
  }
  return false;
}

// static
bool GzipperStubDispatch::AcceptWithResponder(
    Gzipper* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kGzipper_Compress_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)data_decoder::mojom::Gzipper::Compress",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)data_decoder::mojom::Gzipper::Compress");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::Gzipper_Compress_Params_Data* params =
          reinterpret_cast<
              internal::Gzipper_Compress_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::mojo_base::BigBuffer p_data{};
      Gzipper_Compress_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadData(&p_data))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Gzipper::Name_, 0, false);
        return false;
      }
      Gzipper::CompressCallback callback =
          Gzipper_Compress_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Compress(
std::move(p_data), std::move(callback));
      return true;
    }
    case internal::kGzipper_Uncompress_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)data_decoder::mojom::Gzipper::Uncompress",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)data_decoder::mojom::Gzipper::Uncompress");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::Gzipper_Uncompress_Params_Data* params =
          reinterpret_cast<
              internal::Gzipper_Uncompress_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::mojo_base::BigBuffer p_compressed_data{};
      Gzipper_Uncompress_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadCompressedData(&p_compressed_data))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Gzipper::Name_, 1, false);
        return false;
      }
      Gzipper::UncompressCallback callback =
          Gzipper_Uncompress_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Uncompress(
std::move(p_compressed_data), std::move(callback));
      return true;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kGzipperValidationInfo[] = {
    {internal::kGzipper_Compress_Name,
     {&internal::Gzipper_Compress_Params_Data::Validate,
      &internal::Gzipper_Compress_ResponseParams_Data::Validate}},
    {internal::kGzipper_Uncompress_Name,
     {&internal::Gzipper_Uncompress_Params_Data::Validate,
      &internal::Gzipper_Uncompress_ResponseParams_Data::Validate}},
};

bool GzipperRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::data_decoder::mojom::Gzipper::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kGzipperValidationInfo);
}

bool GzipperResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::data_decoder::mojom::Gzipper::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kGzipperValidationInfo);

}
}  // namespace mojom
}  // namespace data_decoder

namespace mojo {

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif