// services/data_decoder/public/mojom/json_parser.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "services/data_decoder/public/mojom/json_parser.mojom-shared.h"

#include <utility>

#include "base/stl_util.h"  // for base::size()
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/data_decoder/public/mojom/json_parser.mojom-params-data.h"
namespace data_decoder {
namespace mojom {

namespace internal {


// static
bool JsonParser_Parse_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const JsonParser_Parse_Params_Data* object = static_cast<const JsonParser_Parse_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->json, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams json_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->json, validation_context,
                                         &json_validate_params)) {
    return false;
  }

  return true;
}

JsonParser_Parse_Params_Data::JsonParser_Parse_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool JsonParser_Parse_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const JsonParser_Parse_ResponseParams_Data* object = static_cast<const JsonParser_Parse_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateInlinedUnion(object->result, validation_context))
    return false;

  const mojo::internal::ContainerValidateParams error_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->error, validation_context,
                                         &error_validate_params)) {
    return false;
  }

  return true;
}

JsonParser_Parse_ResponseParams_Data::JsonParser_Parse_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace data_decoder
