// services/data_decoder/public/mojom/json_parser.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/data_decoder/public/mojom/json_parser.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "services/data_decoder/public/mojom/json_parser.mojom-params-data.h"
#include "services/data_decoder/public/mojom/json_parser.mojom-shared-message-ids.h"

#include "services/data_decoder/public/mojom/json_parser.mojom-import-headers.h"


#ifndef SERVICES_DATA_DECODER_PUBLIC_MOJOM_JSON_PARSER_MOJOM_JUMBO_H_
#define SERVICES_DATA_DECODER_PUBLIC_MOJOM_JSON_PARSER_MOJOM_JUMBO_H_
#endif
namespace data_decoder {
namespace mojom {
const char JsonParser::Name_[] = "data_decoder.mojom.JsonParser";

class JsonParser_Parse_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  JsonParser_Parse_ForwardToCallback(
      JsonParser::ParseCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  JsonParser::ParseCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(JsonParser_Parse_ForwardToCallback);
};

JsonParserProxy::JsonParserProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void JsonParserProxy::Parse(
    const std::string& in_json, ParseCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "data_decoder::mojom::JsonParser::Parse", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("json"), in_json, 
                        "<value of type const std::string&>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kJsonParser_Parse_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::data_decoder::mojom::internal::JsonParser_Parse_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->json)::BaseType> json_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_json, json_fragment);
  params->json.Set(
      json_fragment.is_null() ? nullptr : json_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->json.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null json in JsonParser.Parse request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(JsonParser::Name_);
  message.set_method_name("Parse");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new JsonParser_Parse_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
class JsonParser_Parse_ProxyToResponder {
 public:
  static JsonParser::ParseCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<JsonParser_Parse_ProxyToResponder> proxy(
        new JsonParser_Parse_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&JsonParser_Parse_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~JsonParser_Parse_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  JsonParser_Parse_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "JsonParser::ParseCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      base::Optional<::base::Value> in_result, const base::Optional<std::string>& in_error);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(JsonParser_Parse_ProxyToResponder);
};

bool JsonParser_Parse_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "data_decoder::mojom::JsonParser::ParseCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::JsonParser_Parse_ResponseParams_Data* params =
      reinterpret_cast<
          internal::JsonParser_Parse_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  base::Optional<::base::Value> p_result{};
  base::Optional<std::string> p_error{};
  JsonParser_Parse_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (success && !input_data_view.ReadError(&p_error))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        JsonParser::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_result), 
std::move(p_error));
  return true;
}

void JsonParser_Parse_ProxyToResponder::Run(
    base::Optional<::base::Value> in_result, const base::Optional<std::string>& in_error) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)data_decoder::mojom::JsonParser::ParseCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result, 
                        "<value of type base::Optional<::base::Value>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), in_error, 
                        "<value of type const base::Optional<std::string>&>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kJsonParser_Parse_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::data_decoder::mojom::internal::JsonParser_Parse_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->result)>
      result_fragment(params.message());
  result_fragment.Claim(&params->result);
  mojo::internal::Serialize<::mojo_base::mojom::ValueDataView>(
      in_result, result_fragment, true);
  mojo::internal::MessageFragment<
      typename decltype(params->error)::BaseType> error_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_error, error_fragment);
  params->error.Set(
      error_fragment.is_null() ? nullptr : error_fragment.data());

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)data_decoder::mojom::JsonParser::ParseCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(JsonParser::Name_);
  message.set_method_name("Parse");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool JsonParserStubDispatch::Accept(
    JsonParser* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kJsonParser_Parse_Name: {
      break;
    }
  }
  return false;
}

// static
bool JsonParserStubDispatch::AcceptWithResponder(
    JsonParser* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kJsonParser_Parse_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)data_decoder::mojom::JsonParser::Parse",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)data_decoder::mojom::JsonParser::Parse");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::JsonParser_Parse_Params_Data* params =
          reinterpret_cast<
              internal::JsonParser_Parse_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      std::string p_json{};
      JsonParser_Parse_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadJson(&p_json))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            JsonParser::Name_, 0, false);
        return false;
      }
      JsonParser::ParseCallback callback =
          JsonParser_Parse_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Parse(
std::move(p_json), std::move(callback));
      return true;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kJsonParserValidationInfo[] = {
    {internal::kJsonParser_Parse_Name,
     {&internal::JsonParser_Parse_Params_Data::Validate,
      &internal::JsonParser_Parse_ResponseParams_Data::Validate}},
};

bool JsonParserRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::data_decoder::mojom::JsonParser::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kJsonParserValidationInfo);
}

bool JsonParserResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::data_decoder::mojom::JsonParser::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kJsonParserValidationInfo);

}
}  // namespace mojom
}  // namespace data_decoder

namespace mojo {

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif