// services/device/public/mojom/nfc.mojom-test-utils.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif


#include "services/device/public/mojom/nfc.mojom-test-utils.h"

#include <utility>

#include "base/bind.h"
#include "base/run_loop.h"


#ifndef SERVICES_DEVICE_PUBLIC_MOJOM_NFC_MOJOM_JUMBO_H_
#define SERVICES_DEVICE_PUBLIC_MOJOM_NFC_MOJOM_JUMBO_H_
#endif


namespace device {
namespace mojom {


void NFCInterceptorForTesting::SetClient(::mojo::PendingRemote<NFCClient> client) {
  GetForwardingInterface()->SetClient(std::move(client));
}
void NFCInterceptorForTesting::Push(NDEFMessagePtr message, NDEFWriteOptionsPtr options, PushCallback callback) {
  GetForwardingInterface()->Push(std::move(message), std::move(options), std::move(callback));
}
void NFCInterceptorForTesting::CancelPush() {
  GetForwardingInterface()->CancelPush();
}
void NFCInterceptorForTesting::Watch(uint32_t id, WatchCallback callback) {
  GetForwardingInterface()->Watch(std::move(id), std::move(callback));
}
void NFCInterceptorForTesting::CancelWatch(uint32_t id) {
  GetForwardingInterface()->CancelWatch(std::move(id));
}
NFCAsyncWaiter::NFCAsyncWaiter(
    NFC* proxy) : proxy_(proxy) {}

NFCAsyncWaiter::~NFCAsyncWaiter() = default;

void NFCAsyncWaiter::Push(
    NDEFMessagePtr message, NDEFWriteOptionsPtr options, NDEFErrorPtr* out_error) {
  base::RunLoop loop;
  proxy_->Push(std::move(message),std::move(options),
      base::BindOnce(
          [](base::RunLoop* loop,
             NDEFErrorPtr* out_error
,
             NDEFErrorPtr error) {*out_error = std::move(error);
            loop->Quit();
          },
          &loop,
          out_error));
  loop.Run();
}
void NFCAsyncWaiter::Watch(
    uint32_t id, NDEFErrorPtr* out_error) {
  base::RunLoop loop;
  proxy_->Watch(std::move(id),
      base::BindOnce(
          [](base::RunLoop* loop,
             NDEFErrorPtr* out_error
,
             NDEFErrorPtr error) {*out_error = std::move(error);
            loop->Quit();
          },
          &loop,
          out_error));
  loop.Run();
}



void NFCClientInterceptorForTesting::OnWatch(const std::vector<uint32_t>& watch_ids, const base::Optional<std::string>& serial_number, NDEFMessagePtr message) {
  GetForwardingInterface()->OnWatch(std::move(watch_ids), std::move(serial_number), std::move(message));
}
void NFCClientInterceptorForTesting::OnError(NDEFErrorPtr error) {
  GetForwardingInterface()->OnError(std::move(error));
}
NFCClientAsyncWaiter::NFCClientAsyncWaiter(
    NFCClient* proxy) : proxy_(proxy) {}

NFCClientAsyncWaiter::~NFCClientAsyncWaiter() = default;






}  // namespace mojom
}  // namespace device

#if defined(__clang__)
#pragma clang diagnostic pop
#endif