// services/device/public/mojom/sensor.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "services/device/public/mojom/sensor.mojom-shared.h"

#include <utility>

#include "base/stl_util.h"  // for base::size()
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/device/public/mojom/sensor.mojom-params-data.h"
namespace device {
namespace mojom {

std::string SensorTypeToString(SensorType value) {
  switch(value) {
    case SensorType::AMBIENT_LIGHT:
      return "SensorType::AMBIENT_LIGHT";
    case SensorType::PROXIMITY:
      return "SensorType::PROXIMITY";
    case SensorType::ACCELEROMETER:
      return "SensorType::ACCELEROMETER";
    case SensorType::LINEAR_ACCELERATION:
      return "SensorType::LINEAR_ACCELERATION";
    case SensorType::GRAVITY:
      return "SensorType::GRAVITY";
    case SensorType::GYROSCOPE:
      return "SensorType::GYROSCOPE";
    case SensorType::MAGNETOMETER:
      return "SensorType::MAGNETOMETER";
    case SensorType::PRESSURE:
      return "SensorType::PRESSURE";
    case SensorType::ABSOLUTE_ORIENTATION_EULER_ANGLES:
      return "SensorType::ABSOLUTE_ORIENTATION_EULER_ANGLES";
    case SensorType::ABSOLUTE_ORIENTATION_QUATERNION:
      return "SensorType::ABSOLUTE_ORIENTATION_QUATERNION";
    case SensorType::RELATIVE_ORIENTATION_EULER_ANGLES:
      return "SensorType::RELATIVE_ORIENTATION_EULER_ANGLES";
    case SensorType::RELATIVE_ORIENTATION_QUATERNION:
      return "SensorType::RELATIVE_ORIENTATION_QUATERNION";
    default:
      return base::StringPrintf("Unknown SensorType value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, SensorType value) {
  return os << SensorTypeToString(value);
}

std::string ReportingModeToString(ReportingMode value) {
  switch(value) {
    case ReportingMode::ON_CHANGE:
      return "ReportingMode::ON_CHANGE";
    case ReportingMode::CONTINUOUS:
      return "ReportingMode::CONTINUOUS";
    default:
      return base::StringPrintf("Unknown ReportingMode value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, ReportingMode value) {
  return os << ReportingModeToString(value);
}

namespace internal {


// static
bool SensorConfiguration_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const SensorConfiguration_Data* object = static_cast<const SensorConfiguration_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

SensorConfiguration_Data::SensorConfiguration_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Sensor_GetDefaultConfiguration_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const Sensor_GetDefaultConfiguration_Params_Data* object = static_cast<const Sensor_GetDefaultConfiguration_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

Sensor_GetDefaultConfiguration_Params_Data::Sensor_GetDefaultConfiguration_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Sensor_GetDefaultConfiguration_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const Sensor_GetDefaultConfiguration_ResponseParams_Data* object = static_cast<const Sensor_GetDefaultConfiguration_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->configuration, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->configuration, validation_context))
    return false;

  return true;
}

Sensor_GetDefaultConfiguration_ResponseParams_Data::Sensor_GetDefaultConfiguration_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Sensor_AddConfiguration_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const Sensor_AddConfiguration_Params_Data* object = static_cast<const Sensor_AddConfiguration_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->configuration, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->configuration, validation_context))
    return false;

  return true;
}

Sensor_AddConfiguration_Params_Data::Sensor_AddConfiguration_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Sensor_AddConfiguration_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const Sensor_AddConfiguration_ResponseParams_Data* object = static_cast<const Sensor_AddConfiguration_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

Sensor_AddConfiguration_ResponseParams_Data::Sensor_AddConfiguration_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Sensor_RemoveConfiguration_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const Sensor_RemoveConfiguration_Params_Data* object = static_cast<const Sensor_RemoveConfiguration_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->configuration, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->configuration, validation_context))
    return false;

  return true;
}

Sensor_RemoveConfiguration_Params_Data::Sensor_RemoveConfiguration_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Sensor_Suspend_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const Sensor_Suspend_Params_Data* object = static_cast<const Sensor_Suspend_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

Sensor_Suspend_Params_Data::Sensor_Suspend_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Sensor_Resume_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const Sensor_Resume_Params_Data* object = static_cast<const Sensor_Resume_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

Sensor_Resume_Params_Data::Sensor_Resume_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Sensor_ConfigureReadingChangeNotifications_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const Sensor_ConfigureReadingChangeNotifications_Params_Data* object = static_cast<const Sensor_ConfigureReadingChangeNotifications_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

Sensor_ConfigureReadingChangeNotifications_Params_Data::Sensor_ConfigureReadingChangeNotifications_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SensorClient_RaiseError_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const SensorClient_RaiseError_Params_Data* object = static_cast<const SensorClient_RaiseError_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

SensorClient_RaiseError_Params_Data::SensorClient_RaiseError_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SensorClient_SensorReadingChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const SensorClient_SensorReadingChanged_Params_Data* object = static_cast<const SensorClient_SensorReadingChanged_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

SensorClient_SensorReadingChanged_Params_Data::SensorClient_SensorReadingChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace device

namespace perfetto {

// static
void TraceFormatTraits<::device::mojom::SensorType>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::device::mojom::SensorType value) {
  return std::move(context).WriteString(::device::mojom::SensorTypeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::device::mojom::ReportingMode>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::device::mojom::ReportingMode value) {
  return std::move(context).WriteString(::device::mojom::ReportingModeToString(value));
}

} // namespace perfetto
