// services/device/public/mojom/sensor_provider.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/device/public/mojom/sensor_provider.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "services/device/public/mojom/sensor_provider.mojom-params-data.h"
#include "services/device/public/mojom/sensor_provider.mojom-shared-message-ids.h"

#include "services/device/public/mojom/sensor_provider.mojom-blink-import-headers.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


#ifndef SERVICES_DEVICE_PUBLIC_MOJOM_SENSOR_PROVIDER_MOJOM_BLINK_JUMBO_H_
#define SERVICES_DEVICE_PUBLIC_MOJOM_SENSOR_PROVIDER_MOJOM_BLINK_JUMBO_H_
#endif
namespace device {
namespace mojom {
namespace blink {
constexpr uint64_t SensorInitParams::kReadBufferSizeForTests;
SensorInitParams::SensorInitParams()
    : sensor(),
      client_receiver(),
      memory(),
      buffer_offset(),
      mode(),
      default_configuration(),
      maximum_frequency(),
      minimum_frequency() {}

SensorInitParams::SensorInitParams(
    ::mojo::PendingRemote<::device::mojom::blink::Sensor> sensor_in,
    ::mojo::PendingReceiver<::device::mojom::blink::SensorClient> client_receiver_in,
    ::mojo::ScopedSharedBufferHandle memory_in,
    uint64_t buffer_offset_in,
    ::device::mojom::blink::ReportingMode mode_in,
    ::device::mojom::blink::SensorConfigurationPtr default_configuration_in,
    double maximum_frequency_in,
    double minimum_frequency_in)
    : sensor(std::move(sensor_in)),
      client_receiver(std::move(client_receiver_in)),
      memory(std::move(memory_in)),
      buffer_offset(std::move(buffer_offset_in)),
      mode(std::move(mode_in)),
      default_configuration(std::move(default_configuration_in)),
      maximum_frequency(std::move(maximum_frequency_in)),
      minimum_frequency(std::move(minimum_frequency_in)) {}

SensorInitParams::~SensorInitParams() = default;

void SensorInitParams::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "sensor"), this->sensor, 
      "<value of type ::mojo::PendingRemote<::device::mojom::blink::Sensor>>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "client_receiver"), this->client_receiver, 
      "<value of type ::mojo::PendingReceiver<::device::mojom::blink::SensorClient>>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "memory"), this->memory, 
      "<value of type ::mojo::ScopedSharedBufferHandle>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "buffer_offset"), this->buffer_offset, 
      "<value of type uint64_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "mode"), this->mode, 
      "<value of type ::device::mojom::blink::ReportingMode>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "default_configuration"), this->default_configuration, 
      "<value of type ::device::mojom::blink::SensorConfigurationPtr>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "maximum_frequency"), this->maximum_frequency, 
      "<value of type double>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "minimum_frequency"), this->minimum_frequency, 
      "<value of type double>");
}

bool SensorInitParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
const char SensorProvider::Name_[] = "device.mojom.SensorProvider";

class SensorProvider_GetSensor_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  SensorProvider_GetSensor_ForwardToCallback(
      SensorProvider::GetSensorCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  SensorProvider::GetSensorCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(SensorProvider_GetSensor_ForwardToCallback);
};

SensorProviderProxy::SensorProviderProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void SensorProviderProxy::GetSensor(
    ::device::mojom::blink::SensorType in_type, GetSensorCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "device::mojom::SensorProvider::GetSensor", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("type"), in_type, 
                        "<value of type ::device::mojom::blink::SensorType>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kSensorProvider_GetSensor_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::SensorProvider_GetSensor_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::device::mojom::SensorType>(
      in_type, &params->type);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SensorProvider::Name_);
  message.set_method_name("GetSensor");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new SensorProvider_GetSensor_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
class SensorProvider_GetSensor_ProxyToResponder {
 public:
  static SensorProvider::GetSensorCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<SensorProvider_GetSensor_ProxyToResponder> proxy(
        new SensorProvider_GetSensor_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&SensorProvider_GetSensor_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~SensorProvider_GetSensor_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  SensorProvider_GetSensor_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "SensorProvider::GetSensorCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      SensorCreationResult in_result, SensorInitParamsPtr in_init_params);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(SensorProvider_GetSensor_ProxyToResponder);
};

bool SensorProvider_GetSensor_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "device::mojom::SensorProvider::GetSensorCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::SensorProvider_GetSensor_ResponseParams_Data* params =
      reinterpret_cast<
          internal::SensorProvider_GetSensor_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  SensorCreationResult p_result{};
  SensorInitParamsPtr p_init_params{};
  SensorProvider_GetSensor_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (success && !input_data_view.ReadInitParams(&p_init_params))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        SensorProvider::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_result), 
std::move(p_init_params));
  return true;
}

void SensorProvider_GetSensor_ProxyToResponder::Run(
    SensorCreationResult in_result, SensorInitParamsPtr in_init_params) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)device::mojom::SensorProvider::GetSensorCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result, 
                        "<value of type SensorCreationResult>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("init_params"), in_init_params, 
                        "<value of type SensorInitParamsPtr>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kSensorProvider_GetSensor_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::SensorProvider_GetSensor_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::device::mojom::SensorCreationResult>(
      in_result, &params->result);
  mojo::internal::MessageFragment<
      typename decltype(params->init_params)::BaseType> init_params_fragment(
          params.message());
  mojo::internal::Serialize<::device::mojom::SensorInitParamsDataView>(
      in_init_params, init_params_fragment);
  params->init_params.Set(
      init_params_fragment.is_null() ? nullptr : init_params_fragment.data());

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)device::mojom::SensorProvider::GetSensorCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SensorProvider::Name_);
  message.set_method_name("GetSensor");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool SensorProviderStubDispatch::Accept(
    SensorProvider* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kSensorProvider_GetSensor_Name: {
      break;
    }
  }
  return false;
}

// static
bool SensorProviderStubDispatch::AcceptWithResponder(
    SensorProvider* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kSensorProvider_GetSensor_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)device::mojom::SensorProvider::GetSensor",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)device::mojom::SensorProvider::GetSensor");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::SensorProvider_GetSensor_Params_Data* params =
          reinterpret_cast<
              internal::SensorProvider_GetSensor_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::device::mojom::blink::SensorType p_type{};
      SensorProvider_GetSensor_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadType(&p_type))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SensorProvider::Name_, 0, false);
        return false;
      }
      SensorProvider::GetSensorCallback callback =
          SensorProvider_GetSensor_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetSensor(
std::move(p_type), std::move(callback));
      return true;
    }
  }
  return false;
}


static const mojo::internal::GenericValidationInfo kSensorProviderValidationInfo[] = {
    {&internal::SensorProvider_GetSensor_Params_Data::Validate,
     &internal::SensorProvider_GetSensor_ResponseParams_Data::Validate},
};

bool SensorProviderRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::device::mojom::blink::SensorProvider::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kSensorProviderValidationInfo);
}

bool SensorProviderResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::device::mojom::blink::SensorProvider::Name_;
  return mojo::internal::ValidateResponseGenericPacked(message, name, kSensorProviderValidationInfo);
}
}  // namespace blink
}  // namespace mojom
}  // namespace device

namespace mojo {


// static
bool StructTraits<::device::mojom::blink::SensorInitParams::DataView, ::device::mojom::blink::SensorInitParamsPtr>::Read(
    ::device::mojom::blink::SensorInitParams::DataView input,
    ::device::mojom::blink::SensorInitParamsPtr* output) {
  bool success = true;
  ::device::mojom::blink::SensorInitParamsPtr result(::device::mojom::blink::SensorInitParams::New());
  
      if (success) {
        result->sensor =
            input.TakeSensor<decltype(result->sensor)>();
      }
      if (success) {
        result->client_receiver =
            input.TakeClientReceiver<decltype(result->client_receiver)>();
      }
      if (success)
        result->memory = input.TakeMemory();
      if (success)
        result->buffer_offset = input.buffer_offset();
      if (success && !input.ReadMode(&result->mode))
        success = false;
      if (success && !input.ReadDefaultConfiguration(&result->default_configuration))
        success = false;
      if (success)
        result->maximum_frequency = input.maximum_frequency();
      if (success)
        result->minimum_frequency = input.minimum_frequency();
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif