// services/device/public/mojom/serial.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/device/public/mojom/serial.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "services/device/public/mojom/serial.mojom-params-data.h"
#include "services/device/public/mojom/serial.mojom-shared-message-ids.h"

#include "services/device/public/mojom/serial.mojom-blink-import-headers.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


#ifndef SERVICES_DEVICE_PUBLIC_MOJOM_SERIAL_MOJOM_BLINK_JUMBO_H_
#define SERVICES_DEVICE_PUBLIC_MOJOM_SERIAL_MOJOM_BLINK_JUMBO_H_
#endif
namespace device {
namespace mojom {
namespace blink {
SerialPortInfo::SerialPortInfo()
    : token(),
      path(),
      type(DeviceType::PLATFORM_SERIAL),
      vendor_id(),
      has_vendor_id(false),
      product_id(),
      has_product_id(false),
      display_name(),
      serial_number() {}

SerialPortInfo::SerialPortInfo(
    const ::base::UnguessableToken& token_in,
    const ::base::FilePath& path_in,
    DeviceType type_in,
    uint16_t vendor_id_in,
    bool has_vendor_id_in,
    uint16_t product_id_in,
    bool has_product_id_in,
    const WTF::String& display_name_in,
    const WTF::String& serial_number_in)
    : token(std::move(token_in)),
      path(std::move(path_in)),
      type(std::move(type_in)),
      vendor_id(std::move(vendor_id_in)),
      has_vendor_id(std::move(has_vendor_id_in)),
      product_id(std::move(product_id_in)),
      has_product_id(std::move(has_product_id_in)),
      display_name(std::move(display_name_in)),
      serial_number(std::move(serial_number_in)) {}

SerialPortInfo::~SerialPortInfo() = default;

void SerialPortInfo::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "token"), this->token, 
      "<value of type const ::base::UnguessableToken&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "path"), this->path, 
      "<value of type const ::base::FilePath&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "type"), this->type, 
      "<value of type DeviceType>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "vendor_id"), this->vendor_id, 
      "<value of type uint16_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "has_vendor_id"), this->has_vendor_id, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "product_id"), this->product_id, 
      "<value of type uint16_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "has_product_id"), this->has_product_id, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "display_name"), this->display_name, 
      "<value of type const WTF::String&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "serial_number"), this->serial_number, 
      "<value of type const WTF::String&>");
}

bool SerialPortInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
SerialConnectionOptions::SerialConnectionOptions()
    : bitrate(0U),
      data_bits(SerialDataBits::NONE),
      parity_bit(SerialParityBit::NONE),
      stop_bits(SerialStopBits::NONE),
      cts_flow_control(),
      has_cts_flow_control(false) {}

SerialConnectionOptions::SerialConnectionOptions(
    uint32_t bitrate_in,
    SerialDataBits data_bits_in,
    SerialParityBit parity_bit_in,
    SerialStopBits stop_bits_in,
    bool cts_flow_control_in,
    bool has_cts_flow_control_in)
    : bitrate(std::move(bitrate_in)),
      data_bits(std::move(data_bits_in)),
      parity_bit(std::move(parity_bit_in)),
      stop_bits(std::move(stop_bits_in)),
      cts_flow_control(std::move(cts_flow_control_in)),
      has_cts_flow_control(std::move(has_cts_flow_control_in)) {}

SerialConnectionOptions::~SerialConnectionOptions() = default;
size_t SerialConnectionOptions::Hash(size_t seed) const {
  seed = mojo::internal::WTFHash(seed, this->bitrate);
  seed = mojo::internal::WTFHash(seed, this->data_bits);
  seed = mojo::internal::WTFHash(seed, this->parity_bit);
  seed = mojo::internal::WTFHash(seed, this->stop_bits);
  seed = mojo::internal::WTFHash(seed, this->cts_flow_control);
  seed = mojo::internal::WTFHash(seed, this->has_cts_flow_control);
  return seed;
}

void SerialConnectionOptions::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "bitrate"), this->bitrate, 
      "<value of type uint32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "data_bits"), this->data_bits, 
      "<value of type SerialDataBits>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "parity_bit"), this->parity_bit, 
      "<value of type SerialParityBit>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "stop_bits"), this->stop_bits, 
      "<value of type SerialStopBits>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "cts_flow_control"), this->cts_flow_control, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "has_cts_flow_control"), this->has_cts_flow_control, 
      "<value of type bool>");
}

bool SerialConnectionOptions::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
SerialConnectionInfo::SerialConnectionInfo()
    : bitrate(0U),
      data_bits(SerialDataBits::NONE),
      parity_bit(SerialParityBit::NONE),
      stop_bits(SerialStopBits::NONE),
      cts_flow_control() {}

SerialConnectionInfo::SerialConnectionInfo(
    uint32_t bitrate_in,
    SerialDataBits data_bits_in,
    SerialParityBit parity_bit_in,
    SerialStopBits stop_bits_in,
    bool cts_flow_control_in)
    : bitrate(std::move(bitrate_in)),
      data_bits(std::move(data_bits_in)),
      parity_bit(std::move(parity_bit_in)),
      stop_bits(std::move(stop_bits_in)),
      cts_flow_control(std::move(cts_flow_control_in)) {}

SerialConnectionInfo::~SerialConnectionInfo() = default;
size_t SerialConnectionInfo::Hash(size_t seed) const {
  seed = mojo::internal::WTFHash(seed, this->bitrate);
  seed = mojo::internal::WTFHash(seed, this->data_bits);
  seed = mojo::internal::WTFHash(seed, this->parity_bit);
  seed = mojo::internal::WTFHash(seed, this->stop_bits);
  seed = mojo::internal::WTFHash(seed, this->cts_flow_control);
  return seed;
}

void SerialConnectionInfo::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "bitrate"), this->bitrate, 
      "<value of type uint32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "data_bits"), this->data_bits, 
      "<value of type SerialDataBits>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "parity_bit"), this->parity_bit, 
      "<value of type SerialParityBit>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "stop_bits"), this->stop_bits, 
      "<value of type SerialStopBits>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "cts_flow_control"), this->cts_flow_control, 
      "<value of type bool>");
}

bool SerialConnectionInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
SerialHostControlSignals::SerialHostControlSignals()
    : dtr(),
      has_dtr(false),
      rts(),
      has_rts(false),
      brk(),
      has_brk(false) {}

SerialHostControlSignals::SerialHostControlSignals(
    bool dtr_in,
    bool has_dtr_in,
    bool rts_in,
    bool has_rts_in,
    bool brk_in,
    bool has_brk_in)
    : dtr(std::move(dtr_in)),
      has_dtr(std::move(has_dtr_in)),
      rts(std::move(rts_in)),
      has_rts(std::move(has_rts_in)),
      brk(std::move(brk_in)),
      has_brk(std::move(has_brk_in)) {}

SerialHostControlSignals::~SerialHostControlSignals() = default;
size_t SerialHostControlSignals::Hash(size_t seed) const {
  seed = mojo::internal::WTFHash(seed, this->dtr);
  seed = mojo::internal::WTFHash(seed, this->has_dtr);
  seed = mojo::internal::WTFHash(seed, this->rts);
  seed = mojo::internal::WTFHash(seed, this->has_rts);
  seed = mojo::internal::WTFHash(seed, this->brk);
  seed = mojo::internal::WTFHash(seed, this->has_brk);
  return seed;
}

void SerialHostControlSignals::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "dtr"), this->dtr, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "has_dtr"), this->has_dtr, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "rts"), this->rts, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "has_rts"), this->has_rts, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "brk"), this->brk, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "has_brk"), this->has_brk, 
      "<value of type bool>");
}

bool SerialHostControlSignals::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
SerialPortControlSignals::SerialPortControlSignals()
    : dcd(),
      cts(),
      ri(),
      dsr() {}

SerialPortControlSignals::SerialPortControlSignals(
    bool dcd_in,
    bool cts_in,
    bool ri_in,
    bool dsr_in)
    : dcd(std::move(dcd_in)),
      cts(std::move(cts_in)),
      ri(std::move(ri_in)),
      dsr(std::move(dsr_in)) {}

SerialPortControlSignals::~SerialPortControlSignals() = default;
size_t SerialPortControlSignals::Hash(size_t seed) const {
  seed = mojo::internal::WTFHash(seed, this->dcd);
  seed = mojo::internal::WTFHash(seed, this->cts);
  seed = mojo::internal::WTFHash(seed, this->ri);
  seed = mojo::internal::WTFHash(seed, this->dsr);
  return seed;
}

void SerialPortControlSignals::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "dcd"), this->dcd, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "cts"), this->cts, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "ri"), this->ri, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "dsr"), this->dsr, 
      "<value of type bool>");
}

bool SerialPortControlSignals::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
const char SerialPortManager::Name_[] = "device.mojom.SerialPortManager";

class SerialPortManager_GetDevices_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  SerialPortManager_GetDevices_ForwardToCallback(
      SerialPortManager::GetDevicesCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  SerialPortManager::GetDevicesCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(SerialPortManager_GetDevices_ForwardToCallback);
};

class SerialPortManager_OpenPort_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  SerialPortManager_OpenPort_ForwardToCallback(
      SerialPortManager::OpenPortCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  SerialPortManager::OpenPortCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(SerialPortManager_OpenPort_ForwardToCallback);
};

SerialPortManagerProxy::SerialPortManagerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void SerialPortManagerProxy::SetClient(
    ::mojo::PendingRemote<SerialPortManagerClient> in_client) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "device::mojom::SerialPortManager::SetClient", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client"), in_client, 
                        "<value of type ::mojo::PendingRemote<SerialPortManagerClient>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kSerialPortManager_SetClient_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::SerialPortManager_SetClient_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::device::mojom::SerialPortManagerClientInterfaceBase>>(
      in_client, &params->client, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->client),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid client in SerialPortManager.SetClient request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SerialPortManager::Name_);
  message.set_method_name("SetClient");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void SerialPortManagerProxy::GetDevices(
    GetDevicesCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "device::mojom::SerialPortManager::GetDevices");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kSerialPortManager_GetDevices_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::SerialPortManager_GetDevices_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SerialPortManager::Name_);
  message.set_method_name("GetDevices");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new SerialPortManager_GetDevices_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void SerialPortManagerProxy::OpenPort(
    const ::base::UnguessableToken& in_token, bool in_use_alternate_path, SerialConnectionOptionsPtr in_options, ::mojo::PendingRemote<SerialPortClient> in_client, ::mojo::PendingRemote<SerialPortConnectionWatcher> in_watcher, OpenPortCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "device::mojom::SerialPortManager::OpenPort", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("token"), in_token, 
                        "<value of type const ::base::UnguessableToken&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("use_alternate_path"), in_use_alternate_path, 
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("options"), in_options, 
                        "<value of type SerialConnectionOptionsPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client"), in_client, 
                        "<value of type ::mojo::PendingRemote<SerialPortClient>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("watcher"), in_watcher, 
                        "<value of type ::mojo::PendingRemote<SerialPortConnectionWatcher>>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kSerialPortManager_OpenPort_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::SerialPortManager_OpenPort_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->token)::BaseType> token_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
      in_token, token_fragment);
  params->token.Set(
      token_fragment.is_null() ? nullptr : token_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->token.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null token in SerialPortManager.OpenPort request");
  params->use_alternate_path = in_use_alternate_path;
  mojo::internal::MessageFragment<
      typename decltype(params->options)::BaseType> options_fragment(
          params.message());
  mojo::internal::Serialize<::device::mojom::SerialConnectionOptionsDataView>(
      in_options, options_fragment);
  params->options.Set(
      options_fragment.is_null() ? nullptr : options_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->options.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null options in SerialPortManager.OpenPort request");
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::device::mojom::SerialPortClientInterfaceBase>>(
      in_client, &params->client, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->client),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid client in SerialPortManager.OpenPort request");
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::device::mojom::SerialPortConnectionWatcherInterfaceBase>>(
      in_watcher, &params->watcher, &params.message());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SerialPortManager::Name_);
  message.set_method_name("OpenPort");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new SerialPortManager_OpenPort_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
class SerialPortManager_GetDevices_ProxyToResponder {
 public:
  static SerialPortManager::GetDevicesCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<SerialPortManager_GetDevices_ProxyToResponder> proxy(
        new SerialPortManager_GetDevices_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&SerialPortManager_GetDevices_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~SerialPortManager_GetDevices_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  SerialPortManager_GetDevices_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "SerialPortManager::GetDevicesCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      WTF::Vector<SerialPortInfoPtr> in_devices);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(SerialPortManager_GetDevices_ProxyToResponder);
};

bool SerialPortManager_GetDevices_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "device::mojom::SerialPortManager::GetDevicesCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::SerialPortManager_GetDevices_ResponseParams_Data* params =
      reinterpret_cast<
          internal::SerialPortManager_GetDevices_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  WTF::Vector<SerialPortInfoPtr> p_devices{};
  SerialPortManager_GetDevices_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadDevices(&p_devices))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        SerialPortManager::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_devices));
  return true;
}

void SerialPortManager_GetDevices_ProxyToResponder::Run(
    WTF::Vector<SerialPortInfoPtr> in_devices) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)device::mojom::SerialPortManager::GetDevicesCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("devices"), in_devices, 
                        "<value of type WTF::Vector<SerialPortInfoPtr>>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kSerialPortManager_GetDevices_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::SerialPortManager_GetDevices_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->devices)::BaseType>
      devices_fragment(params.message());
  const mojo::internal::ContainerValidateParams devices_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::device::mojom::SerialPortInfoDataView>>(
      in_devices, devices_fragment, &devices_validate_params);
  params->devices.Set(
      devices_fragment.is_null() ? nullptr : devices_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->devices.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null devices in ");

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)device::mojom::SerialPortManager::GetDevicesCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SerialPortManager::Name_);
  message.set_method_name("GetDevices");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class SerialPortManager_OpenPort_ProxyToResponder {
 public:
  static SerialPortManager::OpenPortCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<SerialPortManager_OpenPort_ProxyToResponder> proxy(
        new SerialPortManager_OpenPort_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&SerialPortManager_OpenPort_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~SerialPortManager_OpenPort_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  SerialPortManager_OpenPort_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "SerialPortManager::OpenPortCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::mojo::PendingRemote<SerialPort> in_port);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(SerialPortManager_OpenPort_ProxyToResponder);
};

bool SerialPortManager_OpenPort_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "device::mojom::SerialPortManager::OpenPortCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::SerialPortManager_OpenPort_ResponseParams_Data* params =
      reinterpret_cast<
          internal::SerialPortManager_OpenPort_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ::mojo::PendingRemote<SerialPort> p_port{};
  SerialPortManager_OpenPort_ResponseParamsDataView input_data_view(params, message);
  
  if (success) {
    p_port =
        input_data_view.TakePort<decltype(p_port)>();
  }
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        SerialPortManager::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_port));
  return true;
}

void SerialPortManager_OpenPort_ProxyToResponder::Run(
    ::mojo::PendingRemote<SerialPort> in_port) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)device::mojom::SerialPortManager::OpenPortCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("port"), in_port, 
                        "<value of type ::mojo::PendingRemote<SerialPort>>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kSerialPortManager_OpenPort_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::SerialPortManager_OpenPort_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::device::mojom::SerialPortInterfaceBase>>(
      in_port, &params->port, &params.message());

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)device::mojom::SerialPortManager::OpenPortCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SerialPortManager::Name_);
  message.set_method_name("OpenPort");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool SerialPortManagerStubDispatch::Accept(
    SerialPortManager* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kSerialPortManager_SetClient_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)device::mojom::SerialPortManager::SetClient",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)device::mojom::SerialPortManager::SetClient");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::SerialPortManager_SetClient_Params_Data* params =
          reinterpret_cast<internal::SerialPortManager_SetClient_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingRemote<SerialPortManagerClient> p_client{};
      SerialPortManager_SetClient_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_client =
            input_data_view.TakeClient<decltype(p_client)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SerialPortManager::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetClient(
std::move(p_client));
      return true;
    }
    case internal::kSerialPortManager_GetDevices_Name: {
      break;
    }
    case internal::kSerialPortManager_OpenPort_Name: {
      break;
    }
  }
  return false;
}

// static
bool SerialPortManagerStubDispatch::AcceptWithResponder(
    SerialPortManager* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kSerialPortManager_SetClient_Name: {
      break;
    }
    case internal::kSerialPortManager_GetDevices_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)device::mojom::SerialPortManager::GetDevices",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)device::mojom::SerialPortManager::GetDevices");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::SerialPortManager_GetDevices_Params_Data* params =
          reinterpret_cast<
              internal::SerialPortManager_GetDevices_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      SerialPortManager_GetDevices_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SerialPortManager::Name_, 1, false);
        return false;
      }
      SerialPortManager::GetDevicesCallback callback =
          SerialPortManager_GetDevices_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetDevices(std::move(callback));
      return true;
    }
    case internal::kSerialPortManager_OpenPort_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)device::mojom::SerialPortManager::OpenPort",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)device::mojom::SerialPortManager::OpenPort");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::SerialPortManager_OpenPort_Params_Data* params =
          reinterpret_cast<
              internal::SerialPortManager_OpenPort_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::base::UnguessableToken p_token{};
      bool p_use_alternate_path{};
      SerialConnectionOptionsPtr p_options{};
      ::mojo::PendingRemote<SerialPortClient> p_client{};
      ::mojo::PendingRemote<SerialPortConnectionWatcher> p_watcher{};
      SerialPortManager_OpenPort_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadToken(&p_token))
        success = false;
      if (success)
        p_use_alternate_path = input_data_view.use_alternate_path();
      if (success && !input_data_view.ReadOptions(&p_options))
        success = false;
      if (success) {
        p_client =
            input_data_view.TakeClient<decltype(p_client)>();
      }
      if (success) {
        p_watcher =
            input_data_view.TakeWatcher<decltype(p_watcher)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SerialPortManager::Name_, 2, false);
        return false;
      }
      SerialPortManager::OpenPortCallback callback =
          SerialPortManager_OpenPort_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OpenPort(
std::move(p_token), 
std::move(p_use_alternate_path), 
std::move(p_options), 
std::move(p_client), 
std::move(p_watcher), std::move(callback));
      return true;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kSerialPortManagerValidationInfo[] = {
    {internal::kSerialPortManager_SetClient_Name,
     {&internal::SerialPortManager_SetClient_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kSerialPortManager_GetDevices_Name,
     {&internal::SerialPortManager_GetDevices_Params_Data::Validate,
      &internal::SerialPortManager_GetDevices_ResponseParams_Data::Validate}},
    {internal::kSerialPortManager_OpenPort_Name,
     {&internal::SerialPortManager_OpenPort_Params_Data::Validate,
      &internal::SerialPortManager_OpenPort_ResponseParams_Data::Validate}},
};

bool SerialPortManagerRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::device::mojom::blink::SerialPortManager::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kSerialPortManagerValidationInfo);
}

bool SerialPortManagerResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::device::mojom::blink::SerialPortManager::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kSerialPortManagerValidationInfo);

}
const char SerialPortManagerClient::Name_[] = "device.mojom.SerialPortManagerClient";

SerialPortManagerClientProxy::SerialPortManagerClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void SerialPortManagerClientProxy::OnPortAdded(
    SerialPortInfoPtr in_port_info) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "device::mojom::SerialPortManagerClient::OnPortAdded", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("port_info"), in_port_info, 
                        "<value of type SerialPortInfoPtr>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kSerialPortManagerClient_OnPortAdded_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::SerialPortManagerClient_OnPortAdded_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->port_info)::BaseType> port_info_fragment(
          params.message());
  mojo::internal::Serialize<::device::mojom::SerialPortInfoDataView>(
      in_port_info, port_info_fragment);
  params->port_info.Set(
      port_info_fragment.is_null() ? nullptr : port_info_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->port_info.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null port_info in SerialPortManagerClient.OnPortAdded request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SerialPortManagerClient::Name_);
  message.set_method_name("OnPortAdded");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void SerialPortManagerClientProxy::OnPortRemoved(
    SerialPortInfoPtr in_port_info) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "device::mojom::SerialPortManagerClient::OnPortRemoved", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("port_info"), in_port_info, 
                        "<value of type SerialPortInfoPtr>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kSerialPortManagerClient_OnPortRemoved_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::SerialPortManagerClient_OnPortRemoved_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->port_info)::BaseType> port_info_fragment(
          params.message());
  mojo::internal::Serialize<::device::mojom::SerialPortInfoDataView>(
      in_port_info, port_info_fragment);
  params->port_info.Set(
      port_info_fragment.is_null() ? nullptr : port_info_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->port_info.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null port_info in SerialPortManagerClient.OnPortRemoved request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SerialPortManagerClient::Name_);
  message.set_method_name("OnPortRemoved");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool SerialPortManagerClientStubDispatch::Accept(
    SerialPortManagerClient* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kSerialPortManagerClient_OnPortAdded_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)device::mojom::SerialPortManagerClient::OnPortAdded",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)device::mojom::SerialPortManagerClient::OnPortAdded");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::SerialPortManagerClient_OnPortAdded_Params_Data* params =
          reinterpret_cast<internal::SerialPortManagerClient_OnPortAdded_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      SerialPortInfoPtr p_port_info{};
      SerialPortManagerClient_OnPortAdded_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPortInfo(&p_port_info))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SerialPortManagerClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnPortAdded(
std::move(p_port_info));
      return true;
    }
    case internal::kSerialPortManagerClient_OnPortRemoved_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)device::mojom::SerialPortManagerClient::OnPortRemoved",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)device::mojom::SerialPortManagerClient::OnPortRemoved");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::SerialPortManagerClient_OnPortRemoved_Params_Data* params =
          reinterpret_cast<internal::SerialPortManagerClient_OnPortRemoved_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      SerialPortInfoPtr p_port_info{};
      SerialPortManagerClient_OnPortRemoved_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPortInfo(&p_port_info))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SerialPortManagerClient::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnPortRemoved(
std::move(p_port_info));
      return true;
    }
  }
  return false;
}

// static
bool SerialPortManagerClientStubDispatch::AcceptWithResponder(
    SerialPortManagerClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kSerialPortManagerClient_OnPortAdded_Name: {
      break;
    }
    case internal::kSerialPortManagerClient_OnPortRemoved_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kSerialPortManagerClientValidationInfo[] = {
    {internal::kSerialPortManagerClient_OnPortAdded_Name,
     {&internal::SerialPortManagerClient_OnPortAdded_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kSerialPortManagerClient_OnPortRemoved_Name,
     {&internal::SerialPortManagerClient_OnPortRemoved_Params_Data::Validate,
      nullptr /* no response */}},
};

bool SerialPortManagerClientRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::device::mojom::blink::SerialPortManagerClient::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kSerialPortManagerClientValidationInfo);
}

const char SerialPort::Name_[] = "device.mojom.SerialPort";

class SerialPort_Flush_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  SerialPort_Flush_ForwardToCallback(
      SerialPort::FlushCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  SerialPort::FlushCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(SerialPort_Flush_ForwardToCallback);
};

class SerialPort_Drain_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  SerialPort_Drain_ForwardToCallback(
      SerialPort::DrainCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  SerialPort::DrainCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(SerialPort_Drain_ForwardToCallback);
};

class SerialPort_GetControlSignals_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  SerialPort_GetControlSignals_ForwardToCallback(
      SerialPort::GetControlSignalsCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  SerialPort::GetControlSignalsCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(SerialPort_GetControlSignals_ForwardToCallback);
};

class SerialPort_SetControlSignals_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  SerialPort_SetControlSignals_ForwardToCallback(
      SerialPort::SetControlSignalsCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  SerialPort::SetControlSignalsCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(SerialPort_SetControlSignals_ForwardToCallback);
};

class SerialPort_ConfigurePort_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  SerialPort_ConfigurePort_ForwardToCallback(
      SerialPort::ConfigurePortCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  SerialPort::ConfigurePortCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(SerialPort_ConfigurePort_ForwardToCallback);
};

class SerialPort_GetPortInfo_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  SerialPort_GetPortInfo_ForwardToCallback(
      SerialPort::GetPortInfoCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  SerialPort::GetPortInfoCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(SerialPort_GetPortInfo_ForwardToCallback);
};

class SerialPort_Close_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  SerialPort_Close_ForwardToCallback(
      SerialPort::CloseCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  SerialPort::CloseCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(SerialPort_Close_ForwardToCallback);
};

SerialPortProxy::SerialPortProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void SerialPortProxy::StartWriting(
    ::mojo::ScopedDataPipeConsumerHandle in_consumer) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "device::mojom::SerialPort::StartWriting", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("consumer"), in_consumer, 
                        "<value of type ::mojo::ScopedDataPipeConsumerHandle>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kSerialPort_StartWriting_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::SerialPort_StartWriting_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::ScopedDataPipeConsumerHandle>(
      in_consumer, &params->consumer, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->consumer),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid consumer in SerialPort.StartWriting request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SerialPort::Name_);
  message.set_method_name("StartWriting");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void SerialPortProxy::StartReading(
    ::mojo::ScopedDataPipeProducerHandle in_producer) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "device::mojom::SerialPort::StartReading", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("producer"), in_producer, 
                        "<value of type ::mojo::ScopedDataPipeProducerHandle>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kSerialPort_StartReading_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::SerialPort_StartReading_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::ScopedDataPipeProducerHandle>(
      in_producer, &params->producer, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->producer),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid producer in SerialPort.StartReading request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SerialPort::Name_);
  message.set_method_name("StartReading");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void SerialPortProxy::Flush(
    SerialPortFlushMode in_mode, FlushCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "device::mojom::SerialPort::Flush", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("mode"), in_mode, 
                        "<value of type SerialPortFlushMode>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kSerialPort_Flush_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::SerialPort_Flush_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::device::mojom::SerialPortFlushMode>(
      in_mode, &params->mode);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SerialPort::Name_);
  message.set_method_name("Flush");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new SerialPort_Flush_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void SerialPortProxy::Drain(
    DrainCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "device::mojom::SerialPort::Drain");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kSerialPort_Drain_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::SerialPort_Drain_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SerialPort::Name_);
  message.set_method_name("Drain");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new SerialPort_Drain_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void SerialPortProxy::GetControlSignals(
    GetControlSignalsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "device::mojom::SerialPort::GetControlSignals");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kSerialPort_GetControlSignals_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::SerialPort_GetControlSignals_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SerialPort::Name_);
  message.set_method_name("GetControlSignals");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new SerialPort_GetControlSignals_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void SerialPortProxy::SetControlSignals(
    SerialHostControlSignalsPtr in_signals, SetControlSignalsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "device::mojom::SerialPort::SetControlSignals", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("signals"), in_signals, 
                        "<value of type SerialHostControlSignalsPtr>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kSerialPort_SetControlSignals_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::SerialPort_SetControlSignals_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->signals)::BaseType> signals_fragment(
          params.message());
  mojo::internal::Serialize<::device::mojom::SerialHostControlSignalsDataView>(
      in_signals, signals_fragment);
  params->signals.Set(
      signals_fragment.is_null() ? nullptr : signals_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->signals.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null signals in SerialPort.SetControlSignals request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SerialPort::Name_);
  message.set_method_name("SetControlSignals");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new SerialPort_SetControlSignals_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void SerialPortProxy::ConfigurePort(
    SerialConnectionOptionsPtr in_options, ConfigurePortCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "device::mojom::SerialPort::ConfigurePort", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("options"), in_options, 
                        "<value of type SerialConnectionOptionsPtr>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kSerialPort_ConfigurePort_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::SerialPort_ConfigurePort_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->options)::BaseType> options_fragment(
          params.message());
  mojo::internal::Serialize<::device::mojom::SerialConnectionOptionsDataView>(
      in_options, options_fragment);
  params->options.Set(
      options_fragment.is_null() ? nullptr : options_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->options.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null options in SerialPort.ConfigurePort request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SerialPort::Name_);
  message.set_method_name("ConfigurePort");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new SerialPort_ConfigurePort_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void SerialPortProxy::GetPortInfo(
    GetPortInfoCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "device::mojom::SerialPort::GetPortInfo");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kSerialPort_GetPortInfo_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::SerialPort_GetPortInfo_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SerialPort::Name_);
  message.set_method_name("GetPortInfo");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new SerialPort_GetPortInfo_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void SerialPortProxy::Close(
    CloseCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "device::mojom::SerialPort::Close");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kSerialPort_Close_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::SerialPort_Close_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SerialPort::Name_);
  message.set_method_name("Close");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new SerialPort_Close_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
class SerialPort_Flush_ProxyToResponder {
 public:
  static SerialPort::FlushCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<SerialPort_Flush_ProxyToResponder> proxy(
        new SerialPort_Flush_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&SerialPort_Flush_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~SerialPort_Flush_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  SerialPort_Flush_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "SerialPort::FlushCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(SerialPort_Flush_ProxyToResponder);
};

bool SerialPort_Flush_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "device::mojom::SerialPort::FlushCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::SerialPort_Flush_ResponseParams_Data* params =
      reinterpret_cast<
          internal::SerialPort_Flush_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  SerialPort_Flush_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        SerialPort::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run();
  return true;
}

void SerialPort_Flush_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "(Impl)device::mojom::SerialPort::FlushCallback");
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kSerialPort_Flush_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::SerialPort_Flush_ResponseParams_Data> params(
          message);
  params.Allocate();

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)device::mojom::SerialPort::FlushCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SerialPort::Name_);
  message.set_method_name("Flush");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class SerialPort_Drain_ProxyToResponder {
 public:
  static SerialPort::DrainCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<SerialPort_Drain_ProxyToResponder> proxy(
        new SerialPort_Drain_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&SerialPort_Drain_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~SerialPort_Drain_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  SerialPort_Drain_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "SerialPort::DrainCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(SerialPort_Drain_ProxyToResponder);
};

bool SerialPort_Drain_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "device::mojom::SerialPort::DrainCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::SerialPort_Drain_ResponseParams_Data* params =
      reinterpret_cast<
          internal::SerialPort_Drain_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  SerialPort_Drain_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        SerialPort::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run();
  return true;
}

void SerialPort_Drain_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "(Impl)device::mojom::SerialPort::DrainCallback");
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kSerialPort_Drain_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::SerialPort_Drain_ResponseParams_Data> params(
          message);
  params.Allocate();

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)device::mojom::SerialPort::DrainCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SerialPort::Name_);
  message.set_method_name("Drain");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class SerialPort_GetControlSignals_ProxyToResponder {
 public:
  static SerialPort::GetControlSignalsCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<SerialPort_GetControlSignals_ProxyToResponder> proxy(
        new SerialPort_GetControlSignals_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&SerialPort_GetControlSignals_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~SerialPort_GetControlSignals_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  SerialPort_GetControlSignals_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "SerialPort::GetControlSignalsCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      SerialPortControlSignalsPtr in_signals);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(SerialPort_GetControlSignals_ProxyToResponder);
};

bool SerialPort_GetControlSignals_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "device::mojom::SerialPort::GetControlSignalsCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::SerialPort_GetControlSignals_ResponseParams_Data* params =
      reinterpret_cast<
          internal::SerialPort_GetControlSignals_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  SerialPortControlSignalsPtr p_signals{};
  SerialPort_GetControlSignals_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadSignals(&p_signals))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        SerialPort::Name_, 4, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_signals));
  return true;
}

void SerialPort_GetControlSignals_ProxyToResponder::Run(
    SerialPortControlSignalsPtr in_signals) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)device::mojom::SerialPort::GetControlSignalsCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("signals"), in_signals, 
                        "<value of type SerialPortControlSignalsPtr>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kSerialPort_GetControlSignals_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::SerialPort_GetControlSignals_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->signals)::BaseType> signals_fragment(
          params.message());
  mojo::internal::Serialize<::device::mojom::SerialPortControlSignalsDataView>(
      in_signals, signals_fragment);
  params->signals.Set(
      signals_fragment.is_null() ? nullptr : signals_fragment.data());

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)device::mojom::SerialPort::GetControlSignalsCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SerialPort::Name_);
  message.set_method_name("GetControlSignals");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class SerialPort_SetControlSignals_ProxyToResponder {
 public:
  static SerialPort::SetControlSignalsCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<SerialPort_SetControlSignals_ProxyToResponder> proxy(
        new SerialPort_SetControlSignals_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&SerialPort_SetControlSignals_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~SerialPort_SetControlSignals_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  SerialPort_SetControlSignals_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "SerialPort::SetControlSignalsCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(SerialPort_SetControlSignals_ProxyToResponder);
};

bool SerialPort_SetControlSignals_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "device::mojom::SerialPort::SetControlSignalsCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::SerialPort_SetControlSignals_ResponseParams_Data* params =
      reinterpret_cast<
          internal::SerialPort_SetControlSignals_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  bool p_success{};
  SerialPort_SetControlSignals_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        SerialPort::Name_, 5, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_success));
  return true;
}

void SerialPort_SetControlSignals_ProxyToResponder::Run(
    bool in_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)device::mojom::SerialPort::SetControlSignalsCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success, 
                        "<value of type bool>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kSerialPort_SetControlSignals_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::SerialPort_SetControlSignals_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->success = in_success;

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)device::mojom::SerialPort::SetControlSignalsCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SerialPort::Name_);
  message.set_method_name("SetControlSignals");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class SerialPort_ConfigurePort_ProxyToResponder {
 public:
  static SerialPort::ConfigurePortCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<SerialPort_ConfigurePort_ProxyToResponder> proxy(
        new SerialPort_ConfigurePort_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&SerialPort_ConfigurePort_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~SerialPort_ConfigurePort_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  SerialPort_ConfigurePort_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "SerialPort::ConfigurePortCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(SerialPort_ConfigurePort_ProxyToResponder);
};

bool SerialPort_ConfigurePort_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "device::mojom::SerialPort::ConfigurePortCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::SerialPort_ConfigurePort_ResponseParams_Data* params =
      reinterpret_cast<
          internal::SerialPort_ConfigurePort_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  bool p_success{};
  SerialPort_ConfigurePort_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        SerialPort::Name_, 6, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_success));
  return true;
}

void SerialPort_ConfigurePort_ProxyToResponder::Run(
    bool in_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)device::mojom::SerialPort::ConfigurePortCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success, 
                        "<value of type bool>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kSerialPort_ConfigurePort_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::SerialPort_ConfigurePort_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->success = in_success;

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)device::mojom::SerialPort::ConfigurePortCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SerialPort::Name_);
  message.set_method_name("ConfigurePort");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class SerialPort_GetPortInfo_ProxyToResponder {
 public:
  static SerialPort::GetPortInfoCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<SerialPort_GetPortInfo_ProxyToResponder> proxy(
        new SerialPort_GetPortInfo_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&SerialPort_GetPortInfo_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~SerialPort_GetPortInfo_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  SerialPort_GetPortInfo_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "SerialPort::GetPortInfoCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      SerialConnectionInfoPtr in_info);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(SerialPort_GetPortInfo_ProxyToResponder);
};

bool SerialPort_GetPortInfo_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "device::mojom::SerialPort::GetPortInfoCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::SerialPort_GetPortInfo_ResponseParams_Data* params =
      reinterpret_cast<
          internal::SerialPort_GetPortInfo_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  SerialConnectionInfoPtr p_info{};
  SerialPort_GetPortInfo_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadInfo(&p_info))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        SerialPort::Name_, 7, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_info));
  return true;
}

void SerialPort_GetPortInfo_ProxyToResponder::Run(
    SerialConnectionInfoPtr in_info) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)device::mojom::SerialPort::GetPortInfoCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("info"), in_info, 
                        "<value of type SerialConnectionInfoPtr>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kSerialPort_GetPortInfo_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::SerialPort_GetPortInfo_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->info)::BaseType> info_fragment(
          params.message());
  mojo::internal::Serialize<::device::mojom::SerialConnectionInfoDataView>(
      in_info, info_fragment);
  params->info.Set(
      info_fragment.is_null() ? nullptr : info_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->info.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null info in ");

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)device::mojom::SerialPort::GetPortInfoCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SerialPort::Name_);
  message.set_method_name("GetPortInfo");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class SerialPort_Close_ProxyToResponder {
 public:
  static SerialPort::CloseCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<SerialPort_Close_ProxyToResponder> proxy(
        new SerialPort_Close_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&SerialPort_Close_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~SerialPort_Close_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  SerialPort_Close_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "SerialPort::CloseCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(SerialPort_Close_ProxyToResponder);
};

bool SerialPort_Close_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "device::mojom::SerialPort::CloseCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::SerialPort_Close_ResponseParams_Data* params =
      reinterpret_cast<
          internal::SerialPort_Close_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  SerialPort_Close_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        SerialPort::Name_, 8, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run();
  return true;
}

void SerialPort_Close_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "(Impl)device::mojom::SerialPort::CloseCallback");
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kSerialPort_Close_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::SerialPort_Close_ResponseParams_Data> params(
          message);
  params.Allocate();

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)device::mojom::SerialPort::CloseCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SerialPort::Name_);
  message.set_method_name("Close");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool SerialPortStubDispatch::Accept(
    SerialPort* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kSerialPort_StartWriting_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)device::mojom::SerialPort::StartWriting",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)device::mojom::SerialPort::StartWriting");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::SerialPort_StartWriting_Params_Data* params =
          reinterpret_cast<internal::SerialPort_StartWriting_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::ScopedDataPipeConsumerHandle p_consumer{};
      SerialPort_StartWriting_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_consumer = input_data_view.TakeConsumer();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SerialPort::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->StartWriting(
std::move(p_consumer));
      return true;
    }
    case internal::kSerialPort_StartReading_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)device::mojom::SerialPort::StartReading",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)device::mojom::SerialPort::StartReading");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::SerialPort_StartReading_Params_Data* params =
          reinterpret_cast<internal::SerialPort_StartReading_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::ScopedDataPipeProducerHandle p_producer{};
      SerialPort_StartReading_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_producer = input_data_view.TakeProducer();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SerialPort::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->StartReading(
std::move(p_producer));
      return true;
    }
    case internal::kSerialPort_Flush_Name: {
      break;
    }
    case internal::kSerialPort_Drain_Name: {
      break;
    }
    case internal::kSerialPort_GetControlSignals_Name: {
      break;
    }
    case internal::kSerialPort_SetControlSignals_Name: {
      break;
    }
    case internal::kSerialPort_ConfigurePort_Name: {
      break;
    }
    case internal::kSerialPort_GetPortInfo_Name: {
      break;
    }
    case internal::kSerialPort_Close_Name: {
      break;
    }
  }
  return false;
}

// static
bool SerialPortStubDispatch::AcceptWithResponder(
    SerialPort* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kSerialPort_StartWriting_Name: {
      break;
    }
    case internal::kSerialPort_StartReading_Name: {
      break;
    }
    case internal::kSerialPort_Flush_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)device::mojom::SerialPort::Flush",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)device::mojom::SerialPort::Flush");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::SerialPort_Flush_Params_Data* params =
          reinterpret_cast<
              internal::SerialPort_Flush_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      SerialPortFlushMode p_mode{};
      SerialPort_Flush_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadMode(&p_mode))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SerialPort::Name_, 2, false);
        return false;
      }
      SerialPort::FlushCallback callback =
          SerialPort_Flush_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Flush(
std::move(p_mode), std::move(callback));
      return true;
    }
    case internal::kSerialPort_Drain_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)device::mojom::SerialPort::Drain",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)device::mojom::SerialPort::Drain");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::SerialPort_Drain_Params_Data* params =
          reinterpret_cast<
              internal::SerialPort_Drain_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      SerialPort_Drain_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SerialPort::Name_, 3, false);
        return false;
      }
      SerialPort::DrainCallback callback =
          SerialPort_Drain_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Drain(std::move(callback));
      return true;
    }
    case internal::kSerialPort_GetControlSignals_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)device::mojom::SerialPort::GetControlSignals",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)device::mojom::SerialPort::GetControlSignals");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::SerialPort_GetControlSignals_Params_Data* params =
          reinterpret_cast<
              internal::SerialPort_GetControlSignals_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      SerialPort_GetControlSignals_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SerialPort::Name_, 4, false);
        return false;
      }
      SerialPort::GetControlSignalsCallback callback =
          SerialPort_GetControlSignals_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetControlSignals(std::move(callback));
      return true;
    }
    case internal::kSerialPort_SetControlSignals_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)device::mojom::SerialPort::SetControlSignals",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)device::mojom::SerialPort::SetControlSignals");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::SerialPort_SetControlSignals_Params_Data* params =
          reinterpret_cast<
              internal::SerialPort_SetControlSignals_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      SerialHostControlSignalsPtr p_signals{};
      SerialPort_SetControlSignals_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSignals(&p_signals))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SerialPort::Name_, 5, false);
        return false;
      }
      SerialPort::SetControlSignalsCallback callback =
          SerialPort_SetControlSignals_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetControlSignals(
std::move(p_signals), std::move(callback));
      return true;
    }
    case internal::kSerialPort_ConfigurePort_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)device::mojom::SerialPort::ConfigurePort",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)device::mojom::SerialPort::ConfigurePort");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::SerialPort_ConfigurePort_Params_Data* params =
          reinterpret_cast<
              internal::SerialPort_ConfigurePort_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      SerialConnectionOptionsPtr p_options{};
      SerialPort_ConfigurePort_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadOptions(&p_options))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SerialPort::Name_, 6, false);
        return false;
      }
      SerialPort::ConfigurePortCallback callback =
          SerialPort_ConfigurePort_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ConfigurePort(
std::move(p_options), std::move(callback));
      return true;
    }
    case internal::kSerialPort_GetPortInfo_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)device::mojom::SerialPort::GetPortInfo",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)device::mojom::SerialPort::GetPortInfo");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::SerialPort_GetPortInfo_Params_Data* params =
          reinterpret_cast<
              internal::SerialPort_GetPortInfo_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      SerialPort_GetPortInfo_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SerialPort::Name_, 7, false);
        return false;
      }
      SerialPort::GetPortInfoCallback callback =
          SerialPort_GetPortInfo_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetPortInfo(std::move(callback));
      return true;
    }
    case internal::kSerialPort_Close_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)device::mojom::SerialPort::Close",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)device::mojom::SerialPort::Close");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::SerialPort_Close_Params_Data* params =
          reinterpret_cast<
              internal::SerialPort_Close_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      SerialPort_Close_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SerialPort::Name_, 8, false);
        return false;
      }
      SerialPort::CloseCallback callback =
          SerialPort_Close_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Close(std::move(callback));
      return true;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kSerialPortValidationInfo[] = {
    {internal::kSerialPort_StartWriting_Name,
     {&internal::SerialPort_StartWriting_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kSerialPort_StartReading_Name,
     {&internal::SerialPort_StartReading_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kSerialPort_Flush_Name,
     {&internal::SerialPort_Flush_Params_Data::Validate,
      &internal::SerialPort_Flush_ResponseParams_Data::Validate}},
    {internal::kSerialPort_Drain_Name,
     {&internal::SerialPort_Drain_Params_Data::Validate,
      &internal::SerialPort_Drain_ResponseParams_Data::Validate}},
    {internal::kSerialPort_GetControlSignals_Name,
     {&internal::SerialPort_GetControlSignals_Params_Data::Validate,
      &internal::SerialPort_GetControlSignals_ResponseParams_Data::Validate}},
    {internal::kSerialPort_SetControlSignals_Name,
     {&internal::SerialPort_SetControlSignals_Params_Data::Validate,
      &internal::SerialPort_SetControlSignals_ResponseParams_Data::Validate}},
    {internal::kSerialPort_ConfigurePort_Name,
     {&internal::SerialPort_ConfigurePort_Params_Data::Validate,
      &internal::SerialPort_ConfigurePort_ResponseParams_Data::Validate}},
    {internal::kSerialPort_GetPortInfo_Name,
     {&internal::SerialPort_GetPortInfo_Params_Data::Validate,
      &internal::SerialPort_GetPortInfo_ResponseParams_Data::Validate}},
    {internal::kSerialPort_Close_Name,
     {&internal::SerialPort_Close_Params_Data::Validate,
      &internal::SerialPort_Close_ResponseParams_Data::Validate}},
};

bool SerialPortRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::device::mojom::blink::SerialPort::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kSerialPortValidationInfo);
}

bool SerialPortResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::device::mojom::blink::SerialPort::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kSerialPortValidationInfo);

}
const char SerialPortClient::Name_[] = "device.mojom.SerialPortClient";

SerialPortClientProxy::SerialPortClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void SerialPortClientProxy::OnReadError(
    SerialReceiveError in_error) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "device::mojom::SerialPortClient::OnReadError", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), in_error, 
                        "<value of type SerialReceiveError>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kSerialPortClient_OnReadError_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::SerialPortClient_OnReadError_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::device::mojom::SerialReceiveError>(
      in_error, &params->error);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SerialPortClient::Name_);
  message.set_method_name("OnReadError");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void SerialPortClientProxy::OnSendError(
    SerialSendError in_error) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "device::mojom::SerialPortClient::OnSendError", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), in_error, 
                        "<value of type SerialSendError>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kSerialPortClient_OnSendError_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::SerialPortClient_OnSendError_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::device::mojom::SerialSendError>(
      in_error, &params->error);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SerialPortClient::Name_);
  message.set_method_name("OnSendError");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool SerialPortClientStubDispatch::Accept(
    SerialPortClient* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kSerialPortClient_OnReadError_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)device::mojom::SerialPortClient::OnReadError",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)device::mojom::SerialPortClient::OnReadError");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::SerialPortClient_OnReadError_Params_Data* params =
          reinterpret_cast<internal::SerialPortClient_OnReadError_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      SerialReceiveError p_error{};
      SerialPortClient_OnReadError_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadError(&p_error))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SerialPortClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnReadError(
std::move(p_error));
      return true;
    }
    case internal::kSerialPortClient_OnSendError_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)device::mojom::SerialPortClient::OnSendError",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)device::mojom::SerialPortClient::OnSendError");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::SerialPortClient_OnSendError_Params_Data* params =
          reinterpret_cast<internal::SerialPortClient_OnSendError_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      SerialSendError p_error{};
      SerialPortClient_OnSendError_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadError(&p_error))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SerialPortClient::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnSendError(
std::move(p_error));
      return true;
    }
  }
  return false;
}

// static
bool SerialPortClientStubDispatch::AcceptWithResponder(
    SerialPortClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kSerialPortClient_OnReadError_Name: {
      break;
    }
    case internal::kSerialPortClient_OnSendError_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kSerialPortClientValidationInfo[] = {
    {internal::kSerialPortClient_OnReadError_Name,
     {&internal::SerialPortClient_OnReadError_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kSerialPortClient_OnSendError_Name,
     {&internal::SerialPortClient_OnSendError_Params_Data::Validate,
      nullptr /* no response */}},
};

bool SerialPortClientRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::device::mojom::blink::SerialPortClient::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kSerialPortClientValidationInfo);
}

const char SerialPortConnectionWatcher::Name_[] = "device.mojom.SerialPortConnectionWatcher";

SerialPortConnectionWatcherProxy::SerialPortConnectionWatcherProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

// static
bool SerialPortConnectionWatcherStubDispatch::Accept(
    SerialPortConnectionWatcher* impl,
    mojo::Message* message) {
  return false;
}

// static
bool SerialPortConnectionWatcherStubDispatch::AcceptWithResponder(
    SerialPortConnectionWatcher* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  return false;
}



bool SerialPortConnectionWatcherRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::device::mojom::blink::SerialPortConnectionWatcher::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, {});
}

}  // namespace blink
}  // namespace mojom
}  // namespace device

namespace mojo {


// static
bool StructTraits<::device::mojom::blink::SerialPortInfo::DataView, ::device::mojom::blink::SerialPortInfoPtr>::Read(
    ::device::mojom::blink::SerialPortInfo::DataView input,
    ::device::mojom::blink::SerialPortInfoPtr* output) {
  bool success = true;
  ::device::mojom::blink::SerialPortInfoPtr result(::device::mojom::blink::SerialPortInfo::New());
  
      if (success && !input.ReadToken(&result->token))
        success = false;
      if (success && !input.ReadPath(&result->path))
        success = false;
      if (success && !input.ReadType(&result->type))
        success = false;
      if (success)
        result->vendor_id = input.vendor_id();
      if (success)
        result->has_vendor_id = input.has_vendor_id();
      if (success)
        result->product_id = input.product_id();
      if (success)
        result->has_product_id = input.has_product_id();
      if (success && !input.ReadDisplayName(&result->display_name))
        success = false;
      if (success && !input.ReadSerialNumber(&result->serial_number))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::device::mojom::blink::SerialConnectionOptions::DataView, ::device::mojom::blink::SerialConnectionOptionsPtr>::Read(
    ::device::mojom::blink::SerialConnectionOptions::DataView input,
    ::device::mojom::blink::SerialConnectionOptionsPtr* output) {
  bool success = true;
  ::device::mojom::blink::SerialConnectionOptionsPtr result(::device::mojom::blink::SerialConnectionOptions::New());
  
      if (success)
        result->bitrate = input.bitrate();
      if (success && !input.ReadDataBits(&result->data_bits))
        success = false;
      if (success && !input.ReadParityBit(&result->parity_bit))
        success = false;
      if (success && !input.ReadStopBits(&result->stop_bits))
        success = false;
      if (success)
        result->cts_flow_control = input.cts_flow_control();
      if (success)
        result->has_cts_flow_control = input.has_cts_flow_control();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::device::mojom::blink::SerialConnectionInfo::DataView, ::device::mojom::blink::SerialConnectionInfoPtr>::Read(
    ::device::mojom::blink::SerialConnectionInfo::DataView input,
    ::device::mojom::blink::SerialConnectionInfoPtr* output) {
  bool success = true;
  ::device::mojom::blink::SerialConnectionInfoPtr result(::device::mojom::blink::SerialConnectionInfo::New());
  
      if (success)
        result->bitrate = input.bitrate();
      if (success && !input.ReadDataBits(&result->data_bits))
        success = false;
      if (success && !input.ReadParityBit(&result->parity_bit))
        success = false;
      if (success && !input.ReadStopBits(&result->stop_bits))
        success = false;
      if (success)
        result->cts_flow_control = input.cts_flow_control();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::device::mojom::blink::SerialHostControlSignals::DataView, ::device::mojom::blink::SerialHostControlSignalsPtr>::Read(
    ::device::mojom::blink::SerialHostControlSignals::DataView input,
    ::device::mojom::blink::SerialHostControlSignalsPtr* output) {
  bool success = true;
  ::device::mojom::blink::SerialHostControlSignalsPtr result(::device::mojom::blink::SerialHostControlSignals::New());
  
      if (success)
        result->dtr = input.dtr();
      if (success)
        result->has_dtr = input.has_dtr();
      if (success)
        result->rts = input.rts();
      if (success)
        result->has_rts = input.has_rts();
      if (success)
        result->brk = input.brk();
      if (success)
        result->has_brk = input.has_brk();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::device::mojom::blink::SerialPortControlSignals::DataView, ::device::mojom::blink::SerialPortControlSignalsPtr>::Read(
    ::device::mojom::blink::SerialPortControlSignals::DataView input,
    ::device::mojom::blink::SerialPortControlSignalsPtr* output) {
  bool success = true;
  ::device::mojom::blink::SerialPortControlSignalsPtr result(::device::mojom::blink::SerialPortControlSignals::New());
  
      if (success)
        result->dcd = input.dcd();
      if (success)
        result->cts = input.cts();
      if (success)
        result->ri = input.ri();
      if (success)
        result->dsr = input.dsr();
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif