// services/device/public/mojom/time_zone_monitor.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/device/public/mojom/time_zone_monitor.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "services/device/public/mojom/time_zone_monitor.mojom-params-data.h"
#include "services/device/public/mojom/time_zone_monitor.mojom-shared-message-ids.h"

#include "services/device/public/mojom/time_zone_monitor.mojom-blink-import-headers.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


#ifndef SERVICES_DEVICE_PUBLIC_MOJOM_TIME_ZONE_MONITOR_MOJOM_BLINK_JUMBO_H_
#define SERVICES_DEVICE_PUBLIC_MOJOM_TIME_ZONE_MONITOR_MOJOM_BLINK_JUMBO_H_
#endif
namespace device {
namespace mojom {
namespace blink {
const char TimeZoneMonitor::Name_[] = "device.mojom.TimeZoneMonitor";

TimeZoneMonitorProxy::TimeZoneMonitorProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void TimeZoneMonitorProxy::AddClient(
    ::mojo::PendingRemote<TimeZoneMonitorClient> in_client) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "device::mojom::TimeZoneMonitor::AddClient", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client"), in_client, 
                        "<value of type ::mojo::PendingRemote<TimeZoneMonitorClient>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kTimeZoneMonitor_AddClient_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::TimeZoneMonitor_AddClient_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::device::mojom::TimeZoneMonitorClientInterfaceBase>>(
      in_client, &params->client, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->client),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid client in TimeZoneMonitor.AddClient request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TimeZoneMonitor::Name_);
  message.set_method_name("AddClient");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool TimeZoneMonitorStubDispatch::Accept(
    TimeZoneMonitor* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kTimeZoneMonitor_AddClient_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)device::mojom::TimeZoneMonitor::AddClient",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)device::mojom::TimeZoneMonitor::AddClient");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::TimeZoneMonitor_AddClient_Params_Data* params =
          reinterpret_cast<internal::TimeZoneMonitor_AddClient_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingRemote<TimeZoneMonitorClient> p_client{};
      TimeZoneMonitor_AddClient_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_client =
            input_data_view.TakeClient<decltype(p_client)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            TimeZoneMonitor::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AddClient(
std::move(p_client));
      return true;
    }
  }
  return false;
}

// static
bool TimeZoneMonitorStubDispatch::AcceptWithResponder(
    TimeZoneMonitor* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kTimeZoneMonitor_AddClient_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kTimeZoneMonitorValidationInfo[] = {
    {internal::kTimeZoneMonitor_AddClient_Name,
     {&internal::TimeZoneMonitor_AddClient_Params_Data::Validate,
      nullptr /* no response */}},
};

bool TimeZoneMonitorRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::device::mojom::blink::TimeZoneMonitor::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kTimeZoneMonitorValidationInfo);
}

const char TimeZoneMonitorClient::Name_[] = "device.mojom.TimeZoneMonitorClient";

TimeZoneMonitorClientProxy::TimeZoneMonitorClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void TimeZoneMonitorClientProxy::OnTimeZoneChange(
    const WTF::String& in_tz_info) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "device::mojom::TimeZoneMonitorClient::OnTimeZoneChange", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("tz_info"), in_tz_info, 
                        "<value of type const WTF::String&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kTimeZoneMonitorClient_OnTimeZoneChange_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::TimeZoneMonitorClient_OnTimeZoneChange_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->tz_info)::BaseType> tz_info_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_tz_info, tz_info_fragment);
  params->tz_info.Set(
      tz_info_fragment.is_null() ? nullptr : tz_info_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->tz_info.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null tz_info in TimeZoneMonitorClient.OnTimeZoneChange request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TimeZoneMonitorClient::Name_);
  message.set_method_name("OnTimeZoneChange");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool TimeZoneMonitorClientStubDispatch::Accept(
    TimeZoneMonitorClient* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kTimeZoneMonitorClient_OnTimeZoneChange_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)device::mojom::TimeZoneMonitorClient::OnTimeZoneChange",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)device::mojom::TimeZoneMonitorClient::OnTimeZoneChange");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::TimeZoneMonitorClient_OnTimeZoneChange_Params_Data* params =
          reinterpret_cast<internal::TimeZoneMonitorClient_OnTimeZoneChange_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      WTF::String p_tz_info{};
      TimeZoneMonitorClient_OnTimeZoneChange_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadTzInfo(&p_tz_info))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            TimeZoneMonitorClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnTimeZoneChange(
std::move(p_tz_info));
      return true;
    }
  }
  return false;
}

// static
bool TimeZoneMonitorClientStubDispatch::AcceptWithResponder(
    TimeZoneMonitorClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kTimeZoneMonitorClient_OnTimeZoneChange_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kTimeZoneMonitorClientValidationInfo[] = {
    {internal::kTimeZoneMonitorClient_OnTimeZoneChange_Name,
     {&internal::TimeZoneMonitorClient_OnTimeZoneChange_Params_Data::Validate,
      nullptr /* no response */}},
};

bool TimeZoneMonitorClientRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::device::mojom::blink::TimeZoneMonitorClient::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kTimeZoneMonitorClientValidationInfo);
}

}  // namespace blink
}  // namespace mojom
}  // namespace device

namespace mojo {

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif