// services/device/public/mojom/usb_device.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "services/device/public/mojom/usb_device.mojom-shared.h"

#include <utility>

#include "base/stl_util.h"  // for base::size()
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/device/public/mojom/usb_device.mojom-params-data.h"
namespace device {
namespace mojom {

std::string UsbOpenDeviceErrorToString(UsbOpenDeviceError value) {
  switch(value) {
    case UsbOpenDeviceError::OK:
      return "UsbOpenDeviceError::OK";
    case UsbOpenDeviceError::ACCESS_DENIED:
      return "UsbOpenDeviceError::ACCESS_DENIED";
    case UsbOpenDeviceError::ALREADY_OPEN:
      return "UsbOpenDeviceError::ALREADY_OPEN";
    default:
      return base::StringPrintf("Unknown UsbOpenDeviceError value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, UsbOpenDeviceError value) {
  return os << UsbOpenDeviceErrorToString(value);
}

std::string UsbTransferDirectionToString(UsbTransferDirection value) {
  switch(value) {
    case UsbTransferDirection::INBOUND:
      return "UsbTransferDirection::INBOUND";
    case UsbTransferDirection::OUTBOUND:
      return "UsbTransferDirection::OUTBOUND";
    default:
      return base::StringPrintf("Unknown UsbTransferDirection value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, UsbTransferDirection value) {
  return os << UsbTransferDirectionToString(value);
}

std::string UsbControlTransferTypeToString(UsbControlTransferType value) {
  switch(value) {
    case UsbControlTransferType::STANDARD:
      return "UsbControlTransferType::STANDARD";
    case UsbControlTransferType::CLASS:
      return "UsbControlTransferType::CLASS";
    case UsbControlTransferType::VENDOR:
      return "UsbControlTransferType::VENDOR";
    case UsbControlTransferType::RESERVED:
      return "UsbControlTransferType::RESERVED";
    default:
      return base::StringPrintf("Unknown UsbControlTransferType value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, UsbControlTransferType value) {
  return os << UsbControlTransferTypeToString(value);
}

std::string UsbControlTransferRecipientToString(UsbControlTransferRecipient value) {
  switch(value) {
    case UsbControlTransferRecipient::DEVICE:
      return "UsbControlTransferRecipient::DEVICE";
    case UsbControlTransferRecipient::INTERFACE:
      return "UsbControlTransferRecipient::INTERFACE";
    case UsbControlTransferRecipient::ENDPOINT:
      return "UsbControlTransferRecipient::ENDPOINT";
    case UsbControlTransferRecipient::OTHER:
      return "UsbControlTransferRecipient::OTHER";
    default:
      return base::StringPrintf("Unknown UsbControlTransferRecipient value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, UsbControlTransferRecipient value) {
  return os << UsbControlTransferRecipientToString(value);
}

std::string UsbTransferTypeToString(UsbTransferType value) {
  switch(value) {
    case UsbTransferType::CONTROL:
      return "UsbTransferType::CONTROL";
    case UsbTransferType::ISOCHRONOUS:
      return "UsbTransferType::ISOCHRONOUS";
    case UsbTransferType::BULK:
      return "UsbTransferType::BULK";
    case UsbTransferType::INTERRUPT:
      return "UsbTransferType::INTERRUPT";
    default:
      return base::StringPrintf("Unknown UsbTransferType value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, UsbTransferType value) {
  return os << UsbTransferTypeToString(value);
}

std::string UsbSynchronizationTypeToString(UsbSynchronizationType value) {
  switch(value) {
    case UsbSynchronizationType::NONE:
      return "UsbSynchronizationType::NONE";
    case UsbSynchronizationType::ASYNCHRONOUS:
      return "UsbSynchronizationType::ASYNCHRONOUS";
    case UsbSynchronizationType::ADAPTIVE:
      return "UsbSynchronizationType::ADAPTIVE";
    case UsbSynchronizationType::SYNCHRONOUS:
      return "UsbSynchronizationType::SYNCHRONOUS";
    default:
      return base::StringPrintf("Unknown UsbSynchronizationType value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, UsbSynchronizationType value) {
  return os << UsbSynchronizationTypeToString(value);
}

std::string UsbUsageTypeToString(UsbUsageType value) {
  switch(value) {
    case UsbUsageType::DATA:
      return "UsbUsageType::DATA";
    case UsbUsageType::FEEDBACK:
      return "UsbUsageType::FEEDBACK";
    case UsbUsageType::EXPLICIT_FEEDBACK:
      return "UsbUsageType::EXPLICIT_FEEDBACK";
    case UsbUsageType::PERIODIC:
      return "UsbUsageType::PERIODIC";
    case UsbUsageType::NOTIFICATION:
      return "UsbUsageType::NOTIFICATION";
    case UsbUsageType::RESERVED:
      return "UsbUsageType::RESERVED";
    default:
      return base::StringPrintf("Unknown UsbUsageType value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, UsbUsageType value) {
  return os << UsbUsageTypeToString(value);
}

std::string UsbTransferStatusToString(UsbTransferStatus value) {
  switch(value) {
    case UsbTransferStatus::COMPLETED:
      return "UsbTransferStatus::COMPLETED";
    case UsbTransferStatus::TRANSFER_ERROR:
      return "UsbTransferStatus::TRANSFER_ERROR";
    case UsbTransferStatus::TIMEOUT:
      return "UsbTransferStatus::TIMEOUT";
    case UsbTransferStatus::CANCELLED:
      return "UsbTransferStatus::CANCELLED";
    case UsbTransferStatus::STALLED:
      return "UsbTransferStatus::STALLED";
    case UsbTransferStatus::DISCONNECT:
      return "UsbTransferStatus::DISCONNECT";
    case UsbTransferStatus::BABBLE:
      return "UsbTransferStatus::BABBLE";
    case UsbTransferStatus::SHORT_PACKET:
      return "UsbTransferStatus::SHORT_PACKET";
    case UsbTransferStatus::PERMISSION_DENIED:
      return "UsbTransferStatus::PERMISSION_DENIED";
    default:
      return base::StringPrintf("Unknown UsbTransferStatus value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, UsbTransferStatus value) {
  return os << UsbTransferStatusToString(value);
}

namespace internal {


// static
bool UsbEndpointInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const UsbEndpointInfo_Data* object = static_cast<const UsbEndpointInfo_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::device::mojom::internal::UsbTransferDirection_Data
        ::Validate(object->direction, validation_context))
    return false;


  if (!::device::mojom::internal::UsbTransferType_Data
        ::Validate(object->type, validation_context))
    return false;


  if (!::device::mojom::internal::UsbSynchronizationType_Data
        ::Validate(object->synchronization_type, validation_context))
    return false;


  if (!::device::mojom::internal::UsbUsageType_Data
        ::Validate(object->usage_type, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->extra_data, 8, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams extra_data_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->extra_data, validation_context,
                                         &extra_data_validate_params)) {
    return false;
  }

  return true;
}

UsbEndpointInfo_Data::UsbEndpointInfo_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool UsbAlternateInterfaceInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const UsbAlternateInterfaceInfo_Data* object = static_cast<const UsbAlternateInterfaceInfo_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateStruct(object->interface_name, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->endpoints, 6, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams endpoints_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->endpoints, validation_context,
                                         &endpoints_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->extra_data, 7, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams extra_data_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->extra_data, validation_context,
                                         &extra_data_validate_params)) {
    return false;
  }

  return true;
}

UsbAlternateInterfaceInfo_Data::UsbAlternateInterfaceInfo_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool UsbInterfaceInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const UsbInterfaceInfo_Data* object = static_cast<const UsbInterfaceInfo_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->alternates, 3, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams alternates_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->alternates, validation_context,
                                         &alternates_validate_params)) {
    return false;
  }

  return true;
}

UsbInterfaceInfo_Data::UsbInterfaceInfo_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool UsbConfigurationInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const UsbConfigurationInfo_Data* object = static_cast<const UsbConfigurationInfo_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateStruct(object->configuration_name, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->interfaces, 6, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams interfaces_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->interfaces, validation_context,
                                         &interfaces_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->extra_data, 7, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams extra_data_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->extra_data, validation_context,
                                         &extra_data_validate_params)) {
    return false;
  }

  return true;
}

UsbConfigurationInfo_Data::UsbConfigurationInfo_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool UsbDeviceInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 80, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const UsbDeviceInfo_Data* object = static_cast<const UsbDeviceInfo_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->guid, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams guid_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->guid, validation_context,
                                         &guid_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->manufacturer_name, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->product_name, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->serial_number, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->webusb_landing_page, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->configurations, 20, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams configurations_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->configurations, validation_context,
                                         &configurations_validate_params)) {
    return false;
  }

  return true;
}

UsbDeviceInfo_Data::UsbDeviceInfo_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool UsbControlTransferParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const UsbControlTransferParams_Data* object = static_cast<const UsbControlTransferParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::device::mojom::internal::UsbControlTransferType_Data
        ::Validate(object->type, validation_context))
    return false;


  if (!::device::mojom::internal::UsbControlTransferRecipient_Data
        ::Validate(object->recipient, validation_context))
    return false;

  return true;
}

UsbControlTransferParams_Data::UsbControlTransferParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool UsbIsochronousPacket_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const UsbIsochronousPacket_Data* object = static_cast<const UsbIsochronousPacket_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::device::mojom::internal::UsbTransferStatus_Data
        ::Validate(object->status, validation_context))
    return false;

  return true;
}

UsbIsochronousPacket_Data::UsbIsochronousPacket_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool UsbDevice_Open_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const UsbDevice_Open_Params_Data* object = static_cast<const UsbDevice_Open_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

UsbDevice_Open_Params_Data::UsbDevice_Open_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool UsbDevice_Open_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const UsbDevice_Open_ResponseParams_Data* object = static_cast<const UsbDevice_Open_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::device::mojom::internal::UsbOpenDeviceError_Data
        ::Validate(object->error, validation_context))
    return false;

  return true;
}

UsbDevice_Open_ResponseParams_Data::UsbDevice_Open_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool UsbDevice_Close_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const UsbDevice_Close_Params_Data* object = static_cast<const UsbDevice_Close_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

UsbDevice_Close_Params_Data::UsbDevice_Close_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool UsbDevice_Close_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const UsbDevice_Close_ResponseParams_Data* object = static_cast<const UsbDevice_Close_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

UsbDevice_Close_ResponseParams_Data::UsbDevice_Close_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool UsbDevice_SetConfiguration_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const UsbDevice_SetConfiguration_Params_Data* object = static_cast<const UsbDevice_SetConfiguration_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

UsbDevice_SetConfiguration_Params_Data::UsbDevice_SetConfiguration_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool UsbDevice_SetConfiguration_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const UsbDevice_SetConfiguration_ResponseParams_Data* object = static_cast<const UsbDevice_SetConfiguration_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

UsbDevice_SetConfiguration_ResponseParams_Data::UsbDevice_SetConfiguration_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool UsbDevice_ClaimInterface_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const UsbDevice_ClaimInterface_Params_Data* object = static_cast<const UsbDevice_ClaimInterface_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

UsbDevice_ClaimInterface_Params_Data::UsbDevice_ClaimInterface_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool UsbDevice_ClaimInterface_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const UsbDevice_ClaimInterface_ResponseParams_Data* object = static_cast<const UsbDevice_ClaimInterface_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

UsbDevice_ClaimInterface_ResponseParams_Data::UsbDevice_ClaimInterface_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool UsbDevice_ReleaseInterface_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const UsbDevice_ReleaseInterface_Params_Data* object = static_cast<const UsbDevice_ReleaseInterface_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

UsbDevice_ReleaseInterface_Params_Data::UsbDevice_ReleaseInterface_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool UsbDevice_ReleaseInterface_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const UsbDevice_ReleaseInterface_ResponseParams_Data* object = static_cast<const UsbDevice_ReleaseInterface_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

UsbDevice_ReleaseInterface_ResponseParams_Data::UsbDevice_ReleaseInterface_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool UsbDevice_SetInterfaceAlternateSetting_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const UsbDevice_SetInterfaceAlternateSetting_Params_Data* object = static_cast<const UsbDevice_SetInterfaceAlternateSetting_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

UsbDevice_SetInterfaceAlternateSetting_Params_Data::UsbDevice_SetInterfaceAlternateSetting_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool UsbDevice_SetInterfaceAlternateSetting_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const UsbDevice_SetInterfaceAlternateSetting_ResponseParams_Data* object = static_cast<const UsbDevice_SetInterfaceAlternateSetting_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

UsbDevice_SetInterfaceAlternateSetting_ResponseParams_Data::UsbDevice_SetInterfaceAlternateSetting_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool UsbDevice_Reset_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const UsbDevice_Reset_Params_Data* object = static_cast<const UsbDevice_Reset_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

UsbDevice_Reset_Params_Data::UsbDevice_Reset_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool UsbDevice_Reset_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const UsbDevice_Reset_ResponseParams_Data* object = static_cast<const UsbDevice_Reset_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

UsbDevice_Reset_ResponseParams_Data::UsbDevice_Reset_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool UsbDevice_ClearHalt_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const UsbDevice_ClearHalt_Params_Data* object = static_cast<const UsbDevice_ClearHalt_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::device::mojom::internal::UsbTransferDirection_Data
        ::Validate(object->direction, validation_context))
    return false;

  return true;
}

UsbDevice_ClearHalt_Params_Data::UsbDevice_ClearHalt_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool UsbDevice_ClearHalt_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const UsbDevice_ClearHalt_ResponseParams_Data* object = static_cast<const UsbDevice_ClearHalt_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

UsbDevice_ClearHalt_ResponseParams_Data::UsbDevice_ClearHalt_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool UsbDevice_ControlTransferIn_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const UsbDevice_ControlTransferIn_Params_Data* object = static_cast<const UsbDevice_ControlTransferIn_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->params, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->params, validation_context))
    return false;

  return true;
}

UsbDevice_ControlTransferIn_Params_Data::UsbDevice_ControlTransferIn_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool UsbDevice_ControlTransferIn_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const UsbDevice_ControlTransferIn_ResponseParams_Data* object = static_cast<const UsbDevice_ControlTransferIn_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::device::mojom::internal::UsbTransferStatus_Data
        ::Validate(object->status, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->data, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams data_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->data, validation_context,
                                         &data_validate_params)) {
    return false;
  }

  return true;
}

UsbDevice_ControlTransferIn_ResponseParams_Data::UsbDevice_ControlTransferIn_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool UsbDevice_ControlTransferOut_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const UsbDevice_ControlTransferOut_Params_Data* object = static_cast<const UsbDevice_ControlTransferOut_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->params, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->params, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->data, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams data_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->data, validation_context,
                                         &data_validate_params)) {
    return false;
  }

  return true;
}

UsbDevice_ControlTransferOut_Params_Data::UsbDevice_ControlTransferOut_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool UsbDevice_ControlTransferOut_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const UsbDevice_ControlTransferOut_ResponseParams_Data* object = static_cast<const UsbDevice_ControlTransferOut_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::device::mojom::internal::UsbTransferStatus_Data
        ::Validate(object->status, validation_context))
    return false;

  return true;
}

UsbDevice_ControlTransferOut_ResponseParams_Data::UsbDevice_ControlTransferOut_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool UsbDevice_GenericTransferIn_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const UsbDevice_GenericTransferIn_Params_Data* object = static_cast<const UsbDevice_GenericTransferIn_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

UsbDevice_GenericTransferIn_Params_Data::UsbDevice_GenericTransferIn_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool UsbDevice_GenericTransferIn_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const UsbDevice_GenericTransferIn_ResponseParams_Data* object = static_cast<const UsbDevice_GenericTransferIn_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::device::mojom::internal::UsbTransferStatus_Data
        ::Validate(object->status, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->data, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams data_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->data, validation_context,
                                         &data_validate_params)) {
    return false;
  }

  return true;
}

UsbDevice_GenericTransferIn_ResponseParams_Data::UsbDevice_GenericTransferIn_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool UsbDevice_GenericTransferOut_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const UsbDevice_GenericTransferOut_Params_Data* object = static_cast<const UsbDevice_GenericTransferOut_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->data, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams data_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->data, validation_context,
                                         &data_validate_params)) {
    return false;
  }

  return true;
}

UsbDevice_GenericTransferOut_Params_Data::UsbDevice_GenericTransferOut_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool UsbDevice_GenericTransferOut_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const UsbDevice_GenericTransferOut_ResponseParams_Data* object = static_cast<const UsbDevice_GenericTransferOut_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::device::mojom::internal::UsbTransferStatus_Data
        ::Validate(object->status, validation_context))
    return false;

  return true;
}

UsbDevice_GenericTransferOut_ResponseParams_Data::UsbDevice_GenericTransferOut_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool UsbDevice_IsochronousTransferIn_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const UsbDevice_IsochronousTransferIn_Params_Data* object = static_cast<const UsbDevice_IsochronousTransferIn_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->packet_lengths, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams packet_lengths_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->packet_lengths, validation_context,
                                         &packet_lengths_validate_params)) {
    return false;
  }

  return true;
}

UsbDevice_IsochronousTransferIn_Params_Data::UsbDevice_IsochronousTransferIn_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool UsbDevice_IsochronousTransferIn_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const UsbDevice_IsochronousTransferIn_ResponseParams_Data* object = static_cast<const UsbDevice_IsochronousTransferIn_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->data, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams data_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->data, validation_context,
                                         &data_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->packets, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams packets_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->packets, validation_context,
                                         &packets_validate_params)) {
    return false;
  }

  return true;
}

UsbDevice_IsochronousTransferIn_ResponseParams_Data::UsbDevice_IsochronousTransferIn_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool UsbDevice_IsochronousTransferOut_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const UsbDevice_IsochronousTransferOut_Params_Data* object = static_cast<const UsbDevice_IsochronousTransferOut_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->data, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams data_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->data, validation_context,
                                         &data_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->packet_lengths, 3, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams packet_lengths_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->packet_lengths, validation_context,
                                         &packet_lengths_validate_params)) {
    return false;
  }

  return true;
}

UsbDevice_IsochronousTransferOut_Params_Data::UsbDevice_IsochronousTransferOut_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool UsbDevice_IsochronousTransferOut_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const UsbDevice_IsochronousTransferOut_ResponseParams_Data* object = static_cast<const UsbDevice_IsochronousTransferOut_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->packets, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams packets_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->packets, validation_context,
                                         &packets_validate_params)) {
    return false;
  }

  return true;
}

UsbDevice_IsochronousTransferOut_ResponseParams_Data::UsbDevice_IsochronousTransferOut_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool UsbDeviceClient_OnDeviceOpened_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const UsbDeviceClient_OnDeviceOpened_Params_Data* object = static_cast<const UsbDeviceClient_OnDeviceOpened_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

UsbDeviceClient_OnDeviceOpened_Params_Data::UsbDeviceClient_OnDeviceOpened_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool UsbDeviceClient_OnDeviceClosed_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const UsbDeviceClient_OnDeviceClosed_Params_Data* object = static_cast<const UsbDeviceClient_OnDeviceClosed_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

UsbDeviceClient_OnDeviceClosed_Params_Data::UsbDeviceClient_OnDeviceClosed_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace device

namespace perfetto {

// static
void TraceFormatTraits<::device::mojom::UsbOpenDeviceError>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::device::mojom::UsbOpenDeviceError value) {
  return std::move(context).WriteString(::device::mojom::UsbOpenDeviceErrorToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::device::mojom::UsbTransferDirection>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::device::mojom::UsbTransferDirection value) {
  return std::move(context).WriteString(::device::mojom::UsbTransferDirectionToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::device::mojom::UsbControlTransferType>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::device::mojom::UsbControlTransferType value) {
  return std::move(context).WriteString(::device::mojom::UsbControlTransferTypeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::device::mojom::UsbControlTransferRecipient>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::device::mojom::UsbControlTransferRecipient value) {
  return std::move(context).WriteString(::device::mojom::UsbControlTransferRecipientToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::device::mojom::UsbTransferType>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::device::mojom::UsbTransferType value) {
  return std::move(context).WriteString(::device::mojom::UsbTransferTypeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::device::mojom::UsbSynchronizationType>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::device::mojom::UsbSynchronizationType value) {
  return std::move(context).WriteString(::device::mojom::UsbSynchronizationTypeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::device::mojom::UsbUsageType>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::device::mojom::UsbUsageType value) {
  return std::move(context).WriteString(::device::mojom::UsbUsageTypeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::device::mojom::UsbTransferStatus>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::device::mojom::UsbTransferStatus value) {
  return std::move(context).WriteString(::device::mojom::UsbTransferStatusToString(value));
}

} // namespace perfetto
