// services/device/public/mojom/usb_manager.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/device/public/mojom/usb_manager.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "services/device/public/mojom/usb_manager.mojom-params-data.h"
#include "services/device/public/mojom/usb_manager.mojom-shared-message-ids.h"

#include "services/device/public/mojom/usb_manager.mojom-blink-import-headers.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


#ifndef SERVICES_DEVICE_PUBLIC_MOJOM_USB_MANAGER_MOJOM_BLINK_JUMBO_H_
#define SERVICES_DEVICE_PUBLIC_MOJOM_USB_MANAGER_MOJOM_BLINK_JUMBO_H_
#endif
namespace device {
namespace mojom {
namespace blink {
const char UsbDeviceManager::Name_[] = "device.mojom.UsbDeviceManager";

class UsbDeviceManager_EnumerateDevicesAndSetClient_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  UsbDeviceManager_EnumerateDevicesAndSetClient_ForwardToCallback(
      UsbDeviceManager::EnumerateDevicesAndSetClientCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  UsbDeviceManager::EnumerateDevicesAndSetClientCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(UsbDeviceManager_EnumerateDevicesAndSetClient_ForwardToCallback);
};

class UsbDeviceManager_GetDevices_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  UsbDeviceManager_GetDevices_ForwardToCallback(
      UsbDeviceManager::GetDevicesCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  UsbDeviceManager::GetDevicesCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(UsbDeviceManager_GetDevices_ForwardToCallback);
};

UsbDeviceManagerProxy::UsbDeviceManagerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void UsbDeviceManagerProxy::EnumerateDevicesAndSetClient(
    ::mojo::PendingAssociatedRemote<::device::mojom::blink::UsbDeviceManagerClient> in_client, EnumerateDevicesAndSetClientCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "device::mojom::UsbDeviceManager::EnumerateDevicesAndSetClient", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client"), in_client, 
                        "<value of type ::mojo::PendingAssociatedRemote<::device::mojom::blink::UsbDeviceManagerClient>>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kUsbDeviceManager_EnumerateDevicesAndSetClient_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::UsbDeviceManager_EnumerateDevicesAndSetClient_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::device::mojom::UsbDeviceManagerClientAssociatedPtrInfoDataView>(
      in_client, &params->client, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->client),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
      "invalid client in UsbDeviceManager.EnumerateDevicesAndSetClient request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(UsbDeviceManager::Name_);
  message.set_method_name("EnumerateDevicesAndSetClient");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new UsbDeviceManager_EnumerateDevicesAndSetClient_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void UsbDeviceManagerProxy::GetDevices(
    ::device::mojom::blink::UsbEnumerationOptionsPtr in_options, GetDevicesCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "device::mojom::UsbDeviceManager::GetDevices", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("options"), in_options, 
                        "<value of type ::device::mojom::blink::UsbEnumerationOptionsPtr>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kUsbDeviceManager_GetDevices_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::UsbDeviceManager_GetDevices_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->options)::BaseType> options_fragment(
          params.message());
  mojo::internal::Serialize<::device::mojom::UsbEnumerationOptionsDataView>(
      in_options, options_fragment);
  params->options.Set(
      options_fragment.is_null() ? nullptr : options_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(UsbDeviceManager::Name_);
  message.set_method_name("GetDevices");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new UsbDeviceManager_GetDevices_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void UsbDeviceManagerProxy::GetDevice(
    const WTF::String& in_guid, ::mojo::PendingReceiver<::device::mojom::blink::UsbDevice> in_device_receiver, ::mojo::PendingRemote<::device::mojom::blink::UsbDeviceClient> in_device_client) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "device::mojom::UsbDeviceManager::GetDevice", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("guid"), in_guid, 
                        "<value of type const WTF::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("device_receiver"), in_device_receiver, 
                        "<value of type ::mojo::PendingReceiver<::device::mojom::blink::UsbDevice>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("device_client"), in_device_client, 
                        "<value of type ::mojo::PendingRemote<::device::mojom::blink::UsbDeviceClient>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kUsbDeviceManager_GetDevice_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::UsbDeviceManager_GetDevice_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->guid)::BaseType> guid_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_guid, guid_fragment);
  params->guid.Set(
      guid_fragment.is_null() ? nullptr : guid_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->guid.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null guid in UsbDeviceManager.GetDevice request");
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::device::mojom::UsbDeviceInterfaceBase>>(
      in_device_receiver, &params->device_receiver, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->device_receiver),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid device_receiver in UsbDeviceManager.GetDevice request");
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::device::mojom::UsbDeviceClientInterfaceBase>>(
      in_device_client, &params->device_client, &params.message());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(UsbDeviceManager::Name_);
  message.set_method_name("GetDevice");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void UsbDeviceManagerProxy::GetSecurityKeyDevice(
    const WTF::String& in_guid, ::mojo::PendingReceiver<::device::mojom::blink::UsbDevice> in_device_receiver, ::mojo::PendingRemote<::device::mojom::blink::UsbDeviceClient> in_device_client) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "device::mojom::UsbDeviceManager::GetSecurityKeyDevice", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("guid"), in_guid, 
                        "<value of type const WTF::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("device_receiver"), in_device_receiver, 
                        "<value of type ::mojo::PendingReceiver<::device::mojom::blink::UsbDevice>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("device_client"), in_device_client, 
                        "<value of type ::mojo::PendingRemote<::device::mojom::blink::UsbDeviceClient>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kUsbDeviceManager_GetSecurityKeyDevice_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::UsbDeviceManager_GetSecurityKeyDevice_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->guid)::BaseType> guid_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_guid, guid_fragment);
  params->guid.Set(
      guid_fragment.is_null() ? nullptr : guid_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->guid.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null guid in UsbDeviceManager.GetSecurityKeyDevice request");
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::device::mojom::UsbDeviceInterfaceBase>>(
      in_device_receiver, &params->device_receiver, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->device_receiver),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid device_receiver in UsbDeviceManager.GetSecurityKeyDevice request");
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::device::mojom::UsbDeviceClientInterfaceBase>>(
      in_device_client, &params->device_client, &params.message());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(UsbDeviceManager::Name_);
  message.set_method_name("GetSecurityKeyDevice");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void UsbDeviceManagerProxy::SetClient(
    ::mojo::PendingAssociatedRemote<::device::mojom::blink::UsbDeviceManagerClient> in_client) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "device::mojom::UsbDeviceManager::SetClient", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client"), in_client, 
                        "<value of type ::mojo::PendingAssociatedRemote<::device::mojom::blink::UsbDeviceManagerClient>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kUsbDeviceManager_SetClient_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::UsbDeviceManager_SetClient_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::device::mojom::UsbDeviceManagerClientAssociatedPtrInfoDataView>(
      in_client, &params->client, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->client),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
      "invalid client in UsbDeviceManager.SetClient request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(UsbDeviceManager::Name_);
  message.set_method_name("SetClient");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}
class UsbDeviceManager_EnumerateDevicesAndSetClient_ProxyToResponder {
 public:
  static UsbDeviceManager::EnumerateDevicesAndSetClientCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<UsbDeviceManager_EnumerateDevicesAndSetClient_ProxyToResponder> proxy(
        new UsbDeviceManager_EnumerateDevicesAndSetClient_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&UsbDeviceManager_EnumerateDevicesAndSetClient_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~UsbDeviceManager_EnumerateDevicesAndSetClient_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  UsbDeviceManager_EnumerateDevicesAndSetClient_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "UsbDeviceManager::EnumerateDevicesAndSetClientCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      WTF::Vector<::device::mojom::blink::UsbDeviceInfoPtr> in_results);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(UsbDeviceManager_EnumerateDevicesAndSetClient_ProxyToResponder);
};

bool UsbDeviceManager_EnumerateDevicesAndSetClient_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "device::mojom::UsbDeviceManager::EnumerateDevicesAndSetClientCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::UsbDeviceManager_EnumerateDevicesAndSetClient_ResponseParams_Data* params =
      reinterpret_cast<
          internal::UsbDeviceManager_EnumerateDevicesAndSetClient_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  WTF::Vector<::device::mojom::blink::UsbDeviceInfoPtr> p_results{};
  UsbDeviceManager_EnumerateDevicesAndSetClient_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResults(&p_results))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        UsbDeviceManager::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_results));
  return true;
}

void UsbDeviceManager_EnumerateDevicesAndSetClient_ProxyToResponder::Run(
    WTF::Vector<::device::mojom::blink::UsbDeviceInfoPtr> in_results) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)device::mojom::UsbDeviceManager::EnumerateDevicesAndSetClientCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("results"), in_results, 
                        "<value of type WTF::Vector<::device::mojom::blink::UsbDeviceInfoPtr>>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kUsbDeviceManager_EnumerateDevicesAndSetClient_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::UsbDeviceManager_EnumerateDevicesAndSetClient_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->results)::BaseType>
      results_fragment(params.message());
  const mojo::internal::ContainerValidateParams results_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::device::mojom::UsbDeviceInfoDataView>>(
      in_results, results_fragment, &results_validate_params);
  params->results.Set(
      results_fragment.is_null() ? nullptr : results_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->results.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null results in ");

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)device::mojom::UsbDeviceManager::EnumerateDevicesAndSetClientCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(UsbDeviceManager::Name_);
  message.set_method_name("EnumerateDevicesAndSetClient");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class UsbDeviceManager_GetDevices_ProxyToResponder {
 public:
  static UsbDeviceManager::GetDevicesCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<UsbDeviceManager_GetDevices_ProxyToResponder> proxy(
        new UsbDeviceManager_GetDevices_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&UsbDeviceManager_GetDevices_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~UsbDeviceManager_GetDevices_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  UsbDeviceManager_GetDevices_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "UsbDeviceManager::GetDevicesCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      WTF::Vector<::device::mojom::blink::UsbDeviceInfoPtr> in_results);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(UsbDeviceManager_GetDevices_ProxyToResponder);
};

bool UsbDeviceManager_GetDevices_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "device::mojom::UsbDeviceManager::GetDevicesCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::UsbDeviceManager_GetDevices_ResponseParams_Data* params =
      reinterpret_cast<
          internal::UsbDeviceManager_GetDevices_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  WTF::Vector<::device::mojom::blink::UsbDeviceInfoPtr> p_results{};
  UsbDeviceManager_GetDevices_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResults(&p_results))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        UsbDeviceManager::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_results));
  return true;
}

void UsbDeviceManager_GetDevices_ProxyToResponder::Run(
    WTF::Vector<::device::mojom::blink::UsbDeviceInfoPtr> in_results) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)device::mojom::UsbDeviceManager::GetDevicesCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("results"), in_results, 
                        "<value of type WTF::Vector<::device::mojom::blink::UsbDeviceInfoPtr>>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kUsbDeviceManager_GetDevices_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::UsbDeviceManager_GetDevices_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->results)::BaseType>
      results_fragment(params.message());
  const mojo::internal::ContainerValidateParams results_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::device::mojom::UsbDeviceInfoDataView>>(
      in_results, results_fragment, &results_validate_params);
  params->results.Set(
      results_fragment.is_null() ? nullptr : results_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->results.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null results in ");

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)device::mojom::UsbDeviceManager::GetDevicesCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(UsbDeviceManager::Name_);
  message.set_method_name("GetDevices");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool UsbDeviceManagerStubDispatch::Accept(
    UsbDeviceManager* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kUsbDeviceManager_EnumerateDevicesAndSetClient_Name: {
      break;
    }
    case internal::kUsbDeviceManager_GetDevices_Name: {
      break;
    }
    case internal::kUsbDeviceManager_GetDevice_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)device::mojom::UsbDeviceManager::GetDevice",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)device::mojom::UsbDeviceManager::GetDevice");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::UsbDeviceManager_GetDevice_Params_Data* params =
          reinterpret_cast<internal::UsbDeviceManager_GetDevice_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      WTF::String p_guid{};
      ::mojo::PendingReceiver<::device::mojom::blink::UsbDevice> p_device_receiver{};
      ::mojo::PendingRemote<::device::mojom::blink::UsbDeviceClient> p_device_client{};
      UsbDeviceManager_GetDevice_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadGuid(&p_guid))
        success = false;
      if (success) {
        p_device_receiver =
            input_data_view.TakeDeviceReceiver<decltype(p_device_receiver)>();
      }
      if (success) {
        p_device_client =
            input_data_view.TakeDeviceClient<decltype(p_device_client)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            UsbDeviceManager::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetDevice(
std::move(p_guid), 
std::move(p_device_receiver), 
std::move(p_device_client));
      return true;
    }
    case internal::kUsbDeviceManager_GetSecurityKeyDevice_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)device::mojom::UsbDeviceManager::GetSecurityKeyDevice",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)device::mojom::UsbDeviceManager::GetSecurityKeyDevice");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::UsbDeviceManager_GetSecurityKeyDevice_Params_Data* params =
          reinterpret_cast<internal::UsbDeviceManager_GetSecurityKeyDevice_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      WTF::String p_guid{};
      ::mojo::PendingReceiver<::device::mojom::blink::UsbDevice> p_device_receiver{};
      ::mojo::PendingRemote<::device::mojom::blink::UsbDeviceClient> p_device_client{};
      UsbDeviceManager_GetSecurityKeyDevice_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadGuid(&p_guid))
        success = false;
      if (success) {
        p_device_receiver =
            input_data_view.TakeDeviceReceiver<decltype(p_device_receiver)>();
      }
      if (success) {
        p_device_client =
            input_data_view.TakeDeviceClient<decltype(p_device_client)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            UsbDeviceManager::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetSecurityKeyDevice(
std::move(p_guid), 
std::move(p_device_receiver), 
std::move(p_device_client));
      return true;
    }
    case internal::kUsbDeviceManager_SetClient_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)device::mojom::UsbDeviceManager::SetClient",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)device::mojom::UsbDeviceManager::SetClient");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::UsbDeviceManager_SetClient_Params_Data* params =
          reinterpret_cast<internal::UsbDeviceManager_SetClient_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingAssociatedRemote<::device::mojom::blink::UsbDeviceManagerClient> p_client{};
      UsbDeviceManager_SetClient_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_client =
            input_data_view.TakeClient<decltype(p_client)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            UsbDeviceManager::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetClient(
std::move(p_client));
      return true;
    }
  }
  return false;
}

// static
bool UsbDeviceManagerStubDispatch::AcceptWithResponder(
    UsbDeviceManager* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kUsbDeviceManager_EnumerateDevicesAndSetClient_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)device::mojom::UsbDeviceManager::EnumerateDevicesAndSetClient",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)device::mojom::UsbDeviceManager::EnumerateDevicesAndSetClient");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::UsbDeviceManager_EnumerateDevicesAndSetClient_Params_Data* params =
          reinterpret_cast<
              internal::UsbDeviceManager_EnumerateDevicesAndSetClient_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingAssociatedRemote<::device::mojom::blink::UsbDeviceManagerClient> p_client{};
      UsbDeviceManager_EnumerateDevicesAndSetClient_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_client =
            input_data_view.TakeClient<decltype(p_client)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            UsbDeviceManager::Name_, 0, false);
        return false;
      }
      UsbDeviceManager::EnumerateDevicesAndSetClientCallback callback =
          UsbDeviceManager_EnumerateDevicesAndSetClient_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->EnumerateDevicesAndSetClient(
std::move(p_client), std::move(callback));
      return true;
    }
    case internal::kUsbDeviceManager_GetDevices_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)device::mojom::UsbDeviceManager::GetDevices",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)device::mojom::UsbDeviceManager::GetDevices");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::UsbDeviceManager_GetDevices_Params_Data* params =
          reinterpret_cast<
              internal::UsbDeviceManager_GetDevices_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::device::mojom::blink::UsbEnumerationOptionsPtr p_options{};
      UsbDeviceManager_GetDevices_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadOptions(&p_options))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            UsbDeviceManager::Name_, 1, false);
        return false;
      }
      UsbDeviceManager::GetDevicesCallback callback =
          UsbDeviceManager_GetDevices_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetDevices(
std::move(p_options), std::move(callback));
      return true;
    }
    case internal::kUsbDeviceManager_GetDevice_Name: {
      break;
    }
    case internal::kUsbDeviceManager_GetSecurityKeyDevice_Name: {
      break;
    }
    case internal::kUsbDeviceManager_SetClient_Name: {
      break;
    }
  }
  return false;
}


static const mojo::internal::GenericValidationInfo kUsbDeviceManagerValidationInfo[] = {
    {&internal::UsbDeviceManager_EnumerateDevicesAndSetClient_Params_Data::Validate,
     &internal::UsbDeviceManager_EnumerateDevicesAndSetClient_ResponseParams_Data::Validate},
    {&internal::UsbDeviceManager_GetDevices_Params_Data::Validate,
     &internal::UsbDeviceManager_GetDevices_ResponseParams_Data::Validate},
    {&internal::UsbDeviceManager_GetDevice_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::UsbDeviceManager_GetSecurityKeyDevice_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::UsbDeviceManager_SetClient_Params_Data::Validate,
     nullptr /* no response */},
};

bool UsbDeviceManagerRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::device::mojom::blink::UsbDeviceManager::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kUsbDeviceManagerValidationInfo);
}

bool UsbDeviceManagerResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::device::mojom::blink::UsbDeviceManager::Name_;
  return mojo::internal::ValidateResponseGenericPacked(message, name, kUsbDeviceManagerValidationInfo);
}
}  // namespace blink
}  // namespace mojom
}  // namespace device

namespace mojo {

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif