// services/device/public/mojom/usb_manager_test.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "services/device/public/mojom/usb_manager_test.mojom-shared.h"

#include <utility>

#include "base/stl_util.h"  // for base::size()
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/device/public/mojom/usb_manager_test.mojom-params-data.h"
namespace device {
namespace mojom {

namespace internal {


// static
bool TestDeviceInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const TestDeviceInfo_Data* object = static_cast<const TestDeviceInfo_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->guid, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams guid_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->guid, validation_context,
                                         &guid_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->name, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams name_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->name, validation_context,
                                         &name_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->serial_number, 3, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams serial_number_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->serial_number, validation_context,
                                         &serial_number_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->landing_page, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->landing_page, validation_context))
    return false;

  return true;
}

TestDeviceInfo_Data::TestDeviceInfo_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool UsbDeviceManagerTest_AddDeviceForTesting_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const UsbDeviceManagerTest_AddDeviceForTesting_Params_Data* object = static_cast<const UsbDeviceManagerTest_AddDeviceForTesting_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->name, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams name_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->name, validation_context,
                                         &name_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->serial_number, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams serial_number_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->serial_number, validation_context,
                                         &serial_number_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->landing_page, 3, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams landing_page_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->landing_page, validation_context,
                                         &landing_page_validate_params)) {
    return false;
  }

  return true;
}

UsbDeviceManagerTest_AddDeviceForTesting_Params_Data::UsbDeviceManagerTest_AddDeviceForTesting_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool UsbDeviceManagerTest_AddDeviceForTesting_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const UsbDeviceManagerTest_AddDeviceForTesting_ResponseParams_Data* object = static_cast<const UsbDeviceManagerTest_AddDeviceForTesting_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->message, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams message_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->message, validation_context,
                                         &message_validate_params)) {
    return false;
  }

  return true;
}

UsbDeviceManagerTest_AddDeviceForTesting_ResponseParams_Data::UsbDeviceManagerTest_AddDeviceForTesting_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool UsbDeviceManagerTest_RemoveDeviceForTesting_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const UsbDeviceManagerTest_RemoveDeviceForTesting_Params_Data* object = static_cast<const UsbDeviceManagerTest_RemoveDeviceForTesting_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->guid, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams guid_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->guid, validation_context,
                                         &guid_validate_params)) {
    return false;
  }

  return true;
}

UsbDeviceManagerTest_RemoveDeviceForTesting_Params_Data::UsbDeviceManagerTest_RemoveDeviceForTesting_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool UsbDeviceManagerTest_RemoveDeviceForTesting_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const UsbDeviceManagerTest_RemoveDeviceForTesting_ResponseParams_Data* object = static_cast<const UsbDeviceManagerTest_RemoveDeviceForTesting_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

UsbDeviceManagerTest_RemoveDeviceForTesting_ResponseParams_Data::UsbDeviceManagerTest_RemoveDeviceForTesting_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool UsbDeviceManagerTest_GetTestDevices_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const UsbDeviceManagerTest_GetTestDevices_Params_Data* object = static_cast<const UsbDeviceManagerTest_GetTestDevices_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

UsbDeviceManagerTest_GetTestDevices_Params_Data::UsbDeviceManagerTest_GetTestDevices_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool UsbDeviceManagerTest_GetTestDevices_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const UsbDeviceManagerTest_GetTestDevices_ResponseParams_Data* object = static_cast<const UsbDeviceManagerTest_GetTestDevices_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->devices, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams devices_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->devices, validation_context,
                                         &devices_validate_params)) {
    return false;
  }

  return true;
}

UsbDeviceManagerTest_GetTestDevices_ResponseParams_Data::UsbDeviceManagerTest_GetTestDevices_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace device
