// services/device/public/mojom/usb_manager_test.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/device/public/mojom/usb_manager_test.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "services/device/public/mojom/usb_manager_test.mojom-params-data.h"
#include "services/device/public/mojom/usb_manager_test.mojom-shared-message-ids.h"

#include "services/device/public/mojom/usb_manager_test.mojom-import-headers.h"


#ifndef SERVICES_DEVICE_PUBLIC_MOJOM_USB_MANAGER_TEST_MOJOM_JUMBO_H_
#define SERVICES_DEVICE_PUBLIC_MOJOM_USB_MANAGER_TEST_MOJOM_JUMBO_H_
#endif
namespace device {
namespace mojom {
TestDeviceInfo::TestDeviceInfo()
    : guid(),
      name(),
      serial_number(),
      landing_page() {}

TestDeviceInfo::TestDeviceInfo(
    const std::string& guid_in,
    const std::string& name_in,
    const std::string& serial_number_in,
    const ::GURL& landing_page_in)
    : guid(std::move(guid_in)),
      name(std::move(name_in)),
      serial_number(std::move(serial_number_in)),
      landing_page(std::move(landing_page_in)) {}

TestDeviceInfo::~TestDeviceInfo() = default;

void TestDeviceInfo::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "guid"), this->guid, 
      "<value of type const std::string&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "name"), this->name, 
      "<value of type const std::string&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "serial_number"), this->serial_number, 
      "<value of type const std::string&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "landing_page"), this->landing_page, 
      "<value of type const ::GURL&>");
}

bool TestDeviceInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
const char UsbDeviceManagerTest::Name_[] = "device.mojom.UsbDeviceManagerTest";

class UsbDeviceManagerTest_AddDeviceForTesting_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  UsbDeviceManagerTest_AddDeviceForTesting_ForwardToCallback(
      UsbDeviceManagerTest::AddDeviceForTestingCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  UsbDeviceManagerTest::AddDeviceForTestingCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(UsbDeviceManagerTest_AddDeviceForTesting_ForwardToCallback);
};

class UsbDeviceManagerTest_RemoveDeviceForTesting_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  UsbDeviceManagerTest_RemoveDeviceForTesting_ForwardToCallback(
      UsbDeviceManagerTest::RemoveDeviceForTestingCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  UsbDeviceManagerTest::RemoveDeviceForTestingCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(UsbDeviceManagerTest_RemoveDeviceForTesting_ForwardToCallback);
};

class UsbDeviceManagerTest_GetTestDevices_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  UsbDeviceManagerTest_GetTestDevices_ForwardToCallback(
      UsbDeviceManagerTest::GetTestDevicesCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  UsbDeviceManagerTest::GetTestDevicesCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(UsbDeviceManagerTest_GetTestDevices_ForwardToCallback);
};

UsbDeviceManagerTestProxy::UsbDeviceManagerTestProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void UsbDeviceManagerTestProxy::AddDeviceForTesting(
    const std::string& in_name, const std::string& in_serial_number, const std::string& in_landing_page, AddDeviceForTestingCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "device::mojom::UsbDeviceManagerTest::AddDeviceForTesting", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("name"), in_name, 
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("serial_number"), in_serial_number, 
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("landing_page"), in_landing_page, 
                        "<value of type const std::string&>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kUsbDeviceManagerTest_AddDeviceForTesting_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::UsbDeviceManagerTest_AddDeviceForTesting_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->name)::BaseType> name_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_name, name_fragment);
  params->name.Set(
      name_fragment.is_null() ? nullptr : name_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->name.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null name in UsbDeviceManagerTest.AddDeviceForTesting request");
  mojo::internal::MessageFragment<
      typename decltype(params->serial_number)::BaseType> serial_number_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_serial_number, serial_number_fragment);
  params->serial_number.Set(
      serial_number_fragment.is_null() ? nullptr : serial_number_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->serial_number.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null serial_number in UsbDeviceManagerTest.AddDeviceForTesting request");
  mojo::internal::MessageFragment<
      typename decltype(params->landing_page)::BaseType> landing_page_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_landing_page, landing_page_fragment);
  params->landing_page.Set(
      landing_page_fragment.is_null() ? nullptr : landing_page_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->landing_page.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null landing_page in UsbDeviceManagerTest.AddDeviceForTesting request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(UsbDeviceManagerTest::Name_);
  message.set_method_name("AddDeviceForTesting");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new UsbDeviceManagerTest_AddDeviceForTesting_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void UsbDeviceManagerTestProxy::RemoveDeviceForTesting(
    const std::string& in_guid, RemoveDeviceForTestingCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "device::mojom::UsbDeviceManagerTest::RemoveDeviceForTesting", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("guid"), in_guid, 
                        "<value of type const std::string&>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kUsbDeviceManagerTest_RemoveDeviceForTesting_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::UsbDeviceManagerTest_RemoveDeviceForTesting_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->guid)::BaseType> guid_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_guid, guid_fragment);
  params->guid.Set(
      guid_fragment.is_null() ? nullptr : guid_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->guid.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null guid in UsbDeviceManagerTest.RemoveDeviceForTesting request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(UsbDeviceManagerTest::Name_);
  message.set_method_name("RemoveDeviceForTesting");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new UsbDeviceManagerTest_RemoveDeviceForTesting_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void UsbDeviceManagerTestProxy::GetTestDevices(
    GetTestDevicesCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "device::mojom::UsbDeviceManagerTest::GetTestDevices");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kUsbDeviceManagerTest_GetTestDevices_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::UsbDeviceManagerTest_GetTestDevices_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(UsbDeviceManagerTest::Name_);
  message.set_method_name("GetTestDevices");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new UsbDeviceManagerTest_GetTestDevices_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
class UsbDeviceManagerTest_AddDeviceForTesting_ProxyToResponder {
 public:
  static UsbDeviceManagerTest::AddDeviceForTestingCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<UsbDeviceManagerTest_AddDeviceForTesting_ProxyToResponder> proxy(
        new UsbDeviceManagerTest_AddDeviceForTesting_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&UsbDeviceManagerTest_AddDeviceForTesting_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~UsbDeviceManagerTest_AddDeviceForTesting_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  UsbDeviceManagerTest_AddDeviceForTesting_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "UsbDeviceManagerTest::AddDeviceForTestingCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success, const std::string& in_message);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(UsbDeviceManagerTest_AddDeviceForTesting_ProxyToResponder);
};

bool UsbDeviceManagerTest_AddDeviceForTesting_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "device::mojom::UsbDeviceManagerTest::AddDeviceForTestingCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::UsbDeviceManagerTest_AddDeviceForTesting_ResponseParams_Data* params =
      reinterpret_cast<
          internal::UsbDeviceManagerTest_AddDeviceForTesting_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  bool p_success{};
  std::string p_message{};
  UsbDeviceManagerTest_AddDeviceForTesting_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (success && !input_data_view.ReadMessage(&p_message))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        UsbDeviceManagerTest::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_success), 
std::move(p_message));
  return true;
}

void UsbDeviceManagerTest_AddDeviceForTesting_ProxyToResponder::Run(
    bool in_success, const std::string& in_message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)device::mojom::UsbDeviceManagerTest::AddDeviceForTestingCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success, 
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("message"), in_message, 
                        "<value of type const std::string&>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kUsbDeviceManagerTest_AddDeviceForTesting_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::UsbDeviceManagerTest_AddDeviceForTesting_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->success = in_success;
  mojo::internal::MessageFragment<
      typename decltype(params->message)::BaseType> message_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_message, message_fragment);
  params->message.Set(
      message_fragment.is_null() ? nullptr : message_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->message.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null message in ");

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)device::mojom::UsbDeviceManagerTest::AddDeviceForTestingCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(UsbDeviceManagerTest::Name_);
  message.set_method_name("AddDeviceForTesting");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class UsbDeviceManagerTest_RemoveDeviceForTesting_ProxyToResponder {
 public:
  static UsbDeviceManagerTest::RemoveDeviceForTestingCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<UsbDeviceManagerTest_RemoveDeviceForTesting_ProxyToResponder> proxy(
        new UsbDeviceManagerTest_RemoveDeviceForTesting_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&UsbDeviceManagerTest_RemoveDeviceForTesting_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~UsbDeviceManagerTest_RemoveDeviceForTesting_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  UsbDeviceManagerTest_RemoveDeviceForTesting_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "UsbDeviceManagerTest::RemoveDeviceForTestingCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(UsbDeviceManagerTest_RemoveDeviceForTesting_ProxyToResponder);
};

bool UsbDeviceManagerTest_RemoveDeviceForTesting_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "device::mojom::UsbDeviceManagerTest::RemoveDeviceForTestingCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::UsbDeviceManagerTest_RemoveDeviceForTesting_ResponseParams_Data* params =
      reinterpret_cast<
          internal::UsbDeviceManagerTest_RemoveDeviceForTesting_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  UsbDeviceManagerTest_RemoveDeviceForTesting_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        UsbDeviceManagerTest::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run();
  return true;
}

void UsbDeviceManagerTest_RemoveDeviceForTesting_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "(Impl)device::mojom::UsbDeviceManagerTest::RemoveDeviceForTestingCallback");
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kUsbDeviceManagerTest_RemoveDeviceForTesting_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::UsbDeviceManagerTest_RemoveDeviceForTesting_ResponseParams_Data> params(
          message);
  params.Allocate();

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)device::mojom::UsbDeviceManagerTest::RemoveDeviceForTestingCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(UsbDeviceManagerTest::Name_);
  message.set_method_name("RemoveDeviceForTesting");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class UsbDeviceManagerTest_GetTestDevices_ProxyToResponder {
 public:
  static UsbDeviceManagerTest::GetTestDevicesCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<UsbDeviceManagerTest_GetTestDevices_ProxyToResponder> proxy(
        new UsbDeviceManagerTest_GetTestDevices_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&UsbDeviceManagerTest_GetTestDevices_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~UsbDeviceManagerTest_GetTestDevices_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  UsbDeviceManagerTest_GetTestDevices_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "UsbDeviceManagerTest::GetTestDevicesCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      std::vector<TestDeviceInfoPtr> in_devices);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(UsbDeviceManagerTest_GetTestDevices_ProxyToResponder);
};

bool UsbDeviceManagerTest_GetTestDevices_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "device::mojom::UsbDeviceManagerTest::GetTestDevicesCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::UsbDeviceManagerTest_GetTestDevices_ResponseParams_Data* params =
      reinterpret_cast<
          internal::UsbDeviceManagerTest_GetTestDevices_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  std::vector<TestDeviceInfoPtr> p_devices{};
  UsbDeviceManagerTest_GetTestDevices_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadDevices(&p_devices))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        UsbDeviceManagerTest::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_devices));
  return true;
}

void UsbDeviceManagerTest_GetTestDevices_ProxyToResponder::Run(
    std::vector<TestDeviceInfoPtr> in_devices) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)device::mojom::UsbDeviceManagerTest::GetTestDevicesCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("devices"), in_devices, 
                        "<value of type std::vector<TestDeviceInfoPtr>>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kUsbDeviceManagerTest_GetTestDevices_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::UsbDeviceManagerTest_GetTestDevices_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->devices)::BaseType>
      devices_fragment(params.message());
  const mojo::internal::ContainerValidateParams devices_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::device::mojom::TestDeviceInfoDataView>>(
      in_devices, devices_fragment, &devices_validate_params);
  params->devices.Set(
      devices_fragment.is_null() ? nullptr : devices_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->devices.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null devices in ");

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)device::mojom::UsbDeviceManagerTest::GetTestDevicesCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(UsbDeviceManagerTest::Name_);
  message.set_method_name("GetTestDevices");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool UsbDeviceManagerTestStubDispatch::Accept(
    UsbDeviceManagerTest* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kUsbDeviceManagerTest_AddDeviceForTesting_Name: {
      break;
    }
    case internal::kUsbDeviceManagerTest_RemoveDeviceForTesting_Name: {
      break;
    }
    case internal::kUsbDeviceManagerTest_GetTestDevices_Name: {
      break;
    }
  }
  return false;
}

// static
bool UsbDeviceManagerTestStubDispatch::AcceptWithResponder(
    UsbDeviceManagerTest* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kUsbDeviceManagerTest_AddDeviceForTesting_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)device::mojom::UsbDeviceManagerTest::AddDeviceForTesting",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)device::mojom::UsbDeviceManagerTest::AddDeviceForTesting");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::UsbDeviceManagerTest_AddDeviceForTesting_Params_Data* params =
          reinterpret_cast<
              internal::UsbDeviceManagerTest_AddDeviceForTesting_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      std::string p_name{};
      std::string p_serial_number{};
      std::string p_landing_page{};
      UsbDeviceManagerTest_AddDeviceForTesting_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadName(&p_name))
        success = false;
      if (success && !input_data_view.ReadSerialNumber(&p_serial_number))
        success = false;
      if (success && !input_data_view.ReadLandingPage(&p_landing_page))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            UsbDeviceManagerTest::Name_, 0, false);
        return false;
      }
      UsbDeviceManagerTest::AddDeviceForTestingCallback callback =
          UsbDeviceManagerTest_AddDeviceForTesting_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AddDeviceForTesting(
std::move(p_name), 
std::move(p_serial_number), 
std::move(p_landing_page), std::move(callback));
      return true;
    }
    case internal::kUsbDeviceManagerTest_RemoveDeviceForTesting_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)device::mojom::UsbDeviceManagerTest::RemoveDeviceForTesting",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)device::mojom::UsbDeviceManagerTest::RemoveDeviceForTesting");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::UsbDeviceManagerTest_RemoveDeviceForTesting_Params_Data* params =
          reinterpret_cast<
              internal::UsbDeviceManagerTest_RemoveDeviceForTesting_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      std::string p_guid{};
      UsbDeviceManagerTest_RemoveDeviceForTesting_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadGuid(&p_guid))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            UsbDeviceManagerTest::Name_, 1, false);
        return false;
      }
      UsbDeviceManagerTest::RemoveDeviceForTestingCallback callback =
          UsbDeviceManagerTest_RemoveDeviceForTesting_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RemoveDeviceForTesting(
std::move(p_guid), std::move(callback));
      return true;
    }
    case internal::kUsbDeviceManagerTest_GetTestDevices_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)device::mojom::UsbDeviceManagerTest::GetTestDevices",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)device::mojom::UsbDeviceManagerTest::GetTestDevices");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::UsbDeviceManagerTest_GetTestDevices_Params_Data* params =
          reinterpret_cast<
              internal::UsbDeviceManagerTest_GetTestDevices_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      UsbDeviceManagerTest_GetTestDevices_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            UsbDeviceManagerTest::Name_, 2, false);
        return false;
      }
      UsbDeviceManagerTest::GetTestDevicesCallback callback =
          UsbDeviceManagerTest_GetTestDevices_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetTestDevices(std::move(callback));
      return true;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kUsbDeviceManagerTestValidationInfo[] = {
    {internal::kUsbDeviceManagerTest_AddDeviceForTesting_Name,
     {&internal::UsbDeviceManagerTest_AddDeviceForTesting_Params_Data::Validate,
      &internal::UsbDeviceManagerTest_AddDeviceForTesting_ResponseParams_Data::Validate}},
    {internal::kUsbDeviceManagerTest_RemoveDeviceForTesting_Name,
     {&internal::UsbDeviceManagerTest_RemoveDeviceForTesting_Params_Data::Validate,
      &internal::UsbDeviceManagerTest_RemoveDeviceForTesting_ResponseParams_Data::Validate}},
    {internal::kUsbDeviceManagerTest_GetTestDevices_Name,
     {&internal::UsbDeviceManagerTest_GetTestDevices_Params_Data::Validate,
      &internal::UsbDeviceManagerTest_GetTestDevices_ResponseParams_Data::Validate}},
};

bool UsbDeviceManagerTestRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::device::mojom::UsbDeviceManagerTest::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kUsbDeviceManagerTestValidationInfo);
}

bool UsbDeviceManagerTestResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::device::mojom::UsbDeviceManagerTest::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kUsbDeviceManagerTestValidationInfo);

}
}  // namespace mojom
}  // namespace device

namespace mojo {


// static
bool StructTraits<::device::mojom::TestDeviceInfo::DataView, ::device::mojom::TestDeviceInfoPtr>::Read(
    ::device::mojom::TestDeviceInfo::DataView input,
    ::device::mojom::TestDeviceInfoPtr* output) {
  bool success = true;
  ::device::mojom::TestDeviceInfoPtr result(::device::mojom::TestDeviceInfo::New());
  
      if (success && !input.ReadGuid(&result->guid))
        success = false;
      if (success && !input.ReadName(&result->name))
        success = false;
      if (success && !input.ReadSerialNumber(&result->serial_number))
        success = false;
      if (success && !input.ReadLandingPage(&result->landing_page))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif