// services/device/public/mojom/wake_lock_provider.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/device/public/mojom/wake_lock_provider.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "services/device/public/mojom/wake_lock_provider.mojom-params-data.h"
#include "services/device/public/mojom/wake_lock_provider.mojom-shared-message-ids.h"

#include "services/device/public/mojom/wake_lock_provider.mojom-blink-import-headers.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


#ifndef SERVICES_DEVICE_PUBLIC_MOJOM_WAKE_LOCK_PROVIDER_MOJOM_BLINK_JUMBO_H_
#define SERVICES_DEVICE_PUBLIC_MOJOM_WAKE_LOCK_PROVIDER_MOJOM_BLINK_JUMBO_H_
#endif
namespace device {
namespace mojom {
namespace blink {
const char WakeLockProvider::Name_[] = "device.mojom.WakeLockProvider";

class WakeLockProvider_GetActiveWakeLocksForTests_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  WakeLockProvider_GetActiveWakeLocksForTests_ForwardToCallback(
      WakeLockProvider::GetActiveWakeLocksForTestsCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  WakeLockProvider::GetActiveWakeLocksForTestsCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(WakeLockProvider_GetActiveWakeLocksForTests_ForwardToCallback);
};

WakeLockProviderProxy::WakeLockProviderProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void WakeLockProviderProxy::GetWakeLockContextForID(
    int32_t in_context_id, ::mojo::PendingReceiver<::device::mojom::blink::WakeLockContext> in_context) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "device::mojom::WakeLockProvider::GetWakeLockContextForID", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("context_id"), in_context_id, 
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("context"), in_context, 
                        "<value of type ::mojo::PendingReceiver<::device::mojom::blink::WakeLockContext>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kWakeLockProvider_GetWakeLockContextForID_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::WakeLockProvider_GetWakeLockContextForID_Params_Data> params(
          message);
  params.Allocate();
  params->context_id = in_context_id;
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::device::mojom::WakeLockContextInterfaceBase>>(
      in_context, &params->context, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->context),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid context in WakeLockProvider.GetWakeLockContextForID request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WakeLockProvider::Name_);
  message.set_method_name("GetWakeLockContextForID");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void WakeLockProviderProxy::GetWakeLockWithoutContext(
    ::device::mojom::blink::WakeLockType in_type, ::device::mojom::blink::WakeLockReason in_reason, const WTF::String& in_description, ::mojo::PendingReceiver<::device::mojom::blink::WakeLock> in_wake_lock) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "device::mojom::WakeLockProvider::GetWakeLockWithoutContext", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("type"), in_type, 
                        "<value of type ::device::mojom::blink::WakeLockType>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("reason"), in_reason, 
                        "<value of type ::device::mojom::blink::WakeLockReason>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("description"), in_description, 
                        "<value of type const WTF::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("wake_lock"), in_wake_lock, 
                        "<value of type ::mojo::PendingReceiver<::device::mojom::blink::WakeLock>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kWakeLockProvider_GetWakeLockWithoutContext_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::WakeLockProvider_GetWakeLockWithoutContext_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::device::mojom::WakeLockType>(
      in_type, &params->type);
  mojo::internal::Serialize<::device::mojom::WakeLockReason>(
      in_reason, &params->reason);
  mojo::internal::MessageFragment<
      typename decltype(params->description)::BaseType> description_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_description, description_fragment);
  params->description.Set(
      description_fragment.is_null() ? nullptr : description_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->description.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null description in WakeLockProvider.GetWakeLockWithoutContext request");
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::device::mojom::WakeLockInterfaceBase>>(
      in_wake_lock, &params->wake_lock, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->wake_lock),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid wake_lock in WakeLockProvider.GetWakeLockWithoutContext request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WakeLockProvider::Name_);
  message.set_method_name("GetWakeLockWithoutContext");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void WakeLockProviderProxy::NotifyOnWakeLockDeactivation(
    ::device::mojom::blink::WakeLockType in_type, ::mojo::PendingRemote<WakeLockObserver> in_observer) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "device::mojom::WakeLockProvider::NotifyOnWakeLockDeactivation", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("type"), in_type, 
                        "<value of type ::device::mojom::blink::WakeLockType>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("observer"), in_observer, 
                        "<value of type ::mojo::PendingRemote<WakeLockObserver>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kWakeLockProvider_NotifyOnWakeLockDeactivation_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::WakeLockProvider_NotifyOnWakeLockDeactivation_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::device::mojom::WakeLockType>(
      in_type, &params->type);
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::device::mojom::WakeLockObserverInterfaceBase>>(
      in_observer, &params->observer, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->observer),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid observer in WakeLockProvider.NotifyOnWakeLockDeactivation request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WakeLockProvider::Name_);
  message.set_method_name("NotifyOnWakeLockDeactivation");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void WakeLockProviderProxy::GetActiveWakeLocksForTests(
    ::device::mojom::blink::WakeLockType in_type, GetActiveWakeLocksForTestsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "device::mojom::WakeLockProvider::GetActiveWakeLocksForTests", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("type"), in_type, 
                        "<value of type ::device::mojom::blink::WakeLockType>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kWakeLockProvider_GetActiveWakeLocksForTests_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::WakeLockProvider_GetActiveWakeLocksForTests_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::device::mojom::WakeLockType>(
      in_type, &params->type);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WakeLockProvider::Name_);
  message.set_method_name("GetActiveWakeLocksForTests");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new WakeLockProvider_GetActiveWakeLocksForTests_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
class WakeLockProvider_GetActiveWakeLocksForTests_ProxyToResponder {
 public:
  static WakeLockProvider::GetActiveWakeLocksForTestsCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<WakeLockProvider_GetActiveWakeLocksForTests_ProxyToResponder> proxy(
        new WakeLockProvider_GetActiveWakeLocksForTests_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&WakeLockProvider_GetActiveWakeLocksForTests_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~WakeLockProvider_GetActiveWakeLocksForTests_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  WakeLockProvider_GetActiveWakeLocksForTests_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "WakeLockProvider::GetActiveWakeLocksForTestsCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      int32_t in_count);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(WakeLockProvider_GetActiveWakeLocksForTests_ProxyToResponder);
};

bool WakeLockProvider_GetActiveWakeLocksForTests_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "device::mojom::WakeLockProvider::GetActiveWakeLocksForTestsCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::WakeLockProvider_GetActiveWakeLocksForTests_ResponseParams_Data* params =
      reinterpret_cast<
          internal::WakeLockProvider_GetActiveWakeLocksForTests_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  int32_t p_count{};
  WakeLockProvider_GetActiveWakeLocksForTests_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_count = input_data_view.count();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        WakeLockProvider::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_count));
  return true;
}

void WakeLockProvider_GetActiveWakeLocksForTests_ProxyToResponder::Run(
    int32_t in_count) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)device::mojom::WakeLockProvider::GetActiveWakeLocksForTestsCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("count"), in_count, 
                        "<value of type int32_t>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kWakeLockProvider_GetActiveWakeLocksForTests_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::WakeLockProvider_GetActiveWakeLocksForTests_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->count = in_count;

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)device::mojom::WakeLockProvider::GetActiveWakeLocksForTestsCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WakeLockProvider::Name_);
  message.set_method_name("GetActiveWakeLocksForTests");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool WakeLockProviderStubDispatch::Accept(
    WakeLockProvider* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kWakeLockProvider_GetWakeLockContextForID_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)device::mojom::WakeLockProvider::GetWakeLockContextForID",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)device::mojom::WakeLockProvider::GetWakeLockContextForID");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::WakeLockProvider_GetWakeLockContextForID_Params_Data* params =
          reinterpret_cast<internal::WakeLockProvider_GetWakeLockContextForID_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      int32_t p_context_id{};
      ::mojo::PendingReceiver<::device::mojom::blink::WakeLockContext> p_context{};
      WakeLockProvider_GetWakeLockContextForID_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_context_id = input_data_view.context_id();
      if (success) {
        p_context =
            input_data_view.TakeContext<decltype(p_context)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WakeLockProvider::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetWakeLockContextForID(
std::move(p_context_id), 
std::move(p_context));
      return true;
    }
    case internal::kWakeLockProvider_GetWakeLockWithoutContext_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)device::mojom::WakeLockProvider::GetWakeLockWithoutContext",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)device::mojom::WakeLockProvider::GetWakeLockWithoutContext");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::WakeLockProvider_GetWakeLockWithoutContext_Params_Data* params =
          reinterpret_cast<internal::WakeLockProvider_GetWakeLockWithoutContext_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::device::mojom::blink::WakeLockType p_type{};
      ::device::mojom::blink::WakeLockReason p_reason{};
      WTF::String p_description{};
      ::mojo::PendingReceiver<::device::mojom::blink::WakeLock> p_wake_lock{};
      WakeLockProvider_GetWakeLockWithoutContext_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadType(&p_type))
        success = false;
      if (success && !input_data_view.ReadReason(&p_reason))
        success = false;
      if (success && !input_data_view.ReadDescription(&p_description))
        success = false;
      if (success) {
        p_wake_lock =
            input_data_view.TakeWakeLock<decltype(p_wake_lock)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WakeLockProvider::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetWakeLockWithoutContext(
std::move(p_type), 
std::move(p_reason), 
std::move(p_description), 
std::move(p_wake_lock));
      return true;
    }
    case internal::kWakeLockProvider_NotifyOnWakeLockDeactivation_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)device::mojom::WakeLockProvider::NotifyOnWakeLockDeactivation",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)device::mojom::WakeLockProvider::NotifyOnWakeLockDeactivation");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::WakeLockProvider_NotifyOnWakeLockDeactivation_Params_Data* params =
          reinterpret_cast<internal::WakeLockProvider_NotifyOnWakeLockDeactivation_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::device::mojom::blink::WakeLockType p_type{};
      ::mojo::PendingRemote<WakeLockObserver> p_observer{};
      WakeLockProvider_NotifyOnWakeLockDeactivation_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadType(&p_type))
        success = false;
      if (success) {
        p_observer =
            input_data_view.TakeObserver<decltype(p_observer)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WakeLockProvider::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->NotifyOnWakeLockDeactivation(
std::move(p_type), 
std::move(p_observer));
      return true;
    }
    case internal::kWakeLockProvider_GetActiveWakeLocksForTests_Name: {
      break;
    }
  }
  return false;
}

// static
bool WakeLockProviderStubDispatch::AcceptWithResponder(
    WakeLockProvider* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kWakeLockProvider_GetWakeLockContextForID_Name: {
      break;
    }
    case internal::kWakeLockProvider_GetWakeLockWithoutContext_Name: {
      break;
    }
    case internal::kWakeLockProvider_NotifyOnWakeLockDeactivation_Name: {
      break;
    }
    case internal::kWakeLockProvider_GetActiveWakeLocksForTests_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)device::mojom::WakeLockProvider::GetActiveWakeLocksForTests",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)device::mojom::WakeLockProvider::GetActiveWakeLocksForTests");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::WakeLockProvider_GetActiveWakeLocksForTests_Params_Data* params =
          reinterpret_cast<
              internal::WakeLockProvider_GetActiveWakeLocksForTests_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::device::mojom::blink::WakeLockType p_type{};
      WakeLockProvider_GetActiveWakeLocksForTests_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadType(&p_type))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WakeLockProvider::Name_, 3, false);
        return false;
      }
      WakeLockProvider::GetActiveWakeLocksForTestsCallback callback =
          WakeLockProvider_GetActiveWakeLocksForTests_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetActiveWakeLocksForTests(
std::move(p_type), std::move(callback));
      return true;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kWakeLockProviderValidationInfo[] = {
    {internal::kWakeLockProvider_GetWakeLockContextForID_Name,
     {&internal::WakeLockProvider_GetWakeLockContextForID_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kWakeLockProvider_GetWakeLockWithoutContext_Name,
     {&internal::WakeLockProvider_GetWakeLockWithoutContext_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kWakeLockProvider_NotifyOnWakeLockDeactivation_Name,
     {&internal::WakeLockProvider_NotifyOnWakeLockDeactivation_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kWakeLockProvider_GetActiveWakeLocksForTests_Name,
     {&internal::WakeLockProvider_GetActiveWakeLocksForTests_Params_Data::Validate,
      &internal::WakeLockProvider_GetActiveWakeLocksForTests_ResponseParams_Data::Validate}},
};

bool WakeLockProviderRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::device::mojom::blink::WakeLockProvider::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kWakeLockProviderValidationInfo);
}

bool WakeLockProviderResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::device::mojom::blink::WakeLockProvider::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kWakeLockProviderValidationInfo);

}
const char WakeLockObserver::Name_[] = "device.mojom.WakeLockObserver";

WakeLockObserverProxy::WakeLockObserverProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void WakeLockObserverProxy::OnWakeLockDeactivated(
    ::device::mojom::blink::WakeLockType in_type) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "device::mojom::WakeLockObserver::OnWakeLockDeactivated", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("type"), in_type, 
                        "<value of type ::device::mojom::blink::WakeLockType>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kWakeLockObserver_OnWakeLockDeactivated_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::WakeLockObserver_OnWakeLockDeactivated_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::device::mojom::WakeLockType>(
      in_type, &params->type);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WakeLockObserver::Name_);
  message.set_method_name("OnWakeLockDeactivated");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool WakeLockObserverStubDispatch::Accept(
    WakeLockObserver* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kWakeLockObserver_OnWakeLockDeactivated_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)device::mojom::WakeLockObserver::OnWakeLockDeactivated",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)device::mojom::WakeLockObserver::OnWakeLockDeactivated");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::WakeLockObserver_OnWakeLockDeactivated_Params_Data* params =
          reinterpret_cast<internal::WakeLockObserver_OnWakeLockDeactivated_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::device::mojom::blink::WakeLockType p_type{};
      WakeLockObserver_OnWakeLockDeactivated_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadType(&p_type))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WakeLockObserver::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnWakeLockDeactivated(
std::move(p_type));
      return true;
    }
  }
  return false;
}

// static
bool WakeLockObserverStubDispatch::AcceptWithResponder(
    WakeLockObserver* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kWakeLockObserver_OnWakeLockDeactivated_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kWakeLockObserverValidationInfo[] = {
    {internal::kWakeLockObserver_OnWakeLockDeactivated_Name,
     {&internal::WakeLockObserver_OnWakeLockDeactivated_Params_Data::Validate,
      nullptr /* no response */}},
};

bool WakeLockObserverRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::device::mojom::blink::WakeLockObserver::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kWakeLockObserverValidationInfo);
}

}  // namespace blink
}  // namespace mojom
}  // namespace device

namespace mojo {

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif