// services/media_session/public/mojom/audio_focus.mojom-test-utils.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif


#include "services/media_session/public/mojom/audio_focus.mojom-test-utils.h"

#include <utility>

#include "base/bind.h"
#include "base/run_loop.h"
#include "mojo/public/mojom/base/unguessable_token.mojom.h"
#include "services/media_session/public/mojom/media_session.mojom.h"


#ifndef SERVICES_MEDIA_SESSION_PUBLIC_MOJOM_AUDIO_FOCUS_MOJOM_JUMBO_H_
#define SERVICES_MEDIA_SESSION_PUBLIC_MOJOM_AUDIO_FOCUS_MOJOM_JUMBO_H_
#endif


namespace media_session {
namespace mojom {


void AudioFocusObserverInterceptorForTesting::OnFocusGained(AudioFocusRequestStatePtr state) {
  GetForwardingInterface()->OnFocusGained(std::move(state));
}
void AudioFocusObserverInterceptorForTesting::OnFocusLost(AudioFocusRequestStatePtr state) {
  GetForwardingInterface()->OnFocusLost(std::move(state));
}
AudioFocusObserverAsyncWaiter::AudioFocusObserverAsyncWaiter(
    AudioFocusObserver* proxy) : proxy_(proxy) {}

AudioFocusObserverAsyncWaiter::~AudioFocusObserverAsyncWaiter() = default;




void AudioFocusRequestClientInterceptorForTesting::RequestAudioFocus(::media_session::mojom::MediaSessionInfoPtr session_info, AudioFocusType type, RequestAudioFocusCallback callback) {
  GetForwardingInterface()->RequestAudioFocus(std::move(session_info), std::move(type), std::move(callback));
}
void AudioFocusRequestClientInterceptorForTesting::AbandonAudioFocus() {
  GetForwardingInterface()->AbandonAudioFocus();
}
void AudioFocusRequestClientInterceptorForTesting::MediaSessionInfoChanged(::media_session::mojom::MediaSessionInfoPtr session_info) {
  GetForwardingInterface()->MediaSessionInfoChanged(std::move(session_info));
}
AudioFocusRequestClientAsyncWaiter::AudioFocusRequestClientAsyncWaiter(
    AudioFocusRequestClient* proxy) : proxy_(proxy) {}

AudioFocusRequestClientAsyncWaiter::~AudioFocusRequestClientAsyncWaiter() = default;

void AudioFocusRequestClientAsyncWaiter::RequestAudioFocus(
    ::media_session::mojom::MediaSessionInfoPtr session_info, AudioFocusType type) {
  base::RunLoop loop;
  proxy_->RequestAudioFocus(std::move(session_info),std::move(type),
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}



void AudioFocusManagerInterceptorForTesting::RequestAudioFocus(::mojo::PendingReceiver<AudioFocusRequestClient> client, ::mojo::PendingRemote<::media_session::mojom::MediaSession> session, ::media_session::mojom::MediaSessionInfoPtr session_info, AudioFocusType type, RequestAudioFocusCallback callback) {
  GetForwardingInterface()->RequestAudioFocus(std::move(client), std::move(session), std::move(session_info), std::move(type), std::move(callback));
}
void AudioFocusManagerInterceptorForTesting::RequestGroupedAudioFocus(const ::base::UnguessableToken& request_id, ::mojo::PendingReceiver<AudioFocusRequestClient> client, ::mojo::PendingRemote<::media_session::mojom::MediaSession> session, ::media_session::mojom::MediaSessionInfoPtr session_info, AudioFocusType type, const ::base::UnguessableToken& group_id, RequestGroupedAudioFocusCallback callback) {
  GetForwardingInterface()->RequestGroupedAudioFocus(std::move(request_id), std::move(client), std::move(session), std::move(session_info), std::move(type), std::move(group_id), std::move(callback));
}
void AudioFocusManagerInterceptorForTesting::GetFocusRequests(GetFocusRequestsCallback callback) {
  GetForwardingInterface()->GetFocusRequests(std::move(callback));
}
void AudioFocusManagerInterceptorForTesting::AddObserver(::mojo::PendingRemote<AudioFocusObserver> observer) {
  GetForwardingInterface()->AddObserver(std::move(observer));
}
void AudioFocusManagerInterceptorForTesting::SetSource(const ::base::UnguessableToken& identity, const std::string& name) {
  GetForwardingInterface()->SetSource(std::move(identity), std::move(name));
}
void AudioFocusManagerInterceptorForTesting::SetEnforcementMode(EnforcementMode mode) {
  GetForwardingInterface()->SetEnforcementMode(std::move(mode));
}
void AudioFocusManagerInterceptorForTesting::AddSourceObserver(const ::base::UnguessableToken& source_id, ::mojo::PendingRemote<AudioFocusObserver> observer) {
  GetForwardingInterface()->AddSourceObserver(std::move(source_id), std::move(observer));
}
void AudioFocusManagerInterceptorForTesting::GetSourceFocusRequests(const ::base::UnguessableToken& source_id, GetSourceFocusRequestsCallback callback) {
  GetForwardingInterface()->GetSourceFocusRequests(std::move(source_id), std::move(callback));
}
AudioFocusManagerAsyncWaiter::AudioFocusManagerAsyncWaiter(
    AudioFocusManager* proxy) : proxy_(proxy) {}

AudioFocusManagerAsyncWaiter::~AudioFocusManagerAsyncWaiter() = default;

void AudioFocusManagerAsyncWaiter::RequestAudioFocus(
    ::mojo::PendingReceiver<AudioFocusRequestClient> client, ::mojo::PendingRemote<::media_session::mojom::MediaSession> session, ::media_session::mojom::MediaSessionInfoPtr session_info, AudioFocusType type, ::base::UnguessableToken* out_request_id) {
  base::RunLoop loop;
  proxy_->RequestAudioFocus(std::move(client),std::move(session),std::move(session_info),std::move(type),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::base::UnguessableToken* out_request_id
,
             const ::base::UnguessableToken& request_id) {*out_request_id = std::move(request_id);
            loop->Quit();
          },
          &loop,
          out_request_id));
  loop.Run();
}
void AudioFocusManagerAsyncWaiter::RequestGroupedAudioFocus(
    const ::base::UnguessableToken& request_id, ::mojo::PendingReceiver<AudioFocusRequestClient> client, ::mojo::PendingRemote<::media_session::mojom::MediaSession> session, ::media_session::mojom::MediaSessionInfoPtr session_info, AudioFocusType type, const ::base::UnguessableToken& group_id, bool* out_success) {
  base::RunLoop loop;
  proxy_->RequestGroupedAudioFocus(std::move(request_id),std::move(client),std::move(session),std::move(session_info),std::move(type),std::move(group_id),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_success
,
             bool success) {*out_success = std::move(success);
            loop->Quit();
          },
          &loop,
          out_success));
  loop.Run();
}
void AudioFocusManagerAsyncWaiter::GetFocusRequests(
    std::vector<AudioFocusRequestStatePtr>* out_requests) {
  base::RunLoop loop;
  proxy_->GetFocusRequests(
      base::BindOnce(
          [](base::RunLoop* loop,
             std::vector<AudioFocusRequestStatePtr>* out_requests
,
             std::vector<AudioFocusRequestStatePtr> requests) {*out_requests = std::move(requests);
            loop->Quit();
          },
          &loop,
          out_requests));
  loop.Run();
}
void AudioFocusManagerAsyncWaiter::GetSourceFocusRequests(
    const ::base::UnguessableToken& source_id, std::vector<AudioFocusRequestStatePtr>* out_requests) {
  base::RunLoop loop;
  proxy_->GetSourceFocusRequests(std::move(source_id),
      base::BindOnce(
          [](base::RunLoop* loop,
             std::vector<AudioFocusRequestStatePtr>* out_requests
,
             std::vector<AudioFocusRequestStatePtr> requests) {*out_requests = std::move(requests);
            loop->Quit();
          },
          &loop,
          out_requests));
  loop.Run();
}



void AudioFocusManagerDebugInterceptorForTesting::GetDebugInfoForRequest(const ::base::UnguessableToken& request_id, GetDebugInfoForRequestCallback callback) {
  GetForwardingInterface()->GetDebugInfoForRequest(std::move(request_id), std::move(callback));
}
AudioFocusManagerDebugAsyncWaiter::AudioFocusManagerDebugAsyncWaiter(
    AudioFocusManagerDebug* proxy) : proxy_(proxy) {}

AudioFocusManagerDebugAsyncWaiter::~AudioFocusManagerDebugAsyncWaiter() = default;

void AudioFocusManagerDebugAsyncWaiter::GetDebugInfoForRequest(
    const ::base::UnguessableToken& request_id, ::media_session::mojom::MediaSessionDebugInfoPtr* out_debug_info) {
  base::RunLoop loop;
  proxy_->GetDebugInfoForRequest(std::move(request_id),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::media_session::mojom::MediaSessionDebugInfoPtr* out_debug_info
,
             ::media_session::mojom::MediaSessionDebugInfoPtr debug_info) {*out_debug_info = std::move(debug_info);
            loop->Quit();
          },
          &loop,
          out_debug_info));
  loop.Run();
}





}  // namespace mojom
}  // namespace media_session

#if defined(__clang__)
#pragma clang diagnostic pop
#endif