// services/media_session/public/mojom/audio_focus.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/media_session/public/mojom/audio_focus.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "services/media_session/public/mojom/audio_focus.mojom-params-data.h"
#include "services/media_session/public/mojom/audio_focus.mojom-shared-message-ids.h"

#include "services/media_session/public/mojom/audio_focus.mojom-import-headers.h"


#ifndef SERVICES_MEDIA_SESSION_PUBLIC_MOJOM_AUDIO_FOCUS_MOJOM_JUMBO_H_
#define SERVICES_MEDIA_SESSION_PUBLIC_MOJOM_AUDIO_FOCUS_MOJOM_JUMBO_H_
#endif
namespace media_session {
namespace mojom {
AudioFocusRequestState::AudioFocusRequestState()
    : session_info(),
      audio_focus_type(),
      source_name(),
      request_id() {}

AudioFocusRequestState::AudioFocusRequestState(
    ::media_session::mojom::MediaSessionInfoPtr session_info_in,
    AudioFocusType audio_focus_type_in)
    : session_info(std::move(session_info_in)),
      audio_focus_type(std::move(audio_focus_type_in)),
      source_name(),
      request_id() {}

AudioFocusRequestState::AudioFocusRequestState(
    ::media_session::mojom::MediaSessionInfoPtr session_info_in,
    AudioFocusType audio_focus_type_in,
    const base::Optional<std::string>& source_name_in)
    : session_info(std::move(session_info_in)),
      audio_focus_type(std::move(audio_focus_type_in)),
      source_name(std::move(source_name_in)),
      request_id() {}

AudioFocusRequestState::AudioFocusRequestState(
    ::media_session::mojom::MediaSessionInfoPtr session_info_in,
    AudioFocusType audio_focus_type_in,
    const base::Optional<std::string>& source_name_in,
    const base::Optional<::base::UnguessableToken>& request_id_in)
    : session_info(std::move(session_info_in)),
      audio_focus_type(std::move(audio_focus_type_in)),
      source_name(std::move(source_name_in)),
      request_id(std::move(request_id_in)) {}

AudioFocusRequestState::~AudioFocusRequestState() = default;

void AudioFocusRequestState::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "session_info"), this->session_info, 
      "<value of type ::media_session::mojom::MediaSessionInfoPtr>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "audio_focus_type"), this->audio_focus_type, 
      "<value of type AudioFocusType>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "source_name"), this->source_name, 
      "<value of type const base::Optional<std::string>&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "request_id"), this->request_id, 
      "<value of type const base::Optional<::base::UnguessableToken>&>");
}

bool AudioFocusRequestState::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
const char AudioFocusObserver::Name_[] = "media_session.mojom.AudioFocusObserver";

AudioFocusObserverProxy::AudioFocusObserverProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void AudioFocusObserverProxy::OnFocusGained(
    AudioFocusRequestStatePtr in_state) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media_session::mojom::AudioFocusObserver::OnFocusGained", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("state"), in_state, 
                        "<value of type AudioFocusRequestStatePtr>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kAudioFocusObserver_OnFocusGained_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media_session::mojom::internal::AudioFocusObserver_OnFocusGained_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->state)::BaseType> state_fragment(
          params.message());
  mojo::internal::Serialize<::media_session::mojom::AudioFocusRequestStateDataView>(
      in_state, state_fragment);
  params->state.Set(
      state_fragment.is_null() ? nullptr : state_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->state.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null state in AudioFocusObserver.OnFocusGained request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AudioFocusObserver::Name_);
  message.set_method_name("OnFocusGained");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void AudioFocusObserverProxy::OnFocusLost(
    AudioFocusRequestStatePtr in_state) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media_session::mojom::AudioFocusObserver::OnFocusLost", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("state"), in_state, 
                        "<value of type AudioFocusRequestStatePtr>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kAudioFocusObserver_OnFocusLost_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media_session::mojom::internal::AudioFocusObserver_OnFocusLost_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->state)::BaseType> state_fragment(
          params.message());
  mojo::internal::Serialize<::media_session::mojom::AudioFocusRequestStateDataView>(
      in_state, state_fragment);
  params->state.Set(
      state_fragment.is_null() ? nullptr : state_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->state.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null state in AudioFocusObserver.OnFocusLost request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AudioFocusObserver::Name_);
  message.set_method_name("OnFocusLost");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool AudioFocusObserverStubDispatch::Accept(
    AudioFocusObserver* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kAudioFocusObserver_OnFocusGained_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media_session::mojom::AudioFocusObserver::OnFocusGained",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media_session::mojom::AudioFocusObserver::OnFocusGained");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::AudioFocusObserver_OnFocusGained_Params_Data* params =
          reinterpret_cast<internal::AudioFocusObserver_OnFocusGained_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      AudioFocusRequestStatePtr p_state{};
      AudioFocusObserver_OnFocusGained_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadState(&p_state))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AudioFocusObserver::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnFocusGained(
std::move(p_state));
      return true;
    }
    case internal::kAudioFocusObserver_OnFocusLost_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media_session::mojom::AudioFocusObserver::OnFocusLost",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media_session::mojom::AudioFocusObserver::OnFocusLost");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::AudioFocusObserver_OnFocusLost_Params_Data* params =
          reinterpret_cast<internal::AudioFocusObserver_OnFocusLost_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      AudioFocusRequestStatePtr p_state{};
      AudioFocusObserver_OnFocusLost_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadState(&p_state))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AudioFocusObserver::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnFocusLost(
std::move(p_state));
      return true;
    }
  }
  return false;
}

// static
bool AudioFocusObserverStubDispatch::AcceptWithResponder(
    AudioFocusObserver* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kAudioFocusObserver_OnFocusGained_Name: {
      break;
    }
    case internal::kAudioFocusObserver_OnFocusLost_Name: {
      break;
    }
  }
  return false;
}


static const mojo::internal::GenericValidationInfo kAudioFocusObserverValidationInfo[] = {
    {&internal::AudioFocusObserver_OnFocusGained_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::AudioFocusObserver_OnFocusLost_Params_Data::Validate,
     nullptr /* no response */},
};

bool AudioFocusObserverRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::media_session::mojom::AudioFocusObserver::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kAudioFocusObserverValidationInfo);
}

const char AudioFocusRequestClient::Name_[] = "media_session.mojom.AudioFocusRequestClient";

class AudioFocusRequestClient_RequestAudioFocus_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  AudioFocusRequestClient_RequestAudioFocus_ForwardToCallback(
      AudioFocusRequestClient::RequestAudioFocusCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  AudioFocusRequestClient::RequestAudioFocusCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(AudioFocusRequestClient_RequestAudioFocus_ForwardToCallback);
};

AudioFocusRequestClientProxy::AudioFocusRequestClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void AudioFocusRequestClientProxy::RequestAudioFocus(
    ::media_session::mojom::MediaSessionInfoPtr in_session_info, AudioFocusType in_type, RequestAudioFocusCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media_session::mojom::AudioFocusRequestClient::RequestAudioFocus", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("session_info"), in_session_info, 
                        "<value of type ::media_session::mojom::MediaSessionInfoPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("type"), in_type, 
                        "<value of type AudioFocusType>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kAudioFocusRequestClient_RequestAudioFocus_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media_session::mojom::internal::AudioFocusRequestClient_RequestAudioFocus_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->session_info)::BaseType> session_info_fragment(
          params.message());
  mojo::internal::Serialize<::media_session::mojom::MediaSessionInfoDataView>(
      in_session_info, session_info_fragment);
  params->session_info.Set(
      session_info_fragment.is_null() ? nullptr : session_info_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->session_info.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null session_info in AudioFocusRequestClient.RequestAudioFocus request");
  mojo::internal::Serialize<::media_session::mojom::AudioFocusType>(
      in_type, &params->type);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AudioFocusRequestClient::Name_);
  message.set_method_name("RequestAudioFocus");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new AudioFocusRequestClient_RequestAudioFocus_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void AudioFocusRequestClientProxy::AbandonAudioFocus(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "media_session::mojom::AudioFocusRequestClient::AbandonAudioFocus");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kAudioFocusRequestClient_AbandonAudioFocus_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media_session::mojom::internal::AudioFocusRequestClient_AbandonAudioFocus_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AudioFocusRequestClient::Name_);
  message.set_method_name("AbandonAudioFocus");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void AudioFocusRequestClientProxy::MediaSessionInfoChanged(
    ::media_session::mojom::MediaSessionInfoPtr in_session_info) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media_session::mojom::AudioFocusRequestClient::MediaSessionInfoChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("session_info"), in_session_info, 
                        "<value of type ::media_session::mojom::MediaSessionInfoPtr>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kAudioFocusRequestClient_MediaSessionInfoChanged_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media_session::mojom::internal::AudioFocusRequestClient_MediaSessionInfoChanged_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->session_info)::BaseType> session_info_fragment(
          params.message());
  mojo::internal::Serialize<::media_session::mojom::MediaSessionInfoDataView>(
      in_session_info, session_info_fragment);
  params->session_info.Set(
      session_info_fragment.is_null() ? nullptr : session_info_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->session_info.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null session_info in AudioFocusRequestClient.MediaSessionInfoChanged request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AudioFocusRequestClient::Name_);
  message.set_method_name("MediaSessionInfoChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}
class AudioFocusRequestClient_RequestAudioFocus_ProxyToResponder {
 public:
  static AudioFocusRequestClient::RequestAudioFocusCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<AudioFocusRequestClient_RequestAudioFocus_ProxyToResponder> proxy(
        new AudioFocusRequestClient_RequestAudioFocus_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&AudioFocusRequestClient_RequestAudioFocus_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~AudioFocusRequestClient_RequestAudioFocus_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  AudioFocusRequestClient_RequestAudioFocus_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "AudioFocusRequestClient::RequestAudioFocusCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(AudioFocusRequestClient_RequestAudioFocus_ProxyToResponder);
};

bool AudioFocusRequestClient_RequestAudioFocus_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "media_session::mojom::AudioFocusRequestClient::RequestAudioFocusCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::AudioFocusRequestClient_RequestAudioFocus_ResponseParams_Data* params =
      reinterpret_cast<
          internal::AudioFocusRequestClient_RequestAudioFocus_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  AudioFocusRequestClient_RequestAudioFocus_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        AudioFocusRequestClient::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run();
  return true;
}

void AudioFocusRequestClient_RequestAudioFocus_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "(Impl)media_session::mojom::AudioFocusRequestClient::RequestAudioFocusCallback");
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kAudioFocusRequestClient_RequestAudioFocus_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media_session::mojom::internal::AudioFocusRequestClient_RequestAudioFocus_ResponseParams_Data> params(
          message);
  params.Allocate();

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)media_session::mojom::AudioFocusRequestClient::RequestAudioFocusCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AudioFocusRequestClient::Name_);
  message.set_method_name("RequestAudioFocus");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool AudioFocusRequestClientStubDispatch::Accept(
    AudioFocusRequestClient* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kAudioFocusRequestClient_RequestAudioFocus_Name: {
      break;
    }
    case internal::kAudioFocusRequestClient_AbandonAudioFocus_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media_session::mojom::AudioFocusRequestClient::AbandonAudioFocus",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media_session::mojom::AudioFocusRequestClient::AbandonAudioFocus");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::AudioFocusRequestClient_AbandonAudioFocus_Params_Data* params =
          reinterpret_cast<internal::AudioFocusRequestClient_AbandonAudioFocus_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      AudioFocusRequestClient_AbandonAudioFocus_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AudioFocusRequestClient::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AbandonAudioFocus();
      return true;
    }
    case internal::kAudioFocusRequestClient_MediaSessionInfoChanged_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media_session::mojom::AudioFocusRequestClient::MediaSessionInfoChanged",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media_session::mojom::AudioFocusRequestClient::MediaSessionInfoChanged");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::AudioFocusRequestClient_MediaSessionInfoChanged_Params_Data* params =
          reinterpret_cast<internal::AudioFocusRequestClient_MediaSessionInfoChanged_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::media_session::mojom::MediaSessionInfoPtr p_session_info{};
      AudioFocusRequestClient_MediaSessionInfoChanged_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSessionInfo(&p_session_info))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AudioFocusRequestClient::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->MediaSessionInfoChanged(
std::move(p_session_info));
      return true;
    }
  }
  return false;
}

// static
bool AudioFocusRequestClientStubDispatch::AcceptWithResponder(
    AudioFocusRequestClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kAudioFocusRequestClient_RequestAudioFocus_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media_session::mojom::AudioFocusRequestClient::RequestAudioFocus",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media_session::mojom::AudioFocusRequestClient::RequestAudioFocus");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::AudioFocusRequestClient_RequestAudioFocus_Params_Data* params =
          reinterpret_cast<
              internal::AudioFocusRequestClient_RequestAudioFocus_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::media_session::mojom::MediaSessionInfoPtr p_session_info{};
      AudioFocusType p_type{};
      AudioFocusRequestClient_RequestAudioFocus_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSessionInfo(&p_session_info))
        success = false;
      if (success && !input_data_view.ReadType(&p_type))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AudioFocusRequestClient::Name_, 0, false);
        return false;
      }
      AudioFocusRequestClient::RequestAudioFocusCallback callback =
          AudioFocusRequestClient_RequestAudioFocus_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RequestAudioFocus(
std::move(p_session_info), 
std::move(p_type), std::move(callback));
      return true;
    }
    case internal::kAudioFocusRequestClient_AbandonAudioFocus_Name: {
      break;
    }
    case internal::kAudioFocusRequestClient_MediaSessionInfoChanged_Name: {
      break;
    }
  }
  return false;
}


static const mojo::internal::GenericValidationInfo kAudioFocusRequestClientValidationInfo[] = {
    {&internal::AudioFocusRequestClient_RequestAudioFocus_Params_Data::Validate,
     &internal::AudioFocusRequestClient_RequestAudioFocus_ResponseParams_Data::Validate},
    {&internal::AudioFocusRequestClient_AbandonAudioFocus_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::AudioFocusRequestClient_MediaSessionInfoChanged_Params_Data::Validate,
     nullptr /* no response */},
};

bool AudioFocusRequestClientRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::media_session::mojom::AudioFocusRequestClient::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kAudioFocusRequestClientValidationInfo);
}

bool AudioFocusRequestClientResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::media_session::mojom::AudioFocusRequestClient::Name_;
  return mojo::internal::ValidateResponseGenericPacked(message, name, kAudioFocusRequestClientValidationInfo);
}
const char AudioFocusManager::Name_[] = "media_session.mojom.AudioFocusManager";
constexpr base::Token AudioFocusManager::Uuid_;

class AudioFocusManager_RequestAudioFocus_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  AudioFocusManager_RequestAudioFocus_ForwardToCallback(
      AudioFocusManager::RequestAudioFocusCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  AudioFocusManager::RequestAudioFocusCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(AudioFocusManager_RequestAudioFocus_ForwardToCallback);
};

class AudioFocusManager_RequestGroupedAudioFocus_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  AudioFocusManager_RequestGroupedAudioFocus_ForwardToCallback(
      AudioFocusManager::RequestGroupedAudioFocusCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  AudioFocusManager::RequestGroupedAudioFocusCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(AudioFocusManager_RequestGroupedAudioFocus_ForwardToCallback);
};

class AudioFocusManager_GetFocusRequests_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  AudioFocusManager_GetFocusRequests_ForwardToCallback(
      AudioFocusManager::GetFocusRequestsCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  AudioFocusManager::GetFocusRequestsCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(AudioFocusManager_GetFocusRequests_ForwardToCallback);
};

class AudioFocusManager_GetSourceFocusRequests_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  AudioFocusManager_GetSourceFocusRequests_ForwardToCallback(
      AudioFocusManager::GetSourceFocusRequestsCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  AudioFocusManager::GetSourceFocusRequestsCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(AudioFocusManager_GetSourceFocusRequests_ForwardToCallback);
};

AudioFocusManagerProxy::AudioFocusManagerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void AudioFocusManagerProxy::RequestAudioFocus(
    ::mojo::PendingReceiver<AudioFocusRequestClient> in_client, ::mojo::PendingRemote<::media_session::mojom::MediaSession> in_session, ::media_session::mojom::MediaSessionInfoPtr in_session_info, AudioFocusType in_type, RequestAudioFocusCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media_session::mojom::AudioFocusManager::RequestAudioFocus", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client"), in_client, 
                        "<value of type ::mojo::PendingReceiver<AudioFocusRequestClient>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("session"), in_session, 
                        "<value of type ::mojo::PendingRemote<::media_session::mojom::MediaSession>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("session_info"), in_session_info, 
                        "<value of type ::media_session::mojom::MediaSessionInfoPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("type"), in_type, 
                        "<value of type AudioFocusType>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kAudioFocusManager_RequestAudioFocus_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media_session::mojom::internal::AudioFocusManager_RequestAudioFocus_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::media_session::mojom::AudioFocusRequestClientInterfaceBase>>(
      in_client, &params->client, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->client),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid client in AudioFocusManager.RequestAudioFocus request");
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::media_session::mojom::MediaSessionInterfaceBase>>(
      in_session, &params->session, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->session),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid session in AudioFocusManager.RequestAudioFocus request");
  mojo::internal::MessageFragment<
      typename decltype(params->session_info)::BaseType> session_info_fragment(
          params.message());
  mojo::internal::Serialize<::media_session::mojom::MediaSessionInfoDataView>(
      in_session_info, session_info_fragment);
  params->session_info.Set(
      session_info_fragment.is_null() ? nullptr : session_info_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->session_info.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null session_info in AudioFocusManager.RequestAudioFocus request");
  mojo::internal::Serialize<::media_session::mojom::AudioFocusType>(
      in_type, &params->type);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AudioFocusManager::Name_);
  message.set_method_name("RequestAudioFocus");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new AudioFocusManager_RequestAudioFocus_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void AudioFocusManagerProxy::RequestGroupedAudioFocus(
    const ::base::UnguessableToken& in_request_id, ::mojo::PendingReceiver<AudioFocusRequestClient> in_client, ::mojo::PendingRemote<::media_session::mojom::MediaSession> in_session, ::media_session::mojom::MediaSessionInfoPtr in_session_info, AudioFocusType in_type, const ::base::UnguessableToken& in_group_id, RequestGroupedAudioFocusCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media_session::mojom::AudioFocusManager::RequestGroupedAudioFocus", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("request_id"), in_request_id, 
                        "<value of type const ::base::UnguessableToken&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client"), in_client, 
                        "<value of type ::mojo::PendingReceiver<AudioFocusRequestClient>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("session"), in_session, 
                        "<value of type ::mojo::PendingRemote<::media_session::mojom::MediaSession>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("session_info"), in_session_info, 
                        "<value of type ::media_session::mojom::MediaSessionInfoPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("type"), in_type, 
                        "<value of type AudioFocusType>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("group_id"), in_group_id, 
                        "<value of type const ::base::UnguessableToken&>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kAudioFocusManager_RequestGroupedAudioFocus_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media_session::mojom::internal::AudioFocusManager_RequestGroupedAudioFocus_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->request_id)::BaseType> request_id_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
      in_request_id, request_id_fragment);
  params->request_id.Set(
      request_id_fragment.is_null() ? nullptr : request_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->request_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null request_id in AudioFocusManager.RequestGroupedAudioFocus request");
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::media_session::mojom::AudioFocusRequestClientInterfaceBase>>(
      in_client, &params->client, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->client),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid client in AudioFocusManager.RequestGroupedAudioFocus request");
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::media_session::mojom::MediaSessionInterfaceBase>>(
      in_session, &params->session, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->session),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid session in AudioFocusManager.RequestGroupedAudioFocus request");
  mojo::internal::MessageFragment<
      typename decltype(params->session_info)::BaseType> session_info_fragment(
          params.message());
  mojo::internal::Serialize<::media_session::mojom::MediaSessionInfoDataView>(
      in_session_info, session_info_fragment);
  params->session_info.Set(
      session_info_fragment.is_null() ? nullptr : session_info_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->session_info.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null session_info in AudioFocusManager.RequestGroupedAudioFocus request");
  mojo::internal::Serialize<::media_session::mojom::AudioFocusType>(
      in_type, &params->type);
  mojo::internal::MessageFragment<
      typename decltype(params->group_id)::BaseType> group_id_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
      in_group_id, group_id_fragment);
  params->group_id.Set(
      group_id_fragment.is_null() ? nullptr : group_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->group_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null group_id in AudioFocusManager.RequestGroupedAudioFocus request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AudioFocusManager::Name_);
  message.set_method_name("RequestGroupedAudioFocus");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new AudioFocusManager_RequestGroupedAudioFocus_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void AudioFocusManagerProxy::GetFocusRequests(
    GetFocusRequestsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "media_session::mojom::AudioFocusManager::GetFocusRequests");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kAudioFocusManager_GetFocusRequests_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media_session::mojom::internal::AudioFocusManager_GetFocusRequests_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AudioFocusManager::Name_);
  message.set_method_name("GetFocusRequests");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new AudioFocusManager_GetFocusRequests_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void AudioFocusManagerProxy::AddObserver(
    ::mojo::PendingRemote<AudioFocusObserver> in_observer) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media_session::mojom::AudioFocusManager::AddObserver", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("observer"), in_observer, 
                        "<value of type ::mojo::PendingRemote<AudioFocusObserver>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kAudioFocusManager_AddObserver_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media_session::mojom::internal::AudioFocusManager_AddObserver_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::media_session::mojom::AudioFocusObserverInterfaceBase>>(
      in_observer, &params->observer, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->observer),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid observer in AudioFocusManager.AddObserver request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AudioFocusManager::Name_);
  message.set_method_name("AddObserver");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void AudioFocusManagerProxy::SetSource(
    const ::base::UnguessableToken& in_identity, const std::string& in_name) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media_session::mojom::AudioFocusManager::SetSource", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("identity"), in_identity, 
                        "<value of type const ::base::UnguessableToken&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("name"), in_name, 
                        "<value of type const std::string&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kAudioFocusManager_SetSource_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media_session::mojom::internal::AudioFocusManager_SetSource_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->identity)::BaseType> identity_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
      in_identity, identity_fragment);
  params->identity.Set(
      identity_fragment.is_null() ? nullptr : identity_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->identity.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null identity in AudioFocusManager.SetSource request");
  mojo::internal::MessageFragment<
      typename decltype(params->name)::BaseType> name_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_name, name_fragment);
  params->name.Set(
      name_fragment.is_null() ? nullptr : name_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->name.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null name in AudioFocusManager.SetSource request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AudioFocusManager::Name_);
  message.set_method_name("SetSource");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void AudioFocusManagerProxy::SetEnforcementMode(
    EnforcementMode in_mode) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media_session::mojom::AudioFocusManager::SetEnforcementMode", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("mode"), in_mode, 
                        "<value of type EnforcementMode>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kAudioFocusManager_SetEnforcementMode_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media_session::mojom::internal::AudioFocusManager_SetEnforcementMode_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::media_session::mojom::EnforcementMode>(
      in_mode, &params->mode);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AudioFocusManager::Name_);
  message.set_method_name("SetEnforcementMode");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void AudioFocusManagerProxy::AddSourceObserver(
    const ::base::UnguessableToken& in_source_id, ::mojo::PendingRemote<AudioFocusObserver> in_observer) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media_session::mojom::AudioFocusManager::AddSourceObserver", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("source_id"), in_source_id, 
                        "<value of type const ::base::UnguessableToken&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("observer"), in_observer, 
                        "<value of type ::mojo::PendingRemote<AudioFocusObserver>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kAudioFocusManager_AddSourceObserver_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media_session::mojom::internal::AudioFocusManager_AddSourceObserver_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->source_id)::BaseType> source_id_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
      in_source_id, source_id_fragment);
  params->source_id.Set(
      source_id_fragment.is_null() ? nullptr : source_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->source_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null source_id in AudioFocusManager.AddSourceObserver request");
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::media_session::mojom::AudioFocusObserverInterfaceBase>>(
      in_observer, &params->observer, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->observer),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid observer in AudioFocusManager.AddSourceObserver request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AudioFocusManager::Name_);
  message.set_method_name("AddSourceObserver");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void AudioFocusManagerProxy::GetSourceFocusRequests(
    const ::base::UnguessableToken& in_source_id, GetSourceFocusRequestsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media_session::mojom::AudioFocusManager::GetSourceFocusRequests", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("source_id"), in_source_id, 
                        "<value of type const ::base::UnguessableToken&>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kAudioFocusManager_GetSourceFocusRequests_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media_session::mojom::internal::AudioFocusManager_GetSourceFocusRequests_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->source_id)::BaseType> source_id_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
      in_source_id, source_id_fragment);
  params->source_id.Set(
      source_id_fragment.is_null() ? nullptr : source_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->source_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null source_id in AudioFocusManager.GetSourceFocusRequests request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AudioFocusManager::Name_);
  message.set_method_name("GetSourceFocusRequests");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new AudioFocusManager_GetSourceFocusRequests_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
class AudioFocusManager_RequestAudioFocus_ProxyToResponder {
 public:
  static AudioFocusManager::RequestAudioFocusCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<AudioFocusManager_RequestAudioFocus_ProxyToResponder> proxy(
        new AudioFocusManager_RequestAudioFocus_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&AudioFocusManager_RequestAudioFocus_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~AudioFocusManager_RequestAudioFocus_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  AudioFocusManager_RequestAudioFocus_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "AudioFocusManager::RequestAudioFocusCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      const ::base::UnguessableToken& in_request_id);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(AudioFocusManager_RequestAudioFocus_ProxyToResponder);
};

bool AudioFocusManager_RequestAudioFocus_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "media_session::mojom::AudioFocusManager::RequestAudioFocusCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::AudioFocusManager_RequestAudioFocus_ResponseParams_Data* params =
      reinterpret_cast<
          internal::AudioFocusManager_RequestAudioFocus_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ::base::UnguessableToken p_request_id{};
  AudioFocusManager_RequestAudioFocus_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadRequestId(&p_request_id))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        AudioFocusManager::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_request_id));
  return true;
}

void AudioFocusManager_RequestAudioFocus_ProxyToResponder::Run(
    const ::base::UnguessableToken& in_request_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)media_session::mojom::AudioFocusManager::RequestAudioFocusCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("request_id"), in_request_id, 
                        "<value of type const ::base::UnguessableToken&>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kAudioFocusManager_RequestAudioFocus_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media_session::mojom::internal::AudioFocusManager_RequestAudioFocus_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->request_id)::BaseType> request_id_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
      in_request_id, request_id_fragment);
  params->request_id.Set(
      request_id_fragment.is_null() ? nullptr : request_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->request_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null request_id in ");

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)media_session::mojom::AudioFocusManager::RequestAudioFocusCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AudioFocusManager::Name_);
  message.set_method_name("RequestAudioFocus");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class AudioFocusManager_RequestGroupedAudioFocus_ProxyToResponder {
 public:
  static AudioFocusManager::RequestGroupedAudioFocusCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<AudioFocusManager_RequestGroupedAudioFocus_ProxyToResponder> proxy(
        new AudioFocusManager_RequestGroupedAudioFocus_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&AudioFocusManager_RequestGroupedAudioFocus_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~AudioFocusManager_RequestGroupedAudioFocus_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  AudioFocusManager_RequestGroupedAudioFocus_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "AudioFocusManager::RequestGroupedAudioFocusCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(AudioFocusManager_RequestGroupedAudioFocus_ProxyToResponder);
};

bool AudioFocusManager_RequestGroupedAudioFocus_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "media_session::mojom::AudioFocusManager::RequestGroupedAudioFocusCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::AudioFocusManager_RequestGroupedAudioFocus_ResponseParams_Data* params =
      reinterpret_cast<
          internal::AudioFocusManager_RequestGroupedAudioFocus_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  bool p_success{};
  AudioFocusManager_RequestGroupedAudioFocus_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        AudioFocusManager::Name_, 4, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_success));
  return true;
}

void AudioFocusManager_RequestGroupedAudioFocus_ProxyToResponder::Run(
    bool in_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)media_session::mojom::AudioFocusManager::RequestGroupedAudioFocusCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success, 
                        "<value of type bool>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kAudioFocusManager_RequestGroupedAudioFocus_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media_session::mojom::internal::AudioFocusManager_RequestGroupedAudioFocus_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->success = in_success;

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)media_session::mojom::AudioFocusManager::RequestGroupedAudioFocusCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AudioFocusManager::Name_);
  message.set_method_name("RequestGroupedAudioFocus");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class AudioFocusManager_GetFocusRequests_ProxyToResponder {
 public:
  static AudioFocusManager::GetFocusRequestsCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<AudioFocusManager_GetFocusRequests_ProxyToResponder> proxy(
        new AudioFocusManager_GetFocusRequests_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&AudioFocusManager_GetFocusRequests_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~AudioFocusManager_GetFocusRequests_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  AudioFocusManager_GetFocusRequests_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "AudioFocusManager::GetFocusRequestsCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      std::vector<AudioFocusRequestStatePtr> in_requests);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(AudioFocusManager_GetFocusRequests_ProxyToResponder);
};

bool AudioFocusManager_GetFocusRequests_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "media_session::mojom::AudioFocusManager::GetFocusRequestsCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::AudioFocusManager_GetFocusRequests_ResponseParams_Data* params =
      reinterpret_cast<
          internal::AudioFocusManager_GetFocusRequests_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  std::vector<AudioFocusRequestStatePtr> p_requests{};
  AudioFocusManager_GetFocusRequests_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadRequests(&p_requests))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        AudioFocusManager::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_requests));
  return true;
}

void AudioFocusManager_GetFocusRequests_ProxyToResponder::Run(
    std::vector<AudioFocusRequestStatePtr> in_requests) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)media_session::mojom::AudioFocusManager::GetFocusRequestsCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("requests"), in_requests, 
                        "<value of type std::vector<AudioFocusRequestStatePtr>>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kAudioFocusManager_GetFocusRequests_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media_session::mojom::internal::AudioFocusManager_GetFocusRequests_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->requests)::BaseType>
      requests_fragment(params.message());
  const mojo::internal::ContainerValidateParams requests_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::media_session::mojom::AudioFocusRequestStateDataView>>(
      in_requests, requests_fragment, &requests_validate_params);
  params->requests.Set(
      requests_fragment.is_null() ? nullptr : requests_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->requests.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null requests in ");

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)media_session::mojom::AudioFocusManager::GetFocusRequestsCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AudioFocusManager::Name_);
  message.set_method_name("GetFocusRequests");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class AudioFocusManager_GetSourceFocusRequests_ProxyToResponder {
 public:
  static AudioFocusManager::GetSourceFocusRequestsCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<AudioFocusManager_GetSourceFocusRequests_ProxyToResponder> proxy(
        new AudioFocusManager_GetSourceFocusRequests_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&AudioFocusManager_GetSourceFocusRequests_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~AudioFocusManager_GetSourceFocusRequests_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  AudioFocusManager_GetSourceFocusRequests_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "AudioFocusManager::GetSourceFocusRequestsCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      std::vector<AudioFocusRequestStatePtr> in_requests);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(AudioFocusManager_GetSourceFocusRequests_ProxyToResponder);
};

bool AudioFocusManager_GetSourceFocusRequests_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "media_session::mojom::AudioFocusManager::GetSourceFocusRequestsCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::AudioFocusManager_GetSourceFocusRequests_ResponseParams_Data* params =
      reinterpret_cast<
          internal::AudioFocusManager_GetSourceFocusRequests_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  std::vector<AudioFocusRequestStatePtr> p_requests{};
  AudioFocusManager_GetSourceFocusRequests_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadRequests(&p_requests))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        AudioFocusManager::Name_, 8, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_requests));
  return true;
}

void AudioFocusManager_GetSourceFocusRequests_ProxyToResponder::Run(
    std::vector<AudioFocusRequestStatePtr> in_requests) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)media_session::mojom::AudioFocusManager::GetSourceFocusRequestsCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("requests"), in_requests, 
                        "<value of type std::vector<AudioFocusRequestStatePtr>>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kAudioFocusManager_GetSourceFocusRequests_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media_session::mojom::internal::AudioFocusManager_GetSourceFocusRequests_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->requests)::BaseType>
      requests_fragment(params.message());
  const mojo::internal::ContainerValidateParams requests_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::media_session::mojom::AudioFocusRequestStateDataView>>(
      in_requests, requests_fragment, &requests_validate_params);
  params->requests.Set(
      requests_fragment.is_null() ? nullptr : requests_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->requests.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null requests in ");

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)media_session::mojom::AudioFocusManager::GetSourceFocusRequestsCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AudioFocusManager::Name_);
  message.set_method_name("GetSourceFocusRequests");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool AudioFocusManagerStubDispatch::Accept(
    AudioFocusManager* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kAudioFocusManager_RequestAudioFocus_Name: {
      break;
    }
    case internal::kAudioFocusManager_RequestGroupedAudioFocus_Name: {
      break;
    }
    case internal::kAudioFocusManager_GetFocusRequests_Name: {
      break;
    }
    case internal::kAudioFocusManager_AddObserver_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media_session::mojom::AudioFocusManager::AddObserver",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media_session::mojom::AudioFocusManager::AddObserver");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::AudioFocusManager_AddObserver_Params_Data* params =
          reinterpret_cast<internal::AudioFocusManager_AddObserver_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingRemote<AudioFocusObserver> p_observer{};
      AudioFocusManager_AddObserver_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_observer =
            input_data_view.TakeObserver<decltype(p_observer)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AudioFocusManager::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AddObserver(
std::move(p_observer));
      return true;
    }
    case internal::kAudioFocusManager_SetSource_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media_session::mojom::AudioFocusManager::SetSource",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media_session::mojom::AudioFocusManager::SetSource");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::AudioFocusManager_SetSource_Params_Data* params =
          reinterpret_cast<internal::AudioFocusManager_SetSource_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::base::UnguessableToken p_identity{};
      std::string p_name{};
      AudioFocusManager_SetSource_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadIdentity(&p_identity))
        success = false;
      if (success && !input_data_view.ReadName(&p_name))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AudioFocusManager::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetSource(
std::move(p_identity), 
std::move(p_name));
      return true;
    }
    case internal::kAudioFocusManager_SetEnforcementMode_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media_session::mojom::AudioFocusManager::SetEnforcementMode",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media_session::mojom::AudioFocusManager::SetEnforcementMode");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::AudioFocusManager_SetEnforcementMode_Params_Data* params =
          reinterpret_cast<internal::AudioFocusManager_SetEnforcementMode_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      EnforcementMode p_mode{};
      AudioFocusManager_SetEnforcementMode_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadMode(&p_mode))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AudioFocusManager::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetEnforcementMode(
std::move(p_mode));
      return true;
    }
    case internal::kAudioFocusManager_AddSourceObserver_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media_session::mojom::AudioFocusManager::AddSourceObserver",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media_session::mojom::AudioFocusManager::AddSourceObserver");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::AudioFocusManager_AddSourceObserver_Params_Data* params =
          reinterpret_cast<internal::AudioFocusManager_AddSourceObserver_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::base::UnguessableToken p_source_id{};
      ::mojo::PendingRemote<AudioFocusObserver> p_observer{};
      AudioFocusManager_AddSourceObserver_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSourceId(&p_source_id))
        success = false;
      if (success) {
        p_observer =
            input_data_view.TakeObserver<decltype(p_observer)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AudioFocusManager::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AddSourceObserver(
std::move(p_source_id), 
std::move(p_observer));
      return true;
    }
    case internal::kAudioFocusManager_GetSourceFocusRequests_Name: {
      break;
    }
  }
  return false;
}

// static
bool AudioFocusManagerStubDispatch::AcceptWithResponder(
    AudioFocusManager* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kAudioFocusManager_RequestAudioFocus_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media_session::mojom::AudioFocusManager::RequestAudioFocus",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media_session::mojom::AudioFocusManager::RequestAudioFocus");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::AudioFocusManager_RequestAudioFocus_Params_Data* params =
          reinterpret_cast<
              internal::AudioFocusManager_RequestAudioFocus_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingReceiver<AudioFocusRequestClient> p_client{};
      ::mojo::PendingRemote<::media_session::mojom::MediaSession> p_session{};
      ::media_session::mojom::MediaSessionInfoPtr p_session_info{};
      AudioFocusType p_type{};
      AudioFocusManager_RequestAudioFocus_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_client =
            input_data_view.TakeClient<decltype(p_client)>();
      }
      if (success) {
        p_session =
            input_data_view.TakeSession<decltype(p_session)>();
      }
      if (success && !input_data_view.ReadSessionInfo(&p_session_info))
        success = false;
      if (success && !input_data_view.ReadType(&p_type))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AudioFocusManager::Name_, 0, false);
        return false;
      }
      AudioFocusManager::RequestAudioFocusCallback callback =
          AudioFocusManager_RequestAudioFocus_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RequestAudioFocus(
std::move(p_client), 
std::move(p_session), 
std::move(p_session_info), 
std::move(p_type), std::move(callback));
      return true;
    }
    case internal::kAudioFocusManager_RequestGroupedAudioFocus_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media_session::mojom::AudioFocusManager::RequestGroupedAudioFocus",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media_session::mojom::AudioFocusManager::RequestGroupedAudioFocus");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::AudioFocusManager_RequestGroupedAudioFocus_Params_Data* params =
          reinterpret_cast<
              internal::AudioFocusManager_RequestGroupedAudioFocus_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::base::UnguessableToken p_request_id{};
      ::mojo::PendingReceiver<AudioFocusRequestClient> p_client{};
      ::mojo::PendingRemote<::media_session::mojom::MediaSession> p_session{};
      ::media_session::mojom::MediaSessionInfoPtr p_session_info{};
      AudioFocusType p_type{};
      ::base::UnguessableToken p_group_id{};
      AudioFocusManager_RequestGroupedAudioFocus_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadRequestId(&p_request_id))
        success = false;
      if (success) {
        p_client =
            input_data_view.TakeClient<decltype(p_client)>();
      }
      if (success) {
        p_session =
            input_data_view.TakeSession<decltype(p_session)>();
      }
      if (success && !input_data_view.ReadSessionInfo(&p_session_info))
        success = false;
      if (success && !input_data_view.ReadType(&p_type))
        success = false;
      if (success && !input_data_view.ReadGroupId(&p_group_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AudioFocusManager::Name_, 4, false);
        return false;
      }
      AudioFocusManager::RequestGroupedAudioFocusCallback callback =
          AudioFocusManager_RequestGroupedAudioFocus_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RequestGroupedAudioFocus(
std::move(p_request_id), 
std::move(p_client), 
std::move(p_session), 
std::move(p_session_info), 
std::move(p_type), 
std::move(p_group_id), std::move(callback));
      return true;
    }
    case internal::kAudioFocusManager_GetFocusRequests_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media_session::mojom::AudioFocusManager::GetFocusRequests",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media_session::mojom::AudioFocusManager::GetFocusRequests");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::AudioFocusManager_GetFocusRequests_Params_Data* params =
          reinterpret_cast<
              internal::AudioFocusManager_GetFocusRequests_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      AudioFocusManager_GetFocusRequests_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AudioFocusManager::Name_, 1, false);
        return false;
      }
      AudioFocusManager::GetFocusRequestsCallback callback =
          AudioFocusManager_GetFocusRequests_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetFocusRequests(std::move(callback));
      return true;
    }
    case internal::kAudioFocusManager_AddObserver_Name: {
      break;
    }
    case internal::kAudioFocusManager_SetSource_Name: {
      break;
    }
    case internal::kAudioFocusManager_SetEnforcementMode_Name: {
      break;
    }
    case internal::kAudioFocusManager_AddSourceObserver_Name: {
      break;
    }
    case internal::kAudioFocusManager_GetSourceFocusRequests_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media_session::mojom::AudioFocusManager::GetSourceFocusRequests",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media_session::mojom::AudioFocusManager::GetSourceFocusRequests");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::AudioFocusManager_GetSourceFocusRequests_Params_Data* params =
          reinterpret_cast<
              internal::AudioFocusManager_GetSourceFocusRequests_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::base::UnguessableToken p_source_id{};
      AudioFocusManager_GetSourceFocusRequests_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSourceId(&p_source_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AudioFocusManager::Name_, 8, false);
        return false;
      }
      AudioFocusManager::GetSourceFocusRequestsCallback callback =
          AudioFocusManager_GetSourceFocusRequests_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetSourceFocusRequests(
std::move(p_source_id), std::move(callback));
      return true;
    }
  }
  return false;
}


static const mojo::internal::GenericValidationInfo kAudioFocusManagerValidationInfo[] = {
    {&internal::AudioFocusManager_RequestAudioFocus_Params_Data::Validate,
     &internal::AudioFocusManager_RequestAudioFocus_ResponseParams_Data::Validate},
    {&internal::AudioFocusManager_GetFocusRequests_Params_Data::Validate,
     &internal::AudioFocusManager_GetFocusRequests_ResponseParams_Data::Validate},
    {&internal::AudioFocusManager_AddObserver_Params_Data::Validate,
     nullptr /* no response */},
    {nullptr, nullptr},  // nonexistent
    {&internal::AudioFocusManager_RequestGroupedAudioFocus_Params_Data::Validate,
     &internal::AudioFocusManager_RequestGroupedAudioFocus_ResponseParams_Data::Validate},
    {&internal::AudioFocusManager_SetEnforcementMode_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::AudioFocusManager_SetSource_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::AudioFocusManager_AddSourceObserver_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::AudioFocusManager_GetSourceFocusRequests_Params_Data::Validate,
     &internal::AudioFocusManager_GetSourceFocusRequests_ResponseParams_Data::Validate},
};

bool AudioFocusManagerRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::media_session::mojom::AudioFocusManager::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kAudioFocusManagerValidationInfo);
}

bool AudioFocusManagerResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::media_session::mojom::AudioFocusManager::Name_;
  return mojo::internal::ValidateResponseGenericPacked(message, name, kAudioFocusManagerValidationInfo);
}
const char AudioFocusManagerDebug::Name_[] = "media_session.mojom.AudioFocusManagerDebug";
constexpr base::Token AudioFocusManagerDebug::Uuid_;

class AudioFocusManagerDebug_GetDebugInfoForRequest_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  AudioFocusManagerDebug_GetDebugInfoForRequest_ForwardToCallback(
      AudioFocusManagerDebug::GetDebugInfoForRequestCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  AudioFocusManagerDebug::GetDebugInfoForRequestCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(AudioFocusManagerDebug_GetDebugInfoForRequest_ForwardToCallback);
};

AudioFocusManagerDebugProxy::AudioFocusManagerDebugProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void AudioFocusManagerDebugProxy::GetDebugInfoForRequest(
    const ::base::UnguessableToken& in_request_id, GetDebugInfoForRequestCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media_session::mojom::AudioFocusManagerDebug::GetDebugInfoForRequest", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("request_id"), in_request_id, 
                        "<value of type const ::base::UnguessableToken&>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kAudioFocusManagerDebug_GetDebugInfoForRequest_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media_session::mojom::internal::AudioFocusManagerDebug_GetDebugInfoForRequest_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->request_id)::BaseType> request_id_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
      in_request_id, request_id_fragment);
  params->request_id.Set(
      request_id_fragment.is_null() ? nullptr : request_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->request_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null request_id in AudioFocusManagerDebug.GetDebugInfoForRequest request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AudioFocusManagerDebug::Name_);
  message.set_method_name("GetDebugInfoForRequest");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new AudioFocusManagerDebug_GetDebugInfoForRequest_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
class AudioFocusManagerDebug_GetDebugInfoForRequest_ProxyToResponder {
 public:
  static AudioFocusManagerDebug::GetDebugInfoForRequestCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<AudioFocusManagerDebug_GetDebugInfoForRequest_ProxyToResponder> proxy(
        new AudioFocusManagerDebug_GetDebugInfoForRequest_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&AudioFocusManagerDebug_GetDebugInfoForRequest_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~AudioFocusManagerDebug_GetDebugInfoForRequest_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  AudioFocusManagerDebug_GetDebugInfoForRequest_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "AudioFocusManagerDebug::GetDebugInfoForRequestCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::media_session::mojom::MediaSessionDebugInfoPtr in_debug_info);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(AudioFocusManagerDebug_GetDebugInfoForRequest_ProxyToResponder);
};

bool AudioFocusManagerDebug_GetDebugInfoForRequest_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "media_session::mojom::AudioFocusManagerDebug::GetDebugInfoForRequestCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::AudioFocusManagerDebug_GetDebugInfoForRequest_ResponseParams_Data* params =
      reinterpret_cast<
          internal::AudioFocusManagerDebug_GetDebugInfoForRequest_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ::media_session::mojom::MediaSessionDebugInfoPtr p_debug_info{};
  AudioFocusManagerDebug_GetDebugInfoForRequest_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadDebugInfo(&p_debug_info))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        AudioFocusManagerDebug::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_debug_info));
  return true;
}

void AudioFocusManagerDebug_GetDebugInfoForRequest_ProxyToResponder::Run(
    ::media_session::mojom::MediaSessionDebugInfoPtr in_debug_info) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)media_session::mojom::AudioFocusManagerDebug::GetDebugInfoForRequestCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("debug_info"), in_debug_info, 
                        "<value of type ::media_session::mojom::MediaSessionDebugInfoPtr>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kAudioFocusManagerDebug_GetDebugInfoForRequest_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media_session::mojom::internal::AudioFocusManagerDebug_GetDebugInfoForRequest_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->debug_info)::BaseType> debug_info_fragment(
          params.message());
  mojo::internal::Serialize<::media_session::mojom::MediaSessionDebugInfoDataView>(
      in_debug_info, debug_info_fragment);
  params->debug_info.Set(
      debug_info_fragment.is_null() ? nullptr : debug_info_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->debug_info.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null debug_info in ");

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)media_session::mojom::AudioFocusManagerDebug::GetDebugInfoForRequestCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AudioFocusManagerDebug::Name_);
  message.set_method_name("GetDebugInfoForRequest");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool AudioFocusManagerDebugStubDispatch::Accept(
    AudioFocusManagerDebug* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kAudioFocusManagerDebug_GetDebugInfoForRequest_Name: {
      break;
    }
  }
  return false;
}

// static
bool AudioFocusManagerDebugStubDispatch::AcceptWithResponder(
    AudioFocusManagerDebug* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kAudioFocusManagerDebug_GetDebugInfoForRequest_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media_session::mojom::AudioFocusManagerDebug::GetDebugInfoForRequest",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media_session::mojom::AudioFocusManagerDebug::GetDebugInfoForRequest");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::AudioFocusManagerDebug_GetDebugInfoForRequest_Params_Data* params =
          reinterpret_cast<
              internal::AudioFocusManagerDebug_GetDebugInfoForRequest_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::base::UnguessableToken p_request_id{};
      AudioFocusManagerDebug_GetDebugInfoForRequest_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadRequestId(&p_request_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AudioFocusManagerDebug::Name_, 0, false);
        return false;
      }
      AudioFocusManagerDebug::GetDebugInfoForRequestCallback callback =
          AudioFocusManagerDebug_GetDebugInfoForRequest_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetDebugInfoForRequest(
std::move(p_request_id), std::move(callback));
      return true;
    }
  }
  return false;
}


static const mojo::internal::GenericValidationInfo kAudioFocusManagerDebugValidationInfo[] = {
    {&internal::AudioFocusManagerDebug_GetDebugInfoForRequest_Params_Data::Validate,
     &internal::AudioFocusManagerDebug_GetDebugInfoForRequest_ResponseParams_Data::Validate},
};

bool AudioFocusManagerDebugRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::media_session::mojom::AudioFocusManagerDebug::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kAudioFocusManagerDebugValidationInfo);
}

bool AudioFocusManagerDebugResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::media_session::mojom::AudioFocusManagerDebug::Name_;
  return mojo::internal::ValidateResponseGenericPacked(message, name, kAudioFocusManagerDebugValidationInfo);
}
}  // namespace mojom
}  // namespace media_session

namespace mojo {


// static
bool StructTraits<::media_session::mojom::AudioFocusRequestState::DataView, ::media_session::mojom::AudioFocusRequestStatePtr>::Read(
    ::media_session::mojom::AudioFocusRequestState::DataView input,
    ::media_session::mojom::AudioFocusRequestStatePtr* output) {
  bool success = true;
  ::media_session::mojom::AudioFocusRequestStatePtr result(::media_session::mojom::AudioFocusRequestState::New());
  
      if (success && !input.ReadSessionInfo(&result->session_info))
        success = false;
      if (success && !input.ReadAudioFocusType(&result->audio_focus_type))
        success = false;
      if (success && !input.ReadSourceName(&result->source_name))
        success = false;
      if (success && !input.ReadRequestId(&result->request_id))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif