// services/media_session/public/mojom/media_session.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/media_session/public/mojom/media_session.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "services/media_session/public/mojom/media_session.mojom-params-data.h"
#include "services/media_session/public/mojom/media_session.mojom-shared-message-ids.h"

#include "services/media_session/public/mojom/media_session.mojom-blink-import-headers.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


#ifndef SERVICES_MEDIA_SESSION_PUBLIC_MOJOM_MEDIA_SESSION_MOJOM_BLINK_JUMBO_H_
#define SERVICES_MEDIA_SESSION_PUBLIC_MOJOM_MEDIA_SESSION_MOJOM_BLINK_JUMBO_H_
#endif
namespace media_session {
namespace mojom {
namespace blink {
MediaImage::MediaImage()
    : src(),
      type(),
      sizes() {}

MediaImage::MediaImage(
    const ::blink::KURL& src_in,
    const ::WTF::String& type_in,
    WTF::Vector<::gfx::Size> sizes_in)
    : src(std::move(src_in)),
      type(std::move(type_in)),
      sizes(std::move(sizes_in)) {}

MediaImage::~MediaImage() = default;

void MediaImage::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "src"), this->src, 
      "<value of type const ::blink::KURL&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "type"), this->type, 
      "<value of type const ::WTF::String&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "sizes"), this->sizes, 
      "<value of type const WTF::Vector<::gfx::Size>&>");
}

bool MediaImage::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
MediaMetadata::MediaMetadata()
    : title(),
      artist(),
      album(),
      source_title() {}

MediaMetadata::MediaMetadata(
    const ::WTF::String& title_in,
    const ::WTF::String& artist_in,
    const ::WTF::String& album_in,
    const ::WTF::String& source_title_in)
    : title(std::move(title_in)),
      artist(std::move(artist_in)),
      album(std::move(album_in)),
      source_title(std::move(source_title_in)) {}

MediaMetadata::~MediaMetadata() = default;

void MediaMetadata::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "title"), this->title, 
      "<value of type const ::WTF::String&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "artist"), this->artist, 
      "<value of type const ::WTF::String&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "album"), this->album, 
      "<value of type const ::WTF::String&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "source_title"), this->source_title, 
      "<value of type const ::WTF::String&>");
}

bool MediaMetadata::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
MediaImageBitmap::MediaImageBitmap()
    : width(),
      height(),
      pixel_data(),
      color_type() {}

MediaImageBitmap::MediaImageBitmap(
    int32_t width_in,
    int32_t height_in,
    WTF::Vector<uint8_t> pixel_data_in)
    : width(std::move(width_in)),
      height(std::move(height_in)),
      pixel_data(std::move(pixel_data_in)),
      color_type() {}

MediaImageBitmap::MediaImageBitmap(
    int32_t width_in,
    int32_t height_in,
    WTF::Vector<uint8_t> pixel_data_in,
    MediaImageBitmapColorType color_type_in)
    : width(std::move(width_in)),
      height(std::move(height_in)),
      pixel_data(std::move(pixel_data_in)),
      color_type(std::move(color_type_in)) {}

MediaImageBitmap::~MediaImageBitmap() = default;

void MediaImageBitmap::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "width"), this->width, 
      "<value of type int32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "height"), this->height, 
      "<value of type int32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "pixel_data"), this->pixel_data, 
      "<value of type const WTF::Vector<uint8_t>&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "color_type"), this->color_type, 
      "<value of type MediaImageBitmapColorType>");
}

bool MediaImageBitmap::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
MediaPosition::MediaPosition()
    : playback_rate(),
      duration(),
      position(),
      last_updated_time() {}

MediaPosition::MediaPosition(
    double playback_rate_in,
    ::base::TimeDelta duration_in,
    ::base::TimeDelta position_in,
    ::base::TimeTicks last_updated_time_in)
    : playback_rate(std::move(playback_rate_in)),
      duration(std::move(duration_in)),
      position(std::move(position_in)),
      last_updated_time(std::move(last_updated_time_in)) {}

MediaPosition::~MediaPosition() = default;

void MediaPosition::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "playback_rate"), this->playback_rate, 
      "<value of type double>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "duration"), this->duration, 
      "<value of type ::base::TimeDelta>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "position"), this->position, 
      "<value of type ::base::TimeDelta>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "last_updated_time"), this->last_updated_time, 
      "<value of type ::base::TimeTicks>");
}

bool MediaPosition::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
MediaSessionInfo::MediaSessionInfo()
    : state(),
      force_duck(),
      playback_state(),
      is_controllable(),
      prefer_stop_for_gain_focus_loss(),
      is_sensitive(),
      picture_in_picture_state(),
      deprecated_audio_video_state(),
      audio_sink_id(),
      audio_video_states() {}

MediaSessionInfo::MediaSessionInfo(
    MediaSessionInfo::SessionState state_in,
    bool force_duck_in)
    : state(std::move(state_in)),
      force_duck(std::move(force_duck_in)),
      playback_state(),
      is_controllable(),
      prefer_stop_for_gain_focus_loss(),
      is_sensitive(),
      picture_in_picture_state(),
      deprecated_audio_video_state(),
      audio_sink_id(),
      audio_video_states() {}

MediaSessionInfo::MediaSessionInfo(
    MediaSessionInfo::SessionState state_in,
    bool force_duck_in,
    MediaPlaybackState playback_state_in)
    : state(std::move(state_in)),
      force_duck(std::move(force_duck_in)),
      playback_state(std::move(playback_state_in)),
      is_controllable(),
      prefer_stop_for_gain_focus_loss(),
      is_sensitive(),
      picture_in_picture_state(),
      deprecated_audio_video_state(),
      audio_sink_id(),
      audio_video_states() {}

MediaSessionInfo::MediaSessionInfo(
    MediaSessionInfo::SessionState state_in,
    bool force_duck_in,
    MediaPlaybackState playback_state_in,
    bool is_controllable_in)
    : state(std::move(state_in)),
      force_duck(std::move(force_duck_in)),
      playback_state(std::move(playback_state_in)),
      is_controllable(std::move(is_controllable_in)),
      prefer_stop_for_gain_focus_loss(),
      is_sensitive(),
      picture_in_picture_state(),
      deprecated_audio_video_state(),
      audio_sink_id(),
      audio_video_states() {}

MediaSessionInfo::MediaSessionInfo(
    MediaSessionInfo::SessionState state_in,
    bool force_duck_in,
    MediaPlaybackState playback_state_in,
    bool is_controllable_in,
    bool prefer_stop_for_gain_focus_loss_in)
    : state(std::move(state_in)),
      force_duck(std::move(force_duck_in)),
      playback_state(std::move(playback_state_in)),
      is_controllable(std::move(is_controllable_in)),
      prefer_stop_for_gain_focus_loss(std::move(prefer_stop_for_gain_focus_loss_in)),
      is_sensitive(),
      picture_in_picture_state(),
      deprecated_audio_video_state(),
      audio_sink_id(),
      audio_video_states() {}

MediaSessionInfo::MediaSessionInfo(
    MediaSessionInfo::SessionState state_in,
    bool force_duck_in,
    MediaPlaybackState playback_state_in,
    bool is_controllable_in,
    bool prefer_stop_for_gain_focus_loss_in,
    bool is_sensitive_in)
    : state(std::move(state_in)),
      force_duck(std::move(force_duck_in)),
      playback_state(std::move(playback_state_in)),
      is_controllable(std::move(is_controllable_in)),
      prefer_stop_for_gain_focus_loss(std::move(prefer_stop_for_gain_focus_loss_in)),
      is_sensitive(std::move(is_sensitive_in)),
      picture_in_picture_state(),
      deprecated_audio_video_state(),
      audio_sink_id(),
      audio_video_states() {}

MediaSessionInfo::MediaSessionInfo(
    MediaSessionInfo::SessionState state_in,
    bool force_duck_in,
    MediaPlaybackState playback_state_in,
    bool is_controllable_in,
    bool prefer_stop_for_gain_focus_loss_in,
    bool is_sensitive_in,
    MediaPictureInPictureState picture_in_picture_state_in)
    : state(std::move(state_in)),
      force_duck(std::move(force_duck_in)),
      playback_state(std::move(playback_state_in)),
      is_controllable(std::move(is_controllable_in)),
      prefer_stop_for_gain_focus_loss(std::move(prefer_stop_for_gain_focus_loss_in)),
      is_sensitive(std::move(is_sensitive_in)),
      picture_in_picture_state(std::move(picture_in_picture_state_in)),
      deprecated_audio_video_state(),
      audio_sink_id(),
      audio_video_states() {}

MediaSessionInfo::MediaSessionInfo(
    MediaSessionInfo::SessionState state_in,
    bool force_duck_in,
    MediaPlaybackState playback_state_in,
    bool is_controllable_in,
    bool prefer_stop_for_gain_focus_loss_in,
    bool is_sensitive_in,
    MediaPictureInPictureState picture_in_picture_state_in,
    MediaAudioVideoState deprecated_audio_video_state_in)
    : state(std::move(state_in)),
      force_duck(std::move(force_duck_in)),
      playback_state(std::move(playback_state_in)),
      is_controllable(std::move(is_controllable_in)),
      prefer_stop_for_gain_focus_loss(std::move(prefer_stop_for_gain_focus_loss_in)),
      is_sensitive(std::move(is_sensitive_in)),
      picture_in_picture_state(std::move(picture_in_picture_state_in)),
      deprecated_audio_video_state(std::move(deprecated_audio_video_state_in)),
      audio_sink_id(),
      audio_video_states() {}

MediaSessionInfo::MediaSessionInfo(
    MediaSessionInfo::SessionState state_in,
    bool force_duck_in,
    MediaPlaybackState playback_state_in,
    bool is_controllable_in,
    bool prefer_stop_for_gain_focus_loss_in,
    bool is_sensitive_in,
    MediaPictureInPictureState picture_in_picture_state_in,
    MediaAudioVideoState deprecated_audio_video_state_in,
    const WTF::String& audio_sink_id_in)
    : state(std::move(state_in)),
      force_duck(std::move(force_duck_in)),
      playback_state(std::move(playback_state_in)),
      is_controllable(std::move(is_controllable_in)),
      prefer_stop_for_gain_focus_loss(std::move(prefer_stop_for_gain_focus_loss_in)),
      is_sensitive(std::move(is_sensitive_in)),
      picture_in_picture_state(std::move(picture_in_picture_state_in)),
      deprecated_audio_video_state(std::move(deprecated_audio_video_state_in)),
      audio_sink_id(std::move(audio_sink_id_in)),
      audio_video_states() {}

MediaSessionInfo::MediaSessionInfo(
    MediaSessionInfo::SessionState state_in,
    bool force_duck_in,
    MediaPlaybackState playback_state_in,
    bool is_controllable_in,
    bool prefer_stop_for_gain_focus_loss_in,
    bool is_sensitive_in,
    MediaPictureInPictureState picture_in_picture_state_in,
    MediaAudioVideoState deprecated_audio_video_state_in,
    const WTF::String& audio_sink_id_in,
    base::Optional<WTF::Vector<MediaAudioVideoState>> audio_video_states_in)
    : state(std::move(state_in)),
      force_duck(std::move(force_duck_in)),
      playback_state(std::move(playback_state_in)),
      is_controllable(std::move(is_controllable_in)),
      prefer_stop_for_gain_focus_loss(std::move(prefer_stop_for_gain_focus_loss_in)),
      is_sensitive(std::move(is_sensitive_in)),
      picture_in_picture_state(std::move(picture_in_picture_state_in)),
      deprecated_audio_video_state(std::move(deprecated_audio_video_state_in)),
      audio_sink_id(std::move(audio_sink_id_in)),
      audio_video_states(std::move(audio_video_states_in)) {}

MediaSessionInfo::~MediaSessionInfo() = default;

void MediaSessionInfo::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "state"), this->state, 
      "<value of type MediaSessionInfo::SessionState>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "force_duck"), this->force_duck, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "playback_state"), this->playback_state, 
      "<value of type MediaPlaybackState>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_controllable"), this->is_controllable, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "prefer_stop_for_gain_focus_loss"), this->prefer_stop_for_gain_focus_loss, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_sensitive"), this->is_sensitive, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "picture_in_picture_state"), this->picture_in_picture_state, 
      "<value of type MediaPictureInPictureState>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "deprecated_audio_video_state"), this->deprecated_audio_video_state, 
      "<value of type MediaAudioVideoState>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "audio_sink_id"), this->audio_sink_id, 
      "<value of type const WTF::String&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "audio_video_states"), this->audio_video_states, 
      "<value of type const base::Optional<WTF::Vector<MediaAudioVideoState>>&>");
}

bool MediaSessionInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
MediaSessionDebugInfo::MediaSessionDebugInfo()
    : name(),
      owner(),
      state() {}

MediaSessionDebugInfo::MediaSessionDebugInfo(
    const WTF::String& name_in,
    const WTF::String& owner_in,
    const WTF::String& state_in)
    : name(std::move(name_in)),
      owner(std::move(owner_in)),
      state(std::move(state_in)) {}

MediaSessionDebugInfo::~MediaSessionDebugInfo() = default;
size_t MediaSessionDebugInfo::Hash(size_t seed) const {
  seed = mojo::internal::WTFHash(seed, this->name);
  seed = mojo::internal::WTFHash(seed, this->owner);
  seed = mojo::internal::WTFHash(seed, this->state);
  return seed;
}

void MediaSessionDebugInfo::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "name"), this->name, 
      "<value of type const WTF::String&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "owner"), this->owner, 
      "<value of type const WTF::String&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "state"), this->state, 
      "<value of type const WTF::String&>");
}

bool MediaSessionDebugInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
const char MediaSessionObserver::Name_[] = "media_session.mojom.MediaSessionObserver";

MediaSessionObserverProxy::MediaSessionObserverProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void MediaSessionObserverProxy::MediaSessionInfoChanged(
    MediaSessionInfoPtr in_info) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media_session::mojom::MediaSessionObserver::MediaSessionInfoChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("info"), in_info, 
                        "<value of type MediaSessionInfoPtr>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kMediaSessionObserver_MediaSessionInfoChanged_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media_session::mojom::internal::MediaSessionObserver_MediaSessionInfoChanged_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->info)::BaseType> info_fragment(
          params.message());
  mojo::internal::Serialize<::media_session::mojom::MediaSessionInfoDataView>(
      in_info, info_fragment);
  params->info.Set(
      info_fragment.is_null() ? nullptr : info_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->info.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null info in MediaSessionObserver.MediaSessionInfoChanged request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaSessionObserver::Name_);
  message.set_method_name("MediaSessionInfoChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void MediaSessionObserverProxy::MediaSessionMetadataChanged(
    MediaMetadataPtr in_metadata) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media_session::mojom::MediaSessionObserver::MediaSessionMetadataChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("metadata"), in_metadata, 
                        "<value of type MediaMetadataPtr>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kMediaSessionObserver_MediaSessionMetadataChanged_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media_session::mojom::internal::MediaSessionObserver_MediaSessionMetadataChanged_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->metadata)::BaseType> metadata_fragment(
          params.message());
  mojo::internal::Serialize<::media_session::mojom::MediaMetadataDataView>(
      in_metadata, metadata_fragment);
  params->metadata.Set(
      metadata_fragment.is_null() ? nullptr : metadata_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaSessionObserver::Name_);
  message.set_method_name("MediaSessionMetadataChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void MediaSessionObserverProxy::MediaSessionActionsChanged(
    const WTF::Vector<MediaSessionAction>& in_action) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media_session::mojom::MediaSessionObserver::MediaSessionActionsChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("action"), in_action, 
                        "<value of type const WTF::Vector<MediaSessionAction>&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kMediaSessionObserver_MediaSessionActionsChanged_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media_session::mojom::internal::MediaSessionObserver_MediaSessionActionsChanged_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->action)::BaseType>
      action_fragment(params.message());
  const mojo::internal::ContainerValidateParams action_validate_params(
      0, ::media_session::mojom::internal::MediaSessionAction_Data::Validate);
  mojo::internal::Serialize<mojo::ArrayDataView<::media_session::mojom::MediaSessionAction>>(
      in_action, action_fragment, &action_validate_params);
  params->action.Set(
      action_fragment.is_null() ? nullptr : action_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->action.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null action in MediaSessionObserver.MediaSessionActionsChanged request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaSessionObserver::Name_);
  message.set_method_name("MediaSessionActionsChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void MediaSessionObserverProxy::MediaSessionImagesChanged(
    WTF::HashMap<MediaSessionImageType, WTF::Vector<MediaImagePtr>> in_images) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media_session::mojom::MediaSessionObserver::MediaSessionImagesChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("images"), in_images, 
                        "<value of type WTF::HashMap<MediaSessionImageType, WTF::Vector<MediaImagePtr>>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kMediaSessionObserver_MediaSessionImagesChanged_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media_session::mojom::internal::MediaSessionObserver_MediaSessionImagesChanged_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->images)::BaseType>
      images_fragment(params.message());
  const mojo::internal::ContainerValidateParams images_validate_params(
      new mojo::internal::ContainerValidateParams(0, ::media_session::mojom::internal::MediaSessionImageType_Data::Validate), new mojo::internal::ContainerValidateParams(0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr)));
  mojo::internal::Serialize<mojo::MapDataView<::media_session::mojom::MediaSessionImageType, mojo::ArrayDataView<::media_session::mojom::MediaImageDataView>>>(
      in_images, images_fragment, &images_validate_params);
  params->images.Set(
      images_fragment.is_null() ? nullptr : images_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->images.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null images in MediaSessionObserver.MediaSessionImagesChanged request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaSessionObserver::Name_);
  message.set_method_name("MediaSessionImagesChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void MediaSessionObserverProxy::MediaSessionPositionChanged(
    MediaPositionPtr in_position) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media_session::mojom::MediaSessionObserver::MediaSessionPositionChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("position"), in_position, 
                        "<value of type MediaPositionPtr>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kMediaSessionObserver_MediaSessionPositionChanged_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media_session::mojom::internal::MediaSessionObserver_MediaSessionPositionChanged_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->position)::BaseType> position_fragment(
          params.message());
  mojo::internal::Serialize<::media_session::mojom::MediaPositionDataView>(
      in_position, position_fragment);
  params->position.Set(
      position_fragment.is_null() ? nullptr : position_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaSessionObserver::Name_);
  message.set_method_name("MediaSessionPositionChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool MediaSessionObserverStubDispatch::Accept(
    MediaSessionObserver* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kMediaSessionObserver_MediaSessionInfoChanged_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media_session::mojom::MediaSessionObserver::MediaSessionInfoChanged",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media_session::mojom::MediaSessionObserver::MediaSessionInfoChanged");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::MediaSessionObserver_MediaSessionInfoChanged_Params_Data* params =
          reinterpret_cast<internal::MediaSessionObserver_MediaSessionInfoChanged_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      MediaSessionInfoPtr p_info{};
      MediaSessionObserver_MediaSessionInfoChanged_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadInfo(&p_info))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaSessionObserver::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->MediaSessionInfoChanged(
std::move(p_info));
      return true;
    }
    case internal::kMediaSessionObserver_MediaSessionMetadataChanged_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media_session::mojom::MediaSessionObserver::MediaSessionMetadataChanged",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media_session::mojom::MediaSessionObserver::MediaSessionMetadataChanged");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::MediaSessionObserver_MediaSessionMetadataChanged_Params_Data* params =
          reinterpret_cast<internal::MediaSessionObserver_MediaSessionMetadataChanged_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      MediaMetadataPtr p_metadata{};
      MediaSessionObserver_MediaSessionMetadataChanged_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadMetadata(&p_metadata))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaSessionObserver::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->MediaSessionMetadataChanged(
std::move(p_metadata));
      return true;
    }
    case internal::kMediaSessionObserver_MediaSessionActionsChanged_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media_session::mojom::MediaSessionObserver::MediaSessionActionsChanged",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media_session::mojom::MediaSessionObserver::MediaSessionActionsChanged");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::MediaSessionObserver_MediaSessionActionsChanged_Params_Data* params =
          reinterpret_cast<internal::MediaSessionObserver_MediaSessionActionsChanged_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      WTF::Vector<MediaSessionAction> p_action{};
      MediaSessionObserver_MediaSessionActionsChanged_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadAction(&p_action))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaSessionObserver::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->MediaSessionActionsChanged(
std::move(p_action));
      return true;
    }
    case internal::kMediaSessionObserver_MediaSessionImagesChanged_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media_session::mojom::MediaSessionObserver::MediaSessionImagesChanged",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media_session::mojom::MediaSessionObserver::MediaSessionImagesChanged");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::MediaSessionObserver_MediaSessionImagesChanged_Params_Data* params =
          reinterpret_cast<internal::MediaSessionObserver_MediaSessionImagesChanged_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      WTF::HashMap<MediaSessionImageType, WTF::Vector<MediaImagePtr>> p_images{};
      MediaSessionObserver_MediaSessionImagesChanged_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadImages(&p_images))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaSessionObserver::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->MediaSessionImagesChanged(
std::move(p_images));
      return true;
    }
    case internal::kMediaSessionObserver_MediaSessionPositionChanged_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media_session::mojom::MediaSessionObserver::MediaSessionPositionChanged",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media_session::mojom::MediaSessionObserver::MediaSessionPositionChanged");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::MediaSessionObserver_MediaSessionPositionChanged_Params_Data* params =
          reinterpret_cast<internal::MediaSessionObserver_MediaSessionPositionChanged_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      MediaPositionPtr p_position{};
      MediaSessionObserver_MediaSessionPositionChanged_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPosition(&p_position))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaSessionObserver::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->MediaSessionPositionChanged(
std::move(p_position));
      return true;
    }
  }
  return false;
}

// static
bool MediaSessionObserverStubDispatch::AcceptWithResponder(
    MediaSessionObserver* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kMediaSessionObserver_MediaSessionInfoChanged_Name: {
      break;
    }
    case internal::kMediaSessionObserver_MediaSessionMetadataChanged_Name: {
      break;
    }
    case internal::kMediaSessionObserver_MediaSessionActionsChanged_Name: {
      break;
    }
    case internal::kMediaSessionObserver_MediaSessionImagesChanged_Name: {
      break;
    }
    case internal::kMediaSessionObserver_MediaSessionPositionChanged_Name: {
      break;
    }
  }
  return false;
}


static const mojo::internal::GenericValidationInfo kMediaSessionObserverValidationInfo[] = {
    {&internal::MediaSessionObserver_MediaSessionInfoChanged_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::MediaSessionObserver_MediaSessionMetadataChanged_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::MediaSessionObserver_MediaSessionActionsChanged_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::MediaSessionObserver_MediaSessionImagesChanged_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::MediaSessionObserver_MediaSessionPositionChanged_Params_Data::Validate,
     nullptr /* no response */},
};

bool MediaSessionObserverRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::media_session::mojom::blink::MediaSessionObserver::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kMediaSessionObserverValidationInfo);
}

const char MediaSession::Name_[] = "media_session.mojom.MediaSession";

class MediaSession_GetMediaSessionInfo_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  MediaSession_GetMediaSessionInfo_ForwardToCallback(
      MediaSession::GetMediaSessionInfoCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  MediaSession::GetMediaSessionInfoCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(MediaSession_GetMediaSessionInfo_ForwardToCallback);
};

class MediaSession_GetDebugInfo_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  MediaSession_GetDebugInfo_ForwardToCallback(
      MediaSession::GetDebugInfoCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  MediaSession::GetDebugInfoCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(MediaSession_GetDebugInfo_ForwardToCallback);
};

class MediaSession_GetMediaImageBitmap_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  MediaSession_GetMediaImageBitmap_ForwardToCallback(
      MediaSession::GetMediaImageBitmapCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  MediaSession::GetMediaImageBitmapCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(MediaSession_GetMediaImageBitmap_ForwardToCallback);
};

MediaSessionProxy::MediaSessionProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void MediaSessionProxy::GetMediaSessionInfo(
    GetMediaSessionInfoCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "media_session::mojom::MediaSession::GetMediaSessionInfo");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kMediaSession_GetMediaSessionInfo_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media_session::mojom::internal::MediaSession_GetMediaSessionInfo_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaSession::Name_);
  message.set_method_name("GetMediaSessionInfo");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new MediaSession_GetMediaSessionInfo_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void MediaSessionProxy::GetDebugInfo(
    GetDebugInfoCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "media_session::mojom::MediaSession::GetDebugInfo");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kMediaSession_GetDebugInfo_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media_session::mojom::internal::MediaSession_GetDebugInfo_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaSession::Name_);
  message.set_method_name("GetDebugInfo");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new MediaSession_GetDebugInfo_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void MediaSessionProxy::StartDucking(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "media_session::mojom::MediaSession::StartDucking");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kMediaSession_StartDucking_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media_session::mojom::internal::MediaSession_StartDucking_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaSession::Name_);
  message.set_method_name("StartDucking");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void MediaSessionProxy::StopDucking(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "media_session::mojom::MediaSession::StopDucking");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kMediaSession_StopDucking_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media_session::mojom::internal::MediaSession_StopDucking_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaSession::Name_);
  message.set_method_name("StopDucking");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void MediaSessionProxy::Suspend(
    MediaSession::SuspendType in_suspend_type) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media_session::mojom::MediaSession::Suspend", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("suspend_type"), in_suspend_type, 
                        "<value of type MediaSession::SuspendType>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kMediaSession_Suspend_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media_session::mojom::internal::MediaSession_Suspend_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::media_session::mojom::MediaSession_SuspendType>(
      in_suspend_type, &params->suspend_type);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaSession::Name_);
  message.set_method_name("Suspend");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void MediaSessionProxy::Resume(
    MediaSession::SuspendType in_suspend_type) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media_session::mojom::MediaSession::Resume", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("suspend_type"), in_suspend_type, 
                        "<value of type MediaSession::SuspendType>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kMediaSession_Resume_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media_session::mojom::internal::MediaSession_Resume_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::media_session::mojom::MediaSession_SuspendType>(
      in_suspend_type, &params->suspend_type);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaSession::Name_);
  message.set_method_name("Resume");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void MediaSessionProxy::AddObserver(
    ::mojo::PendingRemote<MediaSessionObserver> in_observer) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media_session::mojom::MediaSession::AddObserver", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("observer"), in_observer, 
                        "<value of type ::mojo::PendingRemote<MediaSessionObserver>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kMediaSession_AddObserver_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media_session::mojom::internal::MediaSession_AddObserver_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::media_session::mojom::MediaSessionObserverInterfaceBase>>(
      in_observer, &params->observer, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->observer),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid observer in MediaSession.AddObserver request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaSession::Name_);
  message.set_method_name("AddObserver");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void MediaSessionProxy::PreviousTrack(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "media_session::mojom::MediaSession::PreviousTrack");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kMediaSession_PreviousTrack_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media_session::mojom::internal::MediaSession_PreviousTrack_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaSession::Name_);
  message.set_method_name("PreviousTrack");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void MediaSessionProxy::NextTrack(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "media_session::mojom::MediaSession::NextTrack");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kMediaSession_NextTrack_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media_session::mojom::internal::MediaSession_NextTrack_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaSession::Name_);
  message.set_method_name("NextTrack");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void MediaSessionProxy::Seek(
    ::base::TimeDelta in_seek_time) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media_session::mojom::MediaSession::Seek", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("seek_time"), in_seek_time, 
                        "<value of type ::base::TimeDelta>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kMediaSession_Seek_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media_session::mojom::internal::MediaSession_Seek_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->seek_time)::BaseType> seek_time_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
      in_seek_time, seek_time_fragment);
  params->seek_time.Set(
      seek_time_fragment.is_null() ? nullptr : seek_time_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->seek_time.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null seek_time in MediaSession.Seek request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaSession::Name_);
  message.set_method_name("Seek");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void MediaSessionProxy::Stop(
    MediaSession::SuspendType in_suspend_type) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media_session::mojom::MediaSession::Stop", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("suspend_type"), in_suspend_type, 
                        "<value of type MediaSession::SuspendType>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kMediaSession_Stop_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media_session::mojom::internal::MediaSession_Stop_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::media_session::mojom::MediaSession_SuspendType>(
      in_suspend_type, &params->suspend_type);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaSession::Name_);
  message.set_method_name("Stop");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void MediaSessionProxy::SkipAd(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "media_session::mojom::MediaSession::SkipAd");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kMediaSession_SkipAd_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media_session::mojom::internal::MediaSession_SkipAd_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaSession::Name_);
  message.set_method_name("SkipAd");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void MediaSessionProxy::GetMediaImageBitmap(
    MediaImagePtr in_image, int32_t in_minimum_size_px, int32_t in_desired_size_px, GetMediaImageBitmapCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media_session::mojom::MediaSession::GetMediaImageBitmap", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("image"), in_image, 
                        "<value of type MediaImagePtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("minimum_size_px"), in_minimum_size_px, 
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("desired_size_px"), in_desired_size_px, 
                        "<value of type int32_t>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kMediaSession_GetMediaImageBitmap_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media_session::mojom::internal::MediaSession_GetMediaImageBitmap_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->image)::BaseType> image_fragment(
          params.message());
  mojo::internal::Serialize<::media_session::mojom::MediaImageDataView>(
      in_image, image_fragment);
  params->image.Set(
      image_fragment.is_null() ? nullptr : image_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->image.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null image in MediaSession.GetMediaImageBitmap request");
  params->minimum_size_px = in_minimum_size_px;
  params->desired_size_px = in_desired_size_px;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaSession::Name_);
  message.set_method_name("GetMediaImageBitmap");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new MediaSession_GetMediaImageBitmap_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void MediaSessionProxy::SeekTo(
    ::base::TimeDelta in_seek_time) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media_session::mojom::MediaSession::SeekTo", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("seek_time"), in_seek_time, 
                        "<value of type ::base::TimeDelta>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kMediaSession_SeekTo_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media_session::mojom::internal::MediaSession_SeekTo_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->seek_time)::BaseType> seek_time_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
      in_seek_time, seek_time_fragment);
  params->seek_time.Set(
      seek_time_fragment.is_null() ? nullptr : seek_time_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->seek_time.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null seek_time in MediaSession.SeekTo request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaSession::Name_);
  message.set_method_name("SeekTo");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void MediaSessionProxy::ScrubTo(
    ::base::TimeDelta in_seek_time) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media_session::mojom::MediaSession::ScrubTo", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("seek_time"), in_seek_time, 
                        "<value of type ::base::TimeDelta>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kMediaSession_ScrubTo_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media_session::mojom::internal::MediaSession_ScrubTo_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->seek_time)::BaseType> seek_time_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
      in_seek_time, seek_time_fragment);
  params->seek_time.Set(
      seek_time_fragment.is_null() ? nullptr : seek_time_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->seek_time.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null seek_time in MediaSession.ScrubTo request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaSession::Name_);
  message.set_method_name("ScrubTo");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void MediaSessionProxy::EnterPictureInPicture(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "media_session::mojom::MediaSession::EnterPictureInPicture");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kMediaSession_EnterPictureInPicture_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media_session::mojom::internal::MediaSession_EnterPictureInPicture_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaSession::Name_);
  message.set_method_name("EnterPictureInPicture");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void MediaSessionProxy::ExitPictureInPicture(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "media_session::mojom::MediaSession::ExitPictureInPicture");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kMediaSession_ExitPictureInPicture_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media_session::mojom::internal::MediaSession_ExitPictureInPicture_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaSession::Name_);
  message.set_method_name("ExitPictureInPicture");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void MediaSessionProxy::SetAudioSinkId(
    const WTF::String& in_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media_session::mojom::MediaSession::SetAudioSinkId", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("id"), in_id, 
                        "<value of type const WTF::String&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kMediaSession_SetAudioSinkId_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media_session::mojom::internal::MediaSession_SetAudioSinkId_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->id)::BaseType> id_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_id, id_fragment);
  params->id.Set(
      id_fragment.is_null() ? nullptr : id_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaSession::Name_);
  message.set_method_name("SetAudioSinkId");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}
class MediaSession_GetMediaSessionInfo_ProxyToResponder {
 public:
  static MediaSession::GetMediaSessionInfoCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<MediaSession_GetMediaSessionInfo_ProxyToResponder> proxy(
        new MediaSession_GetMediaSessionInfo_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&MediaSession_GetMediaSessionInfo_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~MediaSession_GetMediaSessionInfo_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  MediaSession_GetMediaSessionInfo_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "MediaSession::GetMediaSessionInfoCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      MediaSessionInfoPtr in_info);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(MediaSession_GetMediaSessionInfo_ProxyToResponder);
};

bool MediaSession_GetMediaSessionInfo_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "media_session::mojom::MediaSession::GetMediaSessionInfoCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::MediaSession_GetMediaSessionInfo_ResponseParams_Data* params =
      reinterpret_cast<
          internal::MediaSession_GetMediaSessionInfo_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  MediaSessionInfoPtr p_info{};
  MediaSession_GetMediaSessionInfo_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadInfo(&p_info))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        MediaSession::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_info));
  return true;
}

void MediaSession_GetMediaSessionInfo_ProxyToResponder::Run(
    MediaSessionInfoPtr in_info) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)media_session::mojom::MediaSession::GetMediaSessionInfoCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("info"), in_info, 
                        "<value of type MediaSessionInfoPtr>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kMediaSession_GetMediaSessionInfo_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media_session::mojom::internal::MediaSession_GetMediaSessionInfo_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->info)::BaseType> info_fragment(
          params.message());
  mojo::internal::Serialize<::media_session::mojom::MediaSessionInfoDataView>(
      in_info, info_fragment);
  params->info.Set(
      info_fragment.is_null() ? nullptr : info_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->info.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null info in ");

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)media_session::mojom::MediaSession::GetMediaSessionInfoCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaSession::Name_);
  message.set_method_name("GetMediaSessionInfo");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class MediaSession_GetDebugInfo_ProxyToResponder {
 public:
  static MediaSession::GetDebugInfoCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<MediaSession_GetDebugInfo_ProxyToResponder> proxy(
        new MediaSession_GetDebugInfo_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&MediaSession_GetDebugInfo_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~MediaSession_GetDebugInfo_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  MediaSession_GetDebugInfo_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "MediaSession::GetDebugInfoCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      MediaSessionDebugInfoPtr in_info);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(MediaSession_GetDebugInfo_ProxyToResponder);
};

bool MediaSession_GetDebugInfo_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "media_session::mojom::MediaSession::GetDebugInfoCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::MediaSession_GetDebugInfo_ResponseParams_Data* params =
      reinterpret_cast<
          internal::MediaSession_GetDebugInfo_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  MediaSessionDebugInfoPtr p_info{};
  MediaSession_GetDebugInfo_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadInfo(&p_info))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        MediaSession::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_info));
  return true;
}

void MediaSession_GetDebugInfo_ProxyToResponder::Run(
    MediaSessionDebugInfoPtr in_info) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)media_session::mojom::MediaSession::GetDebugInfoCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("info"), in_info, 
                        "<value of type MediaSessionDebugInfoPtr>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kMediaSession_GetDebugInfo_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media_session::mojom::internal::MediaSession_GetDebugInfo_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->info)::BaseType> info_fragment(
          params.message());
  mojo::internal::Serialize<::media_session::mojom::MediaSessionDebugInfoDataView>(
      in_info, info_fragment);
  params->info.Set(
      info_fragment.is_null() ? nullptr : info_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->info.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null info in ");

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)media_session::mojom::MediaSession::GetDebugInfoCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaSession::Name_);
  message.set_method_name("GetDebugInfo");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class MediaSession_GetMediaImageBitmap_ProxyToResponder {
 public:
  static MediaSession::GetMediaImageBitmapCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<MediaSession_GetMediaImageBitmap_ProxyToResponder> proxy(
        new MediaSession_GetMediaImageBitmap_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&MediaSession_GetMediaImageBitmap_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~MediaSession_GetMediaImageBitmap_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  MediaSession_GetMediaImageBitmap_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "MediaSession::GetMediaImageBitmapCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      MediaImageBitmapPtr in_image);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(MediaSession_GetMediaImageBitmap_ProxyToResponder);
};

bool MediaSession_GetMediaImageBitmap_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "media_session::mojom::MediaSession::GetMediaImageBitmapCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::MediaSession_GetMediaImageBitmap_ResponseParams_Data* params =
      reinterpret_cast<
          internal::MediaSession_GetMediaImageBitmap_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  MediaImageBitmapPtr p_image{};
  MediaSession_GetMediaImageBitmap_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadImage(&p_image))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        MediaSession::Name_, 12, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_image));
  return true;
}

void MediaSession_GetMediaImageBitmap_ProxyToResponder::Run(
    MediaImageBitmapPtr in_image) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)media_session::mojom::MediaSession::GetMediaImageBitmapCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("image"), in_image, 
                        "<value of type MediaImageBitmapPtr>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kMediaSession_GetMediaImageBitmap_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media_session::mojom::internal::MediaSession_GetMediaImageBitmap_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->image)::BaseType> image_fragment(
          params.message());
  mojo::internal::Serialize<::media_session::mojom::MediaImageBitmapDataView>(
      in_image, image_fragment);
  params->image.Set(
      image_fragment.is_null() ? nullptr : image_fragment.data());

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)media_session::mojom::MediaSession::GetMediaImageBitmapCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaSession::Name_);
  message.set_method_name("GetMediaImageBitmap");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool MediaSessionStubDispatch::Accept(
    MediaSession* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kMediaSession_GetMediaSessionInfo_Name: {
      break;
    }
    case internal::kMediaSession_GetDebugInfo_Name: {
      break;
    }
    case internal::kMediaSession_StartDucking_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media_session::mojom::MediaSession::StartDucking",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media_session::mojom::MediaSession::StartDucking");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::MediaSession_StartDucking_Params_Data* params =
          reinterpret_cast<internal::MediaSession_StartDucking_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      MediaSession_StartDucking_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaSession::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->StartDucking();
      return true;
    }
    case internal::kMediaSession_StopDucking_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media_session::mojom::MediaSession::StopDucking",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media_session::mojom::MediaSession::StopDucking");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::MediaSession_StopDucking_Params_Data* params =
          reinterpret_cast<internal::MediaSession_StopDucking_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      MediaSession_StopDucking_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaSession::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->StopDucking();
      return true;
    }
    case internal::kMediaSession_Suspend_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media_session::mojom::MediaSession::Suspend",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media_session::mojom::MediaSession::Suspend");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::MediaSession_Suspend_Params_Data* params =
          reinterpret_cast<internal::MediaSession_Suspend_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      MediaSession::SuspendType p_suspend_type{};
      MediaSession_Suspend_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSuspendType(&p_suspend_type))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaSession::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Suspend(
std::move(p_suspend_type));
      return true;
    }
    case internal::kMediaSession_Resume_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media_session::mojom::MediaSession::Resume",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media_session::mojom::MediaSession::Resume");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::MediaSession_Resume_Params_Data* params =
          reinterpret_cast<internal::MediaSession_Resume_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      MediaSession::SuspendType p_suspend_type{};
      MediaSession_Resume_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSuspendType(&p_suspend_type))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaSession::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Resume(
std::move(p_suspend_type));
      return true;
    }
    case internal::kMediaSession_AddObserver_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media_session::mojom::MediaSession::AddObserver",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media_session::mojom::MediaSession::AddObserver");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::MediaSession_AddObserver_Params_Data* params =
          reinterpret_cast<internal::MediaSession_AddObserver_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingRemote<MediaSessionObserver> p_observer{};
      MediaSession_AddObserver_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_observer =
            input_data_view.TakeObserver<decltype(p_observer)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaSession::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AddObserver(
std::move(p_observer));
      return true;
    }
    case internal::kMediaSession_PreviousTrack_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media_session::mojom::MediaSession::PreviousTrack",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media_session::mojom::MediaSession::PreviousTrack");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::MediaSession_PreviousTrack_Params_Data* params =
          reinterpret_cast<internal::MediaSession_PreviousTrack_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      MediaSession_PreviousTrack_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaSession::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->PreviousTrack();
      return true;
    }
    case internal::kMediaSession_NextTrack_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media_session::mojom::MediaSession::NextTrack",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media_session::mojom::MediaSession::NextTrack");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::MediaSession_NextTrack_Params_Data* params =
          reinterpret_cast<internal::MediaSession_NextTrack_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      MediaSession_NextTrack_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaSession::Name_, 8, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->NextTrack();
      return true;
    }
    case internal::kMediaSession_Seek_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media_session::mojom::MediaSession::Seek",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media_session::mojom::MediaSession::Seek");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::MediaSession_Seek_Params_Data* params =
          reinterpret_cast<internal::MediaSession_Seek_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::base::TimeDelta p_seek_time{};
      MediaSession_Seek_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSeekTime(&p_seek_time))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaSession::Name_, 9, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Seek(
std::move(p_seek_time));
      return true;
    }
    case internal::kMediaSession_Stop_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media_session::mojom::MediaSession::Stop",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media_session::mojom::MediaSession::Stop");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::MediaSession_Stop_Params_Data* params =
          reinterpret_cast<internal::MediaSession_Stop_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      MediaSession::SuspendType p_suspend_type{};
      MediaSession_Stop_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSuspendType(&p_suspend_type))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaSession::Name_, 10, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Stop(
std::move(p_suspend_type));
      return true;
    }
    case internal::kMediaSession_SkipAd_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media_session::mojom::MediaSession::SkipAd",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media_session::mojom::MediaSession::SkipAd");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::MediaSession_SkipAd_Params_Data* params =
          reinterpret_cast<internal::MediaSession_SkipAd_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      MediaSession_SkipAd_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaSession::Name_, 11, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SkipAd();
      return true;
    }
    case internal::kMediaSession_GetMediaImageBitmap_Name: {
      break;
    }
    case internal::kMediaSession_SeekTo_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media_session::mojom::MediaSession::SeekTo",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media_session::mojom::MediaSession::SeekTo");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::MediaSession_SeekTo_Params_Data* params =
          reinterpret_cast<internal::MediaSession_SeekTo_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::base::TimeDelta p_seek_time{};
      MediaSession_SeekTo_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSeekTime(&p_seek_time))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaSession::Name_, 13, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SeekTo(
std::move(p_seek_time));
      return true;
    }
    case internal::kMediaSession_ScrubTo_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media_session::mojom::MediaSession::ScrubTo",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media_session::mojom::MediaSession::ScrubTo");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::MediaSession_ScrubTo_Params_Data* params =
          reinterpret_cast<internal::MediaSession_ScrubTo_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::base::TimeDelta p_seek_time{};
      MediaSession_ScrubTo_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSeekTime(&p_seek_time))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaSession::Name_, 14, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ScrubTo(
std::move(p_seek_time));
      return true;
    }
    case internal::kMediaSession_EnterPictureInPicture_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media_session::mojom::MediaSession::EnterPictureInPicture",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media_session::mojom::MediaSession::EnterPictureInPicture");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::MediaSession_EnterPictureInPicture_Params_Data* params =
          reinterpret_cast<internal::MediaSession_EnterPictureInPicture_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      MediaSession_EnterPictureInPicture_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaSession::Name_, 15, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->EnterPictureInPicture();
      return true;
    }
    case internal::kMediaSession_ExitPictureInPicture_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media_session::mojom::MediaSession::ExitPictureInPicture",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media_session::mojom::MediaSession::ExitPictureInPicture");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::MediaSession_ExitPictureInPicture_Params_Data* params =
          reinterpret_cast<internal::MediaSession_ExitPictureInPicture_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      MediaSession_ExitPictureInPicture_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaSession::Name_, 16, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ExitPictureInPicture();
      return true;
    }
    case internal::kMediaSession_SetAudioSinkId_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media_session::mojom::MediaSession::SetAudioSinkId",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media_session::mojom::MediaSession::SetAudioSinkId");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::MediaSession_SetAudioSinkId_Params_Data* params =
          reinterpret_cast<internal::MediaSession_SetAudioSinkId_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      WTF::String p_id{};
      MediaSession_SetAudioSinkId_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadId(&p_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaSession::Name_, 17, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetAudioSinkId(
std::move(p_id));
      return true;
    }
  }
  return false;
}

// static
bool MediaSessionStubDispatch::AcceptWithResponder(
    MediaSession* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kMediaSession_GetMediaSessionInfo_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media_session::mojom::MediaSession::GetMediaSessionInfo",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media_session::mojom::MediaSession::GetMediaSessionInfo");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::MediaSession_GetMediaSessionInfo_Params_Data* params =
          reinterpret_cast<
              internal::MediaSession_GetMediaSessionInfo_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      MediaSession_GetMediaSessionInfo_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaSession::Name_, 0, false);
        return false;
      }
      MediaSession::GetMediaSessionInfoCallback callback =
          MediaSession_GetMediaSessionInfo_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetMediaSessionInfo(std::move(callback));
      return true;
    }
    case internal::kMediaSession_GetDebugInfo_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media_session::mojom::MediaSession::GetDebugInfo",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media_session::mojom::MediaSession::GetDebugInfo");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::MediaSession_GetDebugInfo_Params_Data* params =
          reinterpret_cast<
              internal::MediaSession_GetDebugInfo_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      MediaSession_GetDebugInfo_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaSession::Name_, 1, false);
        return false;
      }
      MediaSession::GetDebugInfoCallback callback =
          MediaSession_GetDebugInfo_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetDebugInfo(std::move(callback));
      return true;
    }
    case internal::kMediaSession_StartDucking_Name: {
      break;
    }
    case internal::kMediaSession_StopDucking_Name: {
      break;
    }
    case internal::kMediaSession_Suspend_Name: {
      break;
    }
    case internal::kMediaSession_Resume_Name: {
      break;
    }
    case internal::kMediaSession_AddObserver_Name: {
      break;
    }
    case internal::kMediaSession_PreviousTrack_Name: {
      break;
    }
    case internal::kMediaSession_NextTrack_Name: {
      break;
    }
    case internal::kMediaSession_Seek_Name: {
      break;
    }
    case internal::kMediaSession_Stop_Name: {
      break;
    }
    case internal::kMediaSession_SkipAd_Name: {
      break;
    }
    case internal::kMediaSession_GetMediaImageBitmap_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media_session::mojom::MediaSession::GetMediaImageBitmap",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media_session::mojom::MediaSession::GetMediaImageBitmap");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::MediaSession_GetMediaImageBitmap_Params_Data* params =
          reinterpret_cast<
              internal::MediaSession_GetMediaImageBitmap_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      MediaImagePtr p_image{};
      int32_t p_minimum_size_px{};
      int32_t p_desired_size_px{};
      MediaSession_GetMediaImageBitmap_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadImage(&p_image))
        success = false;
      if (success)
        p_minimum_size_px = input_data_view.minimum_size_px();
      if (success)
        p_desired_size_px = input_data_view.desired_size_px();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaSession::Name_, 12, false);
        return false;
      }
      MediaSession::GetMediaImageBitmapCallback callback =
          MediaSession_GetMediaImageBitmap_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetMediaImageBitmap(
std::move(p_image), 
std::move(p_minimum_size_px), 
std::move(p_desired_size_px), std::move(callback));
      return true;
    }
    case internal::kMediaSession_SeekTo_Name: {
      break;
    }
    case internal::kMediaSession_ScrubTo_Name: {
      break;
    }
    case internal::kMediaSession_EnterPictureInPicture_Name: {
      break;
    }
    case internal::kMediaSession_ExitPictureInPicture_Name: {
      break;
    }
    case internal::kMediaSession_SetAudioSinkId_Name: {
      break;
    }
  }
  return false;
}


static const mojo::internal::GenericValidationInfo kMediaSessionValidationInfo[] = {
    {&internal::MediaSession_GetMediaSessionInfo_Params_Data::Validate,
     &internal::MediaSession_GetMediaSessionInfo_ResponseParams_Data::Validate},
    {&internal::MediaSession_GetDebugInfo_Params_Data::Validate,
     &internal::MediaSession_GetDebugInfo_ResponseParams_Data::Validate},
    {&internal::MediaSession_StartDucking_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::MediaSession_StopDucking_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::MediaSession_Suspend_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::MediaSession_Resume_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::MediaSession_AddObserver_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::MediaSession_PreviousTrack_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::MediaSession_NextTrack_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::MediaSession_Seek_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::MediaSession_Stop_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::MediaSession_SkipAd_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::MediaSession_GetMediaImageBitmap_Params_Data::Validate,
     &internal::MediaSession_GetMediaImageBitmap_ResponseParams_Data::Validate},
    {&internal::MediaSession_SeekTo_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::MediaSession_ScrubTo_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::MediaSession_EnterPictureInPicture_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::MediaSession_ExitPictureInPicture_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::MediaSession_SetAudioSinkId_Params_Data::Validate,
     nullptr /* no response */},
};

bool MediaSessionRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::media_session::mojom::blink::MediaSession::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kMediaSessionValidationInfo);
}

bool MediaSessionResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::media_session::mojom::blink::MediaSession::Name_;
  return mojo::internal::ValidateResponseGenericPacked(message, name, kMediaSessionValidationInfo);
}
}  // namespace blink
}  // namespace mojom
}  // namespace media_session

namespace mojo {


// static
bool StructTraits<::media_session::mojom::blink::MediaImage::DataView, ::media_session::mojom::blink::MediaImagePtr>::Read(
    ::media_session::mojom::blink::MediaImage::DataView input,
    ::media_session::mojom::blink::MediaImagePtr* output) {
  bool success = true;
  ::media_session::mojom::blink::MediaImagePtr result(::media_session::mojom::blink::MediaImage::New());
  
      if (success && !input.ReadSrc(&result->src))
        success = false;
      if (success && !input.ReadType(&result->type))
        success = false;
      if (success && !input.ReadSizes(&result->sizes))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::media_session::mojom::blink::MediaMetadata::DataView, ::media_session::mojom::blink::MediaMetadataPtr>::Read(
    ::media_session::mojom::blink::MediaMetadata::DataView input,
    ::media_session::mojom::blink::MediaMetadataPtr* output) {
  bool success = true;
  ::media_session::mojom::blink::MediaMetadataPtr result(::media_session::mojom::blink::MediaMetadata::New());
  
      if (success && !input.ReadTitle(&result->title))
        success = false;
      if (success && !input.ReadArtist(&result->artist))
        success = false;
      if (success && !input.ReadAlbum(&result->album))
        success = false;
      if (success && !input.ReadSourceTitle(&result->source_title))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::media_session::mojom::blink::MediaImageBitmap::DataView, ::media_session::mojom::blink::MediaImageBitmapPtr>::Read(
    ::media_session::mojom::blink::MediaImageBitmap::DataView input,
    ::media_session::mojom::blink::MediaImageBitmapPtr* output) {
  bool success = true;
  ::media_session::mojom::blink::MediaImageBitmapPtr result(::media_session::mojom::blink::MediaImageBitmap::New());
  
      if (success)
        result->width = input.width();
      if (success)
        result->height = input.height();
      if (success && !input.ReadPixelData(&result->pixel_data))
        success = false;
      if (success && !input.ReadColorType(&result->color_type))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::media_session::mojom::blink::MediaPosition::DataView, ::media_session::mojom::blink::MediaPositionPtr>::Read(
    ::media_session::mojom::blink::MediaPosition::DataView input,
    ::media_session::mojom::blink::MediaPositionPtr* output) {
  bool success = true;
  ::media_session::mojom::blink::MediaPositionPtr result(::media_session::mojom::blink::MediaPosition::New());
  
      if (success)
        result->playback_rate = input.playback_rate();
      if (success && !input.ReadDuration(&result->duration))
        success = false;
      if (success && !input.ReadPosition(&result->position))
        success = false;
      if (success && !input.ReadLastUpdatedTime(&result->last_updated_time))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::media_session::mojom::blink::MediaSessionInfo::DataView, ::media_session::mojom::blink::MediaSessionInfoPtr>::Read(
    ::media_session::mojom::blink::MediaSessionInfo::DataView input,
    ::media_session::mojom::blink::MediaSessionInfoPtr* output) {
  bool success = true;
  ::media_session::mojom::blink::MediaSessionInfoPtr result(::media_session::mojom::blink::MediaSessionInfo::New());
  
      if (success && !input.ReadState(&result->state))
        success = false;
      if (success)
        result->force_duck = input.force_duck();
      if (success && !input.ReadPlaybackState(&result->playback_state))
        success = false;
      if (success)
        result->is_controllable = input.is_controllable();
      if (success)
        result->prefer_stop_for_gain_focus_loss = input.prefer_stop_for_gain_focus_loss();
      if (success)
        result->is_sensitive = input.is_sensitive();
      if (success && !input.ReadPictureInPictureState(&result->picture_in_picture_state))
        success = false;
      if (success && !input.ReadDeprecatedAudioVideoState(&result->deprecated_audio_video_state))
        success = false;
      if (success && !input.ReadAudioSinkId(&result->audio_sink_id))
        success = false;
      if (success && !input.ReadAudioVideoStates(&result->audio_video_states))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::media_session::mojom::blink::MediaSessionDebugInfo::DataView, ::media_session::mojom::blink::MediaSessionDebugInfoPtr>::Read(
    ::media_session::mojom::blink::MediaSessionDebugInfo::DataView input,
    ::media_session::mojom::blink::MediaSessionDebugInfoPtr* output) {
  bool success = true;
  ::media_session::mojom::blink::MediaSessionDebugInfoPtr result(::media_session::mojom::blink::MediaSessionDebugInfo::New());
  
      if (success && !input.ReadName(&result->name))
        success = false;
      if (success && !input.ReadOwner(&result->owner))
        success = false;
      if (success && !input.ReadState(&result->state))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif