// services/media_session/public/mojom/media_session.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "services/media_session/public/mojom/media_session.mojom-shared.h"

#include <utility>

#include "base/stl_util.h"  // for base::size()
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/media_session/public/mojom/media_session.mojom-params-data.h"
namespace media_session {
namespace mojom {

std::string MediaPlaybackStateToString(MediaPlaybackState value) {
  switch(value) {
    case MediaPlaybackState::kPaused:
      return "MediaPlaybackState::kPaused";
    case MediaPlaybackState::kPlaying:
      return "MediaPlaybackState::kPlaying";
    default:
      return base::StringPrintf("Unknown MediaPlaybackState value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, MediaPlaybackState value) {
  return os << MediaPlaybackStateToString(value);
}

std::string MediaSessionActionToString(MediaSessionAction value) {
  switch(value) {
    case MediaSessionAction::kPlay:
      return "MediaSessionAction::kPlay";
    case MediaSessionAction::kPause:
      return "MediaSessionAction::kPause";
    case MediaSessionAction::kPreviousTrack:
      return "MediaSessionAction::kPreviousTrack";
    case MediaSessionAction::kNextTrack:
      return "MediaSessionAction::kNextTrack";
    case MediaSessionAction::kSeekBackward:
      return "MediaSessionAction::kSeekBackward";
    case MediaSessionAction::kSeekForward:
      return "MediaSessionAction::kSeekForward";
    case MediaSessionAction::kSkipAd:
      return "MediaSessionAction::kSkipAd";
    case MediaSessionAction::kStop:
      return "MediaSessionAction::kStop";
    case MediaSessionAction::kSeekTo:
      return "MediaSessionAction::kSeekTo";
    case MediaSessionAction::kScrubTo:
      return "MediaSessionAction::kScrubTo";
    case MediaSessionAction::kEnterPictureInPicture:
      return "MediaSessionAction::kEnterPictureInPicture";
    case MediaSessionAction::kExitPictureInPicture:
      return "MediaSessionAction::kExitPictureInPicture";
    case MediaSessionAction::kSwitchAudioDevice:
      return "MediaSessionAction::kSwitchAudioDevice";
    default:
      return base::StringPrintf("Unknown MediaSessionAction value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, MediaSessionAction value) {
  return os << MediaSessionActionToString(value);
}

std::string MediaSessionImageTypeToString(MediaSessionImageType value) {
  switch(value) {
    case MediaSessionImageType::kArtwork:
      return "MediaSessionImageType::kArtwork";
    case MediaSessionImageType::kSourceIcon:
      return "MediaSessionImageType::kSourceIcon";
    default:
      return base::StringPrintf("Unknown MediaSessionImageType value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, MediaSessionImageType value) {
  return os << MediaSessionImageTypeToString(value);
}

std::string MediaPictureInPictureStateToString(MediaPictureInPictureState value) {
  switch(value) {
    case MediaPictureInPictureState::kNotInPictureInPicture:
      return "MediaPictureInPictureState::kNotInPictureInPicture";
    case MediaPictureInPictureState::kInPictureInPicture:
      return "MediaPictureInPictureState::kInPictureInPicture";
    default:
      return base::StringPrintf("Unknown MediaPictureInPictureState value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, MediaPictureInPictureState value) {
  return os << MediaPictureInPictureStateToString(value);
}

std::string MediaAudioVideoStateToString(MediaAudioVideoState value) {
  switch(value) {
    case MediaAudioVideoState::kDeprecatedUnknown:
      return "MediaAudioVideoState::kDeprecatedUnknown";
    case MediaAudioVideoState::kAudioOnly:
      return "MediaAudioVideoState::kAudioOnly";
    case MediaAudioVideoState::kAudioVideo:
      return "MediaAudioVideoState::kAudioVideo";
    case MediaAudioVideoState::kVideoOnly:
      return "MediaAudioVideoState::kVideoOnly";
    default:
      return base::StringPrintf("Unknown MediaAudioVideoState value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, MediaAudioVideoState value) {
  return os << MediaAudioVideoStateToString(value);
}

std::string MediaImageBitmapColorTypeToString(MediaImageBitmapColorType value) {
  switch(value) {
    case MediaImageBitmapColorType::kRGBA_8888:
      return "MediaImageBitmapColorType::kRGBA_8888";
    case MediaImageBitmapColorType::kBGRA_8888:
      return "MediaImageBitmapColorType::kBGRA_8888";
    default:
      return base::StringPrintf("Unknown MediaImageBitmapColorType value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, MediaImageBitmapColorType value) {
  return os << MediaImageBitmapColorTypeToString(value);
}

std::string MediaSessionInfo_SessionStateToString(MediaSessionInfo_SessionState value) {
  switch(value) {
    case MediaSessionInfo_SessionState::kActive:
      return "MediaSessionInfo_SessionState::kActive";
    case MediaSessionInfo_SessionState::kDucking:
      return "MediaSessionInfo_SessionState::kDucking";
    case MediaSessionInfo_SessionState::kSuspended:
      return "MediaSessionInfo_SessionState::kSuspended";
    case MediaSessionInfo_SessionState::kInactive:
      return "MediaSessionInfo_SessionState::kInactive";
    default:
      return base::StringPrintf("Unknown MediaSessionInfo_SessionState value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, MediaSessionInfo_SessionState value) {
  return os << MediaSessionInfo_SessionStateToString(value);
}

std::string MediaSession_SuspendTypeToString(MediaSession_SuspendType value) {
  switch(value) {
    case MediaSession_SuspendType::kSystem:
      return "MediaSession_SuspendType::kSystem";
    case MediaSession_SuspendType::kUI:
      return "MediaSession_SuspendType::kUI";
    case MediaSession_SuspendType::kContent:
      return "MediaSession_SuspendType::kContent";
    default:
      return base::StringPrintf("Unknown MediaSession_SuspendType value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, MediaSession_SuspendType value) {
  return os << MediaSession_SuspendTypeToString(value);
}

namespace internal {


// static
bool MediaImage_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const MediaImage_Data* object = static_cast<const MediaImage_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->src, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->src, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->type, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->type, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->sizes, 3, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams sizes_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->sizes, validation_context,
                                         &sizes_validate_params)) {
    return false;
  }

  return true;
}

MediaImage_Data::MediaImage_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MediaMetadata_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const MediaMetadata_Data* object = static_cast<const MediaMetadata_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->title, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->title, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->artist, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->artist, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->album, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->album, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->source_title, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->source_title, validation_context))
    return false;

  return true;
}

MediaMetadata_Data::MediaMetadata_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MediaImageBitmap_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  static constexpr mojo::internal::StructVersionSize kVersionSizes[] = {
    { 0, 24 },
    { 5, 32 },
  };
  if (!ValidateStructHeaderAndVersionSizeAndClaimMemory(
          data, kVersionSizes, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const MediaImageBitmap_Data* object = static_cast<const MediaImageBitmap_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->pixel_data, 3, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams pixel_data_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->pixel_data, validation_context,
                                         &pixel_data_validate_params)) {
    return false;
  }
  if (object->header_.version < 5)
    return true;


  if (!::media_session::mojom::internal::MediaImageBitmapColorType_Data
        ::Validate(object->color_type, validation_context))
    return false;

  return true;
}

MediaImageBitmap_Data::MediaImageBitmap_Data()
    : header_({sizeof(*this), 5}) {}


// static
bool MediaPosition_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const MediaPosition_Data* object = static_cast<const MediaPosition_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->duration, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->duration, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->position, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->position, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->last_updated_time, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->last_updated_time, validation_context))
    return false;

  return true;
}

MediaPosition_Data::MediaPosition_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MediaSessionInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  static constexpr mojo::internal::StructVersionSize kVersionSizes[] = {
    { 0, 16 },
    { 1, 24 },
    { 2, 24 },
    { 4, 24 },
    { 6, 24 },
    { 7, 24 },
    { 8, 32 },
    { 9, 40 },
    { 10, 48 },
  };
  if (!ValidateStructHeaderAndVersionSizeAndClaimMemory(
          data, kVersionSizes, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const MediaSessionInfo_Data* object = static_cast<const MediaSessionInfo_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::media_session::mojom::internal::MediaSessionInfo_SessionState_Data
        ::Validate(object->state, validation_context))
    return false;
  if (object->header_.version < 1)
    return true;


  if (!::media_session::mojom::internal::MediaPlaybackState_Data
        ::Validate(object->playback_state, validation_context))
    return false;
  if (object->header_.version < 7)
    return true;


  if (!::media_session::mojom::internal::MediaPictureInPictureState_Data
        ::Validate(object->picture_in_picture_state, validation_context))
    return false;
  if (object->header_.version < 8)
    return true;


  if (!::media_session::mojom::internal::MediaAudioVideoState_Data
        ::Validate(object->deprecated_audio_video_state, validation_context))
    return false;
  if (object->header_.version < 9)
    return true;

  const mojo::internal::ContainerValidateParams audio_sink_id_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->audio_sink_id, validation_context,
                                         &audio_sink_id_validate_params)) {
    return false;
  }
  if (object->header_.version < 10)
    return true;

  const mojo::internal::ContainerValidateParams audio_video_states_validate_params(
      0, ::media_session::mojom::internal::MediaAudioVideoState_Data::Validate);
  if (!mojo::internal::ValidateContainer(object->audio_video_states, validation_context,
                                         &audio_video_states_validate_params)) {
    return false;
  }

  return true;
}

MediaSessionInfo_Data::MediaSessionInfo_Data()
    : header_({sizeof(*this), 10}) {}


// static
bool MediaSessionDebugInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const MediaSessionDebugInfo_Data* object = static_cast<const MediaSessionDebugInfo_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->name, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams name_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->name, validation_context,
                                         &name_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->owner, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams owner_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->owner, validation_context,
                                         &owner_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->state, 3, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams state_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->state, validation_context,
                                         &state_validate_params)) {
    return false;
  }

  return true;
}

MediaSessionDebugInfo_Data::MediaSessionDebugInfo_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MediaSessionObserver_MediaSessionInfoChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const MediaSessionObserver_MediaSessionInfoChanged_Params_Data* object = static_cast<const MediaSessionObserver_MediaSessionInfoChanged_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->info, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->info, validation_context))
    return false;

  return true;
}

MediaSessionObserver_MediaSessionInfoChanged_Params_Data::MediaSessionObserver_MediaSessionInfoChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MediaSessionObserver_MediaSessionMetadataChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const MediaSessionObserver_MediaSessionMetadataChanged_Params_Data* object = static_cast<const MediaSessionObserver_MediaSessionMetadataChanged_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateStruct(object->metadata, validation_context))
    return false;

  return true;
}

MediaSessionObserver_MediaSessionMetadataChanged_Params_Data::MediaSessionObserver_MediaSessionMetadataChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MediaSessionObserver_MediaSessionActionsChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const MediaSessionObserver_MediaSessionActionsChanged_Params_Data* object = static_cast<const MediaSessionObserver_MediaSessionActionsChanged_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->action, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams action_validate_params(
      0, ::media_session::mojom::internal::MediaSessionAction_Data::Validate);
  if (!mojo::internal::ValidateContainer(object->action, validation_context,
                                         &action_validate_params)) {
    return false;
  }

  return true;
}

MediaSessionObserver_MediaSessionActionsChanged_Params_Data::MediaSessionObserver_MediaSessionActionsChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MediaSessionObserver_MediaSessionImagesChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const MediaSessionObserver_MediaSessionImagesChanged_Params_Data* object = static_cast<const MediaSessionObserver_MediaSessionImagesChanged_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->images, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams images_validate_params(
      new mojo::internal::ContainerValidateParams(0, ::media_session::mojom::internal::MediaSessionImageType_Data::Validate), new mojo::internal::ContainerValidateParams(0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr)));
  if (!mojo::internal::ValidateContainer(object->images, validation_context,
                                         &images_validate_params)) {
    return false;
  }

  return true;
}

MediaSessionObserver_MediaSessionImagesChanged_Params_Data::MediaSessionObserver_MediaSessionImagesChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MediaSessionObserver_MediaSessionPositionChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const MediaSessionObserver_MediaSessionPositionChanged_Params_Data* object = static_cast<const MediaSessionObserver_MediaSessionPositionChanged_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateStruct(object->position, validation_context))
    return false;

  return true;
}

MediaSessionObserver_MediaSessionPositionChanged_Params_Data::MediaSessionObserver_MediaSessionPositionChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MediaSession_GetMediaSessionInfo_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const MediaSession_GetMediaSessionInfo_Params_Data* object = static_cast<const MediaSession_GetMediaSessionInfo_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

MediaSession_GetMediaSessionInfo_Params_Data::MediaSession_GetMediaSessionInfo_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MediaSession_GetMediaSessionInfo_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const MediaSession_GetMediaSessionInfo_ResponseParams_Data* object = static_cast<const MediaSession_GetMediaSessionInfo_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->info, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->info, validation_context))
    return false;

  return true;
}

MediaSession_GetMediaSessionInfo_ResponseParams_Data::MediaSession_GetMediaSessionInfo_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MediaSession_GetDebugInfo_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const MediaSession_GetDebugInfo_Params_Data* object = static_cast<const MediaSession_GetDebugInfo_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

MediaSession_GetDebugInfo_Params_Data::MediaSession_GetDebugInfo_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MediaSession_GetDebugInfo_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const MediaSession_GetDebugInfo_ResponseParams_Data* object = static_cast<const MediaSession_GetDebugInfo_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->info, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->info, validation_context))
    return false;

  return true;
}

MediaSession_GetDebugInfo_ResponseParams_Data::MediaSession_GetDebugInfo_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MediaSession_StartDucking_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const MediaSession_StartDucking_Params_Data* object = static_cast<const MediaSession_StartDucking_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

MediaSession_StartDucking_Params_Data::MediaSession_StartDucking_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MediaSession_StopDucking_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const MediaSession_StopDucking_Params_Data* object = static_cast<const MediaSession_StopDucking_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

MediaSession_StopDucking_Params_Data::MediaSession_StopDucking_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MediaSession_Suspend_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const MediaSession_Suspend_Params_Data* object = static_cast<const MediaSession_Suspend_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::media_session::mojom::internal::MediaSession_SuspendType_Data
        ::Validate(object->suspend_type, validation_context))
    return false;

  return true;
}

MediaSession_Suspend_Params_Data::MediaSession_Suspend_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MediaSession_Resume_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const MediaSession_Resume_Params_Data* object = static_cast<const MediaSession_Resume_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::media_session::mojom::internal::MediaSession_SuspendType_Data
        ::Validate(object->suspend_type, validation_context))
    return false;

  return true;
}

MediaSession_Resume_Params_Data::MediaSession_Resume_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MediaSession_AddObserver_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const MediaSession_AddObserver_Params_Data* object = static_cast<const MediaSession_AddObserver_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->observer, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->observer,
                                                 validation_context)) {
    return false;
  }

  return true;
}

MediaSession_AddObserver_Params_Data::MediaSession_AddObserver_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MediaSession_PreviousTrack_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const MediaSession_PreviousTrack_Params_Data* object = static_cast<const MediaSession_PreviousTrack_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

MediaSession_PreviousTrack_Params_Data::MediaSession_PreviousTrack_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MediaSession_NextTrack_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const MediaSession_NextTrack_Params_Data* object = static_cast<const MediaSession_NextTrack_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

MediaSession_NextTrack_Params_Data::MediaSession_NextTrack_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MediaSession_Seek_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const MediaSession_Seek_Params_Data* object = static_cast<const MediaSession_Seek_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->seek_time, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->seek_time, validation_context))
    return false;

  return true;
}

MediaSession_Seek_Params_Data::MediaSession_Seek_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MediaSession_Stop_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const MediaSession_Stop_Params_Data* object = static_cast<const MediaSession_Stop_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::media_session::mojom::internal::MediaSession_SuspendType_Data
        ::Validate(object->suspend_type, validation_context))
    return false;

  return true;
}

MediaSession_Stop_Params_Data::MediaSession_Stop_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MediaSession_SkipAd_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const MediaSession_SkipAd_Params_Data* object = static_cast<const MediaSession_SkipAd_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

MediaSession_SkipAd_Params_Data::MediaSession_SkipAd_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MediaSession_GetMediaImageBitmap_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const MediaSession_GetMediaImageBitmap_Params_Data* object = static_cast<const MediaSession_GetMediaImageBitmap_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->image, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->image, validation_context))
    return false;

  return true;
}

MediaSession_GetMediaImageBitmap_Params_Data::MediaSession_GetMediaImageBitmap_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MediaSession_GetMediaImageBitmap_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const MediaSession_GetMediaImageBitmap_ResponseParams_Data* object = static_cast<const MediaSession_GetMediaImageBitmap_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateStruct(object->image, validation_context))
    return false;

  return true;
}

MediaSession_GetMediaImageBitmap_ResponseParams_Data::MediaSession_GetMediaImageBitmap_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MediaSession_SeekTo_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const MediaSession_SeekTo_Params_Data* object = static_cast<const MediaSession_SeekTo_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->seek_time, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->seek_time, validation_context))
    return false;

  return true;
}

MediaSession_SeekTo_Params_Data::MediaSession_SeekTo_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MediaSession_ScrubTo_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const MediaSession_ScrubTo_Params_Data* object = static_cast<const MediaSession_ScrubTo_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->seek_time, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->seek_time, validation_context))
    return false;

  return true;
}

MediaSession_ScrubTo_Params_Data::MediaSession_ScrubTo_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MediaSession_EnterPictureInPicture_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const MediaSession_EnterPictureInPicture_Params_Data* object = static_cast<const MediaSession_EnterPictureInPicture_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

MediaSession_EnterPictureInPicture_Params_Data::MediaSession_EnterPictureInPicture_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MediaSession_ExitPictureInPicture_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const MediaSession_ExitPictureInPicture_Params_Data* object = static_cast<const MediaSession_ExitPictureInPicture_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

MediaSession_ExitPictureInPicture_Params_Data::MediaSession_ExitPictureInPicture_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MediaSession_SetAudioSinkId_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const MediaSession_SetAudioSinkId_Params_Data* object = static_cast<const MediaSession_SetAudioSinkId_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  const mojo::internal::ContainerValidateParams id_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->id, validation_context,
                                         &id_validate_params)) {
    return false;
  }

  return true;
}

MediaSession_SetAudioSinkId_Params_Data::MediaSession_SetAudioSinkId_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace media_session

namespace perfetto {

// static
void TraceFormatTraits<::media_session::mojom::MediaPlaybackState>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::media_session::mojom::MediaPlaybackState value) {
  return std::move(context).WriteString(::media_session::mojom::MediaPlaybackStateToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::media_session::mojom::MediaSessionAction>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::media_session::mojom::MediaSessionAction value) {
  return std::move(context).WriteString(::media_session::mojom::MediaSessionActionToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::media_session::mojom::MediaSessionImageType>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::media_session::mojom::MediaSessionImageType value) {
  return std::move(context).WriteString(::media_session::mojom::MediaSessionImageTypeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::media_session::mojom::MediaPictureInPictureState>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::media_session::mojom::MediaPictureInPictureState value) {
  return std::move(context).WriteString(::media_session::mojom::MediaPictureInPictureStateToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::media_session::mojom::MediaAudioVideoState>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::media_session::mojom::MediaAudioVideoState value) {
  return std::move(context).WriteString(::media_session::mojom::MediaAudioVideoStateToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::media_session::mojom::MediaImageBitmapColorType>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::media_session::mojom::MediaImageBitmapColorType value) {
  return std::move(context).WriteString(::media_session::mojom::MediaImageBitmapColorTypeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::media_session::mojom::MediaSessionInfo_SessionState>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::media_session::mojom::MediaSessionInfo_SessionState value) {
  return std::move(context).WriteString(::media_session::mojom::MediaSessionInfo_SessionStateToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::media_session::mojom::MediaSession_SuspendType>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::media_session::mojom::MediaSession_SuspendType value) {
  return std::move(context).WriteString(::media_session::mojom::MediaSession_SuspendTypeToString(value));
}

} // namespace perfetto
