// services/network/public/mojom/address_list.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/network/public/mojom/address_list.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "services/network/public/mojom/address_list.mojom-params-data.h"
#include "services/network/public/mojom/address_list.mojom-shared-message-ids.h"

#include "services/network/public/mojom/address_list.mojom-import-headers.h"


#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_ADDRESS_LIST_MOJOM_JUMBO_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_ADDRESS_LIST_MOJOM_JUMBO_H_
#endif
namespace network {
namespace mojom {
AddressList::AddressList()
    : addresses(),
      dns_aliases() {}

AddressList::AddressList(
    std::vector<::net::IPEndPoint> addresses_in,
    std::vector<std::string> dns_aliases_in)
    : addresses(std::move(addresses_in)),
      dns_aliases(std::move(dns_aliases_in)) {}

AddressList::~AddressList() = default;

void AddressList::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "addresses"), this->addresses, 
      "<value of type const std::vector<::net::IPEndPoint>&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "dns_aliases"), this->dns_aliases, 
      "<value of type const std::vector<std::string>&>");
}

bool AddressList::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
}  // namespace mojom
}  // namespace network

namespace mojo {


// static
bool StructTraits<::network::mojom::AddressList::DataView, ::network::mojom::AddressListPtr>::Read(
    ::network::mojom::AddressList::DataView input,
    ::network::mojom::AddressListPtr* output) {
  bool success = true;
  ::network::mojom::AddressListPtr result(::network::mojom::AddressList::New());
  
      if (success && !input.ReadAddresses(&result->addresses))
        success = false;
      if (success && !input.ReadDnsAliases(&result->dns_aliases))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif