// services/network/public/mojom/auth_and_certificate_observer.mojom-blink-test-utils.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif


#include "services/network/public/mojom/auth_and_certificate_observer.mojom-blink-test-utils.h"

#include <utility>

#include "base/bind.h"
#include "base/run_loop.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-blink.h"
#include "services/network/public/mojom/network_param.mojom-blink.h"
#include "url/mojom/url.mojom-blink.h"


#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_AUTH_AND_CERTIFICATE_OBSERVER_MOJOM_BLINK_JUMBO_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_AUTH_AND_CERTIFICATE_OBSERVER_MOJOM_BLINK_JUMBO_H_
#endif


namespace network {
namespace mojom {
namespace blink {


void ClientCertificateResponderInterceptorForTesting::ContinueWithCertificate(::network::mojom::blink::X509CertificatePtr x509_certificate, const WTF::String& provider_name, const WTF::Vector<uint16_t>& algorithm_preferences, ::mojo::PendingRemote<SSLPrivateKey> ssl_private_key) {
  GetForwardingInterface()->ContinueWithCertificate(std::move(x509_certificate), std::move(provider_name), std::move(algorithm_preferences), std::move(ssl_private_key));
}
void ClientCertificateResponderInterceptorForTesting::ContinueWithoutCertificate() {
  GetForwardingInterface()->ContinueWithoutCertificate();
}
void ClientCertificateResponderInterceptorForTesting::CancelRequest() {
  GetForwardingInterface()->CancelRequest();
}
ClientCertificateResponderAsyncWaiter::ClientCertificateResponderAsyncWaiter(
    ClientCertificateResponder* proxy) : proxy_(proxy) {}

ClientCertificateResponderAsyncWaiter::~ClientCertificateResponderAsyncWaiter() = default;




void SSLPrivateKeyInterceptorForTesting::Sign(uint16_t algorithm, const WTF::Vector<uint8_t>& input, SignCallback callback) {
  GetForwardingInterface()->Sign(std::move(algorithm), std::move(input), std::move(callback));
}
SSLPrivateKeyAsyncWaiter::SSLPrivateKeyAsyncWaiter(
    SSLPrivateKey* proxy) : proxy_(proxy) {}

SSLPrivateKeyAsyncWaiter::~SSLPrivateKeyAsyncWaiter() = default;

void SSLPrivateKeyAsyncWaiter::Sign(
    uint16_t algorithm, const WTF::Vector<uint8_t>& input, int32_t* out_net_error, WTF::Vector<uint8_t>* out_signature) {
  base::RunLoop loop;
  proxy_->Sign(std::move(algorithm),std::move(input),
      base::BindOnce(
          [](base::RunLoop* loop,
             int32_t* out_net_error
,
             WTF::Vector<uint8_t>* out_signature
,
             int32_t net_error,
             const WTF::Vector<uint8_t>& signature) {*out_net_error = std::move(net_error);*out_signature = std::move(signature);
            loop->Quit();
          },
          &loop,
          out_net_error,
          out_signature));
  loop.Run();
}



void AuthChallengeResponderInterceptorForTesting::OnAuthCredentials(::network::mojom::blink::AuthCredentialsPtr credentials) {
  GetForwardingInterface()->OnAuthCredentials(std::move(credentials));
}
AuthChallengeResponderAsyncWaiter::AuthChallengeResponderAsyncWaiter(
    AuthChallengeResponder* proxy) : proxy_(proxy) {}

AuthChallengeResponderAsyncWaiter::~AuthChallengeResponderAsyncWaiter() = default;




void AuthenticationAndCertificateObserverInterceptorForTesting::OnSSLCertificateError(const ::blink::KURL& url, int32_t net_error, ::network::mojom::blink::SSLInfoPtr ssl_info, bool fatal, OnSSLCertificateErrorCallback callback) {
  GetForwardingInterface()->OnSSLCertificateError(std::move(url), std::move(net_error), std::move(ssl_info), std::move(fatal), std::move(callback));
}
void AuthenticationAndCertificateObserverInterceptorForTesting::OnCertificateRequested(const base::Optional<::base::UnguessableToken>& window_id, ::network::mojom::blink::SSLCertRequestInfoPtr cert_info, ::mojo::PendingRemote<ClientCertificateResponder> cert_responder) {
  GetForwardingInterface()->OnCertificateRequested(std::move(window_id), std::move(cert_info), std::move(cert_responder));
}
void AuthenticationAndCertificateObserverInterceptorForTesting::OnAuthRequired(const base::Optional<::base::UnguessableToken>& window_id, uint32_t request_id, const ::blink::KURL& url, bool first_auth_attempt, const ::net::AuthChallengeInfo& auth_info, ::network::mojom::blink::HttpResponseHeadersPtr head_headers, ::mojo::PendingRemote<AuthChallengeResponder> auth_challenge_responder) {
  GetForwardingInterface()->OnAuthRequired(std::move(window_id), std::move(request_id), std::move(url), std::move(first_auth_attempt), std::move(auth_info), std::move(head_headers), std::move(auth_challenge_responder));
}
void AuthenticationAndCertificateObserverInterceptorForTesting::Clone(::mojo::PendingReceiver<AuthenticationAndCertificateObserver> listener) {
  GetForwardingInterface()->Clone(std::move(listener));
}
AuthenticationAndCertificateObserverAsyncWaiter::AuthenticationAndCertificateObserverAsyncWaiter(
    AuthenticationAndCertificateObserver* proxy) : proxy_(proxy) {}

AuthenticationAndCertificateObserverAsyncWaiter::~AuthenticationAndCertificateObserverAsyncWaiter() = default;

void AuthenticationAndCertificateObserverAsyncWaiter::OnSSLCertificateError(
    const ::blink::KURL& url, int32_t net_error, ::network::mojom::blink::SSLInfoPtr ssl_info, bool fatal, int32_t* out_net_error) {
  base::RunLoop loop;
  proxy_->OnSSLCertificateError(std::move(url),std::move(net_error),std::move(ssl_info),std::move(fatal),
      base::BindOnce(
          [](base::RunLoop* loop,
             int32_t* out_net_error
,
             int32_t net_error) {*out_net_error = std::move(net_error);
            loop->Quit();
          },
          &loop,
          out_net_error));
  loop.Run();
}





}  // namespace blink
}  // namespace mojom
}  // namespace network

#if defined(__clang__)
#pragma clang diagnostic pop
#endif