// services/network/public/mojom/auth_and_certificate_observer.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "services/network/public/mojom/auth_and_certificate_observer.mojom-shared.h"

#include <utility>

#include "base/stl_util.h"  // for base::size()
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/network/public/mojom/auth_and_certificate_observer.mojom-params-data.h"
namespace network {
namespace mojom {

namespace internal {


// static
bool ClientCertificateResponder_ContinueWithCertificate_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ClientCertificateResponder_ContinueWithCertificate_Params_Data* object = static_cast<const ClientCertificateResponder_ContinueWithCertificate_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->x509_certificate, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->x509_certificate, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->provider_name, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams provider_name_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->provider_name, validation_context,
                                         &provider_name_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->algorithm_preferences, 3, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams algorithm_preferences_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->algorithm_preferences, validation_context,
                                         &algorithm_preferences_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->ssl_private_key, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->ssl_private_key,
                                                 validation_context)) {
    return false;
  }

  return true;
}

ClientCertificateResponder_ContinueWithCertificate_Params_Data::ClientCertificateResponder_ContinueWithCertificate_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ClientCertificateResponder_ContinueWithoutCertificate_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ClientCertificateResponder_ContinueWithoutCertificate_Params_Data* object = static_cast<const ClientCertificateResponder_ContinueWithoutCertificate_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

ClientCertificateResponder_ContinueWithoutCertificate_Params_Data::ClientCertificateResponder_ContinueWithoutCertificate_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ClientCertificateResponder_CancelRequest_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ClientCertificateResponder_CancelRequest_Params_Data* object = static_cast<const ClientCertificateResponder_CancelRequest_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

ClientCertificateResponder_CancelRequest_Params_Data::ClientCertificateResponder_CancelRequest_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SSLPrivateKey_Sign_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const SSLPrivateKey_Sign_Params_Data* object = static_cast<const SSLPrivateKey_Sign_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->input, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams input_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->input, validation_context,
                                         &input_validate_params)) {
    return false;
  }

  return true;
}

SSLPrivateKey_Sign_Params_Data::SSLPrivateKey_Sign_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SSLPrivateKey_Sign_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const SSLPrivateKey_Sign_ResponseParams_Data* object = static_cast<const SSLPrivateKey_Sign_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->signature, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams signature_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->signature, validation_context,
                                         &signature_validate_params)) {
    return false;
  }

  return true;
}

SSLPrivateKey_Sign_ResponseParams_Data::SSLPrivateKey_Sign_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AuthChallengeResponder_OnAuthCredentials_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const AuthChallengeResponder_OnAuthCredentials_Params_Data* object = static_cast<const AuthChallengeResponder_OnAuthCredentials_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateStruct(object->credentials, validation_context))
    return false;

  return true;
}

AuthChallengeResponder_OnAuthCredentials_Params_Data::AuthChallengeResponder_OnAuthCredentials_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AuthenticationAndCertificateObserver_OnSSLCertificateError_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const AuthenticationAndCertificateObserver_OnSSLCertificateError_Params_Data* object = static_cast<const AuthenticationAndCertificateObserver_OnSSLCertificateError_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->ssl_info, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->ssl_info, validation_context))
    return false;

  return true;
}

AuthenticationAndCertificateObserver_OnSSLCertificateError_Params_Data::AuthenticationAndCertificateObserver_OnSSLCertificateError_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AuthenticationAndCertificateObserver_OnSSLCertificateError_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const AuthenticationAndCertificateObserver_OnSSLCertificateError_ResponseParams_Data* object = static_cast<const AuthenticationAndCertificateObserver_OnSSLCertificateError_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

AuthenticationAndCertificateObserver_OnSSLCertificateError_ResponseParams_Data::AuthenticationAndCertificateObserver_OnSSLCertificateError_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AuthenticationAndCertificateObserver_OnCertificateRequested_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const AuthenticationAndCertificateObserver_OnCertificateRequested_Params_Data* object = static_cast<const AuthenticationAndCertificateObserver_OnCertificateRequested_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateStruct(object->window_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->cert_info, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->cert_info, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->cert_responder, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->cert_responder,
                                                 validation_context)) {
    return false;
  }

  return true;
}

AuthenticationAndCertificateObserver_OnCertificateRequested_Params_Data::AuthenticationAndCertificateObserver_OnCertificateRequested_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AuthenticationAndCertificateObserver_OnAuthRequired_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 56, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const AuthenticationAndCertificateObserver_OnAuthRequired_Params_Data* object = static_cast<const AuthenticationAndCertificateObserver_OnAuthRequired_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateStruct(object->window_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->auth_info, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->auth_info, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->head_headers, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->auth_challenge_responder, 7, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->auth_challenge_responder,
                                                 validation_context)) {
    return false;
  }

  return true;
}

AuthenticationAndCertificateObserver_OnAuthRequired_Params_Data::AuthenticationAndCertificateObserver_OnAuthRequired_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AuthenticationAndCertificateObserver_Clone_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const AuthenticationAndCertificateObserver_Clone_Params_Data* object = static_cast<const AuthenticationAndCertificateObserver_Clone_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->listener, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->listener,
                                                 validation_context)) {
    return false;
  }

  return true;
}

AuthenticationAndCertificateObserver_Clone_Params_Data::AuthenticationAndCertificateObserver_Clone_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace network
