// services/network/public/mojom/cert_verifier_service.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/network/public/mojom/cert_verifier_service.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "services/network/public/mojom/cert_verifier_service.mojom-params-data.h"
#include "services/network/public/mojom/cert_verifier_service.mojom-shared-message-ids.h"

#include "services/network/public/mojom/cert_verifier_service.mojom-blink-import-headers.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_CERT_VERIFIER_SERVICE_MOJOM_BLINK_JUMBO_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_CERT_VERIFIER_SERVICE_MOJOM_BLINK_JUMBO_H_
#endif
namespace cert_verifier {
namespace mojom {
namespace blink {
RequestParams::RequestParams()
    : certificate(),
      hostname(),
      flags(),
      ocsp_response(),
      sct_list() {}

RequestParams::RequestParams(
    ::network::mojom::blink::X509CertificatePtr certificate_in,
    const WTF::String& hostname_in,
    int32_t flags_in,
    const WTF::String& ocsp_response_in,
    const WTF::String& sct_list_in)
    : certificate(std::move(certificate_in)),
      hostname(std::move(hostname_in)),
      flags(std::move(flags_in)),
      ocsp_response(std::move(ocsp_response_in)),
      sct_list(std::move(sct_list_in)) {}

RequestParams::~RequestParams() = default;

void RequestParams::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "certificate"), this->certificate, 
      "<value of type ::network::mojom::blink::X509CertificatePtr>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "hostname"), this->hostname, 
      "<value of type const WTF::String&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "flags"), this->flags, 
      "<value of type int32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "ocsp_response"), this->ocsp_response, 
      "<value of type const WTF::String&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "sct_list"), this->sct_list, 
      "<value of type const WTF::String&>");
}

bool RequestParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
CertVerifierConfig::CertVerifierConfig()
    : enable_rev_checking(),
      require_rev_checking_local_anchors(),
      enable_sha1_local_anchors(),
      disable_symantec_enforcement(),
      crl_set(),
      additional_trust_anchors(),
      additional_untrusted_authorities() {}

CertVerifierConfig::CertVerifierConfig(
    bool enable_rev_checking_in,
    bool require_rev_checking_local_anchors_in,
    bool enable_sha1_local_anchors_in,
    bool disable_symantec_enforcement_in,
    ::mojo_base::BigBuffer crl_set_in,
    WTF::Vector<::network::mojom::blink::X509CertificatePtr> additional_trust_anchors_in,
    WTF::Vector<::network::mojom::blink::X509CertificatePtr> additional_untrusted_authorities_in)
    : enable_rev_checking(std::move(enable_rev_checking_in)),
      require_rev_checking_local_anchors(std::move(require_rev_checking_local_anchors_in)),
      enable_sha1_local_anchors(std::move(enable_sha1_local_anchors_in)),
      disable_symantec_enforcement(std::move(disable_symantec_enforcement_in)),
      crl_set(std::move(crl_set_in)),
      additional_trust_anchors(std::move(additional_trust_anchors_in)),
      additional_untrusted_authorities(std::move(additional_untrusted_authorities_in)) {}

CertVerifierConfig::~CertVerifierConfig() = default;

void CertVerifierConfig::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "enable_rev_checking"), this->enable_rev_checking, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "require_rev_checking_local_anchors"), this->require_rev_checking_local_anchors, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "enable_sha1_local_anchors"), this->enable_sha1_local_anchors, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "disable_symantec_enforcement"), this->disable_symantec_enforcement, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "crl_set"), this->crl_set, 
      "<value of type ::mojo_base::BigBuffer>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "additional_trust_anchors"), this->additional_trust_anchors, 
      "<value of type WTF::Vector<::network::mojom::blink::X509CertificatePtr>>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "additional_untrusted_authorities"), this->additional_untrusted_authorities, 
      "<value of type WTF::Vector<::network::mojom::blink::X509CertificatePtr>>");
}

bool CertVerifierConfig::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
const char URLLoaderFactoryConnector::Name_[] = "cert_verifier.mojom.URLLoaderFactoryConnector";

URLLoaderFactoryConnectorProxy::URLLoaderFactoryConnectorProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void URLLoaderFactoryConnectorProxy::CreateURLLoaderFactory(
    ::mojo::PendingReceiver<::network::mojom::blink::URLLoaderFactory> in_url_loader_factory) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "cert_verifier::mojom::URLLoaderFactoryConnector::CreateURLLoaderFactory", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url_loader_factory"), in_url_loader_factory, 
                        "<value of type ::mojo::PendingReceiver<::network::mojom::blink::URLLoaderFactory>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kURLLoaderFactoryConnector_CreateURLLoaderFactory_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::cert_verifier::mojom::internal::URLLoaderFactoryConnector_CreateURLLoaderFactory_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::network::mojom::URLLoaderFactoryInterfaceBase>>(
      in_url_loader_factory, &params->url_loader_factory, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->url_loader_factory),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid url_loader_factory in URLLoaderFactoryConnector.CreateURLLoaderFactory request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(URLLoaderFactoryConnector::Name_);
  message.set_method_name("CreateURLLoaderFactory");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool URLLoaderFactoryConnectorStubDispatch::Accept(
    URLLoaderFactoryConnector* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kURLLoaderFactoryConnector_CreateURLLoaderFactory_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)cert_verifier::mojom::URLLoaderFactoryConnector::CreateURLLoaderFactory",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)cert_verifier::mojom::URLLoaderFactoryConnector::CreateURLLoaderFactory");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::URLLoaderFactoryConnector_CreateURLLoaderFactory_Params_Data* params =
          reinterpret_cast<internal::URLLoaderFactoryConnector_CreateURLLoaderFactory_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingReceiver<::network::mojom::blink::URLLoaderFactory> p_url_loader_factory{};
      URLLoaderFactoryConnector_CreateURLLoaderFactory_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_url_loader_factory =
            input_data_view.TakeUrlLoaderFactory<decltype(p_url_loader_factory)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            URLLoaderFactoryConnector::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateURLLoaderFactory(
std::move(p_url_loader_factory));
      return true;
    }
  }
  return false;
}

// static
bool URLLoaderFactoryConnectorStubDispatch::AcceptWithResponder(
    URLLoaderFactoryConnector* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kURLLoaderFactoryConnector_CreateURLLoaderFactory_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kURLLoaderFactoryConnectorValidationInfo[] = {
    {internal::kURLLoaderFactoryConnector_CreateURLLoaderFactory_Name,
     {&internal::URLLoaderFactoryConnector_CreateURLLoaderFactory_Params_Data::Validate,
      nullptr /* no response */}},
};

bool URLLoaderFactoryConnectorRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::cert_verifier::mojom::blink::URLLoaderFactoryConnector::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kURLLoaderFactoryConnectorValidationInfo);
}

const char CertVerifierService::Name_[] = "cert_verifier.mojom.CertVerifierService";

CertVerifierServiceProxy::CertVerifierServiceProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void CertVerifierServiceProxy::EnableNetworkAccess(
    ::mojo::PendingRemote<::network::mojom::blink::URLLoaderFactory> in_url_loader_factory, ::mojo::PendingRemote<URLLoaderFactoryConnector> in_reconnector) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "cert_verifier::mojom::CertVerifierService::EnableNetworkAccess", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url_loader_factory"), in_url_loader_factory, 
                        "<value of type ::mojo::PendingRemote<::network::mojom::blink::URLLoaderFactory>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("reconnector"), in_reconnector, 
                        "<value of type ::mojo::PendingRemote<URLLoaderFactoryConnector>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kCertVerifierService_EnableNetworkAccess_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::cert_verifier::mojom::internal::CertVerifierService_EnableNetworkAccess_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::network::mojom::URLLoaderFactoryInterfaceBase>>(
      in_url_loader_factory, &params->url_loader_factory, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->url_loader_factory),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid url_loader_factory in CertVerifierService.EnableNetworkAccess request");
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::cert_verifier::mojom::URLLoaderFactoryConnectorInterfaceBase>>(
      in_reconnector, &params->reconnector, &params.message());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CertVerifierService::Name_);
  message.set_method_name("EnableNetworkAccess");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void CertVerifierServiceProxy::Verify(
    RequestParamsPtr in_params, ::mojo::PendingRemote<CertVerifierRequest> in_cert_verifier_request) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "cert_verifier::mojom::CertVerifierService::Verify", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("params"), in_params, 
                        "<value of type RequestParamsPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("cert_verifier_request"), in_cert_verifier_request, 
                        "<value of type ::mojo::PendingRemote<CertVerifierRequest>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kCertVerifierService_Verify_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::cert_verifier::mojom::internal::CertVerifierService_Verify_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->params)::BaseType> params_fragment(
          params.message());
  mojo::internal::Serialize<::cert_verifier::mojom::RequestParamsDataView>(
      in_params, params_fragment);
  params->params.Set(
      params_fragment.is_null() ? nullptr : params_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->params.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null params in CertVerifierService.Verify request");
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::cert_verifier::mojom::CertVerifierRequestInterfaceBase>>(
      in_cert_verifier_request, &params->cert_verifier_request, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->cert_verifier_request),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid cert_verifier_request in CertVerifierService.Verify request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CertVerifierService::Name_);
  message.set_method_name("Verify");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void CertVerifierServiceProxy::SetConfig(
    CertVerifierConfigPtr in_config) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "cert_verifier::mojom::CertVerifierService::SetConfig", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("config"), in_config, 
                        "<value of type CertVerifierConfigPtr>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kCertVerifierService_SetConfig_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::cert_verifier::mojom::internal::CertVerifierService_SetConfig_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->config)::BaseType> config_fragment(
          params.message());
  mojo::internal::Serialize<::cert_verifier::mojom::CertVerifierConfigDataView>(
      in_config, config_fragment);
  params->config.Set(
      config_fragment.is_null() ? nullptr : config_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->config.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null config in CertVerifierService.SetConfig request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CertVerifierService::Name_);
  message.set_method_name("SetConfig");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool CertVerifierServiceStubDispatch::Accept(
    CertVerifierService* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kCertVerifierService_EnableNetworkAccess_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)cert_verifier::mojom::CertVerifierService::EnableNetworkAccess",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)cert_verifier::mojom::CertVerifierService::EnableNetworkAccess");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::CertVerifierService_EnableNetworkAccess_Params_Data* params =
          reinterpret_cast<internal::CertVerifierService_EnableNetworkAccess_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingRemote<::network::mojom::blink::URLLoaderFactory> p_url_loader_factory{};
      ::mojo::PendingRemote<URLLoaderFactoryConnector> p_reconnector{};
      CertVerifierService_EnableNetworkAccess_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_url_loader_factory =
            input_data_view.TakeUrlLoaderFactory<decltype(p_url_loader_factory)>();
      }
      if (success) {
        p_reconnector =
            input_data_view.TakeReconnector<decltype(p_reconnector)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CertVerifierService::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->EnableNetworkAccess(
std::move(p_url_loader_factory), 
std::move(p_reconnector));
      return true;
    }
    case internal::kCertVerifierService_Verify_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)cert_verifier::mojom::CertVerifierService::Verify",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)cert_verifier::mojom::CertVerifierService::Verify");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::CertVerifierService_Verify_Params_Data* params =
          reinterpret_cast<internal::CertVerifierService_Verify_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      RequestParamsPtr p_params{};
      ::mojo::PendingRemote<CertVerifierRequest> p_cert_verifier_request{};
      CertVerifierService_Verify_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadParams(&p_params))
        success = false;
      if (success) {
        p_cert_verifier_request =
            input_data_view.TakeCertVerifierRequest<decltype(p_cert_verifier_request)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CertVerifierService::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Verify(
std::move(p_params), 
std::move(p_cert_verifier_request));
      return true;
    }
    case internal::kCertVerifierService_SetConfig_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)cert_verifier::mojom::CertVerifierService::SetConfig",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)cert_verifier::mojom::CertVerifierService::SetConfig");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::CertVerifierService_SetConfig_Params_Data* params =
          reinterpret_cast<internal::CertVerifierService_SetConfig_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      CertVerifierConfigPtr p_config{};
      CertVerifierService_SetConfig_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadConfig(&p_config))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CertVerifierService::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetConfig(
std::move(p_config));
      return true;
    }
  }
  return false;
}

// static
bool CertVerifierServiceStubDispatch::AcceptWithResponder(
    CertVerifierService* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kCertVerifierService_EnableNetworkAccess_Name: {
      break;
    }
    case internal::kCertVerifierService_Verify_Name: {
      break;
    }
    case internal::kCertVerifierService_SetConfig_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kCertVerifierServiceValidationInfo[] = {
    {internal::kCertVerifierService_EnableNetworkAccess_Name,
     {&internal::CertVerifierService_EnableNetworkAccess_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kCertVerifierService_Verify_Name,
     {&internal::CertVerifierService_Verify_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kCertVerifierService_SetConfig_Name,
     {&internal::CertVerifierService_SetConfig_Params_Data::Validate,
      nullptr /* no response */}},
};

bool CertVerifierServiceRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::cert_verifier::mojom::blink::CertVerifierService::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kCertVerifierServiceValidationInfo);
}

const char CertVerifierRequest::Name_[] = "cert_verifier.mojom.CertVerifierRequest";

CertVerifierRequestProxy::CertVerifierRequestProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void CertVerifierRequestProxy::Complete(
    ::network::mojom::blink::CertVerifyResultPtr in_result, int32_t in_net_error) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "cert_verifier::mojom::CertVerifierRequest::Complete", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result, 
                        "<value of type ::network::mojom::blink::CertVerifyResultPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("net_error"), in_net_error, 
                        "<value of type int32_t>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kCertVerifierRequest_Complete_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::cert_verifier::mojom::internal::CertVerifierRequest_Complete_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->result)::BaseType> result_fragment(
          params.message());
  mojo::internal::Serialize<::network::mojom::CertVerifyResultDataView>(
      in_result, result_fragment);
  params->result.Set(
      result_fragment.is_null() ? nullptr : result_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->result.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null result in CertVerifierRequest.Complete request");
  params->net_error = in_net_error;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CertVerifierRequest::Name_);
  message.set_method_name("Complete");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool CertVerifierRequestStubDispatch::Accept(
    CertVerifierRequest* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kCertVerifierRequest_Complete_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)cert_verifier::mojom::CertVerifierRequest::Complete",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)cert_verifier::mojom::CertVerifierRequest::Complete");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::CertVerifierRequest_Complete_Params_Data* params =
          reinterpret_cast<internal::CertVerifierRequest_Complete_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::network::mojom::blink::CertVerifyResultPtr p_result{};
      int32_t p_net_error{};
      CertVerifierRequest_Complete_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadResult(&p_result))
        success = false;
      if (success)
        p_net_error = input_data_view.net_error();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CertVerifierRequest::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Complete(
std::move(p_result), 
std::move(p_net_error));
      return true;
    }
  }
  return false;
}

// static
bool CertVerifierRequestStubDispatch::AcceptWithResponder(
    CertVerifierRequest* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kCertVerifierRequest_Complete_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kCertVerifierRequestValidationInfo[] = {
    {internal::kCertVerifierRequest_Complete_Name,
     {&internal::CertVerifierRequest_Complete_Params_Data::Validate,
      nullptr /* no response */}},
};

bool CertVerifierRequestRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::cert_verifier::mojom::blink::CertVerifierRequest::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kCertVerifierRequestValidationInfo);
}

}  // namespace blink
}  // namespace mojom
}  // namespace cert_verifier

namespace mojo {


// static
bool StructTraits<::cert_verifier::mojom::blink::RequestParams::DataView, ::cert_verifier::mojom::blink::RequestParamsPtr>::Read(
    ::cert_verifier::mojom::blink::RequestParams::DataView input,
    ::cert_verifier::mojom::blink::RequestParamsPtr* output) {
  bool success = true;
  ::cert_verifier::mojom::blink::RequestParamsPtr result(::cert_verifier::mojom::blink::RequestParams::New());
  
      if (success && !input.ReadCertificate(&result->certificate))
        success = false;
      if (success && !input.ReadHostname(&result->hostname))
        success = false;
      if (success)
        result->flags = input.flags();
      if (success && !input.ReadOcspResponse(&result->ocsp_response))
        success = false;
      if (success && !input.ReadSctList(&result->sct_list))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::cert_verifier::mojom::blink::CertVerifierConfig::DataView, ::cert_verifier::mojom::blink::CertVerifierConfigPtr>::Read(
    ::cert_verifier::mojom::blink::CertVerifierConfig::DataView input,
    ::cert_verifier::mojom::blink::CertVerifierConfigPtr* output) {
  bool success = true;
  ::cert_verifier::mojom::blink::CertVerifierConfigPtr result(::cert_verifier::mojom::blink::CertVerifierConfig::New());
  
      if (success)
        result->enable_rev_checking = input.enable_rev_checking();
      if (success)
        result->require_rev_checking_local_anchors = input.require_rev_checking_local_anchors();
      if (success)
        result->enable_sha1_local_anchors = input.enable_sha1_local_anchors();
      if (success)
        result->disable_symantec_enforcement = input.disable_symantec_enforcement();
      if (success && !input.ReadCrlSet(&result->crl_set))
        success = false;
      if (success && !input.ReadAdditionalTrustAnchors(&result->additional_trust_anchors))
        success = false;
      if (success && !input.ReadAdditionalUntrustedAuthorities(&result->additional_untrusted_authorities))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif