// services/network/public/mojom/cert_verifier_service.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "services/network/public/mojom/cert_verifier_service.mojom-shared.h"

#include <utility>

#include "base/stl_util.h"  // for base::size()
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/network/public/mojom/cert_verifier_service.mojom-params-data.h"
namespace cert_verifier {
namespace mojom {

namespace internal {


// static
bool RequestParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 48, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const RequestParams_Data* object = static_cast<const RequestParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->certificate, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->certificate, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->hostname, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams hostname_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->hostname, validation_context,
                                         &hostname_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->ocsp_response, 4, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams ocsp_response_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->ocsp_response, validation_context,
                                         &ocsp_response_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->sct_list, 5, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams sct_list_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->sct_list, validation_context,
                                         &sct_list_validate_params)) {
    return false;
  }

  return true;
}

RequestParams_Data::RequestParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CertVerifierConfig_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 48, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const CertVerifierConfig_Data* object = static_cast<const CertVerifierConfig_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->crl_set, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->crl_set, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->additional_trust_anchors, 6, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams additional_trust_anchors_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->additional_trust_anchors, validation_context,
                                         &additional_trust_anchors_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->additional_untrusted_authorities, 7, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams additional_untrusted_authorities_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->additional_untrusted_authorities, validation_context,
                                         &additional_untrusted_authorities_validate_params)) {
    return false;
  }

  return true;
}

CertVerifierConfig_Data::CertVerifierConfig_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool URLLoaderFactoryConnector_CreateURLLoaderFactory_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const URLLoaderFactoryConnector_CreateURLLoaderFactory_Params_Data* object = static_cast<const URLLoaderFactoryConnector_CreateURLLoaderFactory_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->url_loader_factory, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->url_loader_factory,
                                                 validation_context)) {
    return false;
  }

  return true;
}

URLLoaderFactoryConnector_CreateURLLoaderFactory_Params_Data::URLLoaderFactoryConnector_CreateURLLoaderFactory_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CertVerifierService_EnableNetworkAccess_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const CertVerifierService_EnableNetworkAccess_Params_Data* object = static_cast<const CertVerifierService_EnableNetworkAccess_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->url_loader_factory, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->url_loader_factory,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterface(object->reconnector,
                                                 validation_context)) {
    return false;
  }

  return true;
}

CertVerifierService_EnableNetworkAccess_Params_Data::CertVerifierService_EnableNetworkAccess_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CertVerifierService_Verify_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const CertVerifierService_Verify_Params_Data* object = static_cast<const CertVerifierService_Verify_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->params, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->params, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->cert_verifier_request, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->cert_verifier_request,
                                                 validation_context)) {
    return false;
  }

  return true;
}

CertVerifierService_Verify_Params_Data::CertVerifierService_Verify_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CertVerifierService_SetConfig_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const CertVerifierService_SetConfig_Params_Data* object = static_cast<const CertVerifierService_SetConfig_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->config, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->config, validation_context))
    return false;

  return true;
}

CertVerifierService_SetConfig_Params_Data::CertVerifierService_SetConfig_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CertVerifierRequest_Complete_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const CertVerifierRequest_Complete_Params_Data* object = static_cast<const CertVerifierRequest_Complete_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->result, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->result, validation_context))
    return false;

  return true;
}

CertVerifierRequest_Complete_Params_Data::CertVerifierRequest_Complete_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace cert_verifier
