// services/network/public/mojom/client_security_state.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/network/public/mojom/client_security_state.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "services/network/public/mojom/client_security_state.mojom-params-data.h"
#include "services/network/public/mojom/client_security_state.mojom-shared-message-ids.h"

#include "services/network/public/mojom/client_security_state.mojom-blink-import-headers.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_CLIENT_SECURITY_STATE_MOJOM_BLINK_JUMBO_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_CLIENT_SECURITY_STATE_MOJOM_BLINK_JUMBO_H_
#endif
namespace network {
namespace mojom {
namespace blink {
ClientSecurityState::ClientSecurityState()
    : cross_origin_embedder_policy(),
      is_web_secure_context(false),
      ip_address_space(::network::mojom::blink::IPAddressSpace::kUnknown),
      private_network_request_policy(PrivateNetworkRequestPolicy::kAllow) {}

ClientSecurityState::ClientSecurityState(
    const ::network::CrossOriginEmbedderPolicy& cross_origin_embedder_policy_in,
    bool is_web_secure_context_in,
    ::network::mojom::blink::IPAddressSpace ip_address_space_in,
    PrivateNetworkRequestPolicy private_network_request_policy_in)
    : cross_origin_embedder_policy(std::move(cross_origin_embedder_policy_in)),
      is_web_secure_context(std::move(is_web_secure_context_in)),
      ip_address_space(std::move(ip_address_space_in)),
      private_network_request_policy(std::move(private_network_request_policy_in)) {}

ClientSecurityState::~ClientSecurityState() = default;

void ClientSecurityState::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "cross_origin_embedder_policy"), this->cross_origin_embedder_policy, 
      "<value of type const ::network::CrossOriginEmbedderPolicy&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_web_secure_context"), this->is_web_secure_context, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "ip_address_space"), this->ip_address_space, 
      "<value of type ::network::mojom::blink::IPAddressSpace>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "private_network_request_policy"), this->private_network_request_policy, 
      "<value of type PrivateNetworkRequestPolicy>");
}

bool ClientSecurityState::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
}  // namespace blink
}  // namespace mojom
}  // namespace network

namespace mojo {


// static
bool StructTraits<::network::mojom::blink::ClientSecurityState::DataView, ::network::mojom::blink::ClientSecurityStatePtr>::Read(
    ::network::mojom::blink::ClientSecurityState::DataView input,
    ::network::mojom::blink::ClientSecurityStatePtr* output) {
  bool success = true;
  ::network::mojom::blink::ClientSecurityStatePtr result(::network::mojom::blink::ClientSecurityState::New());
  
      if (success && !input.ReadCrossOriginEmbedderPolicy(&result->cross_origin_embedder_policy))
        success = false;
      if (success)
        result->is_web_secure_context = input.is_web_secure_context();
      if (success && !input.ReadIpAddressSpace(&result->ip_address_space))
        success = false;
      if (success && !input.ReadPrivateNetworkRequestPolicy(&result->private_network_request_policy))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif