// services/network/public/mojom/content_security_policy.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/network/public/mojom/content_security_policy.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "services/network/public/mojom/content_security_policy.mojom-params-data.h"
#include "services/network/public/mojom/content_security_policy.mojom-shared-message-ids.h"

#include "services/network/public/mojom/content_security_policy.mojom-import-headers.h"


#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_CONTENT_SECURITY_POLICY_MOJOM_JUMBO_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_CONTENT_SECURITY_POLICY_MOJOM_JUMBO_H_
#endif
namespace network {
namespace mojom {
ContentSecurityPolicyHeader::ContentSecurityPolicyHeader()
    : header_value(),
      type(ContentSecurityPolicyType::kEnforce),
      source(ContentSecurityPolicySource::kHTTP) {}

ContentSecurityPolicyHeader::ContentSecurityPolicyHeader(
    const std::string& header_value_in,
    ContentSecurityPolicyType type_in,
    ContentSecurityPolicySource source_in)
    : header_value(std::move(header_value_in)),
      type(std::move(type_in)),
      source(std::move(source_in)) {}

ContentSecurityPolicyHeader::~ContentSecurityPolicyHeader() = default;
size_t ContentSecurityPolicyHeader::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->header_value);
  seed = mojo::internal::Hash(seed, this->type);
  seed = mojo::internal::Hash(seed, this->source);
  return seed;
}

void ContentSecurityPolicyHeader::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "header_value"), this->header_value, 
      "<value of type const std::string&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "type"), this->type, 
      "<value of type ContentSecurityPolicyType>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "source"), this->source, 
      "<value of type ContentSecurityPolicySource>");
}

bool ContentSecurityPolicyHeader::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
CSPSource::CSPSource()
    : scheme(),
      host(),
      port(-1),
      path(),
      is_host_wildcard(false),
      is_port_wildcard(false) {}

CSPSource::CSPSource(
    const std::string& scheme_in,
    const std::string& host_in,
    int32_t port_in,
    const std::string& path_in,
    bool is_host_wildcard_in,
    bool is_port_wildcard_in)
    : scheme(std::move(scheme_in)),
      host(std::move(host_in)),
      port(std::move(port_in)),
      path(std::move(path_in)),
      is_host_wildcard(std::move(is_host_wildcard_in)),
      is_port_wildcard(std::move(is_port_wildcard_in)) {}

CSPSource::~CSPSource() = default;
size_t CSPSource::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->scheme);
  seed = mojo::internal::Hash(seed, this->host);
  seed = mojo::internal::Hash(seed, this->port);
  seed = mojo::internal::Hash(seed, this->path);
  seed = mojo::internal::Hash(seed, this->is_host_wildcard);
  seed = mojo::internal::Hash(seed, this->is_port_wildcard);
  return seed;
}

void CSPSource::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "scheme"), this->scheme, 
      "<value of type const std::string&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "host"), this->host, 
      "<value of type const std::string&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "port"), this->port, 
      "<value of type int32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "path"), this->path, 
      "<value of type const std::string&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_host_wildcard"), this->is_host_wildcard, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_port_wildcard"), this->is_port_wildcard, 
      "<value of type bool>");
}

bool CSPSource::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
CSPHashSource::CSPHashSource()
    : algorithm(),
      value() {}

CSPHashSource::CSPHashSource(
    CSPHashAlgorithm algorithm_in,
    std::vector<uint8_t> value_in)
    : algorithm(std::move(algorithm_in)),
      value(std::move(value_in)) {}

CSPHashSource::~CSPHashSource() = default;

void CSPHashSource::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "algorithm"), this->algorithm, 
      "<value of type CSPHashAlgorithm>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "value"), this->value, 
      "<value of type const std::vector<uint8_t>&>");
}

bool CSPHashSource::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
CSPSourceList::CSPSourceList()
    : sources(),
      nonces(),
      hashes(),
      allow_self(false),
      allow_star(false),
      allow_response_redirects(false),
      allow_inline(false),
      allow_eval(false),
      allow_wasm_eval(false),
      allow_dynamic(false),
      allow_unsafe_hashes(false),
      report_sample(false) {}

CSPSourceList::CSPSourceList(
    std::vector<CSPSourcePtr> sources_in,
    std::vector<std::string> nonces_in,
    std::vector<CSPHashSourcePtr> hashes_in,
    bool allow_self_in,
    bool allow_star_in,
    bool allow_response_redirects_in,
    bool allow_inline_in,
    bool allow_eval_in,
    bool allow_wasm_eval_in,
    bool allow_dynamic_in,
    bool allow_unsafe_hashes_in,
    bool report_sample_in)
    : sources(std::move(sources_in)),
      nonces(std::move(nonces_in)),
      hashes(std::move(hashes_in)),
      allow_self(std::move(allow_self_in)),
      allow_star(std::move(allow_star_in)),
      allow_response_redirects(std::move(allow_response_redirects_in)),
      allow_inline(std::move(allow_inline_in)),
      allow_eval(std::move(allow_eval_in)),
      allow_wasm_eval(std::move(allow_wasm_eval_in)),
      allow_dynamic(std::move(allow_dynamic_in)),
      allow_unsafe_hashes(std::move(allow_unsafe_hashes_in)),
      report_sample(std::move(report_sample_in)) {}

CSPSourceList::~CSPSourceList() = default;

void CSPSourceList::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "sources"), this->sources, 
      "<value of type std::vector<CSPSourcePtr>>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "nonces"), this->nonces, 
      "<value of type const std::vector<std::string>&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "hashes"), this->hashes, 
      "<value of type std::vector<CSPHashSourcePtr>>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "allow_self"), this->allow_self, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "allow_star"), this->allow_star, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "allow_response_redirects"), this->allow_response_redirects, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "allow_inline"), this->allow_inline, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "allow_eval"), this->allow_eval, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "allow_wasm_eval"), this->allow_wasm_eval, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "allow_dynamic"), this->allow_dynamic, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "allow_unsafe_hashes"), this->allow_unsafe_hashes, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "report_sample"), this->report_sample, 
      "<value of type bool>");
}

bool CSPSourceList::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
CSPTrustedTypes::CSPTrustedTypes()
    : list(),
      allow_any(false),
      allow_duplicates(false) {}

CSPTrustedTypes::CSPTrustedTypes(
    std::vector<std::string> list_in,
    bool allow_any_in,
    bool allow_duplicates_in)
    : list(std::move(list_in)),
      allow_any(std::move(allow_any_in)),
      allow_duplicates(std::move(allow_duplicates_in)) {}

CSPTrustedTypes::~CSPTrustedTypes() = default;

void CSPTrustedTypes::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "list"), this->list, 
      "<value of type const std::vector<std::string>&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "allow_any"), this->allow_any, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "allow_duplicates"), this->allow_duplicates, 
      "<value of type bool>");
}

bool CSPTrustedTypes::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ContentSecurityPolicy::ContentSecurityPolicy()
    : self_origin(),
      raw_directives(),
      directives(),
      upgrade_insecure_requests(false),
      treat_as_public_address(false),
      block_all_mixed_content(false),
      sandbox(::network::mojom::WebSandboxFlags::kNone),
      header(),
      use_reporting_api(false),
      report_endpoints(),
      require_trusted_types_for(CSPRequireTrustedTypesFor::None),
      trusted_types(),
      parsing_errors() {}

ContentSecurityPolicy::ContentSecurityPolicy(
    CSPSourcePtr self_origin_in,
    const base::flat_map<CSPDirectiveName, std::string>& raw_directives_in,
    base::flat_map<CSPDirectiveName, CSPSourceListPtr> directives_in,
    bool upgrade_insecure_requests_in,
    bool treat_as_public_address_in,
    bool block_all_mixed_content_in,
    ::network::mojom::WebSandboxFlags sandbox_in,
    ContentSecurityPolicyHeaderPtr header_in,
    bool use_reporting_api_in,
    std::vector<std::string> report_endpoints_in,
    CSPRequireTrustedTypesFor require_trusted_types_for_in,
    CSPTrustedTypesPtr trusted_types_in,
    std::vector<std::string> parsing_errors_in)
    : self_origin(std::move(self_origin_in)),
      raw_directives(std::move(raw_directives_in)),
      directives(std::move(directives_in)),
      upgrade_insecure_requests(std::move(upgrade_insecure_requests_in)),
      treat_as_public_address(std::move(treat_as_public_address_in)),
      block_all_mixed_content(std::move(block_all_mixed_content_in)),
      sandbox(std::move(sandbox_in)),
      header(std::move(header_in)),
      use_reporting_api(std::move(use_reporting_api_in)),
      report_endpoints(std::move(report_endpoints_in)),
      require_trusted_types_for(std::move(require_trusted_types_for_in)),
      trusted_types(std::move(trusted_types_in)),
      parsing_errors(std::move(parsing_errors_in)) {}

ContentSecurityPolicy::~ContentSecurityPolicy() = default;

void ContentSecurityPolicy::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "self_origin"), this->self_origin, 
      "<value of type CSPSourcePtr>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "raw_directives"), this->raw_directives, 
      "<value of type const base::flat_map<CSPDirectiveName, std::string>&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "directives"), this->directives, 
      "<value of type base::flat_map<CSPDirectiveName, CSPSourceListPtr>>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "upgrade_insecure_requests"), this->upgrade_insecure_requests, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "treat_as_public_address"), this->treat_as_public_address, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "block_all_mixed_content"), this->block_all_mixed_content, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "sandbox"), this->sandbox, 
      "<value of type ::network::mojom::WebSandboxFlags>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "header"), this->header, 
      "<value of type ContentSecurityPolicyHeaderPtr>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "use_reporting_api"), this->use_reporting_api, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "report_endpoints"), this->report_endpoints, 
      "<value of type const std::vector<std::string>&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "require_trusted_types_for"), this->require_trusted_types_for, 
      "<value of type CSPRequireTrustedTypesFor>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "trusted_types"), this->trusted_types, 
      "<value of type CSPTrustedTypesPtr>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "parsing_errors"), this->parsing_errors, 
      "<value of type const std::vector<std::string>&>");
}

bool ContentSecurityPolicy::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
CSPViolation::CSPViolation()
    : directive(),
      effective_directive(),
      console_message(),
      blocked_url(),
      report_endpoints(),
      use_reporting_api(),
      header(),
      type(),
      after_redirect(),
      source_location() {}

CSPViolation::CSPViolation(
    const std::string& directive_in,
    const std::string& effective_directive_in,
    const std::string& console_message_in,
    const ::GURL& blocked_url_in,
    std::vector<std::string> report_endpoints_in,
    bool use_reporting_api_in,
    const std::string& header_in,
    ContentSecurityPolicyType type_in,
    bool after_redirect_in,
    ::network::mojom::SourceLocationPtr source_location_in)
    : directive(std::move(directive_in)),
      effective_directive(std::move(effective_directive_in)),
      console_message(std::move(console_message_in)),
      blocked_url(std::move(blocked_url_in)),
      report_endpoints(std::move(report_endpoints_in)),
      use_reporting_api(std::move(use_reporting_api_in)),
      header(std::move(header_in)),
      type(std::move(type_in)),
      after_redirect(std::move(after_redirect_in)),
      source_location(std::move(source_location_in)) {}

CSPViolation::~CSPViolation() = default;

void CSPViolation::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "directive"), this->directive, 
      "<value of type const std::string&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "effective_directive"), this->effective_directive, 
      "<value of type const std::string&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "console_message"), this->console_message, 
      "<value of type const std::string&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "blocked_url"), this->blocked_url, 
      "<value of type const ::GURL&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "report_endpoints"), this->report_endpoints, 
      "<value of type const std::vector<std::string>&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "use_reporting_api"), this->use_reporting_api, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "header"), this->header, 
      "<value of type const std::string&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "type"), this->type, 
      "<value of type ContentSecurityPolicyType>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "after_redirect"), this->after_redirect, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "source_location"), this->source_location, 
      "<value of type ::network::mojom::SourceLocationPtr>");
}

bool CSPViolation::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
AllowCSPFromHeaderValue::AllowCSPFromHeaderValue() : tag_(Tag::ALLOW_STAR) {
  data_.allow_star = bool();
}

AllowCSPFromHeaderValue::~AllowCSPFromHeaderValue() {
  DestroyActive();
}


void AllowCSPFromHeaderValue::set_allow_star(
    bool allow_star) {
  if (tag_ != Tag::ALLOW_STAR) {
    DestroyActive();
    tag_ = Tag::ALLOW_STAR;
  }
  data_.allow_star = allow_star;
}
void AllowCSPFromHeaderValue::set_origin(
    const ::url::Origin& origin) {
  if (tag_ == Tag::ORIGIN) {
    *(data_.origin) = std::move(origin);
  } else {
    DestroyActive();
    tag_ = Tag::ORIGIN;
    data_.origin = new ::url::Origin(
        std::move(origin));
  }
}
void AllowCSPFromHeaderValue::set_error_message(
    const std::string& error_message) {
  if (tag_ == Tag::ERROR_MESSAGE) {
    *(data_.error_message) = std::move(error_message);
  } else {
    DestroyActive();
    tag_ = Tag::ERROR_MESSAGE;
    data_.error_message = new std::string(
        std::move(error_message));
  }
}

void AllowCSPFromHeaderValue::DestroyActive() {
  switch (tag_) {

    case Tag::ALLOW_STAR:

      break;
    case Tag::ORIGIN:

      delete data_.origin;
      break;
    case Tag::ERROR_MESSAGE:

      delete data_.error_message;
      break;
  }
}

bool AllowCSPFromHeaderValue::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
}  // namespace mojom
}  // namespace network

namespace mojo {


// static
bool StructTraits<::network::mojom::ContentSecurityPolicyHeader::DataView, ::network::mojom::ContentSecurityPolicyHeaderPtr>::Read(
    ::network::mojom::ContentSecurityPolicyHeader::DataView input,
    ::network::mojom::ContentSecurityPolicyHeaderPtr* output) {
  bool success = true;
  ::network::mojom::ContentSecurityPolicyHeaderPtr result(::network::mojom::ContentSecurityPolicyHeader::New());
  
      if (success && !input.ReadHeaderValue(&result->header_value))
        success = false;
      if (success && !input.ReadType(&result->type))
        success = false;
      if (success && !input.ReadSource(&result->source))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::CSPSource::DataView, ::network::mojom::CSPSourcePtr>::Read(
    ::network::mojom::CSPSource::DataView input,
    ::network::mojom::CSPSourcePtr* output) {
  bool success = true;
  ::network::mojom::CSPSourcePtr result(::network::mojom::CSPSource::New());
  
      if (success && !input.ReadScheme(&result->scheme))
        success = false;
      if (success && !input.ReadHost(&result->host))
        success = false;
      if (success)
        result->port = input.port();
      if (success && !input.ReadPath(&result->path))
        success = false;
      if (success)
        result->is_host_wildcard = input.is_host_wildcard();
      if (success)
        result->is_port_wildcard = input.is_port_wildcard();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::CSPHashSource::DataView, ::network::mojom::CSPHashSourcePtr>::Read(
    ::network::mojom::CSPHashSource::DataView input,
    ::network::mojom::CSPHashSourcePtr* output) {
  bool success = true;
  ::network::mojom::CSPHashSourcePtr result(::network::mojom::CSPHashSource::New());
  
      if (success && !input.ReadAlgorithm(&result->algorithm))
        success = false;
      if (success && !input.ReadValue(&result->value))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::CSPSourceList::DataView, ::network::mojom::CSPSourceListPtr>::Read(
    ::network::mojom::CSPSourceList::DataView input,
    ::network::mojom::CSPSourceListPtr* output) {
  bool success = true;
  ::network::mojom::CSPSourceListPtr result(::network::mojom::CSPSourceList::New());
  
      if (success && !input.ReadSources(&result->sources))
        success = false;
      if (success && !input.ReadNonces(&result->nonces))
        success = false;
      if (success && !input.ReadHashes(&result->hashes))
        success = false;
      if (success)
        result->allow_self = input.allow_self();
      if (success)
        result->allow_star = input.allow_star();
      if (success)
        result->allow_response_redirects = input.allow_response_redirects();
      if (success)
        result->allow_inline = input.allow_inline();
      if (success)
        result->allow_eval = input.allow_eval();
      if (success)
        result->allow_wasm_eval = input.allow_wasm_eval();
      if (success)
        result->allow_dynamic = input.allow_dynamic();
      if (success)
        result->allow_unsafe_hashes = input.allow_unsafe_hashes();
      if (success)
        result->report_sample = input.report_sample();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::CSPTrustedTypes::DataView, ::network::mojom::CSPTrustedTypesPtr>::Read(
    ::network::mojom::CSPTrustedTypes::DataView input,
    ::network::mojom::CSPTrustedTypesPtr* output) {
  bool success = true;
  ::network::mojom::CSPTrustedTypesPtr result(::network::mojom::CSPTrustedTypes::New());
  
      if (success && !input.ReadList(&result->list))
        success = false;
      if (success)
        result->allow_any = input.allow_any();
      if (success)
        result->allow_duplicates = input.allow_duplicates();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::ContentSecurityPolicy::DataView, ::network::mojom::ContentSecurityPolicyPtr>::Read(
    ::network::mojom::ContentSecurityPolicy::DataView input,
    ::network::mojom::ContentSecurityPolicyPtr* output) {
  bool success = true;
  ::network::mojom::ContentSecurityPolicyPtr result(::network::mojom::ContentSecurityPolicy::New());
  
      if (success && !input.ReadSelfOrigin(&result->self_origin))
        success = false;
      if (success && !input.ReadRawDirectives(&result->raw_directives))
        success = false;
      if (success && !input.ReadDirectives(&result->directives))
        success = false;
      if (success)
        result->upgrade_insecure_requests = input.upgrade_insecure_requests();
      if (success)
        result->treat_as_public_address = input.treat_as_public_address();
      if (success)
        result->block_all_mixed_content = input.block_all_mixed_content();
      if (success && !input.ReadSandbox(&result->sandbox))
        success = false;
      if (success && !input.ReadHeader(&result->header))
        success = false;
      if (success)
        result->use_reporting_api = input.use_reporting_api();
      if (success && !input.ReadReportEndpoints(&result->report_endpoints))
        success = false;
      if (success && !input.ReadRequireTrustedTypesFor(&result->require_trusted_types_for))
        success = false;
      if (success && !input.ReadTrustedTypes(&result->trusted_types))
        success = false;
      if (success && !input.ReadParsingErrors(&result->parsing_errors))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::CSPViolation::DataView, ::network::mojom::CSPViolationPtr>::Read(
    ::network::mojom::CSPViolation::DataView input,
    ::network::mojom::CSPViolationPtr* output) {
  bool success = true;
  ::network::mojom::CSPViolationPtr result(::network::mojom::CSPViolation::New());
  
      if (success && !input.ReadDirective(&result->directive))
        success = false;
      if (success && !input.ReadEffectiveDirective(&result->effective_directive))
        success = false;
      if (success && !input.ReadConsoleMessage(&result->console_message))
        success = false;
      if (success && !input.ReadBlockedUrl(&result->blocked_url))
        success = false;
      if (success && !input.ReadReportEndpoints(&result->report_endpoints))
        success = false;
      if (success)
        result->use_reporting_api = input.use_reporting_api();
      if (success && !input.ReadHeader(&result->header))
        success = false;
      if (success && !input.ReadType(&result->type))
        success = false;
      if (success)
        result->after_redirect = input.after_redirect();
      if (success && !input.ReadSourceLocation(&result->source_location))
        success = false;
  *output = std::move(result);
  return success;
}

// static
bool UnionTraits<::network::mojom::AllowCSPFromHeaderValue::DataView, ::network::mojom::AllowCSPFromHeaderValuePtr>::Read(
    ::network::mojom::AllowCSPFromHeaderValue::DataView input,
    ::network::mojom::AllowCSPFromHeaderValuePtr* output) {
  using UnionType = ::network::mojom::AllowCSPFromHeaderValue;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::ALLOW_STAR: {
      *output = UnionType::NewAllowStar(input.allow_star());
      break;
    }
    case Tag::ORIGIN: {
      ::url::Origin result_origin;
      if (!input.ReadOrigin(&result_origin))
        return false;

      *output = UnionType::NewOrigin(
          std::move(result_origin));
      break;
    }
    case Tag::ERROR_MESSAGE: {
      std::string result_error_message;
      if (!input.ReadErrorMessage(&result_error_message))
        return false;

      *output = UnionType::NewErrorMessage(
          std::move(result_error_message));
      break;
    }
    default:
      return false;
  }
  return true;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif