// services/network/public/mojom/cookie_manager.mojom-blink-test-utils.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif


#include "services/network/public/mojom/cookie_manager.mojom-blink-test-utils.h"

#include <utility>

#include "base/bind.h"
#include "base/run_loop.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"
#include "components/content_settings/core/common/content_settings.mojom-blink.h"
#include "mojo/public/mojom/base/time.mojom-blink.h"
#include "services/network/public/mojom/site_for_cookies.mojom-blink.h"
#include "url/mojom/url.mojom-blink.h"


#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_COOKIE_MANAGER_MOJOM_BLINK_JUMBO_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_COOKIE_MANAGER_MOJOM_BLINK_JUMBO_H_
#endif


namespace network {
namespace mojom {
namespace blink {


void CookieChangeListenerInterceptorForTesting::OnCookieChange(CookieChangeInfoPtr change) {
  GetForwardingInterface()->OnCookieChange(std::move(change));
}
CookieChangeListenerAsyncWaiter::CookieChangeListenerAsyncWaiter(
    CookieChangeListener* proxy) : proxy_(proxy) {}

CookieChangeListenerAsyncWaiter::~CookieChangeListenerAsyncWaiter() = default;




void CookieRemoteAccessFilterInterceptorForTesting::AllowedAccess(const ::blink::KURL& url, const ::net::SiteForCookies& site_for_cookies, AllowedAccessCallback callback) {
  GetForwardingInterface()->AllowedAccess(std::move(url), std::move(site_for_cookies), std::move(callback));
}
CookieRemoteAccessFilterAsyncWaiter::CookieRemoteAccessFilterAsyncWaiter(
    CookieRemoteAccessFilter* proxy) : proxy_(proxy) {}

CookieRemoteAccessFilterAsyncWaiter::~CookieRemoteAccessFilterAsyncWaiter() = default;

void CookieRemoteAccessFilterAsyncWaiter::AllowedAccess(
    const ::blink::KURL& url, const ::net::SiteForCookies& site_for_cookies, bool* out_allowed) {
  base::RunLoop loop;
  proxy_->AllowedAccess(std::move(url),std::move(site_for_cookies),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_allowed
,
             bool allowed) {*out_allowed = std::move(allowed);
            loop->Quit();
          },
          &loop,
          out_allowed));
  loop.Run();
}



void CookieManagerInterceptorForTesting::GetAllCookies(GetAllCookiesCallback callback) {
  GetForwardingInterface()->GetAllCookies(std::move(callback));
}
void CookieManagerInterceptorForTesting::GetAllCookiesWithAccessSemantics(GetAllCookiesWithAccessSemanticsCallback callback) {
  GetForwardingInterface()->GetAllCookiesWithAccessSemantics(std::move(callback));
}
void CookieManagerInterceptorForTesting::GetCookieList(const ::blink::KURL& url, CookieOptionsPtr cookie_options, GetCookieListCallback callback) {
  GetForwardingInterface()->GetCookieList(std::move(url), std::move(cookie_options), std::move(callback));
}
void CookieManagerInterceptorForTesting::SetCanonicalCookie(const ::net::CanonicalCookie& cookie, const ::blink::KURL& source_url, CookieOptionsPtr cookie_options, SetCanonicalCookieCallback callback) {
  GetForwardingInterface()->SetCanonicalCookie(std::move(cookie), std::move(source_url), std::move(cookie_options), std::move(callback));
}
void CookieManagerInterceptorForTesting::DeleteCanonicalCookie(const ::net::CanonicalCookie& cookie, DeleteCanonicalCookieCallback callback) {
  GetForwardingInterface()->DeleteCanonicalCookie(std::move(cookie), std::move(callback));
}
void CookieManagerInterceptorForTesting::DeleteCookies(CookieDeletionFilterPtr filter, DeleteCookiesCallback callback) {
  GetForwardingInterface()->DeleteCookies(std::move(filter), std::move(callback));
}
void CookieManagerInterceptorForTesting::AddCookieChangeListener(const ::blink::KURL& url, const WTF::String& name, ::mojo::PendingRemote<CookieChangeListener> listener) {
  GetForwardingInterface()->AddCookieChangeListener(std::move(url), std::move(name), std::move(listener));
}
void CookieManagerInterceptorForTesting::AddGlobalChangeListener(::mojo::PendingRemote<CookieChangeListener> notification_pointer) {
  GetForwardingInterface()->AddGlobalChangeListener(std::move(notification_pointer));
}
void CookieManagerInterceptorForTesting::CloneInterface(::mojo::PendingReceiver<CookieManager> new_interface) {
  GetForwardingInterface()->CloneInterface(std::move(new_interface));
}
void CookieManagerInterceptorForTesting::FlushCookieStore(FlushCookieStoreCallback callback) {
  GetForwardingInterface()->FlushCookieStore(std::move(callback));
}
void CookieManagerInterceptorForTesting::AllowFileSchemeCookies(bool allow, AllowFileSchemeCookiesCallback callback) {
  GetForwardingInterface()->AllowFileSchemeCookies(std::move(allow), std::move(callback));
}
void CookieManagerInterceptorForTesting::SetContentSettings(WTF::Vector<::content_settings::mojom::blink::ContentSettingPatternSourcePtr> settings) {
  GetForwardingInterface()->SetContentSettings(std::move(settings));
}
void CookieManagerInterceptorForTesting::SetRemoteFilter(::mojo::PendingRemote<CookieRemoteAccessFilter> remote_access_filter) {
  GetForwardingInterface()->SetRemoteFilter(std::move(remote_access_filter));
}
void CookieManagerInterceptorForTesting::SetForceKeepSessionState() {
  GetForwardingInterface()->SetForceKeepSessionState();
}
void CookieManagerInterceptorForTesting::BlockThirdPartyCookies(bool block) {
  GetForwardingInterface()->BlockThirdPartyCookies(std::move(block));
}
void CookieManagerInterceptorForTesting::SetContentSettingsForLegacyCookieAccess(WTF::Vector<::content_settings::mojom::blink::ContentSettingPatternSourcePtr> settings) {
  GetForwardingInterface()->SetContentSettingsForLegacyCookieAccess(std::move(settings));
}
void CookieManagerInterceptorForTesting::SetStorageAccessGrantSettings(WTF::Vector<::content_settings::mojom::blink::ContentSettingPatternSourcePtr> settings, SetStorageAccessGrantSettingsCallback callback) {
  GetForwardingInterface()->SetStorageAccessGrantSettings(std::move(settings), std::move(callback));
}
CookieManagerAsyncWaiter::CookieManagerAsyncWaiter(
    CookieManager* proxy) : proxy_(proxy) {}

CookieManagerAsyncWaiter::~CookieManagerAsyncWaiter() = default;

void CookieManagerAsyncWaiter::GetAllCookies(
    WTF::Vector<::net::CanonicalCookie>* out_cookies) {
  base::RunLoop loop;
  proxy_->GetAllCookies(
      base::BindOnce(
          [](base::RunLoop* loop,
             WTF::Vector<::net::CanonicalCookie>* out_cookies
,
             const WTF::Vector<::net::CanonicalCookie>& cookies) {*out_cookies = std::move(cookies);
            loop->Quit();
          },
          &loop,
          out_cookies));
  loop.Run();
}
void CookieManagerAsyncWaiter::GetAllCookiesWithAccessSemantics(
    WTF::Vector<::net::CanonicalCookie>* out_cookies, WTF::Vector<CookieAccessSemantics>* out_access_semantics_list) {
  base::RunLoop loop;
  proxy_->GetAllCookiesWithAccessSemantics(
      base::BindOnce(
          [](base::RunLoop* loop,
             WTF::Vector<::net::CanonicalCookie>* out_cookies
,
             WTF::Vector<CookieAccessSemantics>* out_access_semantics_list
,
             const WTF::Vector<::net::CanonicalCookie>& cookies,
             const WTF::Vector<CookieAccessSemantics>& access_semantics_list) {*out_cookies = std::move(cookies);*out_access_semantics_list = std::move(access_semantics_list);
            loop->Quit();
          },
          &loop,
          out_cookies,
          out_access_semantics_list));
  loop.Run();
}
void CookieManagerAsyncWaiter::GetCookieList(
    const ::blink::KURL& url, CookieOptionsPtr cookie_options, WTF::Vector<CookieWithAccessResultPtr>* out_cookies, WTF::Vector<CookieWithAccessResultPtr>* out_excluded_cookies) {
  base::RunLoop loop;
  proxy_->GetCookieList(std::move(url),std::move(cookie_options),
      base::BindOnce(
          [](base::RunLoop* loop,
             WTF::Vector<CookieWithAccessResultPtr>* out_cookies
,
             WTF::Vector<CookieWithAccessResultPtr>* out_excluded_cookies
,
             WTF::Vector<CookieWithAccessResultPtr> cookies,
             WTF::Vector<CookieWithAccessResultPtr> excluded_cookies) {*out_cookies = std::move(cookies);*out_excluded_cookies = std::move(excluded_cookies);
            loop->Quit();
          },
          &loop,
          out_cookies,
          out_excluded_cookies));
  loop.Run();
}
void CookieManagerAsyncWaiter::SetCanonicalCookie(
    const ::net::CanonicalCookie& cookie, const ::blink::KURL& source_url, CookieOptionsPtr cookie_options, CookieAccessResultPtr* out_access_result) {
  base::RunLoop loop;
  proxy_->SetCanonicalCookie(std::move(cookie),std::move(source_url),std::move(cookie_options),
      base::BindOnce(
          [](base::RunLoop* loop,
             CookieAccessResultPtr* out_access_result
,
             CookieAccessResultPtr access_result) {*out_access_result = std::move(access_result);
            loop->Quit();
          },
          &loop,
          out_access_result));
  loop.Run();
}
void CookieManagerAsyncWaiter::DeleteCanonicalCookie(
    const ::net::CanonicalCookie& cookie, bool* out_success) {
  base::RunLoop loop;
  proxy_->DeleteCanonicalCookie(std::move(cookie),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_success
,
             bool success) {*out_success = std::move(success);
            loop->Quit();
          },
          &loop,
          out_success));
  loop.Run();
}
void CookieManagerAsyncWaiter::DeleteCookies(
    CookieDeletionFilterPtr filter, uint32_t* out_num_deleted) {
  base::RunLoop loop;
  proxy_->DeleteCookies(std::move(filter),
      base::BindOnce(
          [](base::RunLoop* loop,
             uint32_t* out_num_deleted
,
             uint32_t num_deleted) {*out_num_deleted = std::move(num_deleted);
            loop->Quit();
          },
          &loop,
          out_num_deleted));
  loop.Run();
}
void CookieManagerAsyncWaiter::FlushCookieStore(
    ) {
  base::RunLoop loop;
  proxy_->FlushCookieStore(
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}
void CookieManagerAsyncWaiter::AllowFileSchemeCookies(
    bool allow, bool* out_success) {
  base::RunLoop loop;
  proxy_->AllowFileSchemeCookies(std::move(allow),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_success
,
             bool success) {*out_success = std::move(success);
            loop->Quit();
          },
          &loop,
          out_success));
  loop.Run();
}
void CookieManagerAsyncWaiter::SetStorageAccessGrantSettings(
    WTF::Vector<::content_settings::mojom::blink::ContentSettingPatternSourcePtr> settings) {
  base::RunLoop loop;
  proxy_->SetStorageAccessGrantSettings(std::move(settings),
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}





}  // namespace blink
}  // namespace mojom
}  // namespace network

#if defined(__clang__)
#pragma clang diagnostic pop
#endif