// services/network/public/mojom/cookie_manager.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/network/public/mojom/cookie_manager.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "services/network/public/mojom/cookie_manager.mojom-params-data.h"
#include "services/network/public/mojom/cookie_manager.mojom-shared-message-ids.h"

#include "services/network/public/mojom/cookie_manager.mojom-blink-import-headers.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_COOKIE_MANAGER_MOJOM_BLINK_JUMBO_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_COOKIE_MANAGER_MOJOM_BLINK_JUMBO_H_
#endif
namespace network {
namespace mojom {
namespace blink {
CookieManagerParams::CookieManagerParams()
    : block_third_party_cookies(false),
      settings(),
      secure_origin_cookies_allowed_schemes(),
      matching_scheme_cookies_allowed_schemes(),
      third_party_cookies_allowed_schemes(),
      allow_file_scheme_cookies(false),
      settings_for_legacy_cookie_access(),
      settings_for_storage_access(),
      cookie_access_delegate_type(CookieAccessDelegateType::USE_CONTENT_SETTINGS) {}

CookieManagerParams::CookieManagerParams(
    bool block_third_party_cookies_in,
    WTF::Vector<::content_settings::mojom::blink::ContentSettingPatternSourcePtr> settings_in,
    WTF::Vector<WTF::String> secure_origin_cookies_allowed_schemes_in,
    WTF::Vector<WTF::String> matching_scheme_cookies_allowed_schemes_in,
    WTF::Vector<WTF::String> third_party_cookies_allowed_schemes_in,
    bool allow_file_scheme_cookies_in,
    WTF::Vector<::content_settings::mojom::blink::ContentSettingPatternSourcePtr> settings_for_legacy_cookie_access_in,
    WTF::Vector<::content_settings::mojom::blink::ContentSettingPatternSourcePtr> settings_for_storage_access_in,
    CookieAccessDelegateType cookie_access_delegate_type_in)
    : block_third_party_cookies(std::move(block_third_party_cookies_in)),
      settings(std::move(settings_in)),
      secure_origin_cookies_allowed_schemes(std::move(secure_origin_cookies_allowed_schemes_in)),
      matching_scheme_cookies_allowed_schemes(std::move(matching_scheme_cookies_allowed_schemes_in)),
      third_party_cookies_allowed_schemes(std::move(third_party_cookies_allowed_schemes_in)),
      allow_file_scheme_cookies(std::move(allow_file_scheme_cookies_in)),
      settings_for_legacy_cookie_access(std::move(settings_for_legacy_cookie_access_in)),
      settings_for_storage_access(std::move(settings_for_storage_access_in)),
      cookie_access_delegate_type(std::move(cookie_access_delegate_type_in)) {}

CookieManagerParams::~CookieManagerParams() = default;

void CookieManagerParams::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "block_third_party_cookies"), this->block_third_party_cookies, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "settings"), this->settings, 
      "<value of type WTF::Vector<::content_settings::mojom::blink::ContentSettingPatternSourcePtr>>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "secure_origin_cookies_allowed_schemes"), this->secure_origin_cookies_allowed_schemes, 
      "<value of type const WTF::Vector<WTF::String>&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "matching_scheme_cookies_allowed_schemes"), this->matching_scheme_cookies_allowed_schemes, 
      "<value of type const WTF::Vector<WTF::String>&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "third_party_cookies_allowed_schemes"), this->third_party_cookies_allowed_schemes, 
      "<value of type const WTF::Vector<WTF::String>&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "allow_file_scheme_cookies"), this->allow_file_scheme_cookies, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "settings_for_legacy_cookie_access"), this->settings_for_legacy_cookie_access, 
      "<value of type WTF::Vector<::content_settings::mojom::blink::ContentSettingPatternSourcePtr>>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "settings_for_storage_access"), this->settings_for_storage_access, 
      "<value of type WTF::Vector<::content_settings::mojom::blink::ContentSettingPatternSourcePtr>>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "cookie_access_delegate_type"), this->cookie_access_delegate_type, 
      "<value of type CookieAccessDelegateType>");
}

bool CookieManagerParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
CookieSameSiteContext::CookieSameSiteContext()
    : context(ContextType::CROSS_SITE),
      schemeful_context(ContextType::CROSS_SITE) {}

CookieSameSiteContext::CookieSameSiteContext(
    ContextType context_in,
    ContextType schemeful_context_in)
    : context(std::move(context_in)),
      schemeful_context(std::move(schemeful_context_in)) {}

CookieSameSiteContext::~CookieSameSiteContext() = default;
size_t CookieSameSiteContext::Hash(size_t seed) const {
  seed = mojo::internal::WTFHash(seed, this->context);
  seed = mojo::internal::WTFHash(seed, this->schemeful_context);
  return seed;
}

void CookieSameSiteContext::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "context"), this->context, 
      "<value of type ContextType>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "schemeful_context"), this->schemeful_context, 
      "<value of type ContextType>");
}

bool CookieSameSiteContext::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
CookieOptions::CookieOptions()
    : exclude_httponly(true),
      same_site_cookie_context(),
      update_access_time(true),
      return_excluded_cookies(false),
      same_party_cookie_context_type(SamePartyCookieContextType::kCrossParty),
      full_party_context_size(0U),
      is_in_nontrivial_first_party_set(false) {}

CookieOptions::CookieOptions(
    bool exclude_httponly_in,
    CookieSameSiteContextPtr same_site_cookie_context_in,
    bool update_access_time_in,
    bool return_excluded_cookies_in,
    SamePartyCookieContextType same_party_cookie_context_type_in,
    uint32_t full_party_context_size_in,
    bool is_in_nontrivial_first_party_set_in)
    : exclude_httponly(std::move(exclude_httponly_in)),
      same_site_cookie_context(std::move(same_site_cookie_context_in)),
      update_access_time(std::move(update_access_time_in)),
      return_excluded_cookies(std::move(return_excluded_cookies_in)),
      same_party_cookie_context_type(std::move(same_party_cookie_context_type_in)),
      full_party_context_size(std::move(full_party_context_size_in)),
      is_in_nontrivial_first_party_set(std::move(is_in_nontrivial_first_party_set_in)) {}

CookieOptions::~CookieOptions() = default;
size_t CookieOptions::Hash(size_t seed) const {
  seed = mojo::internal::WTFHash(seed, this->exclude_httponly);
  seed = mojo::internal::WTFHash(seed, this->same_site_cookie_context);
  seed = mojo::internal::WTFHash(seed, this->update_access_time);
  seed = mojo::internal::WTFHash(seed, this->return_excluded_cookies);
  seed = mojo::internal::WTFHash(seed, this->same_party_cookie_context_type);
  seed = mojo::internal::WTFHash(seed, this->full_party_context_size);
  seed = mojo::internal::WTFHash(seed, this->is_in_nontrivial_first_party_set);
  return seed;
}

void CookieOptions::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "exclude_httponly"), this->exclude_httponly, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "same_site_cookie_context"), this->same_site_cookie_context, 
      "<value of type CookieSameSiteContextPtr>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "update_access_time"), this->update_access_time, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "return_excluded_cookies"), this->return_excluded_cookies, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "same_party_cookie_context_type"), this->same_party_cookie_context_type, 
      "<value of type SamePartyCookieContextType>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "full_party_context_size"), this->full_party_context_size, 
      "<value of type uint32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_in_nontrivial_first_party_set"), this->is_in_nontrivial_first_party_set, 
      "<value of type bool>");
}

bool CookieOptions::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
CanonicalCookie::CanonicalCookie()
    : name(),
      value(),
      domain(),
      path(),
      creation(),
      expiry(),
      last_access(),
      secure(false),
      httponly(false),
      site_restrictions(CookieSameSite::NO_RESTRICTION),
      priority(CookiePriority::MEDIUM),
      source_scheme(CookieSourceScheme::kUnset),
      same_party(false),
      source_port(-1) {}

CanonicalCookie::CanonicalCookie(
    const WTF::String& name_in,
    const WTF::String& value_in,
    const WTF::String& domain_in,
    const WTF::String& path_in,
    ::base::Time creation_in,
    ::base::Time expiry_in,
    ::base::Time last_access_in,
    bool secure_in,
    bool httponly_in,
    CookieSameSite site_restrictions_in,
    CookiePriority priority_in,
    CookieSourceScheme source_scheme_in,
    bool same_party_in,
    int32_t source_port_in)
    : name(std::move(name_in)),
      value(std::move(value_in)),
      domain(std::move(domain_in)),
      path(std::move(path_in)),
      creation(std::move(creation_in)),
      expiry(std::move(expiry_in)),
      last_access(std::move(last_access_in)),
      secure(std::move(secure_in)),
      httponly(std::move(httponly_in)),
      site_restrictions(std::move(site_restrictions_in)),
      priority(std::move(priority_in)),
      source_scheme(std::move(source_scheme_in)),
      same_party(std::move(same_party_in)),
      source_port(std::move(source_port_in)) {}

CanonicalCookie::~CanonicalCookie() = default;

void CanonicalCookie::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "name"), this->name, 
      "<value of type const WTF::String&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "value"), this->value, 
      "<value of type const WTF::String&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "domain"), this->domain, 
      "<value of type const WTF::String&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "path"), this->path, 
      "<value of type const WTF::String&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "creation"), this->creation, 
      "<value of type ::base::Time>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "expiry"), this->expiry, 
      "<value of type ::base::Time>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "last_access"), this->last_access, 
      "<value of type ::base::Time>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "secure"), this->secure, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "httponly"), this->httponly, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "site_restrictions"), this->site_restrictions, 
      "<value of type CookieSameSite>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "priority"), this->priority, 
      "<value of type CookiePriority>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "source_scheme"), this->source_scheme, 
      "<value of type CookieSourceScheme>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "same_party"), this->same_party, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "source_port"), this->source_port, 
      "<value of type int32_t>");
}

bool CanonicalCookie::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
CookieInclusionStatus::CookieInclusionStatus()
    : exclusion_reasons(),
      warning_reasons() {}

CookieInclusionStatus::CookieInclusionStatus(
    uint32_t exclusion_reasons_in,
    uint32_t warning_reasons_in)
    : exclusion_reasons(std::move(exclusion_reasons_in)),
      warning_reasons(std::move(warning_reasons_in)) {}

CookieInclusionStatus::~CookieInclusionStatus() = default;
size_t CookieInclusionStatus::Hash(size_t seed) const {
  seed = mojo::internal::WTFHash(seed, this->exclusion_reasons);
  seed = mojo::internal::WTFHash(seed, this->warning_reasons);
  return seed;
}

void CookieInclusionStatus::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "exclusion_reasons"), this->exclusion_reasons, 
      "<value of type uint32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "warning_reasons"), this->warning_reasons, 
      "<value of type uint32_t>");
}

bool CookieInclusionStatus::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
CookieAndLineWithAccessResult::CookieAndLineWithAccessResult()
    : cookie(),
      cookie_string(),
      access_result() {}

CookieAndLineWithAccessResult::CookieAndLineWithAccessResult(
    const base::Optional<::net::CanonicalCookie>& cookie_in,
    const WTF::String& cookie_string_in,
    CookieAccessResultPtr access_result_in)
    : cookie(std::move(cookie_in)),
      cookie_string(std::move(cookie_string_in)),
      access_result(std::move(access_result_in)) {}

CookieAndLineWithAccessResult::~CookieAndLineWithAccessResult() = default;

void CookieAndLineWithAccessResult::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "cookie"), this->cookie, 
      "<value of type const base::Optional<::net::CanonicalCookie>&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "cookie_string"), this->cookie_string, 
      "<value of type const WTF::String&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "access_result"), this->access_result, 
      "<value of type CookieAccessResultPtr>");
}

bool CookieAndLineWithAccessResult::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
CookieOrLineWithAccessResult::CookieOrLineWithAccessResult()
    : cookie_or_line(),
      access_result() {}

CookieOrLineWithAccessResult::CookieOrLineWithAccessResult(
    CookieOrLinePtr cookie_or_line_in,
    CookieAccessResultPtr access_result_in)
    : cookie_or_line(std::move(cookie_or_line_in)),
      access_result(std::move(access_result_in)) {}

CookieOrLineWithAccessResult::~CookieOrLineWithAccessResult() = default;

void CookieOrLineWithAccessResult::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "cookie_or_line"), this->cookie_or_line, 
      "<value of type CookieOrLinePtr>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "access_result"), this->access_result, 
      "<value of type CookieAccessResultPtr>");
}

bool CookieOrLineWithAccessResult::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
CookieAccessResult::CookieAccessResult()
    : effective_same_site(),
      access_semantics(),
      status(),
      is_allowed_to_access_secure_cookies() {}

CookieAccessResult::CookieAccessResult(
    CookieEffectiveSameSite effective_same_site_in,
    CookieAccessSemantics access_semantics_in,
    CookieInclusionStatusPtr status_in,
    bool is_allowed_to_access_secure_cookies_in)
    : effective_same_site(std::move(effective_same_site_in)),
      access_semantics(std::move(access_semantics_in)),
      status(std::move(status_in)),
      is_allowed_to_access_secure_cookies(std::move(is_allowed_to_access_secure_cookies_in)) {}

CookieAccessResult::~CookieAccessResult() = default;
size_t CookieAccessResult::Hash(size_t seed) const {
  seed = mojo::internal::WTFHash(seed, this->effective_same_site);
  seed = mojo::internal::WTFHash(seed, this->access_semantics);
  seed = mojo::internal::WTFHash(seed, this->status);
  seed = mojo::internal::WTFHash(seed, this->is_allowed_to_access_secure_cookies);
  return seed;
}

void CookieAccessResult::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "effective_same_site"), this->effective_same_site, 
      "<value of type CookieEffectiveSameSite>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "access_semantics"), this->access_semantics, 
      "<value of type CookieAccessSemantics>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "status"), this->status, 
      "<value of type CookieInclusionStatusPtr>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_allowed_to_access_secure_cookies"), this->is_allowed_to_access_secure_cookies, 
      "<value of type bool>");
}

bool CookieAccessResult::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
CookieWithAccessResult::CookieWithAccessResult()
    : cookie(),
      access_result() {}

CookieWithAccessResult::CookieWithAccessResult(
    const ::net::CanonicalCookie& cookie_in,
    CookieAccessResultPtr access_result_in)
    : cookie(std::move(cookie_in)),
      access_result(std::move(access_result_in)) {}

CookieWithAccessResult::~CookieWithAccessResult() = default;

void CookieWithAccessResult::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "cookie"), this->cookie, 
      "<value of type const ::net::CanonicalCookie&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "access_result"), this->access_result, 
      "<value of type CookieAccessResultPtr>");
}

bool CookieWithAccessResult::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
CookieChangeInfo::CookieChangeInfo()
    : cookie(),
      access_result(),
      cause() {}

CookieChangeInfo::CookieChangeInfo(
    const ::net::CanonicalCookie& cookie_in,
    CookieAccessResultPtr access_result_in,
    CookieChangeCause cause_in)
    : cookie(std::move(cookie_in)),
      access_result(std::move(access_result_in)),
      cause(std::move(cause_in)) {}

CookieChangeInfo::~CookieChangeInfo() = default;

void CookieChangeInfo::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "cookie"), this->cookie, 
      "<value of type const ::net::CanonicalCookie&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "access_result"), this->access_result, 
      "<value of type CookieAccessResultPtr>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "cause"), this->cause, 
      "<value of type CookieChangeCause>");
}

bool CookieChangeInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
CookieDeletionFilter::CookieDeletionFilter()
    : created_after_time(),
      created_before_time(),
      excluding_domains(),
      including_domains(),
      cookie_name(),
      host_name(),
      url(),
      session_control(CookieDeletionSessionControl::IGNORE_CONTROL) {}

CookieDeletionFilter::CookieDeletionFilter(
    base::Optional<::base::Time> created_after_time_in,
    base::Optional<::base::Time> created_before_time_in,
    base::Optional<WTF::Vector<WTF::String>> excluding_domains_in,
    base::Optional<WTF::Vector<WTF::String>> including_domains_in,
    const WTF::String& cookie_name_in,
    const WTF::String& host_name_in,
    const base::Optional<::blink::KURL>& url_in,
    CookieDeletionSessionControl session_control_in)
    : created_after_time(std::move(created_after_time_in)),
      created_before_time(std::move(created_before_time_in)),
      excluding_domains(std::move(excluding_domains_in)),
      including_domains(std::move(including_domains_in)),
      cookie_name(std::move(cookie_name_in)),
      host_name(std::move(host_name_in)),
      url(std::move(url_in)),
      session_control(std::move(session_control_in)) {}

CookieDeletionFilter::~CookieDeletionFilter() = default;

void CookieDeletionFilter::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "created_after_time"), this->created_after_time, 
      "<value of type base::Optional<::base::Time>>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "created_before_time"), this->created_before_time, 
      "<value of type base::Optional<::base::Time>>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "excluding_domains"), this->excluding_domains, 
      "<value of type const base::Optional<WTF::Vector<WTF::String>>&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "including_domains"), this->including_domains, 
      "<value of type const base::Optional<WTF::Vector<WTF::String>>&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "cookie_name"), this->cookie_name, 
      "<value of type const WTF::String&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "host_name"), this->host_name, 
      "<value of type const WTF::String&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "url"), this->url, 
      "<value of type const base::Optional<::blink::KURL>&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "session_control"), this->session_control, 
      "<value of type CookieDeletionSessionControl>");
}

bool CookieDeletionFilter::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
CookieOrLine::CookieOrLine() : tag_(Tag::COOKIE) {
  data_.cookie = new ::net::CanonicalCookie;
}

CookieOrLine::~CookieOrLine() {
  DestroyActive();
}


void CookieOrLine::set_cookie(
    const ::net::CanonicalCookie& cookie) {
  if (tag_ == Tag::COOKIE) {
    *(data_.cookie) = std::move(cookie);
  } else {
    DestroyActive();
    tag_ = Tag::COOKIE;
    data_.cookie = new ::net::CanonicalCookie(
        std::move(cookie));
  }
}
void CookieOrLine::set_cookie_string(
    const WTF::String& cookie_string) {
  if (tag_ == Tag::COOKIE_STRING) {
    *(data_.cookie_string) = std::move(cookie_string);
  } else {
    DestroyActive();
    tag_ = Tag::COOKIE_STRING;
    data_.cookie_string = new WTF::String(
        std::move(cookie_string));
  }
}

void CookieOrLine::DestroyActive() {
  switch (tag_) {

    case Tag::COOKIE:

      delete data_.cookie;
      break;
    case Tag::COOKIE_STRING:

      delete data_.cookie_string;
      break;
  }
}

bool CookieOrLine::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
const char CookieChangeListener::Name_[] = "network.mojom.CookieChangeListener";

CookieChangeListenerProxy::CookieChangeListenerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void CookieChangeListenerProxy::OnCookieChange(
    CookieChangeInfoPtr in_change) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::CookieChangeListener::OnCookieChange", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("change"), in_change, 
                        "<value of type CookieChangeInfoPtr>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kCookieChangeListener_OnCookieChange_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::CookieChangeListener_OnCookieChange_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->change)::BaseType> change_fragment(
          params.message());
  mojo::internal::Serialize<::network::mojom::CookieChangeInfoDataView>(
      in_change, change_fragment);
  params->change.Set(
      change_fragment.is_null() ? nullptr : change_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->change.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null change in CookieChangeListener.OnCookieChange request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CookieChangeListener::Name_);
  message.set_method_name("OnCookieChange");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool CookieChangeListenerStubDispatch::Accept(
    CookieChangeListener* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kCookieChangeListener_OnCookieChange_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::CookieChangeListener::OnCookieChange",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::CookieChangeListener::OnCookieChange");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::CookieChangeListener_OnCookieChange_Params_Data* params =
          reinterpret_cast<internal::CookieChangeListener_OnCookieChange_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      CookieChangeInfoPtr p_change{};
      CookieChangeListener_OnCookieChange_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadChange(&p_change))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CookieChangeListener::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnCookieChange(
std::move(p_change));
      return true;
    }
  }
  return false;
}

// static
bool CookieChangeListenerStubDispatch::AcceptWithResponder(
    CookieChangeListener* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kCookieChangeListener_OnCookieChange_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kCookieChangeListenerValidationInfo[] = {
    {internal::kCookieChangeListener_OnCookieChange_Name,
     {&internal::CookieChangeListener_OnCookieChange_Params_Data::Validate,
      nullptr /* no response */}},
};

bool CookieChangeListenerRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::network::mojom::blink::CookieChangeListener::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kCookieChangeListenerValidationInfo);
}

const char CookieRemoteAccessFilter::Name_[] = "network.mojom.CookieRemoteAccessFilter";

class CookieRemoteAccessFilter_AllowedAccess_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  CookieRemoteAccessFilter_AllowedAccess_ForwardToCallback(
      CookieRemoteAccessFilter::AllowedAccessCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  CookieRemoteAccessFilter::AllowedAccessCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(CookieRemoteAccessFilter_AllowedAccess_ForwardToCallback);
};

CookieRemoteAccessFilterProxy::CookieRemoteAccessFilterProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void CookieRemoteAccessFilterProxy::AllowedAccess(
    const ::blink::KURL& in_url, const ::net::SiteForCookies& in_site_for_cookies, AllowedAccessCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::CookieRemoteAccessFilter::AllowedAccess", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url, 
                        "<value of type const ::blink::KURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("site_for_cookies"), in_site_for_cookies, 
                        "<value of type const ::net::SiteForCookies&>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kCookieRemoteAccessFilter_AllowedAccess_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::CookieRemoteAccessFilter_AllowedAccess_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_url, url_fragment);
  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->url.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url in CookieRemoteAccessFilter.AllowedAccess request");
  mojo::internal::MessageFragment<
      typename decltype(params->site_for_cookies)::BaseType> site_for_cookies_fragment(
          params.message());
  mojo::internal::Serialize<::network::mojom::SiteForCookiesDataView>(
      in_site_for_cookies, site_for_cookies_fragment);
  params->site_for_cookies.Set(
      site_for_cookies_fragment.is_null() ? nullptr : site_for_cookies_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->site_for_cookies.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null site_for_cookies in CookieRemoteAccessFilter.AllowedAccess request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CookieRemoteAccessFilter::Name_);
  message.set_method_name("AllowedAccess");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new CookieRemoteAccessFilter_AllowedAccess_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
class CookieRemoteAccessFilter_AllowedAccess_ProxyToResponder {
 public:
  static CookieRemoteAccessFilter::AllowedAccessCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<CookieRemoteAccessFilter_AllowedAccess_ProxyToResponder> proxy(
        new CookieRemoteAccessFilter_AllowedAccess_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&CookieRemoteAccessFilter_AllowedAccess_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~CookieRemoteAccessFilter_AllowedAccess_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  CookieRemoteAccessFilter_AllowedAccess_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "CookieRemoteAccessFilter::AllowedAccessCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_allowed);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(CookieRemoteAccessFilter_AllowedAccess_ProxyToResponder);
};

bool CookieRemoteAccessFilter_AllowedAccess_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "network::mojom::CookieRemoteAccessFilter::AllowedAccessCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::CookieRemoteAccessFilter_AllowedAccess_ResponseParams_Data* params =
      reinterpret_cast<
          internal::CookieRemoteAccessFilter_AllowedAccess_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  bool p_allowed{};
  CookieRemoteAccessFilter_AllowedAccess_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_allowed = input_data_view.allowed();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        CookieRemoteAccessFilter::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_allowed));
  return true;
}

void CookieRemoteAccessFilter_AllowedAccess_ProxyToResponder::Run(
    bool in_allowed) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)network::mojom::CookieRemoteAccessFilter::AllowedAccessCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("allowed"), in_allowed, 
                        "<value of type bool>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kCookieRemoteAccessFilter_AllowedAccess_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::CookieRemoteAccessFilter_AllowedAccess_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->allowed = in_allowed;

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)network::mojom::CookieRemoteAccessFilter::AllowedAccessCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CookieRemoteAccessFilter::Name_);
  message.set_method_name("AllowedAccess");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool CookieRemoteAccessFilterStubDispatch::Accept(
    CookieRemoteAccessFilter* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kCookieRemoteAccessFilter_AllowedAccess_Name: {
      break;
    }
  }
  return false;
}

// static
bool CookieRemoteAccessFilterStubDispatch::AcceptWithResponder(
    CookieRemoteAccessFilter* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kCookieRemoteAccessFilter_AllowedAccess_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::CookieRemoteAccessFilter::AllowedAccess",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::CookieRemoteAccessFilter::AllowedAccess");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::CookieRemoteAccessFilter_AllowedAccess_Params_Data* params =
          reinterpret_cast<
              internal::CookieRemoteAccessFilter_AllowedAccess_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::blink::KURL p_url{};
      ::net::SiteForCookies p_site_for_cookies{};
      CookieRemoteAccessFilter_AllowedAccess_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (success && !input_data_view.ReadSiteForCookies(&p_site_for_cookies))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CookieRemoteAccessFilter::Name_, 0, false);
        return false;
      }
      CookieRemoteAccessFilter::AllowedAccessCallback callback =
          CookieRemoteAccessFilter_AllowedAccess_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AllowedAccess(
std::move(p_url), 
std::move(p_site_for_cookies), std::move(callback));
      return true;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kCookieRemoteAccessFilterValidationInfo[] = {
    {internal::kCookieRemoteAccessFilter_AllowedAccess_Name,
     {&internal::CookieRemoteAccessFilter_AllowedAccess_Params_Data::Validate,
      &internal::CookieRemoteAccessFilter_AllowedAccess_ResponseParams_Data::Validate}},
};

bool CookieRemoteAccessFilterRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::network::mojom::blink::CookieRemoteAccessFilter::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kCookieRemoteAccessFilterValidationInfo);
}

bool CookieRemoteAccessFilterResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::network::mojom::blink::CookieRemoteAccessFilter::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kCookieRemoteAccessFilterValidationInfo);

}
const char CookieManager::Name_[] = "network.mojom.CookieManager";

class CookieManager_GetAllCookies_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  CookieManager_GetAllCookies_ForwardToCallback(
      CookieManager::GetAllCookiesCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  CookieManager::GetAllCookiesCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(CookieManager_GetAllCookies_ForwardToCallback);
};

class CookieManager_GetAllCookiesWithAccessSemantics_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  CookieManager_GetAllCookiesWithAccessSemantics_ForwardToCallback(
      CookieManager::GetAllCookiesWithAccessSemanticsCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  CookieManager::GetAllCookiesWithAccessSemanticsCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(CookieManager_GetAllCookiesWithAccessSemantics_ForwardToCallback);
};

class CookieManager_GetCookieList_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  CookieManager_GetCookieList_ForwardToCallback(
      CookieManager::GetCookieListCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  CookieManager::GetCookieListCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(CookieManager_GetCookieList_ForwardToCallback);
};

class CookieManager_SetCanonicalCookie_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  CookieManager_SetCanonicalCookie_ForwardToCallback(
      CookieManager::SetCanonicalCookieCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  CookieManager::SetCanonicalCookieCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(CookieManager_SetCanonicalCookie_ForwardToCallback);
};

class CookieManager_DeleteCanonicalCookie_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  CookieManager_DeleteCanonicalCookie_ForwardToCallback(
      CookieManager::DeleteCanonicalCookieCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  CookieManager::DeleteCanonicalCookieCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(CookieManager_DeleteCanonicalCookie_ForwardToCallback);
};

class CookieManager_DeleteCookies_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  CookieManager_DeleteCookies_ForwardToCallback(
      CookieManager::DeleteCookiesCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  CookieManager::DeleteCookiesCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(CookieManager_DeleteCookies_ForwardToCallback);
};

class CookieManager_FlushCookieStore_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  CookieManager_FlushCookieStore_ForwardToCallback(
      CookieManager::FlushCookieStoreCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  CookieManager::FlushCookieStoreCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(CookieManager_FlushCookieStore_ForwardToCallback);
};

class CookieManager_AllowFileSchemeCookies_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  CookieManager_AllowFileSchemeCookies_ForwardToCallback(
      CookieManager::AllowFileSchemeCookiesCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  CookieManager::AllowFileSchemeCookiesCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(CookieManager_AllowFileSchemeCookies_ForwardToCallback);
};

class CookieManager_SetStorageAccessGrantSettings_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  CookieManager_SetStorageAccessGrantSettings_ForwardToCallback(
      CookieManager::SetStorageAccessGrantSettingsCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  CookieManager::SetStorageAccessGrantSettingsCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(CookieManager_SetStorageAccessGrantSettings_ForwardToCallback);
};

CookieManagerProxy::CookieManagerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void CookieManagerProxy::GetAllCookies(
    GetAllCookiesCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "network::mojom::CookieManager::GetAllCookies");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kCookieManager_GetAllCookies_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::CookieManager_GetAllCookies_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CookieManager::Name_);
  message.set_method_name("GetAllCookies");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new CookieManager_GetAllCookies_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void CookieManagerProxy::GetAllCookiesWithAccessSemantics(
    GetAllCookiesWithAccessSemanticsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "network::mojom::CookieManager::GetAllCookiesWithAccessSemantics");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kCookieManager_GetAllCookiesWithAccessSemantics_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::CookieManager_GetAllCookiesWithAccessSemantics_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CookieManager::Name_);
  message.set_method_name("GetAllCookiesWithAccessSemantics");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new CookieManager_GetAllCookiesWithAccessSemantics_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void CookieManagerProxy::GetCookieList(
    const ::blink::KURL& in_url, CookieOptionsPtr in_cookie_options, GetCookieListCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::CookieManager::GetCookieList", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url, 
                        "<value of type const ::blink::KURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("cookie_options"), in_cookie_options, 
                        "<value of type CookieOptionsPtr>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kCookieManager_GetCookieList_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::CookieManager_GetCookieList_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_url, url_fragment);
  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->url.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url in CookieManager.GetCookieList request");
  mojo::internal::MessageFragment<
      typename decltype(params->cookie_options)::BaseType> cookie_options_fragment(
          params.message());
  mojo::internal::Serialize<::network::mojom::CookieOptionsDataView>(
      in_cookie_options, cookie_options_fragment);
  params->cookie_options.Set(
      cookie_options_fragment.is_null() ? nullptr : cookie_options_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->cookie_options.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null cookie_options in CookieManager.GetCookieList request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CookieManager::Name_);
  message.set_method_name("GetCookieList");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new CookieManager_GetCookieList_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void CookieManagerProxy::SetCanonicalCookie(
    const ::net::CanonicalCookie& in_cookie, const ::blink::KURL& in_source_url, CookieOptionsPtr in_cookie_options, SetCanonicalCookieCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::CookieManager::SetCanonicalCookie", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("cookie"), in_cookie, 
                        "<value of type const ::net::CanonicalCookie&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("source_url"), in_source_url, 
                        "<value of type const ::blink::KURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("cookie_options"), in_cookie_options, 
                        "<value of type CookieOptionsPtr>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kCookieManager_SetCanonicalCookie_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::CookieManager_SetCanonicalCookie_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->cookie)::BaseType> cookie_fragment(
          params.message());
  mojo::internal::Serialize<::network::mojom::CanonicalCookieDataView>(
      in_cookie, cookie_fragment);
  params->cookie.Set(
      cookie_fragment.is_null() ? nullptr : cookie_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->cookie.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null cookie in CookieManager.SetCanonicalCookie request");
  mojo::internal::MessageFragment<
      typename decltype(params->source_url)::BaseType> source_url_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_source_url, source_url_fragment);
  params->source_url.Set(
      source_url_fragment.is_null() ? nullptr : source_url_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->source_url.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null source_url in CookieManager.SetCanonicalCookie request");
  mojo::internal::MessageFragment<
      typename decltype(params->cookie_options)::BaseType> cookie_options_fragment(
          params.message());
  mojo::internal::Serialize<::network::mojom::CookieOptionsDataView>(
      in_cookie_options, cookie_options_fragment);
  params->cookie_options.Set(
      cookie_options_fragment.is_null() ? nullptr : cookie_options_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->cookie_options.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null cookie_options in CookieManager.SetCanonicalCookie request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CookieManager::Name_);
  message.set_method_name("SetCanonicalCookie");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new CookieManager_SetCanonicalCookie_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void CookieManagerProxy::DeleteCanonicalCookie(
    const ::net::CanonicalCookie& in_cookie, DeleteCanonicalCookieCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::CookieManager::DeleteCanonicalCookie", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("cookie"), in_cookie, 
                        "<value of type const ::net::CanonicalCookie&>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kCookieManager_DeleteCanonicalCookie_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::CookieManager_DeleteCanonicalCookie_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->cookie)::BaseType> cookie_fragment(
          params.message());
  mojo::internal::Serialize<::network::mojom::CanonicalCookieDataView>(
      in_cookie, cookie_fragment);
  params->cookie.Set(
      cookie_fragment.is_null() ? nullptr : cookie_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->cookie.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null cookie in CookieManager.DeleteCanonicalCookie request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CookieManager::Name_);
  message.set_method_name("DeleteCanonicalCookie");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new CookieManager_DeleteCanonicalCookie_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void CookieManagerProxy::DeleteCookies(
    CookieDeletionFilterPtr in_filter, DeleteCookiesCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::CookieManager::DeleteCookies", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("filter"), in_filter, 
                        "<value of type CookieDeletionFilterPtr>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kCookieManager_DeleteCookies_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::CookieManager_DeleteCookies_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->filter)::BaseType> filter_fragment(
          params.message());
  mojo::internal::Serialize<::network::mojom::CookieDeletionFilterDataView>(
      in_filter, filter_fragment);
  params->filter.Set(
      filter_fragment.is_null() ? nullptr : filter_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->filter.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null filter in CookieManager.DeleteCookies request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CookieManager::Name_);
  message.set_method_name("DeleteCookies");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new CookieManager_DeleteCookies_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void CookieManagerProxy::AddCookieChangeListener(
    const ::blink::KURL& in_url, const WTF::String& in_name, ::mojo::PendingRemote<CookieChangeListener> in_listener) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::CookieManager::AddCookieChangeListener", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url, 
                        "<value of type const ::blink::KURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("name"), in_name, 
                        "<value of type const WTF::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("listener"), in_listener, 
                        "<value of type ::mojo::PendingRemote<CookieChangeListener>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kCookieManager_AddCookieChangeListener_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::CookieManager_AddCookieChangeListener_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_url, url_fragment);
  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->url.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url in CookieManager.AddCookieChangeListener request");
  mojo::internal::MessageFragment<
      typename decltype(params->name)::BaseType> name_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_name, name_fragment);
  params->name.Set(
      name_fragment.is_null() ? nullptr : name_fragment.data());
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::network::mojom::CookieChangeListenerInterfaceBase>>(
      in_listener, &params->listener, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->listener),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid listener in CookieManager.AddCookieChangeListener request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CookieManager::Name_);
  message.set_method_name("AddCookieChangeListener");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void CookieManagerProxy::AddGlobalChangeListener(
    ::mojo::PendingRemote<CookieChangeListener> in_notification_pointer) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::CookieManager::AddGlobalChangeListener", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("notification_pointer"), in_notification_pointer, 
                        "<value of type ::mojo::PendingRemote<CookieChangeListener>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kCookieManager_AddGlobalChangeListener_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::CookieManager_AddGlobalChangeListener_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::network::mojom::CookieChangeListenerInterfaceBase>>(
      in_notification_pointer, &params->notification_pointer, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->notification_pointer),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid notification_pointer in CookieManager.AddGlobalChangeListener request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CookieManager::Name_);
  message.set_method_name("AddGlobalChangeListener");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void CookieManagerProxy::CloneInterface(
    ::mojo::PendingReceiver<CookieManager> in_new_interface) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::CookieManager::CloneInterface", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("new_interface"), in_new_interface, 
                        "<value of type ::mojo::PendingReceiver<CookieManager>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kCookieManager_CloneInterface_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::CookieManager_CloneInterface_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::network::mojom::CookieManagerInterfaceBase>>(
      in_new_interface, &params->new_interface, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->new_interface),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid new_interface in CookieManager.CloneInterface request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CookieManager::Name_);
  message.set_method_name("CloneInterface");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void CookieManagerProxy::FlushCookieStore(
    FlushCookieStoreCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "network::mojom::CookieManager::FlushCookieStore");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kCookieManager_FlushCookieStore_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::CookieManager_FlushCookieStore_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CookieManager::Name_);
  message.set_method_name("FlushCookieStore");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new CookieManager_FlushCookieStore_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void CookieManagerProxy::AllowFileSchemeCookies(
    bool in_allow, AllowFileSchemeCookiesCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::CookieManager::AllowFileSchemeCookies", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("allow"), in_allow, 
                        "<value of type bool>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kCookieManager_AllowFileSchemeCookies_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::CookieManager_AllowFileSchemeCookies_Params_Data> params(
          message);
  params.Allocate();
  params->allow = in_allow;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CookieManager::Name_);
  message.set_method_name("AllowFileSchemeCookies");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new CookieManager_AllowFileSchemeCookies_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void CookieManagerProxy::SetContentSettings(
    WTF::Vector<::content_settings::mojom::blink::ContentSettingPatternSourcePtr> in_settings) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::CookieManager::SetContentSettings", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("settings"), in_settings, 
                        "<value of type WTF::Vector<::content_settings::mojom::blink::ContentSettingPatternSourcePtr>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kCookieManager_SetContentSettings_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::CookieManager_SetContentSettings_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->settings)::BaseType>
      settings_fragment(params.message());
  const mojo::internal::ContainerValidateParams settings_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::content_settings::mojom::ContentSettingPatternSourceDataView>>(
      in_settings, settings_fragment, &settings_validate_params);
  params->settings.Set(
      settings_fragment.is_null() ? nullptr : settings_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->settings.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null settings in CookieManager.SetContentSettings request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CookieManager::Name_);
  message.set_method_name("SetContentSettings");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void CookieManagerProxy::SetRemoteFilter(
    ::mojo::PendingRemote<CookieRemoteAccessFilter> in_remote_access_filter) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::CookieManager::SetRemoteFilter", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("remote_access_filter"), in_remote_access_filter, 
                        "<value of type ::mojo::PendingRemote<CookieRemoteAccessFilter>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kCookieManager_SetRemoteFilter_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::CookieManager_SetRemoteFilter_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::network::mojom::CookieRemoteAccessFilterInterfaceBase>>(
      in_remote_access_filter, &params->remote_access_filter, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->remote_access_filter),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid remote_access_filter in CookieManager.SetRemoteFilter request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CookieManager::Name_);
  message.set_method_name("SetRemoteFilter");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void CookieManagerProxy::SetForceKeepSessionState(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "network::mojom::CookieManager::SetForceKeepSessionState");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kCookieManager_SetForceKeepSessionState_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::CookieManager_SetForceKeepSessionState_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CookieManager::Name_);
  message.set_method_name("SetForceKeepSessionState");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void CookieManagerProxy::BlockThirdPartyCookies(
    bool in_block) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::CookieManager::BlockThirdPartyCookies", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("block"), in_block, 
                        "<value of type bool>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kCookieManager_BlockThirdPartyCookies_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::CookieManager_BlockThirdPartyCookies_Params_Data> params(
          message);
  params.Allocate();
  params->block = in_block;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CookieManager::Name_);
  message.set_method_name("BlockThirdPartyCookies");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void CookieManagerProxy::SetContentSettingsForLegacyCookieAccess(
    WTF::Vector<::content_settings::mojom::blink::ContentSettingPatternSourcePtr> in_settings) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::CookieManager::SetContentSettingsForLegacyCookieAccess", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("settings"), in_settings, 
                        "<value of type WTF::Vector<::content_settings::mojom::blink::ContentSettingPatternSourcePtr>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kCookieManager_SetContentSettingsForLegacyCookieAccess_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::CookieManager_SetContentSettingsForLegacyCookieAccess_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->settings)::BaseType>
      settings_fragment(params.message());
  const mojo::internal::ContainerValidateParams settings_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::content_settings::mojom::ContentSettingPatternSourceDataView>>(
      in_settings, settings_fragment, &settings_validate_params);
  params->settings.Set(
      settings_fragment.is_null() ? nullptr : settings_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->settings.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null settings in CookieManager.SetContentSettingsForLegacyCookieAccess request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CookieManager::Name_);
  message.set_method_name("SetContentSettingsForLegacyCookieAccess");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void CookieManagerProxy::SetStorageAccessGrantSettings(
    WTF::Vector<::content_settings::mojom::blink::ContentSettingPatternSourcePtr> in_settings, SetStorageAccessGrantSettingsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::CookieManager::SetStorageAccessGrantSettings", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("settings"), in_settings, 
                        "<value of type WTF::Vector<::content_settings::mojom::blink::ContentSettingPatternSourcePtr>>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kCookieManager_SetStorageAccessGrantSettings_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::CookieManager_SetStorageAccessGrantSettings_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->settings)::BaseType>
      settings_fragment(params.message());
  const mojo::internal::ContainerValidateParams settings_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::content_settings::mojom::ContentSettingPatternSourceDataView>>(
      in_settings, settings_fragment, &settings_validate_params);
  params->settings.Set(
      settings_fragment.is_null() ? nullptr : settings_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->settings.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null settings in CookieManager.SetStorageAccessGrantSettings request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CookieManager::Name_);
  message.set_method_name("SetStorageAccessGrantSettings");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new CookieManager_SetStorageAccessGrantSettings_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
class CookieManager_GetAllCookies_ProxyToResponder {
 public:
  static CookieManager::GetAllCookiesCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<CookieManager_GetAllCookies_ProxyToResponder> proxy(
        new CookieManager_GetAllCookies_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&CookieManager_GetAllCookies_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~CookieManager_GetAllCookies_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  CookieManager_GetAllCookies_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "CookieManager::GetAllCookiesCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      const WTF::Vector<::net::CanonicalCookie>& in_cookies);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(CookieManager_GetAllCookies_ProxyToResponder);
};

bool CookieManager_GetAllCookies_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "network::mojom::CookieManager::GetAllCookiesCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::CookieManager_GetAllCookies_ResponseParams_Data* params =
      reinterpret_cast<
          internal::CookieManager_GetAllCookies_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  WTF::Vector<::net::CanonicalCookie> p_cookies{};
  CookieManager_GetAllCookies_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadCookies(&p_cookies))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        CookieManager::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_cookies));
  return true;
}

void CookieManager_GetAllCookies_ProxyToResponder::Run(
    const WTF::Vector<::net::CanonicalCookie>& in_cookies) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)network::mojom::CookieManager::GetAllCookiesCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("cookies"), in_cookies, 
                        "<value of type const WTF::Vector<::net::CanonicalCookie>&>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kCookieManager_GetAllCookies_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::CookieManager_GetAllCookies_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->cookies)::BaseType>
      cookies_fragment(params.message());
  const mojo::internal::ContainerValidateParams cookies_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::CanonicalCookieDataView>>(
      in_cookies, cookies_fragment, &cookies_validate_params);
  params->cookies.Set(
      cookies_fragment.is_null() ? nullptr : cookies_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->cookies.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null cookies in ");

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)network::mojom::CookieManager::GetAllCookiesCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CookieManager::Name_);
  message.set_method_name("GetAllCookies");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class CookieManager_GetAllCookiesWithAccessSemantics_ProxyToResponder {
 public:
  static CookieManager::GetAllCookiesWithAccessSemanticsCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<CookieManager_GetAllCookiesWithAccessSemantics_ProxyToResponder> proxy(
        new CookieManager_GetAllCookiesWithAccessSemantics_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&CookieManager_GetAllCookiesWithAccessSemantics_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~CookieManager_GetAllCookiesWithAccessSemantics_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  CookieManager_GetAllCookiesWithAccessSemantics_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "CookieManager::GetAllCookiesWithAccessSemanticsCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      const WTF::Vector<::net::CanonicalCookie>& in_cookies, const WTF::Vector<CookieAccessSemantics>& in_access_semantics_list);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(CookieManager_GetAllCookiesWithAccessSemantics_ProxyToResponder);
};

bool CookieManager_GetAllCookiesWithAccessSemantics_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "network::mojom::CookieManager::GetAllCookiesWithAccessSemanticsCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::CookieManager_GetAllCookiesWithAccessSemantics_ResponseParams_Data* params =
      reinterpret_cast<
          internal::CookieManager_GetAllCookiesWithAccessSemantics_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  WTF::Vector<::net::CanonicalCookie> p_cookies{};
  WTF::Vector<CookieAccessSemantics> p_access_semantics_list{};
  CookieManager_GetAllCookiesWithAccessSemantics_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadCookies(&p_cookies))
    success = false;
  if (success && !input_data_view.ReadAccessSemanticsList(&p_access_semantics_list))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        CookieManager::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_cookies), 
std::move(p_access_semantics_list));
  return true;
}

void CookieManager_GetAllCookiesWithAccessSemantics_ProxyToResponder::Run(
    const WTF::Vector<::net::CanonicalCookie>& in_cookies, const WTF::Vector<CookieAccessSemantics>& in_access_semantics_list) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)network::mojom::CookieManager::GetAllCookiesWithAccessSemanticsCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("cookies"), in_cookies, 
                        "<value of type const WTF::Vector<::net::CanonicalCookie>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("access_semantics_list"), in_access_semantics_list, 
                        "<value of type const WTF::Vector<CookieAccessSemantics>&>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kCookieManager_GetAllCookiesWithAccessSemantics_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::CookieManager_GetAllCookiesWithAccessSemantics_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->cookies)::BaseType>
      cookies_fragment(params.message());
  const mojo::internal::ContainerValidateParams cookies_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::CanonicalCookieDataView>>(
      in_cookies, cookies_fragment, &cookies_validate_params);
  params->cookies.Set(
      cookies_fragment.is_null() ? nullptr : cookies_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->cookies.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null cookies in ");
  mojo::internal::MessageFragment<
      typename decltype(params->access_semantics_list)::BaseType>
      access_semantics_list_fragment(params.message());
  const mojo::internal::ContainerValidateParams access_semantics_list_validate_params(
      0, ::network::mojom::internal::CookieAccessSemantics_Data::Validate);
  mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::CookieAccessSemantics>>(
      in_access_semantics_list, access_semantics_list_fragment, &access_semantics_list_validate_params);
  params->access_semantics_list.Set(
      access_semantics_list_fragment.is_null() ? nullptr : access_semantics_list_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->access_semantics_list.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null access_semantics_list in ");

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)network::mojom::CookieManager::GetAllCookiesWithAccessSemanticsCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CookieManager::Name_);
  message.set_method_name("GetAllCookiesWithAccessSemantics");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class CookieManager_GetCookieList_ProxyToResponder {
 public:
  static CookieManager::GetCookieListCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<CookieManager_GetCookieList_ProxyToResponder> proxy(
        new CookieManager_GetCookieList_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&CookieManager_GetCookieList_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~CookieManager_GetCookieList_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  CookieManager_GetCookieList_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "CookieManager::GetCookieListCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      WTF::Vector<CookieWithAccessResultPtr> in_cookies, WTF::Vector<CookieWithAccessResultPtr> in_excluded_cookies);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(CookieManager_GetCookieList_ProxyToResponder);
};

bool CookieManager_GetCookieList_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "network::mojom::CookieManager::GetCookieListCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::CookieManager_GetCookieList_ResponseParams_Data* params =
      reinterpret_cast<
          internal::CookieManager_GetCookieList_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  WTF::Vector<CookieWithAccessResultPtr> p_cookies{};
  WTF::Vector<CookieWithAccessResultPtr> p_excluded_cookies{};
  CookieManager_GetCookieList_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadCookies(&p_cookies))
    success = false;
  if (success && !input_data_view.ReadExcludedCookies(&p_excluded_cookies))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        CookieManager::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_cookies), 
std::move(p_excluded_cookies));
  return true;
}

void CookieManager_GetCookieList_ProxyToResponder::Run(
    WTF::Vector<CookieWithAccessResultPtr> in_cookies, WTF::Vector<CookieWithAccessResultPtr> in_excluded_cookies) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)network::mojom::CookieManager::GetCookieListCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("cookies"), in_cookies, 
                        "<value of type WTF::Vector<CookieWithAccessResultPtr>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("excluded_cookies"), in_excluded_cookies, 
                        "<value of type WTF::Vector<CookieWithAccessResultPtr>>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kCookieManager_GetCookieList_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::CookieManager_GetCookieList_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->cookies)::BaseType>
      cookies_fragment(params.message());
  const mojo::internal::ContainerValidateParams cookies_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::CookieWithAccessResultDataView>>(
      in_cookies, cookies_fragment, &cookies_validate_params);
  params->cookies.Set(
      cookies_fragment.is_null() ? nullptr : cookies_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->cookies.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null cookies in ");
  mojo::internal::MessageFragment<
      typename decltype(params->excluded_cookies)::BaseType>
      excluded_cookies_fragment(params.message());
  const mojo::internal::ContainerValidateParams excluded_cookies_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::CookieWithAccessResultDataView>>(
      in_excluded_cookies, excluded_cookies_fragment, &excluded_cookies_validate_params);
  params->excluded_cookies.Set(
      excluded_cookies_fragment.is_null() ? nullptr : excluded_cookies_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->excluded_cookies.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null excluded_cookies in ");

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)network::mojom::CookieManager::GetCookieListCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CookieManager::Name_);
  message.set_method_name("GetCookieList");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class CookieManager_SetCanonicalCookie_ProxyToResponder {
 public:
  static CookieManager::SetCanonicalCookieCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<CookieManager_SetCanonicalCookie_ProxyToResponder> proxy(
        new CookieManager_SetCanonicalCookie_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&CookieManager_SetCanonicalCookie_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~CookieManager_SetCanonicalCookie_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  CookieManager_SetCanonicalCookie_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "CookieManager::SetCanonicalCookieCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      CookieAccessResultPtr in_access_result);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(CookieManager_SetCanonicalCookie_ProxyToResponder);
};

bool CookieManager_SetCanonicalCookie_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "network::mojom::CookieManager::SetCanonicalCookieCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::CookieManager_SetCanonicalCookie_ResponseParams_Data* params =
      reinterpret_cast<
          internal::CookieManager_SetCanonicalCookie_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  CookieAccessResultPtr p_access_result{};
  CookieManager_SetCanonicalCookie_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadAccessResult(&p_access_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        CookieManager::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_access_result));
  return true;
}

void CookieManager_SetCanonicalCookie_ProxyToResponder::Run(
    CookieAccessResultPtr in_access_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)network::mojom::CookieManager::SetCanonicalCookieCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("access_result"), in_access_result, 
                        "<value of type CookieAccessResultPtr>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kCookieManager_SetCanonicalCookie_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::CookieManager_SetCanonicalCookie_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->access_result)::BaseType> access_result_fragment(
          params.message());
  mojo::internal::Serialize<::network::mojom::CookieAccessResultDataView>(
      in_access_result, access_result_fragment);
  params->access_result.Set(
      access_result_fragment.is_null() ? nullptr : access_result_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->access_result.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null access_result in ");

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)network::mojom::CookieManager::SetCanonicalCookieCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CookieManager::Name_);
  message.set_method_name("SetCanonicalCookie");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class CookieManager_DeleteCanonicalCookie_ProxyToResponder {
 public:
  static CookieManager::DeleteCanonicalCookieCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<CookieManager_DeleteCanonicalCookie_ProxyToResponder> proxy(
        new CookieManager_DeleteCanonicalCookie_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&CookieManager_DeleteCanonicalCookie_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~CookieManager_DeleteCanonicalCookie_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  CookieManager_DeleteCanonicalCookie_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "CookieManager::DeleteCanonicalCookieCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(CookieManager_DeleteCanonicalCookie_ProxyToResponder);
};

bool CookieManager_DeleteCanonicalCookie_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "network::mojom::CookieManager::DeleteCanonicalCookieCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::CookieManager_DeleteCanonicalCookie_ResponseParams_Data* params =
      reinterpret_cast<
          internal::CookieManager_DeleteCanonicalCookie_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  bool p_success{};
  CookieManager_DeleteCanonicalCookie_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        CookieManager::Name_, 4, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_success));
  return true;
}

void CookieManager_DeleteCanonicalCookie_ProxyToResponder::Run(
    bool in_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)network::mojom::CookieManager::DeleteCanonicalCookieCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success, 
                        "<value of type bool>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kCookieManager_DeleteCanonicalCookie_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::CookieManager_DeleteCanonicalCookie_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->success = in_success;

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)network::mojom::CookieManager::DeleteCanonicalCookieCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CookieManager::Name_);
  message.set_method_name("DeleteCanonicalCookie");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class CookieManager_DeleteCookies_ProxyToResponder {
 public:
  static CookieManager::DeleteCookiesCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<CookieManager_DeleteCookies_ProxyToResponder> proxy(
        new CookieManager_DeleteCookies_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&CookieManager_DeleteCookies_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~CookieManager_DeleteCookies_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  CookieManager_DeleteCookies_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "CookieManager::DeleteCookiesCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      uint32_t in_num_deleted);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(CookieManager_DeleteCookies_ProxyToResponder);
};

bool CookieManager_DeleteCookies_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "network::mojom::CookieManager::DeleteCookiesCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::CookieManager_DeleteCookies_ResponseParams_Data* params =
      reinterpret_cast<
          internal::CookieManager_DeleteCookies_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  uint32_t p_num_deleted{};
  CookieManager_DeleteCookies_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_num_deleted = input_data_view.num_deleted();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        CookieManager::Name_, 5, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_num_deleted));
  return true;
}

void CookieManager_DeleteCookies_ProxyToResponder::Run(
    uint32_t in_num_deleted) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)network::mojom::CookieManager::DeleteCookiesCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("num_deleted"), in_num_deleted, 
                        "<value of type uint32_t>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kCookieManager_DeleteCookies_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::CookieManager_DeleteCookies_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->num_deleted = in_num_deleted;

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)network::mojom::CookieManager::DeleteCookiesCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CookieManager::Name_);
  message.set_method_name("DeleteCookies");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class CookieManager_FlushCookieStore_ProxyToResponder {
 public:
  static CookieManager::FlushCookieStoreCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<CookieManager_FlushCookieStore_ProxyToResponder> proxy(
        new CookieManager_FlushCookieStore_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&CookieManager_FlushCookieStore_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~CookieManager_FlushCookieStore_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  CookieManager_FlushCookieStore_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "CookieManager::FlushCookieStoreCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(CookieManager_FlushCookieStore_ProxyToResponder);
};

bool CookieManager_FlushCookieStore_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "network::mojom::CookieManager::FlushCookieStoreCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::CookieManager_FlushCookieStore_ResponseParams_Data* params =
      reinterpret_cast<
          internal::CookieManager_FlushCookieStore_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  CookieManager_FlushCookieStore_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        CookieManager::Name_, 9, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run();
  return true;
}

void CookieManager_FlushCookieStore_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "(Impl)network::mojom::CookieManager::FlushCookieStoreCallback");
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kCookieManager_FlushCookieStore_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::CookieManager_FlushCookieStore_ResponseParams_Data> params(
          message);
  params.Allocate();

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)network::mojom::CookieManager::FlushCookieStoreCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CookieManager::Name_);
  message.set_method_name("FlushCookieStore");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class CookieManager_AllowFileSchemeCookies_ProxyToResponder {
 public:
  static CookieManager::AllowFileSchemeCookiesCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<CookieManager_AllowFileSchemeCookies_ProxyToResponder> proxy(
        new CookieManager_AllowFileSchemeCookies_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&CookieManager_AllowFileSchemeCookies_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~CookieManager_AllowFileSchemeCookies_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  CookieManager_AllowFileSchemeCookies_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "CookieManager::AllowFileSchemeCookiesCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(CookieManager_AllowFileSchemeCookies_ProxyToResponder);
};

bool CookieManager_AllowFileSchemeCookies_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "network::mojom::CookieManager::AllowFileSchemeCookiesCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::CookieManager_AllowFileSchemeCookies_ResponseParams_Data* params =
      reinterpret_cast<
          internal::CookieManager_AllowFileSchemeCookies_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  bool p_success{};
  CookieManager_AllowFileSchemeCookies_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        CookieManager::Name_, 10, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_success));
  return true;
}

void CookieManager_AllowFileSchemeCookies_ProxyToResponder::Run(
    bool in_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)network::mojom::CookieManager::AllowFileSchemeCookiesCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success, 
                        "<value of type bool>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kCookieManager_AllowFileSchemeCookies_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::CookieManager_AllowFileSchemeCookies_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->success = in_success;

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)network::mojom::CookieManager::AllowFileSchemeCookiesCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CookieManager::Name_);
  message.set_method_name("AllowFileSchemeCookies");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class CookieManager_SetStorageAccessGrantSettings_ProxyToResponder {
 public:
  static CookieManager::SetStorageAccessGrantSettingsCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<CookieManager_SetStorageAccessGrantSettings_ProxyToResponder> proxy(
        new CookieManager_SetStorageAccessGrantSettings_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&CookieManager_SetStorageAccessGrantSettings_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~CookieManager_SetStorageAccessGrantSettings_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  CookieManager_SetStorageAccessGrantSettings_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "CookieManager::SetStorageAccessGrantSettingsCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(CookieManager_SetStorageAccessGrantSettings_ProxyToResponder);
};

bool CookieManager_SetStorageAccessGrantSettings_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "network::mojom::CookieManager::SetStorageAccessGrantSettingsCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::CookieManager_SetStorageAccessGrantSettings_ResponseParams_Data* params =
      reinterpret_cast<
          internal::CookieManager_SetStorageAccessGrantSettings_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  CookieManager_SetStorageAccessGrantSettings_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        CookieManager::Name_, 16, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run();
  return true;
}

void CookieManager_SetStorageAccessGrantSettings_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "(Impl)network::mojom::CookieManager::SetStorageAccessGrantSettingsCallback");
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kCookieManager_SetStorageAccessGrantSettings_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::CookieManager_SetStorageAccessGrantSettings_ResponseParams_Data> params(
          message);
  params.Allocate();

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)network::mojom::CookieManager::SetStorageAccessGrantSettingsCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CookieManager::Name_);
  message.set_method_name("SetStorageAccessGrantSettings");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool CookieManagerStubDispatch::Accept(
    CookieManager* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kCookieManager_GetAllCookies_Name: {
      break;
    }
    case internal::kCookieManager_GetAllCookiesWithAccessSemantics_Name: {
      break;
    }
    case internal::kCookieManager_GetCookieList_Name: {
      break;
    }
    case internal::kCookieManager_SetCanonicalCookie_Name: {
      break;
    }
    case internal::kCookieManager_DeleteCanonicalCookie_Name: {
      break;
    }
    case internal::kCookieManager_DeleteCookies_Name: {
      break;
    }
    case internal::kCookieManager_AddCookieChangeListener_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::CookieManager::AddCookieChangeListener",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::CookieManager::AddCookieChangeListener");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::CookieManager_AddCookieChangeListener_Params_Data* params =
          reinterpret_cast<internal::CookieManager_AddCookieChangeListener_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::blink::KURL p_url{};
      WTF::String p_name{};
      ::mojo::PendingRemote<CookieChangeListener> p_listener{};
      CookieManager_AddCookieChangeListener_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (success && !input_data_view.ReadName(&p_name))
        success = false;
      if (success) {
        p_listener =
            input_data_view.TakeListener<decltype(p_listener)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CookieManager::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AddCookieChangeListener(
std::move(p_url), 
std::move(p_name), 
std::move(p_listener));
      return true;
    }
    case internal::kCookieManager_AddGlobalChangeListener_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::CookieManager::AddGlobalChangeListener",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::CookieManager::AddGlobalChangeListener");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::CookieManager_AddGlobalChangeListener_Params_Data* params =
          reinterpret_cast<internal::CookieManager_AddGlobalChangeListener_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingRemote<CookieChangeListener> p_notification_pointer{};
      CookieManager_AddGlobalChangeListener_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_notification_pointer =
            input_data_view.TakeNotificationPointer<decltype(p_notification_pointer)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CookieManager::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AddGlobalChangeListener(
std::move(p_notification_pointer));
      return true;
    }
    case internal::kCookieManager_CloneInterface_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::CookieManager::CloneInterface",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::CookieManager::CloneInterface");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::CookieManager_CloneInterface_Params_Data* params =
          reinterpret_cast<internal::CookieManager_CloneInterface_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingReceiver<CookieManager> p_new_interface{};
      CookieManager_CloneInterface_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_new_interface =
            input_data_view.TakeNewInterface<decltype(p_new_interface)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CookieManager::Name_, 8, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CloneInterface(
std::move(p_new_interface));
      return true;
    }
    case internal::kCookieManager_FlushCookieStore_Name: {
      break;
    }
    case internal::kCookieManager_AllowFileSchemeCookies_Name: {
      break;
    }
    case internal::kCookieManager_SetContentSettings_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::CookieManager::SetContentSettings",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::CookieManager::SetContentSettings");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::CookieManager_SetContentSettings_Params_Data* params =
          reinterpret_cast<internal::CookieManager_SetContentSettings_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      WTF::Vector<::content_settings::mojom::blink::ContentSettingPatternSourcePtr> p_settings{};
      CookieManager_SetContentSettings_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSettings(&p_settings))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CookieManager::Name_, 11, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetContentSettings(
std::move(p_settings));
      return true;
    }
    case internal::kCookieManager_SetRemoteFilter_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::CookieManager::SetRemoteFilter",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::CookieManager::SetRemoteFilter");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::CookieManager_SetRemoteFilter_Params_Data* params =
          reinterpret_cast<internal::CookieManager_SetRemoteFilter_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingRemote<CookieRemoteAccessFilter> p_remote_access_filter{};
      CookieManager_SetRemoteFilter_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_remote_access_filter =
            input_data_view.TakeRemoteAccessFilter<decltype(p_remote_access_filter)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CookieManager::Name_, 12, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetRemoteFilter(
std::move(p_remote_access_filter));
      return true;
    }
    case internal::kCookieManager_SetForceKeepSessionState_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::CookieManager::SetForceKeepSessionState",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::CookieManager::SetForceKeepSessionState");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::CookieManager_SetForceKeepSessionState_Params_Data* params =
          reinterpret_cast<internal::CookieManager_SetForceKeepSessionState_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      CookieManager_SetForceKeepSessionState_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CookieManager::Name_, 13, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetForceKeepSessionState();
      return true;
    }
    case internal::kCookieManager_BlockThirdPartyCookies_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::CookieManager::BlockThirdPartyCookies",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::CookieManager::BlockThirdPartyCookies");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::CookieManager_BlockThirdPartyCookies_Params_Data* params =
          reinterpret_cast<internal::CookieManager_BlockThirdPartyCookies_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      bool p_block{};
      CookieManager_BlockThirdPartyCookies_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_block = input_data_view.block();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CookieManager::Name_, 14, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BlockThirdPartyCookies(
std::move(p_block));
      return true;
    }
    case internal::kCookieManager_SetContentSettingsForLegacyCookieAccess_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::CookieManager::SetContentSettingsForLegacyCookieAccess",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::CookieManager::SetContentSettingsForLegacyCookieAccess");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::CookieManager_SetContentSettingsForLegacyCookieAccess_Params_Data* params =
          reinterpret_cast<internal::CookieManager_SetContentSettingsForLegacyCookieAccess_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      WTF::Vector<::content_settings::mojom::blink::ContentSettingPatternSourcePtr> p_settings{};
      CookieManager_SetContentSettingsForLegacyCookieAccess_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSettings(&p_settings))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CookieManager::Name_, 15, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetContentSettingsForLegacyCookieAccess(
std::move(p_settings));
      return true;
    }
    case internal::kCookieManager_SetStorageAccessGrantSettings_Name: {
      break;
    }
  }
  return false;
}

// static
bool CookieManagerStubDispatch::AcceptWithResponder(
    CookieManager* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kCookieManager_GetAllCookies_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::CookieManager::GetAllCookies",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::CookieManager::GetAllCookies");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::CookieManager_GetAllCookies_Params_Data* params =
          reinterpret_cast<
              internal::CookieManager_GetAllCookies_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      CookieManager_GetAllCookies_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CookieManager::Name_, 0, false);
        return false;
      }
      CookieManager::GetAllCookiesCallback callback =
          CookieManager_GetAllCookies_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetAllCookies(std::move(callback));
      return true;
    }
    case internal::kCookieManager_GetAllCookiesWithAccessSemantics_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::CookieManager::GetAllCookiesWithAccessSemantics",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::CookieManager::GetAllCookiesWithAccessSemantics");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::CookieManager_GetAllCookiesWithAccessSemantics_Params_Data* params =
          reinterpret_cast<
              internal::CookieManager_GetAllCookiesWithAccessSemantics_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      CookieManager_GetAllCookiesWithAccessSemantics_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CookieManager::Name_, 1, false);
        return false;
      }
      CookieManager::GetAllCookiesWithAccessSemanticsCallback callback =
          CookieManager_GetAllCookiesWithAccessSemantics_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetAllCookiesWithAccessSemantics(std::move(callback));
      return true;
    }
    case internal::kCookieManager_GetCookieList_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::CookieManager::GetCookieList",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::CookieManager::GetCookieList");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::CookieManager_GetCookieList_Params_Data* params =
          reinterpret_cast<
              internal::CookieManager_GetCookieList_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::blink::KURL p_url{};
      CookieOptionsPtr p_cookie_options{};
      CookieManager_GetCookieList_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (success && !input_data_view.ReadCookieOptions(&p_cookie_options))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CookieManager::Name_, 2, false);
        return false;
      }
      CookieManager::GetCookieListCallback callback =
          CookieManager_GetCookieList_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetCookieList(
std::move(p_url), 
std::move(p_cookie_options), std::move(callback));
      return true;
    }
    case internal::kCookieManager_SetCanonicalCookie_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::CookieManager::SetCanonicalCookie",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::CookieManager::SetCanonicalCookie");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::CookieManager_SetCanonicalCookie_Params_Data* params =
          reinterpret_cast<
              internal::CookieManager_SetCanonicalCookie_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::net::CanonicalCookie p_cookie{};
      ::blink::KURL p_source_url{};
      CookieOptionsPtr p_cookie_options{};
      CookieManager_SetCanonicalCookie_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadCookie(&p_cookie))
        success = false;
      if (success && !input_data_view.ReadSourceUrl(&p_source_url))
        success = false;
      if (success && !input_data_view.ReadCookieOptions(&p_cookie_options))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CookieManager::Name_, 3, false);
        return false;
      }
      CookieManager::SetCanonicalCookieCallback callback =
          CookieManager_SetCanonicalCookie_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetCanonicalCookie(
std::move(p_cookie), 
std::move(p_source_url), 
std::move(p_cookie_options), std::move(callback));
      return true;
    }
    case internal::kCookieManager_DeleteCanonicalCookie_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::CookieManager::DeleteCanonicalCookie",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::CookieManager::DeleteCanonicalCookie");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::CookieManager_DeleteCanonicalCookie_Params_Data* params =
          reinterpret_cast<
              internal::CookieManager_DeleteCanonicalCookie_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::net::CanonicalCookie p_cookie{};
      CookieManager_DeleteCanonicalCookie_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadCookie(&p_cookie))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CookieManager::Name_, 4, false);
        return false;
      }
      CookieManager::DeleteCanonicalCookieCallback callback =
          CookieManager_DeleteCanonicalCookie_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DeleteCanonicalCookie(
std::move(p_cookie), std::move(callback));
      return true;
    }
    case internal::kCookieManager_DeleteCookies_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::CookieManager::DeleteCookies",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::CookieManager::DeleteCookies");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::CookieManager_DeleteCookies_Params_Data* params =
          reinterpret_cast<
              internal::CookieManager_DeleteCookies_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      CookieDeletionFilterPtr p_filter{};
      CookieManager_DeleteCookies_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadFilter(&p_filter))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CookieManager::Name_, 5, false);
        return false;
      }
      CookieManager::DeleteCookiesCallback callback =
          CookieManager_DeleteCookies_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DeleteCookies(
std::move(p_filter), std::move(callback));
      return true;
    }
    case internal::kCookieManager_AddCookieChangeListener_Name: {
      break;
    }
    case internal::kCookieManager_AddGlobalChangeListener_Name: {
      break;
    }
    case internal::kCookieManager_CloneInterface_Name: {
      break;
    }
    case internal::kCookieManager_FlushCookieStore_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::CookieManager::FlushCookieStore",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::CookieManager::FlushCookieStore");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::CookieManager_FlushCookieStore_Params_Data* params =
          reinterpret_cast<
              internal::CookieManager_FlushCookieStore_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      CookieManager_FlushCookieStore_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CookieManager::Name_, 9, false);
        return false;
      }
      CookieManager::FlushCookieStoreCallback callback =
          CookieManager_FlushCookieStore_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->FlushCookieStore(std::move(callback));
      return true;
    }
    case internal::kCookieManager_AllowFileSchemeCookies_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::CookieManager::AllowFileSchemeCookies",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::CookieManager::AllowFileSchemeCookies");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::CookieManager_AllowFileSchemeCookies_Params_Data* params =
          reinterpret_cast<
              internal::CookieManager_AllowFileSchemeCookies_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      bool p_allow{};
      CookieManager_AllowFileSchemeCookies_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_allow = input_data_view.allow();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CookieManager::Name_, 10, false);
        return false;
      }
      CookieManager::AllowFileSchemeCookiesCallback callback =
          CookieManager_AllowFileSchemeCookies_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AllowFileSchemeCookies(
std::move(p_allow), std::move(callback));
      return true;
    }
    case internal::kCookieManager_SetContentSettings_Name: {
      break;
    }
    case internal::kCookieManager_SetRemoteFilter_Name: {
      break;
    }
    case internal::kCookieManager_SetForceKeepSessionState_Name: {
      break;
    }
    case internal::kCookieManager_BlockThirdPartyCookies_Name: {
      break;
    }
    case internal::kCookieManager_SetContentSettingsForLegacyCookieAccess_Name: {
      break;
    }
    case internal::kCookieManager_SetStorageAccessGrantSettings_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::CookieManager::SetStorageAccessGrantSettings",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::CookieManager::SetStorageAccessGrantSettings");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::CookieManager_SetStorageAccessGrantSettings_Params_Data* params =
          reinterpret_cast<
              internal::CookieManager_SetStorageAccessGrantSettings_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      WTF::Vector<::content_settings::mojom::blink::ContentSettingPatternSourcePtr> p_settings{};
      CookieManager_SetStorageAccessGrantSettings_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSettings(&p_settings))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CookieManager::Name_, 16, false);
        return false;
      }
      CookieManager::SetStorageAccessGrantSettingsCallback callback =
          CookieManager_SetStorageAccessGrantSettings_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetStorageAccessGrantSettings(
std::move(p_settings), std::move(callback));
      return true;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kCookieManagerValidationInfo[] = {
    {internal::kCookieManager_GetAllCookies_Name,
     {&internal::CookieManager_GetAllCookies_Params_Data::Validate,
      &internal::CookieManager_GetAllCookies_ResponseParams_Data::Validate}},
    {internal::kCookieManager_GetAllCookiesWithAccessSemantics_Name,
     {&internal::CookieManager_GetAllCookiesWithAccessSemantics_Params_Data::Validate,
      &internal::CookieManager_GetAllCookiesWithAccessSemantics_ResponseParams_Data::Validate}},
    {internal::kCookieManager_GetCookieList_Name,
     {&internal::CookieManager_GetCookieList_Params_Data::Validate,
      &internal::CookieManager_GetCookieList_ResponseParams_Data::Validate}},
    {internal::kCookieManager_SetCanonicalCookie_Name,
     {&internal::CookieManager_SetCanonicalCookie_Params_Data::Validate,
      &internal::CookieManager_SetCanonicalCookie_ResponseParams_Data::Validate}},
    {internal::kCookieManager_DeleteCanonicalCookie_Name,
     {&internal::CookieManager_DeleteCanonicalCookie_Params_Data::Validate,
      &internal::CookieManager_DeleteCanonicalCookie_ResponseParams_Data::Validate}},
    {internal::kCookieManager_DeleteCookies_Name,
     {&internal::CookieManager_DeleteCookies_Params_Data::Validate,
      &internal::CookieManager_DeleteCookies_ResponseParams_Data::Validate}},
    {internal::kCookieManager_AddCookieChangeListener_Name,
     {&internal::CookieManager_AddCookieChangeListener_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kCookieManager_AddGlobalChangeListener_Name,
     {&internal::CookieManager_AddGlobalChangeListener_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kCookieManager_CloneInterface_Name,
     {&internal::CookieManager_CloneInterface_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kCookieManager_FlushCookieStore_Name,
     {&internal::CookieManager_FlushCookieStore_Params_Data::Validate,
      &internal::CookieManager_FlushCookieStore_ResponseParams_Data::Validate}},
    {internal::kCookieManager_AllowFileSchemeCookies_Name,
     {&internal::CookieManager_AllowFileSchemeCookies_Params_Data::Validate,
      &internal::CookieManager_AllowFileSchemeCookies_ResponseParams_Data::Validate}},
    {internal::kCookieManager_SetContentSettings_Name,
     {&internal::CookieManager_SetContentSettings_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kCookieManager_SetRemoteFilter_Name,
     {&internal::CookieManager_SetRemoteFilter_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kCookieManager_SetForceKeepSessionState_Name,
     {&internal::CookieManager_SetForceKeepSessionState_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kCookieManager_BlockThirdPartyCookies_Name,
     {&internal::CookieManager_BlockThirdPartyCookies_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kCookieManager_SetContentSettingsForLegacyCookieAccess_Name,
     {&internal::CookieManager_SetContentSettingsForLegacyCookieAccess_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kCookieManager_SetStorageAccessGrantSettings_Name,
     {&internal::CookieManager_SetStorageAccessGrantSettings_Params_Data::Validate,
      &internal::CookieManager_SetStorageAccessGrantSettings_ResponseParams_Data::Validate}},
};

bool CookieManagerRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::network::mojom::blink::CookieManager::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kCookieManagerValidationInfo);
}

bool CookieManagerResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::network::mojom::blink::CookieManager::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kCookieManagerValidationInfo);

}
}  // namespace blink
}  // namespace mojom
}  // namespace network

namespace mojo {


// static
bool StructTraits<::network::mojom::blink::CookieManagerParams::DataView, ::network::mojom::blink::CookieManagerParamsPtr>::Read(
    ::network::mojom::blink::CookieManagerParams::DataView input,
    ::network::mojom::blink::CookieManagerParamsPtr* output) {
  bool success = true;
  ::network::mojom::blink::CookieManagerParamsPtr result(::network::mojom::blink::CookieManagerParams::New());
  
      if (success)
        result->block_third_party_cookies = input.block_third_party_cookies();
      if (success && !input.ReadSettings(&result->settings))
        success = false;
      if (success && !input.ReadSecureOriginCookiesAllowedSchemes(&result->secure_origin_cookies_allowed_schemes))
        success = false;
      if (success && !input.ReadMatchingSchemeCookiesAllowedSchemes(&result->matching_scheme_cookies_allowed_schemes))
        success = false;
      if (success && !input.ReadThirdPartyCookiesAllowedSchemes(&result->third_party_cookies_allowed_schemes))
        success = false;
      if (success)
        result->allow_file_scheme_cookies = input.allow_file_scheme_cookies();
      if (success && !input.ReadSettingsForLegacyCookieAccess(&result->settings_for_legacy_cookie_access))
        success = false;
      if (success && !input.ReadSettingsForStorageAccess(&result->settings_for_storage_access))
        success = false;
      if (success && !input.ReadCookieAccessDelegateType(&result->cookie_access_delegate_type))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::blink::CookieSameSiteContext::DataView, ::network::mojom::blink::CookieSameSiteContextPtr>::Read(
    ::network::mojom::blink::CookieSameSiteContext::DataView input,
    ::network::mojom::blink::CookieSameSiteContextPtr* output) {
  bool success = true;
  ::network::mojom::blink::CookieSameSiteContextPtr result(::network::mojom::blink::CookieSameSiteContext::New());
  
      if (success && !input.ReadContext(&result->context))
        success = false;
      if (success && !input.ReadSchemefulContext(&result->schemeful_context))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::blink::CookieOptions::DataView, ::network::mojom::blink::CookieOptionsPtr>::Read(
    ::network::mojom::blink::CookieOptions::DataView input,
    ::network::mojom::blink::CookieOptionsPtr* output) {
  bool success = true;
  ::network::mojom::blink::CookieOptionsPtr result(::network::mojom::blink::CookieOptions::New());
  
      if (success)
        result->exclude_httponly = input.exclude_httponly();
      if (success && !input.ReadSameSiteCookieContext(&result->same_site_cookie_context))
        success = false;
      if (success)
        result->update_access_time = input.update_access_time();
      if (success)
        result->return_excluded_cookies = input.return_excluded_cookies();
      if (success && !input.ReadSamePartyCookieContextType(&result->same_party_cookie_context_type))
        success = false;
      if (success)
        result->full_party_context_size = input.full_party_context_size();
      if (success)
        result->is_in_nontrivial_first_party_set = input.is_in_nontrivial_first_party_set();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::blink::CanonicalCookie::DataView, ::network::mojom::blink::CanonicalCookiePtr>::Read(
    ::network::mojom::blink::CanonicalCookie::DataView input,
    ::network::mojom::blink::CanonicalCookiePtr* output) {
  bool success = true;
  ::network::mojom::blink::CanonicalCookiePtr result(::network::mojom::blink::CanonicalCookie::New());
  
      if (success && !input.ReadName(&result->name))
        success = false;
      if (success && !input.ReadValue(&result->value))
        success = false;
      if (success && !input.ReadDomain(&result->domain))
        success = false;
      if (success && !input.ReadPath(&result->path))
        success = false;
      if (success && !input.ReadCreation(&result->creation))
        success = false;
      if (success && !input.ReadExpiry(&result->expiry))
        success = false;
      if (success && !input.ReadLastAccess(&result->last_access))
        success = false;
      if (success)
        result->secure = input.secure();
      if (success)
        result->httponly = input.httponly();
      if (success && !input.ReadSiteRestrictions(&result->site_restrictions))
        success = false;
      if (success && !input.ReadPriority(&result->priority))
        success = false;
      if (success && !input.ReadSourceScheme(&result->source_scheme))
        success = false;
      if (success)
        result->same_party = input.same_party();
      if (success)
        result->source_port = input.source_port();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::blink::CookieInclusionStatus::DataView, ::network::mojom::blink::CookieInclusionStatusPtr>::Read(
    ::network::mojom::blink::CookieInclusionStatus::DataView input,
    ::network::mojom::blink::CookieInclusionStatusPtr* output) {
  bool success = true;
  ::network::mojom::blink::CookieInclusionStatusPtr result(::network::mojom::blink::CookieInclusionStatus::New());
  
      if (success)
        result->exclusion_reasons = input.exclusion_reasons();
      if (success)
        result->warning_reasons = input.warning_reasons();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::blink::CookieAndLineWithAccessResult::DataView, ::network::mojom::blink::CookieAndLineWithAccessResultPtr>::Read(
    ::network::mojom::blink::CookieAndLineWithAccessResult::DataView input,
    ::network::mojom::blink::CookieAndLineWithAccessResultPtr* output) {
  bool success = true;
  ::network::mojom::blink::CookieAndLineWithAccessResultPtr result(::network::mojom::blink::CookieAndLineWithAccessResult::New());
  
      if (success && !input.ReadCookie(&result->cookie))
        success = false;
      if (success && !input.ReadCookieString(&result->cookie_string))
        success = false;
      if (success && !input.ReadAccessResult(&result->access_result))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::blink::CookieOrLineWithAccessResult::DataView, ::network::mojom::blink::CookieOrLineWithAccessResultPtr>::Read(
    ::network::mojom::blink::CookieOrLineWithAccessResult::DataView input,
    ::network::mojom::blink::CookieOrLineWithAccessResultPtr* output) {
  bool success = true;
  ::network::mojom::blink::CookieOrLineWithAccessResultPtr result(::network::mojom::blink::CookieOrLineWithAccessResult::New());
  
      if (success && !input.ReadCookieOrLine(&result->cookie_or_line))
        success = false;
      if (success && !input.ReadAccessResult(&result->access_result))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::blink::CookieAccessResult::DataView, ::network::mojom::blink::CookieAccessResultPtr>::Read(
    ::network::mojom::blink::CookieAccessResult::DataView input,
    ::network::mojom::blink::CookieAccessResultPtr* output) {
  bool success = true;
  ::network::mojom::blink::CookieAccessResultPtr result(::network::mojom::blink::CookieAccessResult::New());
  
      if (success && !input.ReadEffectiveSameSite(&result->effective_same_site))
        success = false;
      if (success && !input.ReadAccessSemantics(&result->access_semantics))
        success = false;
      if (success && !input.ReadStatus(&result->status))
        success = false;
      if (success)
        result->is_allowed_to_access_secure_cookies = input.is_allowed_to_access_secure_cookies();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::blink::CookieWithAccessResult::DataView, ::network::mojom::blink::CookieWithAccessResultPtr>::Read(
    ::network::mojom::blink::CookieWithAccessResult::DataView input,
    ::network::mojom::blink::CookieWithAccessResultPtr* output) {
  bool success = true;
  ::network::mojom::blink::CookieWithAccessResultPtr result(::network::mojom::blink::CookieWithAccessResult::New());
  
      if (success && !input.ReadCookie(&result->cookie))
        success = false;
      if (success && !input.ReadAccessResult(&result->access_result))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::blink::CookieChangeInfo::DataView, ::network::mojom::blink::CookieChangeInfoPtr>::Read(
    ::network::mojom::blink::CookieChangeInfo::DataView input,
    ::network::mojom::blink::CookieChangeInfoPtr* output) {
  bool success = true;
  ::network::mojom::blink::CookieChangeInfoPtr result(::network::mojom::blink::CookieChangeInfo::New());
  
      if (success && !input.ReadCookie(&result->cookie))
        success = false;
      if (success && !input.ReadAccessResult(&result->access_result))
        success = false;
      if (success && !input.ReadCause(&result->cause))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::blink::CookieDeletionFilter::DataView, ::network::mojom::blink::CookieDeletionFilterPtr>::Read(
    ::network::mojom::blink::CookieDeletionFilter::DataView input,
    ::network::mojom::blink::CookieDeletionFilterPtr* output) {
  bool success = true;
  ::network::mojom::blink::CookieDeletionFilterPtr result(::network::mojom::blink::CookieDeletionFilter::New());
  
      if (success && !input.ReadCreatedAfterTime(&result->created_after_time))
        success = false;
      if (success && !input.ReadCreatedBeforeTime(&result->created_before_time))
        success = false;
      if (success && !input.ReadExcludingDomains(&result->excluding_domains))
        success = false;
      if (success && !input.ReadIncludingDomains(&result->including_domains))
        success = false;
      if (success && !input.ReadCookieName(&result->cookie_name))
        success = false;
      if (success && !input.ReadHostName(&result->host_name))
        success = false;
      if (success && !input.ReadUrl(&result->url))
        success = false;
      if (success && !input.ReadSessionControl(&result->session_control))
        success = false;
  *output = std::move(result);
  return success;
}

// static
bool UnionTraits<::network::mojom::blink::CookieOrLine::DataView, ::network::mojom::blink::CookieOrLinePtr>::Read(
    ::network::mojom::blink::CookieOrLine::DataView input,
    ::network::mojom::blink::CookieOrLinePtr* output) {
  using UnionType = ::network::mojom::blink::CookieOrLine;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::COOKIE: {
      ::net::CanonicalCookie result_cookie;
      if (!input.ReadCookie(&result_cookie))
        return false;

      *output = UnionType::NewCookie(
          std::move(result_cookie));
      break;
    }
    case Tag::COOKIE_STRING: {
      WTF::String result_cookie_string;
      if (!input.ReadCookieString(&result_cookie_string))
        return false;

      *output = UnionType::NewCookieString(
          std::move(result_cookie_string));
      break;
    }
    default:
      return false;
  }
  return true;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif