// services/network/public/mojom/cors.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "services/network/public/mojom/cors.mojom-shared.h"

#include <utility>

#include "base/stl_util.h"  // for base::size()
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/network/public/mojom/cors.mojom-params-data.h"
namespace network {
namespace mojom {

std::string CorsPreflightPolicyToString(CorsPreflightPolicy value) {
  switch(value) {
    case CorsPreflightPolicy::kConsiderPreflight:
      return "CorsPreflightPolicy::kConsiderPreflight";
    case CorsPreflightPolicy::kPreventPreflight:
      return "CorsPreflightPolicy::kPreventPreflight";
    default:
      return base::StringPrintf("Unknown CorsPreflightPolicy value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, CorsPreflightPolicy value) {
  return os << CorsPreflightPolicyToString(value);
}

std::string CorsErrorToString(CorsError value) {
  switch(value) {
    case CorsError::kDisallowedByMode:
      return "CorsError::kDisallowedByMode";
    case CorsError::kInvalidResponse:
      return "CorsError::kInvalidResponse";
    case CorsError::kWildcardOriginNotAllowed:
      return "CorsError::kWildcardOriginNotAllowed";
    case CorsError::kMissingAllowOriginHeader:
      return "CorsError::kMissingAllowOriginHeader";
    case CorsError::kMultipleAllowOriginValues:
      return "CorsError::kMultipleAllowOriginValues";
    case CorsError::kInvalidAllowOriginValue:
      return "CorsError::kInvalidAllowOriginValue";
    case CorsError::kAllowOriginMismatch:
      return "CorsError::kAllowOriginMismatch";
    case CorsError::kInvalidAllowCredentials:
      return "CorsError::kInvalidAllowCredentials";
    case CorsError::kCorsDisabledScheme:
      return "CorsError::kCorsDisabledScheme";
    case CorsError::kPreflightInvalidStatus:
      return "CorsError::kPreflightInvalidStatus";
    case CorsError::kPreflightDisallowedRedirect:
      return "CorsError::kPreflightDisallowedRedirect";
    case CorsError::kPreflightWildcardOriginNotAllowed:
      return "CorsError::kPreflightWildcardOriginNotAllowed";
    case CorsError::kPreflightMissingAllowOriginHeader:
      return "CorsError::kPreflightMissingAllowOriginHeader";
    case CorsError::kPreflightMultipleAllowOriginValues:
      return "CorsError::kPreflightMultipleAllowOriginValues";
    case CorsError::kPreflightInvalidAllowOriginValue:
      return "CorsError::kPreflightInvalidAllowOriginValue";
    case CorsError::kPreflightAllowOriginMismatch:
      return "CorsError::kPreflightAllowOriginMismatch";
    case CorsError::kPreflightInvalidAllowCredentials:
      return "CorsError::kPreflightInvalidAllowCredentials";
    case CorsError::kPreflightMissingAllowExternal:
      return "CorsError::kPreflightMissingAllowExternal";
    case CorsError::kPreflightInvalidAllowExternal:
      return "CorsError::kPreflightInvalidAllowExternal";
    case CorsError::kInvalidAllowMethodsPreflightResponse:
      return "CorsError::kInvalidAllowMethodsPreflightResponse";
    case CorsError::kInvalidAllowHeadersPreflightResponse:
      return "CorsError::kInvalidAllowHeadersPreflightResponse";
    case CorsError::kMethodDisallowedByPreflightResponse:
      return "CorsError::kMethodDisallowedByPreflightResponse";
    case CorsError::kHeaderDisallowedByPreflightResponse:
      return "CorsError::kHeaderDisallowedByPreflightResponse";
    case CorsError::kRedirectContainsCredentials:
      return "CorsError::kRedirectContainsCredentials";
    case CorsError::kInsecurePrivateNetwork:
      return "CorsError::kInsecurePrivateNetwork";
    default:
      return base::StringPrintf("Unknown CorsError value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, CorsError value) {
  return os << CorsErrorToString(value);
}

namespace internal {

}  // namespace internal
}  // namespace mojom
}  // namespace network

namespace perfetto {

// static
void TraceFormatTraits<::network::mojom::CorsPreflightPolicy>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::network::mojom::CorsPreflightPolicy value) {
  return std::move(context).WriteString(::network::mojom::CorsPreflightPolicyToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::network::mojom::CorsError>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::network::mojom::CorsError value) {
  return std::move(context).WriteString(::network::mojom::CorsErrorToString(value));
}

} // namespace perfetto
