// services/network/public/mojom/cross_origin_opener_policy.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/network/public/mojom/cross_origin_opener_policy.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "services/network/public/mojom/cross_origin_opener_policy.mojom-params-data.h"
#include "services/network/public/mojom/cross_origin_opener_policy.mojom-shared-message-ids.h"

#include "services/network/public/mojom/cross_origin_opener_policy.mojom-blink-import-headers.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_CROSS_ORIGIN_OPENER_POLICY_MOJOM_BLINK_JUMBO_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_CROSS_ORIGIN_OPENER_POLICY_MOJOM_BLINK_JUMBO_H_
#endif
namespace network {
namespace mojom {
namespace blink {
CrossOriginOpenerPolicy::CrossOriginOpenerPolicy()
    : value(CrossOriginOpenerPolicyValue::kUnsafeNone),
      reporting_endpoint(),
      report_only_value(CrossOriginOpenerPolicyValue::kUnsafeNone),
      report_only_reporting_endpoint() {}

CrossOriginOpenerPolicy::CrossOriginOpenerPolicy(
    CrossOriginOpenerPolicyValue value_in,
    const WTF::String& reporting_endpoint_in,
    CrossOriginOpenerPolicyValue report_only_value_in,
    const WTF::String& report_only_reporting_endpoint_in)
    : value(std::move(value_in)),
      reporting_endpoint(std::move(reporting_endpoint_in)),
      report_only_value(std::move(report_only_value_in)),
      report_only_reporting_endpoint(std::move(report_only_reporting_endpoint_in)) {}

CrossOriginOpenerPolicy::~CrossOriginOpenerPolicy() = default;

void CrossOriginOpenerPolicy::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "value"), this->value, 
      "<value of type CrossOriginOpenerPolicyValue>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "reporting_endpoint"), this->reporting_endpoint, 
      "<value of type const WTF::String&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "report_only_value"), this->report_only_value, 
      "<value of type CrossOriginOpenerPolicyValue>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "report_only_reporting_endpoint"), this->report_only_reporting_endpoint, 
      "<value of type const WTF::String&>");
}

bool CrossOriginOpenerPolicy::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
const char CrossOriginOpenerPolicyReporter::Name_[] = "network.mojom.CrossOriginOpenerPolicyReporter";

CrossOriginOpenerPolicyReporterProxy::CrossOriginOpenerPolicyReporterProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void CrossOriginOpenerPolicyReporterProxy::QueueAccessReport(
    CoopAccessReportType in_report_type, const WTF::String& in_property, ::network::mojom::blink::SourceLocationPtr in_source_location, const WTF::String& in_reported_window_url) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::CrossOriginOpenerPolicyReporter::QueueAccessReport", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("report_type"), in_report_type, 
                        "<value of type CoopAccessReportType>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("property"), in_property, 
                        "<value of type const WTF::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("source_location"), in_source_location, 
                        "<value of type ::network::mojom::blink::SourceLocationPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("reported_window_url"), in_reported_window_url, 
                        "<value of type const WTF::String&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kCrossOriginOpenerPolicyReporter_QueueAccessReport_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::CrossOriginOpenerPolicyReporter_QueueAccessReport_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::network::mojom::CoopAccessReportType>(
      in_report_type, &params->report_type);
  mojo::internal::MessageFragment<
      typename decltype(params->property)::BaseType> property_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_property, property_fragment);
  params->property.Set(
      property_fragment.is_null() ? nullptr : property_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->property.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null property in CrossOriginOpenerPolicyReporter.QueueAccessReport request");
  mojo::internal::MessageFragment<
      typename decltype(params->source_location)::BaseType> source_location_fragment(
          params.message());
  mojo::internal::Serialize<::network::mojom::SourceLocationDataView>(
      in_source_location, source_location_fragment);
  params->source_location.Set(
      source_location_fragment.is_null() ? nullptr : source_location_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->source_location.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null source_location in CrossOriginOpenerPolicyReporter.QueueAccessReport request");
  mojo::internal::MessageFragment<
      typename decltype(params->reported_window_url)::BaseType> reported_window_url_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_reported_window_url, reported_window_url_fragment);
  params->reported_window_url.Set(
      reported_window_url_fragment.is_null() ? nullptr : reported_window_url_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->reported_window_url.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null reported_window_url in CrossOriginOpenerPolicyReporter.QueueAccessReport request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CrossOriginOpenerPolicyReporter::Name_);
  message.set_method_name("QueueAccessReport");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool CrossOriginOpenerPolicyReporterStubDispatch::Accept(
    CrossOriginOpenerPolicyReporter* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kCrossOriginOpenerPolicyReporter_QueueAccessReport_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::CrossOriginOpenerPolicyReporter::QueueAccessReport",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::CrossOriginOpenerPolicyReporter::QueueAccessReport");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::CrossOriginOpenerPolicyReporter_QueueAccessReport_Params_Data* params =
          reinterpret_cast<internal::CrossOriginOpenerPolicyReporter_QueueAccessReport_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      CoopAccessReportType p_report_type{};
      WTF::String p_property{};
      ::network::mojom::blink::SourceLocationPtr p_source_location{};
      WTF::String p_reported_window_url{};
      CrossOriginOpenerPolicyReporter_QueueAccessReport_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadReportType(&p_report_type))
        success = false;
      if (success && !input_data_view.ReadProperty(&p_property))
        success = false;
      if (success && !input_data_view.ReadSourceLocation(&p_source_location))
        success = false;
      if (success && !input_data_view.ReadReportedWindowUrl(&p_reported_window_url))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CrossOriginOpenerPolicyReporter::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->QueueAccessReport(
std::move(p_report_type), 
std::move(p_property), 
std::move(p_source_location), 
std::move(p_reported_window_url));
      return true;
    }
  }
  return false;
}

// static
bool CrossOriginOpenerPolicyReporterStubDispatch::AcceptWithResponder(
    CrossOriginOpenerPolicyReporter* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kCrossOriginOpenerPolicyReporter_QueueAccessReport_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kCrossOriginOpenerPolicyReporterValidationInfo[] = {
    {internal::kCrossOriginOpenerPolicyReporter_QueueAccessReport_Name,
     {&internal::CrossOriginOpenerPolicyReporter_QueueAccessReport_Params_Data::Validate,
      nullptr /* no response */}},
};

bool CrossOriginOpenerPolicyReporterRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::network::mojom::blink::CrossOriginOpenerPolicyReporter::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kCrossOriginOpenerPolicyReporterValidationInfo);
}

}  // namespace blink
}  // namespace mojom
}  // namespace network

namespace mojo {


// static
bool StructTraits<::network::mojom::blink::CrossOriginOpenerPolicy::DataView, ::network::mojom::blink::CrossOriginOpenerPolicyPtr>::Read(
    ::network::mojom::blink::CrossOriginOpenerPolicy::DataView input,
    ::network::mojom::blink::CrossOriginOpenerPolicyPtr* output) {
  bool success = true;
  ::network::mojom::blink::CrossOriginOpenerPolicyPtr result(::network::mojom::blink::CrossOriginOpenerPolicy::New());
  
      if (success && !input.ReadValue(&result->value))
        success = false;
      if (success && !input.ReadReportingEndpoint(&result->reporting_endpoint))
        success = false;
      if (success && !input.ReadReportOnlyValue(&result->report_only_value))
        success = false;
      if (success && !input.ReadReportOnlyReportingEndpoint(&result->report_only_reporting_endpoint))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif