// services/network/public/mojom/cross_origin_opener_policy.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "services/network/public/mojom/cross_origin_opener_policy.mojom-shared.h"

#include <utility>

#include "base/stl_util.h"  // for base::size()
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/network/public/mojom/cross_origin_opener_policy.mojom-params-data.h"
namespace network {
namespace mojom {

std::string CoopAccessReportTypeToString(CoopAccessReportType value) {
  switch(value) {
    case CoopAccessReportType::kAccessFromCoopPageToOpener:
      return "CoopAccessReportType::kAccessFromCoopPageToOpener";
    case CoopAccessReportType::kAccessFromCoopPageToOpenee:
      return "CoopAccessReportType::kAccessFromCoopPageToOpenee";
    case CoopAccessReportType::kAccessFromCoopPageToOther:
      return "CoopAccessReportType::kAccessFromCoopPageToOther";
    case CoopAccessReportType::kAccessToCoopPageFromOpener:
      return "CoopAccessReportType::kAccessToCoopPageFromOpener";
    case CoopAccessReportType::kAccessToCoopPageFromOpenee:
      return "CoopAccessReportType::kAccessToCoopPageFromOpenee";
    case CoopAccessReportType::kAccessToCoopPageFromOther:
      return "CoopAccessReportType::kAccessToCoopPageFromOther";
    default:
      return base::StringPrintf("Unknown CoopAccessReportType value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, CoopAccessReportType value) {
  return os << CoopAccessReportTypeToString(value);
}

std::string CrossOriginOpenerPolicyValueToString(CrossOriginOpenerPolicyValue value) {
  switch(value) {
    case CrossOriginOpenerPolicyValue::kSameOrigin:
      return "CrossOriginOpenerPolicyValue::kSameOrigin";
    case CrossOriginOpenerPolicyValue::kSameOriginAllowPopups:
      return "CrossOriginOpenerPolicyValue::kSameOriginAllowPopups";
    case CrossOriginOpenerPolicyValue::kUnsafeNone:
      return "CrossOriginOpenerPolicyValue::kUnsafeNone";
    case CrossOriginOpenerPolicyValue::kSameOriginPlusCoep:
      return "CrossOriginOpenerPolicyValue::kSameOriginPlusCoep";
    default:
      return base::StringPrintf("Unknown CrossOriginOpenerPolicyValue value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, CrossOriginOpenerPolicyValue value) {
  return os << CrossOriginOpenerPolicyValueToString(value);
}

namespace internal {


// static
bool CrossOriginOpenerPolicy_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const CrossOriginOpenerPolicy_Data* object = static_cast<const CrossOriginOpenerPolicy_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::network::mojom::internal::CrossOriginOpenerPolicyValue_Data
        ::Validate(object->value, validation_context))
    return false;

  const mojo::internal::ContainerValidateParams reporting_endpoint_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->reporting_endpoint, validation_context,
                                         &reporting_endpoint_validate_params)) {
    return false;
  }


  if (!::network::mojom::internal::CrossOriginOpenerPolicyValue_Data
        ::Validate(object->report_only_value, validation_context))
    return false;

  const mojo::internal::ContainerValidateParams report_only_reporting_endpoint_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->report_only_reporting_endpoint, validation_context,
                                         &report_only_reporting_endpoint_validate_params)) {
    return false;
  }

  return true;
}

CrossOriginOpenerPolicy_Data::CrossOriginOpenerPolicy_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CrossOriginOpenerPolicyReporter_QueueAccessReport_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const CrossOriginOpenerPolicyReporter_QueueAccessReport_Params_Data* object = static_cast<const CrossOriginOpenerPolicyReporter_QueueAccessReport_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::network::mojom::internal::CoopAccessReportType_Data
        ::Validate(object->report_type, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->property, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams property_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->property, validation_context,
                                         &property_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->source_location, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->source_location, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->reported_window_url, 4, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams reported_window_url_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->reported_window_url, validation_context,
                                         &reported_window_url_validate_params)) {
    return false;
  }

  return true;
}

CrossOriginOpenerPolicyReporter_QueueAccessReport_Params_Data::CrossOriginOpenerPolicyReporter_QueueAccessReport_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace network

namespace perfetto {

// static
void TraceFormatTraits<::network::mojom::CoopAccessReportType>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::network::mojom::CoopAccessReportType value) {
  return std::move(context).WriteString(::network::mojom::CoopAccessReportTypeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::network::mojom::CrossOriginOpenerPolicyValue>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::network::mojom::CrossOriginOpenerPolicyValue value) {
  return std::move(context).WriteString(::network::mojom::CrossOriginOpenerPolicyValueToString(value));
}

} // namespace perfetto
