// services/network/public/mojom/digitally_signed.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "services/network/public/mojom/digitally_signed.mojom-shared.h"

#include <utility>

#include "base/stl_util.h"  // for base::size()
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/network/public/mojom/digitally_signed.mojom-params-data.h"
namespace network {
namespace mojom {

std::string HashAlgorithmToString(HashAlgorithm value) {
  switch(value) {
    case HashAlgorithm::HASH_ALGO_NONE:
      return "HashAlgorithm::HASH_ALGO_NONE";
    case HashAlgorithm::HASH_ALGO_MD5:
      return "HashAlgorithm::HASH_ALGO_MD5";
    case HashAlgorithm::HASH_ALGO_SHA1:
      return "HashAlgorithm::HASH_ALGO_SHA1";
    case HashAlgorithm::HASH_ALGO_SHA224:
      return "HashAlgorithm::HASH_ALGO_SHA224";
    case HashAlgorithm::HASH_ALGO_SHA256:
      return "HashAlgorithm::HASH_ALGO_SHA256";
    case HashAlgorithm::HASH_ALGO_SHA384:
      return "HashAlgorithm::HASH_ALGO_SHA384";
    case HashAlgorithm::HASH_ALGO_SHA512:
      return "HashAlgorithm::HASH_ALGO_SHA512";
    default:
      return base::StringPrintf("Unknown HashAlgorithm value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, HashAlgorithm value) {
  return os << HashAlgorithmToString(value);
}

std::string SignatureAlgorithmToString(SignatureAlgorithm value) {
  switch(value) {
    case SignatureAlgorithm::SIG_ALGO_ANONYMOUS:
      return "SignatureAlgorithm::SIG_ALGO_ANONYMOUS";
    case SignatureAlgorithm::SIG_ALGO_RSA:
      return "SignatureAlgorithm::SIG_ALGO_RSA";
    case SignatureAlgorithm::SIG_ALGO_DSA:
      return "SignatureAlgorithm::SIG_ALGO_DSA";
    case SignatureAlgorithm::SIG_ALGO_ECDSA:
      return "SignatureAlgorithm::SIG_ALGO_ECDSA";
    default:
      return base::StringPrintf("Unknown SignatureAlgorithm value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, SignatureAlgorithm value) {
  return os << SignatureAlgorithmToString(value);
}

namespace internal {


// static
bool DigitallySigned_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const DigitallySigned_Data* object = static_cast<const DigitallySigned_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::network::mojom::internal::HashAlgorithm_Data
        ::Validate(object->hash_algorithm, validation_context))
    return false;


  if (!::network::mojom::internal::SignatureAlgorithm_Data
        ::Validate(object->signature_algorithm, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->signature, 3, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams signature_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->signature, validation_context,
                                         &signature_validate_params)) {
    return false;
  }

  return true;
}

DigitallySigned_Data::DigitallySigned_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace network

namespace perfetto {

// static
void TraceFormatTraits<::network::mojom::HashAlgorithm>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::network::mojom::HashAlgorithm value) {
  return std::move(context).WriteString(::network::mojom::HashAlgorithmToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::network::mojom::SignatureAlgorithm>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::network::mojom::SignatureAlgorithm value) {
  return std::move(context).WriteString(::network::mojom::SignatureAlgorithmToString(value));
}

} // namespace perfetto
