// services/network/public/mojom/fetch_api.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "services/network/public/mojom/fetch_api.mojom-shared.h"

#include <utility>

#include "base/stl_util.h"  // for base::size()
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/network/public/mojom/fetch_api.mojom-params-data.h"
namespace network {
namespace mojom {

std::string RequestModeToString(RequestMode value) {
  switch(value) {
    case RequestMode::kSameOrigin:
      return "RequestMode::kSameOrigin";
    case RequestMode::kNoCors:
      return "RequestMode::kNoCors";
    case RequestMode::kCors:
      return "RequestMode::kCors";
    case RequestMode::kCorsWithForcedPreflight:
      return "RequestMode::kCorsWithForcedPreflight";
    case RequestMode::kNavigate:
      return "RequestMode::kNavigate";
    default:
      return base::StringPrintf("Unknown RequestMode value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, RequestMode value) {
  return os << RequestModeToString(value);
}

std::string RequestDestinationToString(RequestDestination value) {
  switch(value) {
    case RequestDestination::kEmpty:
      return "RequestDestination::kEmpty";
    case RequestDestination::kAudio:
      return "RequestDestination::kAudio";
    case RequestDestination::kAudioWorklet:
      return "RequestDestination::kAudioWorklet";
    case RequestDestination::kDocument:
      return "RequestDestination::kDocument";
    case RequestDestination::kEmbed:
      return "RequestDestination::kEmbed";
    case RequestDestination::kFont:
      return "RequestDestination::kFont";
    case RequestDestination::kFrame:
      return "RequestDestination::kFrame";
    case RequestDestination::kIframe:
      return "RequestDestination::kIframe";
    case RequestDestination::kImage:
      return "RequestDestination::kImage";
    case RequestDestination::kManifest:
      return "RequestDestination::kManifest";
    case RequestDestination::kObject:
      return "RequestDestination::kObject";
    case RequestDestination::kPaintWorklet:
      return "RequestDestination::kPaintWorklet";
    case RequestDestination::kReport:
      return "RequestDestination::kReport";
    case RequestDestination::kScript:
      return "RequestDestination::kScript";
    case RequestDestination::kServiceWorker:
      return "RequestDestination::kServiceWorker";
    case RequestDestination::kSharedWorker:
      return "RequestDestination::kSharedWorker";
    case RequestDestination::kStyle:
      return "RequestDestination::kStyle";
    case RequestDestination::kTrack:
      return "RequestDestination::kTrack";
    case RequestDestination::kVideo:
      return "RequestDestination::kVideo";
    case RequestDestination::kWebBundle:
      return "RequestDestination::kWebBundle";
    case RequestDestination::kWorker:
      return "RequestDestination::kWorker";
    case RequestDestination::kXslt:
      return "RequestDestination::kXslt";
    default:
      return base::StringPrintf("Unknown RequestDestination value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, RequestDestination value) {
  return os << RequestDestinationToString(value);
}

std::string RedirectModeToString(RedirectMode value) {
  switch(value) {
    case RedirectMode::kFollow:
      return "RedirectMode::kFollow";
    case RedirectMode::kError:
      return "RedirectMode::kError";
    case RedirectMode::kManual:
      return "RedirectMode::kManual";
    default:
      return base::StringPrintf("Unknown RedirectMode value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, RedirectMode value) {
  return os << RedirectModeToString(value);
}

std::string CredentialsModeToString(CredentialsMode value) {
  switch(value) {
    case CredentialsMode::kOmit:
      return "CredentialsMode::kOmit";
    case CredentialsMode::kSameOrigin:
      return "CredentialsMode::kSameOrigin";
    case CredentialsMode::kInclude:
      return "CredentialsMode::kInclude";
    case CredentialsMode::kOmitBug_775438_Workaround:
      return "CredentialsMode::kOmitBug_775438_Workaround";
    default:
      return base::StringPrintf("Unknown CredentialsMode value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, CredentialsMode value) {
  return os << CredentialsModeToString(value);
}

std::string FetchResponseTypeToString(FetchResponseType value) {
  switch(value) {
    case FetchResponseType::kBasic:
      return "FetchResponseType::kBasic";
    case FetchResponseType::kCors:
      return "FetchResponseType::kCors";
    case FetchResponseType::kDefault:
      return "FetchResponseType::kDefault";
    case FetchResponseType::kError:
      return "FetchResponseType::kError";
    case FetchResponseType::kOpaque:
      return "FetchResponseType::kOpaque";
    case FetchResponseType::kOpaqueRedirect:
      return "FetchResponseType::kOpaqueRedirect";
    default:
      return base::StringPrintf("Unknown FetchResponseType value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, FetchResponseType value) {
  return os << FetchResponseTypeToString(value);
}

std::string FetchResponseSourceToString(FetchResponseSource value) {
  switch(value) {
    case FetchResponseSource::kUnspecified:
      return "FetchResponseSource::kUnspecified";
    case FetchResponseSource::kNetwork:
      return "FetchResponseSource::kNetwork";
    case FetchResponseSource::kHttpCache:
      return "FetchResponseSource::kHttpCache";
    case FetchResponseSource::kCacheStorage:
      return "FetchResponseSource::kCacheStorage";
    default:
      return base::StringPrintf("Unknown FetchResponseSource value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, FetchResponseSource value) {
  return os << FetchResponseSourceToString(value);
}

namespace internal {

}  // namespace internal
}  // namespace mojom
}  // namespace network

namespace perfetto {

// static
void TraceFormatTraits<::network::mojom::RequestMode>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::network::mojom::RequestMode value) {
  return std::move(context).WriteString(::network::mojom::RequestModeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::network::mojom::RequestDestination>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::network::mojom::RequestDestination value) {
  return std::move(context).WriteString(::network::mojom::RequestDestinationToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::network::mojom::RedirectMode>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::network::mojom::RedirectMode value) {
  return std::move(context).WriteString(::network::mojom::RedirectModeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::network::mojom::CredentialsMode>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::network::mojom::CredentialsMode value) {
  return std::move(context).WriteString(::network::mojom::CredentialsModeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::network::mojom::FetchResponseType>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::network::mojom::FetchResponseType value) {
  return std::move(context).WriteString(::network::mojom::FetchResponseTypeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::network::mojom::FetchResponseSource>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::network::mojom::FetchResponseSource value) {
  return std::move(context).WriteString(::network::mojom::FetchResponseSourceToString(value));
}

} // namespace perfetto
