// services/network/public/mojom/host_resolver.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "services/network/public/mojom/host_resolver.mojom-shared.h"

#include <utility>

#include "base/stl_util.h"  // for base::size()
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/network/public/mojom/host_resolver.mojom-params-data.h"
namespace network {
namespace mojom {

std::string OptionalSecureDnsModeToString(OptionalSecureDnsMode value) {
  switch(value) {
    case OptionalSecureDnsMode::NO_OVERRIDE:
      return "OptionalSecureDnsMode::NO_OVERRIDE";
    case OptionalSecureDnsMode::OFF:
      return "OptionalSecureDnsMode::OFF";
    case OptionalSecureDnsMode::AUTOMATIC:
      return "OptionalSecureDnsMode::AUTOMATIC";
    case OptionalSecureDnsMode::SECURE:
      return "OptionalSecureDnsMode::SECURE";
    default:
      return base::StringPrintf("Unknown OptionalSecureDnsMode value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, OptionalSecureDnsMode value) {
  return os << OptionalSecureDnsModeToString(value);
}

std::string SecureDnsModeToString(SecureDnsMode value) {
  switch(value) {
    case SecureDnsMode::OFF:
      return "SecureDnsMode::OFF";
    case SecureDnsMode::AUTOMATIC:
      return "SecureDnsMode::AUTOMATIC";
    case SecureDnsMode::SECURE:
      return "SecureDnsMode::SECURE";
    default:
      return base::StringPrintf("Unknown SecureDnsMode value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, SecureDnsMode value) {
  return os << SecureDnsModeToString(value);
}

std::string DnsQueryTypeToString(DnsQueryType value) {
  switch(value) {
    case DnsQueryType::UNSPECIFIED:
      return "DnsQueryType::UNSPECIFIED";
    case DnsQueryType::A:
      return "DnsQueryType::A";
    case DnsQueryType::AAAA:
      return "DnsQueryType::AAAA";
    case DnsQueryType::TXT:
      return "DnsQueryType::TXT";
    case DnsQueryType::PTR:
      return "DnsQueryType::PTR";
    case DnsQueryType::SRV:
      return "DnsQueryType::SRV";
    case DnsQueryType::HTTPS:
      return "DnsQueryType::HTTPS";
    default:
      return base::StringPrintf("Unknown DnsQueryType value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, DnsQueryType value) {
  return os << DnsQueryTypeToString(value);
}

std::string DnsConfigOverrides_TristateToString(DnsConfigOverrides_Tristate value) {
  switch(value) {
    case DnsConfigOverrides_Tristate::NO_OVERRIDE:
      return "DnsConfigOverrides_Tristate::NO_OVERRIDE";
    case DnsConfigOverrides_Tristate::TRISTATE_TRUE:
      return "DnsConfigOverrides_Tristate::TRISTATE_TRUE";
    case DnsConfigOverrides_Tristate::TRISTATE_FALSE:
      return "DnsConfigOverrides_Tristate::TRISTATE_FALSE";
    default:
      return base::StringPrintf("Unknown DnsConfigOverrides_Tristate value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, DnsConfigOverrides_Tristate value) {
  return os << DnsConfigOverrides_TristateToString(value);
}

std::string ResolveHostParameters_SourceToString(ResolveHostParameters_Source value) {
  switch(value) {
    case ResolveHostParameters_Source::ANY:
      return "ResolveHostParameters_Source::ANY";
    case ResolveHostParameters_Source::SYSTEM:
      return "ResolveHostParameters_Source::SYSTEM";
    case ResolveHostParameters_Source::DNS:
      return "ResolveHostParameters_Source::DNS";
    case ResolveHostParameters_Source::MULTICAST_DNS:
      return "ResolveHostParameters_Source::MULTICAST_DNS";
    case ResolveHostParameters_Source::LOCAL_ONLY:
      return "ResolveHostParameters_Source::LOCAL_ONLY";
    default:
      return base::StringPrintf("Unknown ResolveHostParameters_Source value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, ResolveHostParameters_Source value) {
  return os << ResolveHostParameters_SourceToString(value);
}

std::string ResolveHostParameters_CacheUsageToString(ResolveHostParameters_CacheUsage value) {
  switch(value) {
    case ResolveHostParameters_CacheUsage::ALLOWED:
      return "ResolveHostParameters_CacheUsage::ALLOWED";
    case ResolveHostParameters_CacheUsage::STALE_ALLOWED:
      return "ResolveHostParameters_CacheUsage::STALE_ALLOWED";
    case ResolveHostParameters_CacheUsage::DISALLOWED:
      return "ResolveHostParameters_CacheUsage::DISALLOWED";
    default:
      return base::StringPrintf("Unknown ResolveHostParameters_CacheUsage value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, ResolveHostParameters_CacheUsage value) {
  return os << ResolveHostParameters_CacheUsageToString(value);
}

std::string MdnsListenClient_UpdateTypeToString(MdnsListenClient_UpdateType value) {
  switch(value) {
    case MdnsListenClient_UpdateType::ADDED:
      return "MdnsListenClient_UpdateType::ADDED";
    case MdnsListenClient_UpdateType::CHANGED:
      return "MdnsListenClient_UpdateType::CHANGED";
    case MdnsListenClient_UpdateType::REMOVED:
      return "MdnsListenClient_UpdateType::REMOVED";
    default:
      return base::StringPrintf("Unknown MdnsListenClient_UpdateType value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, MdnsListenClient_UpdateType value) {
  return os << MdnsListenClient_UpdateTypeToString(value);
}

namespace internal {


// static
bool DnsOverHttpsServer_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const DnsOverHttpsServer_Data* object = static_cast<const DnsOverHttpsServer_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->server_template, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams server_template_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->server_template, validation_context,
                                         &server_template_validate_params)) {
    return false;
  }

  return true;
}

DnsOverHttpsServer_Data::DnsOverHttpsServer_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DnsConfigOverrides_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 80, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const DnsConfigOverrides_Data* object = static_cast<const DnsConfigOverrides_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  const mojo::internal::ContainerValidateParams nameservers_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->nameservers, validation_context,
                                         &nameservers_validate_params)) {
    return false;
  }

  const mojo::internal::ContainerValidateParams search_validate_params(
      0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr));
  if (!mojo::internal::ValidateContainer(object->search, validation_context,
                                         &search_validate_params)) {
    return false;
  }


  if (!::network::mojom::internal::DnsConfigOverrides_Tristate_Data
        ::Validate(object->append_to_multi_label_name, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->fallback_period, validation_context))
    return false;


  if (!::network::mojom::internal::DnsConfigOverrides_Tristate_Data
        ::Validate(object->rotate, validation_context))
    return false;


  if (!::network::mojom::internal::DnsConfigOverrides_Tristate_Data
        ::Validate(object->use_local_ipv6, validation_context))
    return false;

  const mojo::internal::ContainerValidateParams dns_over_https_servers_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->dns_over_https_servers, validation_context,
                                         &dns_over_https_servers_validate_params)) {
    return false;
  }


  if (!::network::mojom::internal::OptionalSecureDnsMode_Data
        ::Validate(object->secure_dns_mode, validation_context))
    return false;


  if (!::network::mojom::internal::DnsConfigOverrides_Tristate_Data
        ::Validate(object->allow_dns_over_https_upgrade, validation_context))
    return false;

  const mojo::internal::ContainerValidateParams disabled_upgrade_providers_validate_params(
      0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr));
  if (!mojo::internal::ValidateContainer(object->disabled_upgrade_providers, validation_context,
                                         &disabled_upgrade_providers_validate_params)) {
    return false;
  }

  return true;
}

DnsConfigOverrides_Data::DnsConfigOverrides_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ResolveErrorInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ResolveErrorInfo_Data* object = static_cast<const ResolveErrorInfo_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

ResolveErrorInfo_Data::ResolveErrorInfo_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ResolveHostParameters_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ResolveHostParameters_Data* object = static_cast<const ResolveHostParameters_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::network::mojom::internal::DnsQueryType_Data
        ::Validate(object->dns_query_type, validation_context))
    return false;


  if (!::network::mojom::internal::RequestPriority_Data
        ::Validate(object->initial_priority, validation_context))
    return false;


  if (!::network::mojom::internal::ResolveHostParameters_Source_Data
        ::Validate(object->source, validation_context))
    return false;


  if (!::network::mojom::internal::ResolveHostParameters_CacheUsage_Data
        ::Validate(object->cache_usage, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterface(object->control_handle,
                                                 validation_context)) {
    return false;
  }


  if (!::network::mojom::internal::OptionalSecureDnsMode_Data
        ::Validate(object->secure_dns_mode_override, validation_context))
    return false;

  return true;
}

ResolveHostParameters_Data::ResolveHostParameters_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ResolveHostHandle_Cancel_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ResolveHostHandle_Cancel_Params_Data* object = static_cast<const ResolveHostHandle_Cancel_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

ResolveHostHandle_Cancel_Params_Data::ResolveHostHandle_Cancel_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ResolveHostClient_OnComplete_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ResolveHostClient_OnComplete_Params_Data* object = static_cast<const ResolveHostClient_OnComplete_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->resolve_error_info, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->resolve_error_info, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->resolved_addresses, validation_context))
    return false;

  return true;
}

ResolveHostClient_OnComplete_Params_Data::ResolveHostClient_OnComplete_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ResolveHostClient_OnTextResults_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ResolveHostClient_OnTextResults_Params_Data* object = static_cast<const ResolveHostClient_OnTextResults_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->text_results, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams text_results_validate_params(
      0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr));
  if (!mojo::internal::ValidateContainer(object->text_results, validation_context,
                                         &text_results_validate_params)) {
    return false;
  }

  return true;
}

ResolveHostClient_OnTextResults_Params_Data::ResolveHostClient_OnTextResults_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ResolveHostClient_OnHostnameResults_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ResolveHostClient_OnHostnameResults_Params_Data* object = static_cast<const ResolveHostClient_OnHostnameResults_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->hosts, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams hosts_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->hosts, validation_context,
                                         &hosts_validate_params)) {
    return false;
  }

  return true;
}

ResolveHostClient_OnHostnameResults_Params_Data::ResolveHostClient_OnHostnameResults_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MdnsListenClient_OnAddressResult_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const MdnsListenClient_OnAddressResult_Params_Data* object = static_cast<const MdnsListenClient_OnAddressResult_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::network::mojom::internal::MdnsListenClient_UpdateType_Data
        ::Validate(object->update_type, validation_context))
    return false;


  if (!::network::mojom::internal::DnsQueryType_Data
        ::Validate(object->query_type, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->endpoint, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->endpoint, validation_context))
    return false;

  return true;
}

MdnsListenClient_OnAddressResult_Params_Data::MdnsListenClient_OnAddressResult_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MdnsListenClient_OnTextResult_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const MdnsListenClient_OnTextResult_Params_Data* object = static_cast<const MdnsListenClient_OnTextResult_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::network::mojom::internal::MdnsListenClient_UpdateType_Data
        ::Validate(object->update_type, validation_context))
    return false;


  if (!::network::mojom::internal::DnsQueryType_Data
        ::Validate(object->query_type, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->text_records, 3, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams text_records_validate_params(
      0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr));
  if (!mojo::internal::ValidateContainer(object->text_records, validation_context,
                                         &text_records_validate_params)) {
    return false;
  }

  return true;
}

MdnsListenClient_OnTextResult_Params_Data::MdnsListenClient_OnTextResult_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MdnsListenClient_OnHostnameResult_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const MdnsListenClient_OnHostnameResult_Params_Data* object = static_cast<const MdnsListenClient_OnHostnameResult_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::network::mojom::internal::MdnsListenClient_UpdateType_Data
        ::Validate(object->update_type, validation_context))
    return false;


  if (!::network::mojom::internal::DnsQueryType_Data
        ::Validate(object->query_type, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->host, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->host, validation_context))
    return false;

  return true;
}

MdnsListenClient_OnHostnameResult_Params_Data::MdnsListenClient_OnHostnameResult_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MdnsListenClient_OnUnhandledResult_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const MdnsListenClient_OnUnhandledResult_Params_Data* object = static_cast<const MdnsListenClient_OnUnhandledResult_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::network::mojom::internal::MdnsListenClient_UpdateType_Data
        ::Validate(object->update_type, validation_context))
    return false;


  if (!::network::mojom::internal::DnsQueryType_Data
        ::Validate(object->query_type, validation_context))
    return false;

  return true;
}

MdnsListenClient_OnUnhandledResult_Params_Data::MdnsListenClient_OnUnhandledResult_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool HostResolver_ResolveHost_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const HostResolver_ResolveHost_Params_Data* object = static_cast<const HostResolver_ResolveHost_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->host, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->host, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->network_isolation_key, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->network_isolation_key, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->optional_parameters, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->response_client, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->response_client,
                                                 validation_context)) {
    return false;
  }

  return true;
}

HostResolver_ResolveHost_Params_Data::HostResolver_ResolveHost_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool HostResolver_MdnsListen_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const HostResolver_MdnsListen_Params_Data* object = static_cast<const HostResolver_MdnsListen_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->host, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->host, validation_context))
    return false;


  if (!::network::mojom::internal::DnsQueryType_Data
        ::Validate(object->query_type, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->response_client, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->response_client,
                                                 validation_context)) {
    return false;
  }

  return true;
}

HostResolver_MdnsListen_Params_Data::HostResolver_MdnsListen_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool HostResolver_MdnsListen_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const HostResolver_MdnsListen_ResponseParams_Data* object = static_cast<const HostResolver_MdnsListen_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

HostResolver_MdnsListen_ResponseParams_Data::HostResolver_MdnsListen_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DnsConfigChangeManagerClient_OnDnsConfigChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const DnsConfigChangeManagerClient_OnDnsConfigChanged_Params_Data* object = static_cast<const DnsConfigChangeManagerClient_OnDnsConfigChanged_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

DnsConfigChangeManagerClient_OnDnsConfigChanged_Params_Data::DnsConfigChangeManagerClient_OnDnsConfigChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DnsConfigChangeManager_RequestNotifications_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const DnsConfigChangeManager_RequestNotifications_Params_Data* object = static_cast<const DnsConfigChangeManager_RequestNotifications_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->client, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->client,
                                                 validation_context)) {
    return false;
  }

  return true;
}

DnsConfigChangeManager_RequestNotifications_Params_Data::DnsConfigChangeManager_RequestNotifications_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace network

namespace perfetto {

// static
void TraceFormatTraits<::network::mojom::OptionalSecureDnsMode>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::network::mojom::OptionalSecureDnsMode value) {
  return std::move(context).WriteString(::network::mojom::OptionalSecureDnsModeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::network::mojom::SecureDnsMode>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::network::mojom::SecureDnsMode value) {
  return std::move(context).WriteString(::network::mojom::SecureDnsModeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::network::mojom::DnsQueryType>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::network::mojom::DnsQueryType value) {
  return std::move(context).WriteString(::network::mojom::DnsQueryTypeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::network::mojom::DnsConfigOverrides_Tristate>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::network::mojom::DnsConfigOverrides_Tristate value) {
  return std::move(context).WriteString(::network::mojom::DnsConfigOverrides_TristateToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::network::mojom::ResolveHostParameters_Source>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::network::mojom::ResolveHostParameters_Source value) {
  return std::move(context).WriteString(::network::mojom::ResolveHostParameters_SourceToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::network::mojom::ResolveHostParameters_CacheUsage>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::network::mojom::ResolveHostParameters_CacheUsage value) {
  return std::move(context).WriteString(::network::mojom::ResolveHostParameters_CacheUsageToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::network::mojom::MdnsListenClient_UpdateType>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::network::mojom::MdnsListenClient_UpdateType value) {
  return std::move(context).WriteString(::network::mojom::MdnsListenClient_UpdateTypeToString(value));
}

} // namespace perfetto
