// services/network/public/mojom/http_raw_headers.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/network/public/mojom/http_raw_headers.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "services/network/public/mojom/http_raw_headers.mojom-params-data.h"
#include "services/network/public/mojom/http_raw_headers.mojom-shared-message-ids.h"

#include "services/network/public/mojom/http_raw_headers.mojom-import-headers.h"


#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_HTTP_RAW_HEADERS_MOJOM_JUMBO_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_HTTP_RAW_HEADERS_MOJOM_JUMBO_H_
#endif
namespace network {
namespace mojom {
HttpRawHeaderPair::HttpRawHeaderPair()
    : key(),
      value() {}

HttpRawHeaderPair::HttpRawHeaderPair(
    const std::string& key_in,
    const std::string& value_in)
    : key(std::move(key_in)),
      value(std::move(value_in)) {}

HttpRawHeaderPair::~HttpRawHeaderPair() = default;
size_t HttpRawHeaderPair::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->key);
  seed = mojo::internal::Hash(seed, this->value);
  return seed;
}

void HttpRawHeaderPair::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "key"), this->key, 
      "<value of type const std::string&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "value"), this->value, 
      "<value of type const std::string&>");
}

bool HttpRawHeaderPair::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
}  // namespace mojom
}  // namespace network

namespace mojo {


// static
bool StructTraits<::network::mojom::HttpRawHeaderPair::DataView, ::network::mojom::HttpRawHeaderPairPtr>::Read(
    ::network::mojom::HttpRawHeaderPair::DataView input,
    ::network::mojom::HttpRawHeaderPairPtr* output) {
  bool success = true;
  ::network::mojom::HttpRawHeaderPairPtr result(::network::mojom::HttpRawHeaderPair::New());
  
      if (success && !input.ReadKey(&result->key))
        success = false;
      if (success && !input.ReadValue(&result->value))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif