// services/network/public/mojom/isolation_info.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "services/network/public/mojom/isolation_info.mojom-shared.h"

#include <utility>

#include "base/stl_util.h"  // for base::size()
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/network/public/mojom/isolation_info.mojom-params-data.h"
namespace network {
namespace mojom {

std::string IsolationInfoRequestTypeToString(IsolationInfoRequestType value) {
  switch(value) {
    case IsolationInfoRequestType::kMainFrame:
      return "IsolationInfoRequestType::kMainFrame";
    case IsolationInfoRequestType::kSubFrame:
      return "IsolationInfoRequestType::kSubFrame";
    case IsolationInfoRequestType::kOther:
      return "IsolationInfoRequestType::kOther";
    default:
      return base::StringPrintf("Unknown IsolationInfoRequestType value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, IsolationInfoRequestType value) {
  return os << IsolationInfoRequestTypeToString(value);
}

namespace internal {


// static
bool IsolationInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 48, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const IsolationInfo_Data* object = static_cast<const IsolationInfo_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::network::mojom::internal::IsolationInfoRequestType_Data
        ::Validate(object->request_type, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->top_frame_origin, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->frame_origin, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->site_for_cookies, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->site_for_cookies, validation_context))
    return false;

  const mojo::internal::ContainerValidateParams party_context_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->party_context, validation_context,
                                         &party_context_validate_params)) {
    return false;
  }

  return true;
}

IsolationInfo_Data::IsolationInfo_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace network

namespace perfetto {

// static
void TraceFormatTraits<::network::mojom::IsolationInfoRequestType>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::network::mojom::IsolationInfoRequestType value) {
  return std::move(context).WriteString(::network::mojom::IsolationInfoRequestTypeToString(value));
}

} // namespace perfetto
