// services/network/public/mojom/load_timing_info.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/network/public/mojom/load_timing_info.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "services/network/public/mojom/load_timing_info.mojom-params-data.h"
#include "services/network/public/mojom/load_timing_info.mojom-shared-message-ids.h"

#include "services/network/public/mojom/load_timing_info.mojom-import-headers.h"


#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_LOAD_TIMING_INFO_MOJOM_JUMBO_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_LOAD_TIMING_INFO_MOJOM_JUMBO_H_
#endif
namespace network {
namespace mojom {
LoadTimingInfoConnectTiming::LoadTimingInfoConnectTiming()
    : dns_start(),
      dns_end(),
      connect_start(),
      connect_end(),
      ssl_start(),
      ssl_end() {}

LoadTimingInfoConnectTiming::LoadTimingInfoConnectTiming(
    ::base::TimeTicks dns_start_in,
    ::base::TimeTicks dns_end_in,
    ::base::TimeTicks connect_start_in,
    ::base::TimeTicks connect_end_in,
    ::base::TimeTicks ssl_start_in,
    ::base::TimeTicks ssl_end_in)
    : dns_start(std::move(dns_start_in)),
      dns_end(std::move(dns_end_in)),
      connect_start(std::move(connect_start_in)),
      connect_end(std::move(connect_end_in)),
      ssl_start(std::move(ssl_start_in)),
      ssl_end(std::move(ssl_end_in)) {}

LoadTimingInfoConnectTiming::~LoadTimingInfoConnectTiming() = default;

void LoadTimingInfoConnectTiming::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "dns_start"), this->dns_start, 
      "<value of type ::base::TimeTicks>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "dns_end"), this->dns_end, 
      "<value of type ::base::TimeTicks>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "connect_start"), this->connect_start, 
      "<value of type ::base::TimeTicks>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "connect_end"), this->connect_end, 
      "<value of type ::base::TimeTicks>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "ssl_start"), this->ssl_start, 
      "<value of type ::base::TimeTicks>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "ssl_end"), this->ssl_end, 
      "<value of type ::base::TimeTicks>");
}

bool LoadTimingInfoConnectTiming::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
LoadTimingInfo::LoadTimingInfo()
    : socket_reused(),
      socket_log_id(),
      request_start_time(),
      request_start(),
      proxy_resolve_start(),
      proxy_resolve_end(),
      connect_timing(),
      send_start(),
      send_end(),
      receive_headers_start(),
      receive_headers_end(),
      receive_non_informational_headers_start(),
      first_early_hints_time(),
      push_start(),
      push_end(),
      service_worker_start_time(),
      service_worker_ready_time(),
      service_worker_fetch_start(),
      service_worker_respond_with_settled() {}

LoadTimingInfo::LoadTimingInfo(
    bool socket_reused_in,
    uint32_t socket_log_id_in,
    ::base::Time request_start_time_in,
    ::base::TimeTicks request_start_in,
    ::base::TimeTicks proxy_resolve_start_in,
    ::base::TimeTicks proxy_resolve_end_in,
    const ::net::LoadTimingInfo::ConnectTiming& connect_timing_in,
    ::base::TimeTicks send_start_in,
    ::base::TimeTicks send_end_in,
    ::base::TimeTicks receive_headers_start_in,
    ::base::TimeTicks receive_headers_end_in,
    ::base::TimeTicks receive_non_informational_headers_start_in,
    ::base::TimeTicks first_early_hints_time_in,
    ::base::TimeTicks push_start_in,
    ::base::TimeTicks push_end_in,
    ::base::TimeTicks service_worker_start_time_in,
    ::base::TimeTicks service_worker_ready_time_in,
    ::base::TimeTicks service_worker_fetch_start_in,
    ::base::TimeTicks service_worker_respond_with_settled_in)
    : socket_reused(std::move(socket_reused_in)),
      socket_log_id(std::move(socket_log_id_in)),
      request_start_time(std::move(request_start_time_in)),
      request_start(std::move(request_start_in)),
      proxy_resolve_start(std::move(proxy_resolve_start_in)),
      proxy_resolve_end(std::move(proxy_resolve_end_in)),
      connect_timing(std::move(connect_timing_in)),
      send_start(std::move(send_start_in)),
      send_end(std::move(send_end_in)),
      receive_headers_start(std::move(receive_headers_start_in)),
      receive_headers_end(std::move(receive_headers_end_in)),
      receive_non_informational_headers_start(std::move(receive_non_informational_headers_start_in)),
      first_early_hints_time(std::move(first_early_hints_time_in)),
      push_start(std::move(push_start_in)),
      push_end(std::move(push_end_in)),
      service_worker_start_time(std::move(service_worker_start_time_in)),
      service_worker_ready_time(std::move(service_worker_ready_time_in)),
      service_worker_fetch_start(std::move(service_worker_fetch_start_in)),
      service_worker_respond_with_settled(std::move(service_worker_respond_with_settled_in)) {}

LoadTimingInfo::~LoadTimingInfo() = default;

void LoadTimingInfo::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "socket_reused"), this->socket_reused, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "socket_log_id"), this->socket_log_id, 
      "<value of type uint32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "request_start_time"), this->request_start_time, 
      "<value of type ::base::Time>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "request_start"), this->request_start, 
      "<value of type ::base::TimeTicks>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "proxy_resolve_start"), this->proxy_resolve_start, 
      "<value of type ::base::TimeTicks>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "proxy_resolve_end"), this->proxy_resolve_end, 
      "<value of type ::base::TimeTicks>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "connect_timing"), this->connect_timing, 
      "<value of type const ::net::LoadTimingInfo::ConnectTiming&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "send_start"), this->send_start, 
      "<value of type ::base::TimeTicks>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "send_end"), this->send_end, 
      "<value of type ::base::TimeTicks>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "receive_headers_start"), this->receive_headers_start, 
      "<value of type ::base::TimeTicks>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "receive_headers_end"), this->receive_headers_end, 
      "<value of type ::base::TimeTicks>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "receive_non_informational_headers_start"), this->receive_non_informational_headers_start, 
      "<value of type ::base::TimeTicks>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "first_early_hints_time"), this->first_early_hints_time, 
      "<value of type ::base::TimeTicks>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "push_start"), this->push_start, 
      "<value of type ::base::TimeTicks>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "push_end"), this->push_end, 
      "<value of type ::base::TimeTicks>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "service_worker_start_time"), this->service_worker_start_time, 
      "<value of type ::base::TimeTicks>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "service_worker_ready_time"), this->service_worker_ready_time, 
      "<value of type ::base::TimeTicks>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "service_worker_fetch_start"), this->service_worker_fetch_start, 
      "<value of type ::base::TimeTicks>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "service_worker_respond_with_settled"), this->service_worker_respond_with_settled, 
      "<value of type ::base::TimeTicks>");
}

bool LoadTimingInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
}  // namespace mojom
}  // namespace network

namespace mojo {


// static
bool StructTraits<::network::mojom::LoadTimingInfoConnectTiming::DataView, ::network::mojom::LoadTimingInfoConnectTimingPtr>::Read(
    ::network::mojom::LoadTimingInfoConnectTiming::DataView input,
    ::network::mojom::LoadTimingInfoConnectTimingPtr* output) {
  bool success = true;
  ::network::mojom::LoadTimingInfoConnectTimingPtr result(::network::mojom::LoadTimingInfoConnectTiming::New());
  
      if (success && !input.ReadDnsStart(&result->dns_start))
        success = false;
      if (success && !input.ReadDnsEnd(&result->dns_end))
        success = false;
      if (success && !input.ReadConnectStart(&result->connect_start))
        success = false;
      if (success && !input.ReadConnectEnd(&result->connect_end))
        success = false;
      if (success && !input.ReadSslStart(&result->ssl_start))
        success = false;
      if (success && !input.ReadSslEnd(&result->ssl_end))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::LoadTimingInfo::DataView, ::network::mojom::LoadTimingInfoPtr>::Read(
    ::network::mojom::LoadTimingInfo::DataView input,
    ::network::mojom::LoadTimingInfoPtr* output) {
  bool success = true;
  ::network::mojom::LoadTimingInfoPtr result(::network::mojom::LoadTimingInfo::New());
  
      if (success)
        result->socket_reused = input.socket_reused();
      if (success)
        result->socket_log_id = input.socket_log_id();
      if (success && !input.ReadRequestStartTime(&result->request_start_time))
        success = false;
      if (success && !input.ReadRequestStart(&result->request_start))
        success = false;
      if (success && !input.ReadProxyResolveStart(&result->proxy_resolve_start))
        success = false;
      if (success && !input.ReadProxyResolveEnd(&result->proxy_resolve_end))
        success = false;
      if (success && !input.ReadConnectTiming(&result->connect_timing))
        success = false;
      if (success && !input.ReadSendStart(&result->send_start))
        success = false;
      if (success && !input.ReadSendEnd(&result->send_end))
        success = false;
      if (success && !input.ReadReceiveHeadersStart(&result->receive_headers_start))
        success = false;
      if (success && !input.ReadReceiveHeadersEnd(&result->receive_headers_end))
        success = false;
      if (success && !input.ReadReceiveNonInformationalHeadersStart(&result->receive_non_informational_headers_start))
        success = false;
      if (success && !input.ReadFirstEarlyHintsTime(&result->first_early_hints_time))
        success = false;
      if (success && !input.ReadPushStart(&result->push_start))
        success = false;
      if (success && !input.ReadPushEnd(&result->push_end))
        success = false;
      if (success && !input.ReadServiceWorkerStartTime(&result->service_worker_start_time))
        success = false;
      if (success && !input.ReadServiceWorkerReadyTime(&result->service_worker_ready_time))
        success = false;
      if (success && !input.ReadServiceWorkerFetchStart(&result->service_worker_fetch_start))
        success = false;
      if (success && !input.ReadServiceWorkerRespondWithSettled(&result->service_worker_respond_with_settled))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif