// services/network/public/mojom/net_log.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "services/network/public/mojom/net_log.mojom-shared.h"

#include <utility>

#include "base/stl_util.h"  // for base::size()
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/network/public/mojom/net_log.mojom-params-data.h"
namespace network {
namespace mojom {

std::string NetLogCaptureModeToString(NetLogCaptureMode value) {
  switch(value) {
    case NetLogCaptureMode::DEFAULT:
      return "NetLogCaptureMode::DEFAULT";
    case NetLogCaptureMode::INCLUDE_PRIVACY_INFO:
      return "NetLogCaptureMode::INCLUDE_PRIVACY_INFO";
    case NetLogCaptureMode::EVERYTHING:
      return "NetLogCaptureMode::EVERYTHING";
    default:
      return base::StringPrintf("Unknown NetLogCaptureMode value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, NetLogCaptureMode value) {
  return os << NetLogCaptureModeToString(value);
}

std::string NetLogEventPhaseToString(NetLogEventPhase value) {
  switch(value) {
    case NetLogEventPhase::BEGIN:
      return "NetLogEventPhase::BEGIN";
    case NetLogEventPhase::END:
      return "NetLogEventPhase::END";
    case NetLogEventPhase::NONE:
      return "NetLogEventPhase::NONE";
    default:
      return base::StringPrintf("Unknown NetLogEventPhase value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, NetLogEventPhase value) {
  return os << NetLogEventPhaseToString(value);
}

namespace internal {


// static
bool NetLogExporter_Start_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const NetLogExporter_Start_Params_Data* object = static_cast<const NetLogExporter_Start_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->destination, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->destination, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->extra_constants, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->extra_constants, validation_context))
    return false;


  if (!::network::mojom::internal::NetLogCaptureMode_Data
        ::Validate(object->capture_mode, validation_context))
    return false;

  return true;
}

NetLogExporter_Start_Params_Data::NetLogExporter_Start_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetLogExporter_Start_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const NetLogExporter_Start_ResponseParams_Data* object = static_cast<const NetLogExporter_Start_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

NetLogExporter_Start_ResponseParams_Data::NetLogExporter_Start_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetLogExporter_Stop_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const NetLogExporter_Stop_Params_Data* object = static_cast<const NetLogExporter_Stop_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->polled_values, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->polled_values, validation_context))
    return false;

  return true;
}

NetLogExporter_Stop_Params_Data::NetLogExporter_Stop_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetLogExporter_Stop_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const NetLogExporter_Stop_ResponseParams_Data* object = static_cast<const NetLogExporter_Stop_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

NetLogExporter_Stop_ResponseParams_Data::NetLogExporter_Stop_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetLogProxySource_UpdateCaptureModes_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const NetLogProxySource_UpdateCaptureModes_Params_Data* object = static_cast<const NetLogProxySource_UpdateCaptureModes_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

NetLogProxySource_UpdateCaptureModes_Params_Data::NetLogProxySource_UpdateCaptureModes_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetLogProxySink_AddEntry_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 56, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const NetLogProxySink_AddEntry_Params_Data* object = static_cast<const NetLogProxySink_AddEntry_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->source_start_time, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->source_start_time, validation_context))
    return false;


  if (!::network::mojom::internal::NetLogEventPhase_Data
        ::Validate(object->phase, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->time, 6, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->time, validation_context))
    return false;

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->params, 7, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->params, validation_context))
    return false;

  return true;
}

NetLogProxySink_AddEntry_Params_Data::NetLogProxySink_AddEntry_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace network

namespace perfetto {

// static
void TraceFormatTraits<::network::mojom::NetLogCaptureMode>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::network::mojom::NetLogCaptureMode value) {
  return std::move(context).WriteString(::network::mojom::NetLogCaptureModeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::network::mojom::NetLogEventPhase>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::network::mojom::NetLogEventPhase value) {
  return std::move(context).WriteString(::network::mojom::NetLogEventPhaseToString(value));
}

} // namespace perfetto
