// services/network/public/mojom/network_change_manager.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "services/network/public/mojom/network_change_manager.mojom-shared.h"

#include <utility>

#include "base/stl_util.h"  // for base::size()
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/network/public/mojom/network_change_manager.mojom-params-data.h"
namespace network {
namespace mojom {

std::string ConnectionTypeToString(ConnectionType value) {
  switch(value) {
    case ConnectionType::CONNECTION_UNKNOWN:
      return "ConnectionType::CONNECTION_UNKNOWN";
    case ConnectionType::CONNECTION_ETHERNET:
      return "ConnectionType::CONNECTION_ETHERNET";
    case ConnectionType::CONNECTION_WIFI:
      return "ConnectionType::CONNECTION_WIFI";
    case ConnectionType::CONNECTION_2G:
      return "ConnectionType::CONNECTION_2G";
    case ConnectionType::CONNECTION_3G:
      return "ConnectionType::CONNECTION_3G";
    case ConnectionType::CONNECTION_4G:
      return "ConnectionType::CONNECTION_4G";
    case ConnectionType::CONNECTION_NONE:
      return "ConnectionType::CONNECTION_NONE";
    case ConnectionType::CONNECTION_BLUETOOTH:
      return "ConnectionType::CONNECTION_BLUETOOTH";
    case ConnectionType::CONNECTION_5G:
      return "ConnectionType::{CONNECTION_5G, CONNECTION_LAST}";
    default:
      return base::StringPrintf("Unknown ConnectionType value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, ConnectionType value) {
  return os << ConnectionTypeToString(value);
}

std::string ConnectionSubtypeToString(ConnectionSubtype value) {
  switch(value) {
    case ConnectionSubtype::SUBTYPE_UNKNOWN:
      return "ConnectionSubtype::SUBTYPE_UNKNOWN";
    case ConnectionSubtype::SUBTYPE_NONE:
      return "ConnectionSubtype::SUBTYPE_NONE";
    case ConnectionSubtype::SUBTYPE_OTHER:
      return "ConnectionSubtype::SUBTYPE_OTHER";
    case ConnectionSubtype::SUBTYPE_GSM:
      return "ConnectionSubtype::SUBTYPE_GSM";
    case ConnectionSubtype::SUBTYPE_IDEN:
      return "ConnectionSubtype::SUBTYPE_IDEN";
    case ConnectionSubtype::SUBTYPE_CDMA:
      return "ConnectionSubtype::SUBTYPE_CDMA";
    case ConnectionSubtype::SUBTYPE_1XRTT:
      return "ConnectionSubtype::SUBTYPE_1XRTT";
    case ConnectionSubtype::SUBTYPE_GPRS:
      return "ConnectionSubtype::SUBTYPE_GPRS";
    case ConnectionSubtype::SUBTYPE_EDGE:
      return "ConnectionSubtype::SUBTYPE_EDGE";
    case ConnectionSubtype::SUBTYPE_UMTS:
      return "ConnectionSubtype::SUBTYPE_UMTS";
    case ConnectionSubtype::SUBTYPE_EVDO_REV_0:
      return "ConnectionSubtype::SUBTYPE_EVDO_REV_0";
    case ConnectionSubtype::SUBTYPE_EVDO_REV_A:
      return "ConnectionSubtype::SUBTYPE_EVDO_REV_A";
    case ConnectionSubtype::SUBTYPE_HSPA:
      return "ConnectionSubtype::SUBTYPE_HSPA";
    case ConnectionSubtype::SUBTYPE_EVDO_REV_B:
      return "ConnectionSubtype::SUBTYPE_EVDO_REV_B";
    case ConnectionSubtype::SUBTYPE_HSDPA:
      return "ConnectionSubtype::SUBTYPE_HSDPA";
    case ConnectionSubtype::SUBTYPE_HSUPA:
      return "ConnectionSubtype::SUBTYPE_HSUPA";
    case ConnectionSubtype::SUBTYPE_EHRPD:
      return "ConnectionSubtype::SUBTYPE_EHRPD";
    case ConnectionSubtype::SUBTYPE_HSPAP:
      return "ConnectionSubtype::SUBTYPE_HSPAP";
    case ConnectionSubtype::SUBTYPE_LTE:
      return "ConnectionSubtype::SUBTYPE_LTE";
    case ConnectionSubtype::SUBTYPE_LTE_ADVANCED:
      return "ConnectionSubtype::SUBTYPE_LTE_ADVANCED";
    case ConnectionSubtype::SUBTYPE_BLUETOOTH_1_2:
      return "ConnectionSubtype::SUBTYPE_BLUETOOTH_1_2";
    case ConnectionSubtype::SUBTYPE_BLUETOOTH_2_1:
      return "ConnectionSubtype::SUBTYPE_BLUETOOTH_2_1";
    case ConnectionSubtype::SUBTYPE_BLUETOOTH_3_0:
      return "ConnectionSubtype::SUBTYPE_BLUETOOTH_3_0";
    case ConnectionSubtype::SUBTYPE_BLUETOOTH_4_0:
      return "ConnectionSubtype::SUBTYPE_BLUETOOTH_4_0";
    case ConnectionSubtype::SUBTYPE_ETHERNET:
      return "ConnectionSubtype::SUBTYPE_ETHERNET";
    case ConnectionSubtype::SUBTYPE_FAST_ETHERNET:
      return "ConnectionSubtype::SUBTYPE_FAST_ETHERNET";
    case ConnectionSubtype::SUBTYPE_GIGABIT_ETHERNET:
      return "ConnectionSubtype::SUBTYPE_GIGABIT_ETHERNET";
    case ConnectionSubtype::SUBTYPE_10_GIGABIT_ETHERNET:
      return "ConnectionSubtype::SUBTYPE_10_GIGABIT_ETHERNET";
    case ConnectionSubtype::SUBTYPE_WIFI_B:
      return "ConnectionSubtype::SUBTYPE_WIFI_B";
    case ConnectionSubtype::SUBTYPE_WIFI_G:
      return "ConnectionSubtype::SUBTYPE_WIFI_G";
    case ConnectionSubtype::SUBTYPE_WIFI_N:
      return "ConnectionSubtype::SUBTYPE_WIFI_N";
    case ConnectionSubtype::SUBTYPE_WIFI_AC:
      return "ConnectionSubtype::SUBTYPE_WIFI_AC";
    case ConnectionSubtype::SUBTYPE_WIFI_AD:
      return "ConnectionSubtype::{SUBTYPE_WIFI_AD, SUBTYPE_LAST}";
    default:
      return base::StringPrintf("Unknown ConnectionSubtype value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, ConnectionSubtype value) {
  return os << ConnectionSubtypeToString(value);
}

namespace internal {


// static
bool NetworkChangeManagerClient_OnInitialConnectionType_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const NetworkChangeManagerClient_OnInitialConnectionType_Params_Data* object = static_cast<const NetworkChangeManagerClient_OnInitialConnectionType_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::network::mojom::internal::ConnectionType_Data
        ::Validate(object->type, validation_context))
    return false;

  return true;
}

NetworkChangeManagerClient_OnInitialConnectionType_Params_Data::NetworkChangeManagerClient_OnInitialConnectionType_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkChangeManagerClient_OnNetworkChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const NetworkChangeManagerClient_OnNetworkChanged_Params_Data* object = static_cast<const NetworkChangeManagerClient_OnNetworkChanged_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::network::mojom::internal::ConnectionType_Data
        ::Validate(object->type, validation_context))
    return false;

  return true;
}

NetworkChangeManagerClient_OnNetworkChanged_Params_Data::NetworkChangeManagerClient_OnNetworkChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkChangeManager_RequestNotifications_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const NetworkChangeManager_RequestNotifications_Params_Data* object = static_cast<const NetworkChangeManager_RequestNotifications_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->client_remote, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->client_remote,
                                                 validation_context)) {
    return false;
  }

  return true;
}

NetworkChangeManager_RequestNotifications_Params_Data::NetworkChangeManager_RequestNotifications_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace network

namespace perfetto {

// static
void TraceFormatTraits<::network::mojom::ConnectionType>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::network::mojom::ConnectionType value) {
  return std::move(context).WriteString(::network::mojom::ConnectionTypeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::network::mojom::ConnectionSubtype>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::network::mojom::ConnectionSubtype value) {
  return std::move(context).WriteString(::network::mojom::ConnectionSubtypeToString(value));
}

} // namespace perfetto
