// services/network/public/mojom/network_change_manager.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/network/public/mojom/network_change_manager.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "services/network/public/mojom/network_change_manager.mojom-params-data.h"
#include "services/network/public/mojom/network_change_manager.mojom-shared-message-ids.h"

#include "services/network/public/mojom/network_change_manager.mojom-import-headers.h"


#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_NETWORK_CHANGE_MANAGER_MOJOM_JUMBO_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_NETWORK_CHANGE_MANAGER_MOJOM_JUMBO_H_
#endif
namespace network {
namespace mojom {
const char NetworkChangeManagerClient::Name_[] = "network.mojom.NetworkChangeManagerClient";

NetworkChangeManagerClientProxy::NetworkChangeManagerClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void NetworkChangeManagerClientProxy::OnInitialConnectionType(
    ConnectionType in_type) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::NetworkChangeManagerClient::OnInitialConnectionType", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("type"), in_type, 
                        "<value of type ConnectionType>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkChangeManagerClient_OnInitialConnectionType_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkChangeManagerClient_OnInitialConnectionType_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::network::mojom::ConnectionType>(
      in_type, &params->type);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkChangeManagerClient::Name_);
  message.set_method_name("OnInitialConnectionType");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void NetworkChangeManagerClientProxy::OnNetworkChanged(
    ConnectionType in_type) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::NetworkChangeManagerClient::OnNetworkChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("type"), in_type, 
                        "<value of type ConnectionType>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkChangeManagerClient_OnNetworkChanged_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkChangeManagerClient_OnNetworkChanged_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::network::mojom::ConnectionType>(
      in_type, &params->type);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkChangeManagerClient::Name_);
  message.set_method_name("OnNetworkChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool NetworkChangeManagerClientStubDispatch::Accept(
    NetworkChangeManagerClient* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kNetworkChangeManagerClient_OnInitialConnectionType_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::NetworkChangeManagerClient::OnInitialConnectionType",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::NetworkChangeManagerClient::OnInitialConnectionType");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::NetworkChangeManagerClient_OnInitialConnectionType_Params_Data* params =
          reinterpret_cast<internal::NetworkChangeManagerClient_OnInitialConnectionType_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ConnectionType p_type{};
      NetworkChangeManagerClient_OnInitialConnectionType_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadType(&p_type))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkChangeManagerClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnInitialConnectionType(
std::move(p_type));
      return true;
    }
    case internal::kNetworkChangeManagerClient_OnNetworkChanged_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::NetworkChangeManagerClient::OnNetworkChanged",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::NetworkChangeManagerClient::OnNetworkChanged");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::NetworkChangeManagerClient_OnNetworkChanged_Params_Data* params =
          reinterpret_cast<internal::NetworkChangeManagerClient_OnNetworkChanged_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ConnectionType p_type{};
      NetworkChangeManagerClient_OnNetworkChanged_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadType(&p_type))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkChangeManagerClient::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnNetworkChanged(
std::move(p_type));
      return true;
    }
  }
  return false;
}

// static
bool NetworkChangeManagerClientStubDispatch::AcceptWithResponder(
    NetworkChangeManagerClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kNetworkChangeManagerClient_OnInitialConnectionType_Name: {
      break;
    }
    case internal::kNetworkChangeManagerClient_OnNetworkChanged_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kNetworkChangeManagerClientValidationInfo[] = {
    {internal::kNetworkChangeManagerClient_OnInitialConnectionType_Name,
     {&internal::NetworkChangeManagerClient_OnInitialConnectionType_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kNetworkChangeManagerClient_OnNetworkChanged_Name,
     {&internal::NetworkChangeManagerClient_OnNetworkChanged_Params_Data::Validate,
      nullptr /* no response */}},
};

bool NetworkChangeManagerClientRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::network::mojom::NetworkChangeManagerClient::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kNetworkChangeManagerClientValidationInfo);
}

const char NetworkChangeManager::Name_[] = "network.mojom.NetworkChangeManager";

NetworkChangeManagerProxy::NetworkChangeManagerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void NetworkChangeManagerProxy::RequestNotifications(
    ::mojo::PendingRemote<NetworkChangeManagerClient> in_client_remote) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::NetworkChangeManager::RequestNotifications", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client_remote"), in_client_remote, 
                        "<value of type ::mojo::PendingRemote<NetworkChangeManagerClient>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkChangeManager_RequestNotifications_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkChangeManager_RequestNotifications_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::network::mojom::NetworkChangeManagerClientInterfaceBase>>(
      in_client_remote, &params->client_remote, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->client_remote),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid client_remote in NetworkChangeManager.RequestNotifications request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkChangeManager::Name_);
  message.set_method_name("RequestNotifications");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool NetworkChangeManagerStubDispatch::Accept(
    NetworkChangeManager* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kNetworkChangeManager_RequestNotifications_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::NetworkChangeManager::RequestNotifications",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::NetworkChangeManager::RequestNotifications");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::NetworkChangeManager_RequestNotifications_Params_Data* params =
          reinterpret_cast<internal::NetworkChangeManager_RequestNotifications_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingRemote<NetworkChangeManagerClient> p_client_remote{};
      NetworkChangeManager_RequestNotifications_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_client_remote =
            input_data_view.TakeClientRemote<decltype(p_client_remote)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkChangeManager::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RequestNotifications(
std::move(p_client_remote));
      return true;
    }
  }
  return false;
}

// static
bool NetworkChangeManagerStubDispatch::AcceptWithResponder(
    NetworkChangeManager* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kNetworkChangeManager_RequestNotifications_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kNetworkChangeManagerValidationInfo[] = {
    {internal::kNetworkChangeManager_RequestNotifications_Name,
     {&internal::NetworkChangeManager_RequestNotifications_Params_Data::Validate,
      nullptr /* no response */}},
};

bool NetworkChangeManagerRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::network::mojom::NetworkChangeManager::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kNetworkChangeManagerValidationInfo);
}

}  // namespace mojom
}  // namespace network

namespace mojo {

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif