// services/network/public/mojom/network_quality_estimator_manager.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "services/network/public/mojom/network_quality_estimator_manager.mojom-shared.h"

#include <utility>

#include "base/stl_util.h"  // for base::size()
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/network/public/mojom/network_quality_estimator_manager.mojom-params-data.h"
namespace network {
namespace mojom {

namespace internal {


// static
bool NetworkQualityEstimatorManagerClient_OnNetworkQualityChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const NetworkQualityEstimatorManagerClient_OnNetworkQualityChanged_Params_Data* object = static_cast<const NetworkQualityEstimatorManagerClient_OnNetworkQualityChanged_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::network::mojom::internal::EffectiveConnectionType_Data
        ::Validate(object->type, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->http_rtt, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->http_rtt, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->transport_rtt, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->transport_rtt, validation_context))
    return false;

  return true;
}

NetworkQualityEstimatorManagerClient_OnNetworkQualityChanged_Params_Data::NetworkQualityEstimatorManagerClient_OnNetworkQualityChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkQualityEstimatorManager_RequestNotifications_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const NetworkQualityEstimatorManager_RequestNotifications_Params_Data* object = static_cast<const NetworkQualityEstimatorManager_RequestNotifications_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->client, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->client,
                                                 validation_context)) {
    return false;
  }

  return true;
}

NetworkQualityEstimatorManager_RequestNotifications_Params_Data::NetworkQualityEstimatorManager_RequestNotifications_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace network
