// services/network/public/mojom/network_quality_estimator_manager.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/network/public/mojom/network_quality_estimator_manager.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "services/network/public/mojom/network_quality_estimator_manager.mojom-params-data.h"
#include "services/network/public/mojom/network_quality_estimator_manager.mojom-shared-message-ids.h"

#include "services/network/public/mojom/network_quality_estimator_manager.mojom-import-headers.h"


#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_NETWORK_QUALITY_ESTIMATOR_MANAGER_MOJOM_JUMBO_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_NETWORK_QUALITY_ESTIMATOR_MANAGER_MOJOM_JUMBO_H_
#endif
namespace network {
namespace mojom {
const char NetworkQualityEstimatorManagerClient::Name_[] = "network.mojom.NetworkQualityEstimatorManagerClient";

NetworkQualityEstimatorManagerClientProxy::NetworkQualityEstimatorManagerClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void NetworkQualityEstimatorManagerClientProxy::OnNetworkQualityChanged(
    ::net::EffectiveConnectionType in_type, ::base::TimeDelta in_http_rtt, ::base::TimeDelta in_transport_rtt, int32_t in_downlink_bandwidth_kbps) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::NetworkQualityEstimatorManagerClient::OnNetworkQualityChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("type"), in_type, 
                        "<value of type ::net::EffectiveConnectionType>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("http_rtt"), in_http_rtt, 
                        "<value of type ::base::TimeDelta>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("transport_rtt"), in_transport_rtt, 
                        "<value of type ::base::TimeDelta>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("downlink_bandwidth_kbps"), in_downlink_bandwidth_kbps, 
                        "<value of type int32_t>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkQualityEstimatorManagerClient_OnNetworkQualityChanged_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkQualityEstimatorManagerClient_OnNetworkQualityChanged_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::network::mojom::EffectiveConnectionType>(
      in_type, &params->type);
  mojo::internal::MessageFragment<
      typename decltype(params->http_rtt)::BaseType> http_rtt_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
      in_http_rtt, http_rtt_fragment);
  params->http_rtt.Set(
      http_rtt_fragment.is_null() ? nullptr : http_rtt_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->http_rtt.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null http_rtt in NetworkQualityEstimatorManagerClient.OnNetworkQualityChanged request");
  mojo::internal::MessageFragment<
      typename decltype(params->transport_rtt)::BaseType> transport_rtt_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
      in_transport_rtt, transport_rtt_fragment);
  params->transport_rtt.Set(
      transport_rtt_fragment.is_null() ? nullptr : transport_rtt_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->transport_rtt.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null transport_rtt in NetworkQualityEstimatorManagerClient.OnNetworkQualityChanged request");
  params->downlink_bandwidth_kbps = in_downlink_bandwidth_kbps;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkQualityEstimatorManagerClient::Name_);
  message.set_method_name("OnNetworkQualityChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool NetworkQualityEstimatorManagerClientStubDispatch::Accept(
    NetworkQualityEstimatorManagerClient* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kNetworkQualityEstimatorManagerClient_OnNetworkQualityChanged_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::NetworkQualityEstimatorManagerClient::OnNetworkQualityChanged",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::NetworkQualityEstimatorManagerClient::OnNetworkQualityChanged");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::NetworkQualityEstimatorManagerClient_OnNetworkQualityChanged_Params_Data* params =
          reinterpret_cast<internal::NetworkQualityEstimatorManagerClient_OnNetworkQualityChanged_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::net::EffectiveConnectionType p_type{};
      ::base::TimeDelta p_http_rtt{};
      ::base::TimeDelta p_transport_rtt{};
      int32_t p_downlink_bandwidth_kbps{};
      NetworkQualityEstimatorManagerClient_OnNetworkQualityChanged_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadType(&p_type))
        success = false;
      if (success && !input_data_view.ReadHttpRtt(&p_http_rtt))
        success = false;
      if (success && !input_data_view.ReadTransportRtt(&p_transport_rtt))
        success = false;
      if (success)
        p_downlink_bandwidth_kbps = input_data_view.downlink_bandwidth_kbps();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkQualityEstimatorManagerClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnNetworkQualityChanged(
std::move(p_type), 
std::move(p_http_rtt), 
std::move(p_transport_rtt), 
std::move(p_downlink_bandwidth_kbps));
      return true;
    }
  }
  return false;
}

// static
bool NetworkQualityEstimatorManagerClientStubDispatch::AcceptWithResponder(
    NetworkQualityEstimatorManagerClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kNetworkQualityEstimatorManagerClient_OnNetworkQualityChanged_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kNetworkQualityEstimatorManagerClientValidationInfo[] = {
    {internal::kNetworkQualityEstimatorManagerClient_OnNetworkQualityChanged_Name,
     {&internal::NetworkQualityEstimatorManagerClient_OnNetworkQualityChanged_Params_Data::Validate,
      nullptr /* no response */}},
};

bool NetworkQualityEstimatorManagerClientRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::network::mojom::NetworkQualityEstimatorManagerClient::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kNetworkQualityEstimatorManagerClientValidationInfo);
}

const char NetworkQualityEstimatorManager::Name_[] = "network.mojom.NetworkQualityEstimatorManager";

NetworkQualityEstimatorManagerProxy::NetworkQualityEstimatorManagerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void NetworkQualityEstimatorManagerProxy::RequestNotifications(
    ::mojo::PendingRemote<NetworkQualityEstimatorManagerClient> in_client) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::NetworkQualityEstimatorManager::RequestNotifications", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client"), in_client, 
                        "<value of type ::mojo::PendingRemote<NetworkQualityEstimatorManagerClient>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkQualityEstimatorManager_RequestNotifications_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkQualityEstimatorManager_RequestNotifications_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::network::mojom::NetworkQualityEstimatorManagerClientInterfaceBase>>(
      in_client, &params->client, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->client),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid client in NetworkQualityEstimatorManager.RequestNotifications request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkQualityEstimatorManager::Name_);
  message.set_method_name("RequestNotifications");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool NetworkQualityEstimatorManagerStubDispatch::Accept(
    NetworkQualityEstimatorManager* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kNetworkQualityEstimatorManager_RequestNotifications_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::NetworkQualityEstimatorManager::RequestNotifications",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::NetworkQualityEstimatorManager::RequestNotifications");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::NetworkQualityEstimatorManager_RequestNotifications_Params_Data* params =
          reinterpret_cast<internal::NetworkQualityEstimatorManager_RequestNotifications_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingRemote<NetworkQualityEstimatorManagerClient> p_client{};
      NetworkQualityEstimatorManager_RequestNotifications_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_client =
            input_data_view.TakeClient<decltype(p_client)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkQualityEstimatorManager::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RequestNotifications(
std::move(p_client));
      return true;
    }
  }
  return false;
}

// static
bool NetworkQualityEstimatorManagerStubDispatch::AcceptWithResponder(
    NetworkQualityEstimatorManager* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kNetworkQualityEstimatorManager_RequestNotifications_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kNetworkQualityEstimatorManagerValidationInfo[] = {
    {internal::kNetworkQualityEstimatorManager_RequestNotifications_Name,
     {&internal::NetworkQualityEstimatorManager_RequestNotifications_Params_Data::Validate,
      nullptr /* no response */}},
};

bool NetworkQualityEstimatorManagerRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::network::mojom::NetworkQualityEstimatorManager::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kNetworkQualityEstimatorManagerValidationInfo);
}

}  // namespace mojom
}  // namespace network

namespace mojo {

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif