// services/network/public/mojom/network_service.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/network/public/mojom/network_service.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "services/network/public/mojom/network_service.mojom-params-data.h"
#include "services/network/public/mojom/network_service.mojom-shared-message-ids.h"

#include "services/network/public/mojom/network_service.mojom-blink-import-headers.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_NETWORK_SERVICE_MOJOM_BLINK_JUMBO_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_NETWORK_SERVICE_MOJOM_BLINK_JUMBO_H_
#endif
namespace network {
namespace mojom {
namespace blink {
LoadInfo::LoadInfo()
    : process_id(),
      routing_id(),
      host(),
      load_state(),
      state_param(),
      upload_position(),
      upload_size() {}

LoadInfo::LoadInfo(
    int32_t process_id_in,
    int32_t routing_id_in,
    const WTF::String& host_in,
    uint32_t load_state_in,
    const ::WTF::String& state_param_in,
    uint64_t upload_position_in,
    uint64_t upload_size_in)
    : process_id(std::move(process_id_in)),
      routing_id(std::move(routing_id_in)),
      host(std::move(host_in)),
      load_state(std::move(load_state_in)),
      state_param(std::move(state_param_in)),
      upload_position(std::move(upload_position_in)),
      upload_size(std::move(upload_size_in)) {}

LoadInfo::~LoadInfo() = default;

void LoadInfo::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "process_id"), this->process_id, 
      "<value of type int32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "routing_id"), this->routing_id, 
      "<value of type int32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "host"), this->host, 
      "<value of type const WTF::String&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "load_state"), this->load_state, 
      "<value of type uint32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "state_param"), this->state_param, 
      "<value of type const ::WTF::String&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "upload_position"), this->upload_position, 
      "<value of type uint64_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "upload_size"), this->upload_size, 
      "<value of type uint64_t>");
}

bool LoadInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
HttpAuthStaticParams::HttpAuthStaticParams()
    : supported_schemes(),
      gssapi_library_name() {}

HttpAuthStaticParams::HttpAuthStaticParams(
    WTF::Vector<WTF::String> supported_schemes_in,
    const WTF::String& gssapi_library_name_in)
    : supported_schemes(std::move(supported_schemes_in)),
      gssapi_library_name(std::move(gssapi_library_name_in)) {}

HttpAuthStaticParams::~HttpAuthStaticParams() = default;

void HttpAuthStaticParams::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "supported_schemes"), this->supported_schemes, 
      "<value of type const WTF::Vector<WTF::String>&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "gssapi_library_name"), this->gssapi_library_name, 
      "<value of type const WTF::String&>");
}

bool HttpAuthStaticParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
HttpAuthDynamicParams::HttpAuthDynamicParams()
    : server_allowlist(),
      delegate_allowlist(),
      delegate_by_kdc_policy(false),
      negotiate_disable_cname_lookup(false),
      enable_negotiate_port(false),
      ntlm_v2_enabled(true),
      android_negotiate_account_type(),
      allow_gssapi_library_load(true),
      basic_over_http_enabled(true) {}

HttpAuthDynamicParams::HttpAuthDynamicParams(
    const WTF::String& server_allowlist_in,
    const WTF::String& delegate_allowlist_in,
    bool delegate_by_kdc_policy_in,
    bool negotiate_disable_cname_lookup_in,
    bool enable_negotiate_port_in,
    bool ntlm_v2_enabled_in,
    const WTF::String& android_negotiate_account_type_in,
    bool allow_gssapi_library_load_in,
    bool basic_over_http_enabled_in)
    : server_allowlist(std::move(server_allowlist_in)),
      delegate_allowlist(std::move(delegate_allowlist_in)),
      delegate_by_kdc_policy(std::move(delegate_by_kdc_policy_in)),
      negotiate_disable_cname_lookup(std::move(negotiate_disable_cname_lookup_in)),
      enable_negotiate_port(std::move(enable_negotiate_port_in)),
      ntlm_v2_enabled(std::move(ntlm_v2_enabled_in)),
      android_negotiate_account_type(std::move(android_negotiate_account_type_in)),
      allow_gssapi_library_load(std::move(allow_gssapi_library_load_in)),
      basic_over_http_enabled(std::move(basic_over_http_enabled_in)) {}

HttpAuthDynamicParams::~HttpAuthDynamicParams() = default;
size_t HttpAuthDynamicParams::Hash(size_t seed) const {
  seed = mojo::internal::WTFHash(seed, this->server_allowlist);
  seed = mojo::internal::WTFHash(seed, this->delegate_allowlist);
  seed = mojo::internal::WTFHash(seed, this->delegate_by_kdc_policy);
  seed = mojo::internal::WTFHash(seed, this->negotiate_disable_cname_lookup);
  seed = mojo::internal::WTFHash(seed, this->enable_negotiate_port);
  seed = mojo::internal::WTFHash(seed, this->ntlm_v2_enabled);
  seed = mojo::internal::WTFHash(seed, this->android_negotiate_account_type);
  seed = mojo::internal::WTFHash(seed, this->allow_gssapi_library_load);
  seed = mojo::internal::WTFHash(seed, this->basic_over_http_enabled);
  return seed;
}

void HttpAuthDynamicParams::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "server_allowlist"), this->server_allowlist, 
      "<value of type const WTF::String&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "delegate_allowlist"), this->delegate_allowlist, 
      "<value of type const WTF::String&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "delegate_by_kdc_policy"), this->delegate_by_kdc_policy, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "negotiate_disable_cname_lookup"), this->negotiate_disable_cname_lookup, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "enable_negotiate_port"), this->enable_negotiate_port, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "ntlm_v2_enabled"), this->ntlm_v2_enabled, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "android_negotiate_account_type"), this->android_negotiate_account_type, 
      "<value of type const WTF::String&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "allow_gssapi_library_load"), this->allow_gssapi_library_load, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "basic_over_http_enabled"), this->basic_over_http_enabled, 
      "<value of type bool>");
}

bool HttpAuthDynamicParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
CryptConfig::CryptConfig()
    : store(),
      product_name(),
      should_use_preference(),
      user_data_path() {}

CryptConfig::CryptConfig(
    const WTF::String& store_in,
    const WTF::String& product_name_in,
    bool should_use_preference_in,
    const ::base::FilePath& user_data_path_in)
    : store(std::move(store_in)),
      product_name(std::move(product_name_in)),
      should_use_preference(std::move(should_use_preference_in)),
      user_data_path(std::move(user_data_path_in)) {}

CryptConfig::~CryptConfig() = default;

void CryptConfig::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "store"), this->store, 
      "<value of type const WTF::String&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "product_name"), this->product_name, 
      "<value of type const WTF::String&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "should_use_preference"), this->should_use_preference, 
      "<value of type bool>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "user_data_path"), this->user_data_path, 
      "<value of type const ::base::FilePath&>");
}

bool CryptConfig::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
EnvironmentVariable::EnvironmentVariable()
    : name(),
      value() {}

EnvironmentVariable::EnvironmentVariable(
    const WTF::String& name_in,
    const WTF::String& value_in)
    : name(std::move(name_in)),
      value(std::move(value_in)) {}

EnvironmentVariable::~EnvironmentVariable() = default;
size_t EnvironmentVariable::Hash(size_t seed) const {
  seed = mojo::internal::WTFHash(seed, this->name);
  seed = mojo::internal::WTFHash(seed, this->value);
  return seed;
}

void EnvironmentVariable::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "name"), this->name, 
      "<value of type const WTF::String&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "value"), this->value, 
      "<value of type const WTF::String&>");
}

bool EnvironmentVariable::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
NetworkServiceParams::NetworkServiceParams()
    : initial_connection_type(::network::mojom::blink::ConnectionType::CONNECTION_UNKNOWN),
      initial_connection_subtype(::network::mojom::blink::ConnectionSubtype::SUBTYPE_UNKNOWN),
      environment() {}

NetworkServiceParams::NetworkServiceParams(
    ::network::mojom::blink::ConnectionType initial_connection_type_in,
    ::network::mojom::blink::ConnectionSubtype initial_connection_subtype_in,
    WTF::Vector<EnvironmentVariablePtr> environment_in)
    : initial_connection_type(std::move(initial_connection_type_in)),
      initial_connection_subtype(std::move(initial_connection_subtype_in)),
      environment(std::move(environment_in)) {}

NetworkServiceParams::~NetworkServiceParams() = default;

void NetworkServiceParams::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "initial_connection_type"), this->initial_connection_type, 
      "<value of type ::network::mojom::blink::ConnectionType>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "initial_connection_subtype"), this->initial_connection_subtype, 
      "<value of type ::network::mojom::blink::ConnectionSubtype>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "environment"), this->environment, 
      "<value of type WTF::Vector<EnvironmentVariablePtr>>");
}

bool NetworkServiceParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
const char NetworkServiceClient::Name_[] = "network.mojom.NetworkServiceClient";

class NetworkServiceClient_OnLoadingStateUpdate_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NetworkServiceClient_OnLoadingStateUpdate_ForwardToCallback(
      NetworkServiceClient::OnLoadingStateUpdateCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  NetworkServiceClient::OnLoadingStateUpdateCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(NetworkServiceClient_OnLoadingStateUpdate_ForwardToCallback);
};

NetworkServiceClientProxy::NetworkServiceClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void NetworkServiceClientProxy::OnLoadingStateUpdate(
    WTF::Vector<LoadInfoPtr> in_infos, OnLoadingStateUpdateCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::NetworkServiceClient::OnLoadingStateUpdate", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("infos"), in_infos, 
                        "<value of type WTF::Vector<LoadInfoPtr>>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkServiceClient_OnLoadingStateUpdate_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkServiceClient_OnLoadingStateUpdate_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->infos)::BaseType>
      infos_fragment(params.message());
  const mojo::internal::ContainerValidateParams infos_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::LoadInfoDataView>>(
      in_infos, infos_fragment, &infos_validate_params);
  params->infos.Set(
      infos_fragment.is_null() ? nullptr : infos_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->infos.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null infos in NetworkServiceClient.OnLoadingStateUpdate request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkServiceClient::Name_);
  message.set_method_name("OnLoadingStateUpdate");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NetworkServiceClient_OnLoadingStateUpdate_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void NetworkServiceClientProxy::OnDataUseUpdate(
    int32_t in_network_traffic_annotation_id_hash, int64_t in_recv_bytes, int64_t in_sent_bytes) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::NetworkServiceClient::OnDataUseUpdate", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("network_traffic_annotation_id_hash"), in_network_traffic_annotation_id_hash, 
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("recv_bytes"), in_recv_bytes, 
                        "<value of type int64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("sent_bytes"), in_sent_bytes, 
                        "<value of type int64_t>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkServiceClient_OnDataUseUpdate_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkServiceClient_OnDataUseUpdate_Params_Data> params(
          message);
  params.Allocate();
  params->network_traffic_annotation_id_hash = in_network_traffic_annotation_id_hash;
  params->recv_bytes = in_recv_bytes;
  params->sent_bytes = in_sent_bytes;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkServiceClient::Name_);
  message.set_method_name("OnDataUseUpdate");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void NetworkServiceClientProxy::OnRawRequest(
    int32_t in_process_id, int32_t in_routing_id, const WTF::String& in_devtool_request_id, WTF::Vector<::network::mojom::blink::CookieWithAccessResultPtr> in_cookies_with_access_result, WTF::Vector<::network::mojom::blink::HttpRawHeaderPairPtr> in_headers, ::network::mojom::blink::ClientSecurityStatePtr in_client_security_state) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::NetworkServiceClient::OnRawRequest", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("process_id"), in_process_id, 
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("routing_id"), in_routing_id, 
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("devtool_request_id"), in_devtool_request_id, 
                        "<value of type const WTF::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("cookies_with_access_result"), in_cookies_with_access_result, 
                        "<value of type WTF::Vector<::network::mojom::blink::CookieWithAccessResultPtr>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("headers"), in_headers, 
                        "<value of type WTF::Vector<::network::mojom::blink::HttpRawHeaderPairPtr>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client_security_state"), in_client_security_state, 
                        "<value of type ::network::mojom::blink::ClientSecurityStatePtr>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkServiceClient_OnRawRequest_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkServiceClient_OnRawRequest_Params_Data> params(
          message);
  params.Allocate();
  params->process_id = in_process_id;
  params->routing_id = in_routing_id;
  mojo::internal::MessageFragment<
      typename decltype(params->devtool_request_id)::BaseType> devtool_request_id_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_devtool_request_id, devtool_request_id_fragment);
  params->devtool_request_id.Set(
      devtool_request_id_fragment.is_null() ? nullptr : devtool_request_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->devtool_request_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null devtool_request_id in NetworkServiceClient.OnRawRequest request");
  mojo::internal::MessageFragment<
      typename decltype(params->cookies_with_access_result)::BaseType>
      cookies_with_access_result_fragment(params.message());
  const mojo::internal::ContainerValidateParams cookies_with_access_result_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::CookieWithAccessResultDataView>>(
      in_cookies_with_access_result, cookies_with_access_result_fragment, &cookies_with_access_result_validate_params);
  params->cookies_with_access_result.Set(
      cookies_with_access_result_fragment.is_null() ? nullptr : cookies_with_access_result_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->cookies_with_access_result.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null cookies_with_access_result in NetworkServiceClient.OnRawRequest request");
  mojo::internal::MessageFragment<
      typename decltype(params->headers)::BaseType>
      headers_fragment(params.message());
  const mojo::internal::ContainerValidateParams headers_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::HttpRawHeaderPairDataView>>(
      in_headers, headers_fragment, &headers_validate_params);
  params->headers.Set(
      headers_fragment.is_null() ? nullptr : headers_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->headers.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null headers in NetworkServiceClient.OnRawRequest request");
  mojo::internal::MessageFragment<
      typename decltype(params->client_security_state)::BaseType> client_security_state_fragment(
          params.message());
  mojo::internal::Serialize<::network::mojom::ClientSecurityStateDataView>(
      in_client_security_state, client_security_state_fragment);
  params->client_security_state.Set(
      client_security_state_fragment.is_null() ? nullptr : client_security_state_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkServiceClient::Name_);
  message.set_method_name("OnRawRequest");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void NetworkServiceClientProxy::OnRawResponse(
    int32_t in_process_id, int32_t in_routing_id, const WTF::String& in_devtool_request_id, WTF::Vector<::network::mojom::blink::CookieAndLineWithAccessResultPtr> in_cookies_with_access_result, WTF::Vector<::network::mojom::blink::HttpRawHeaderPairPtr> in_headers, const WTF::String& in_raw_response_headers, ::network::mojom::blink::IPAddressSpace in_resource_address_space) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::NetworkServiceClient::OnRawResponse", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("process_id"), in_process_id, 
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("routing_id"), in_routing_id, 
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("devtool_request_id"), in_devtool_request_id, 
                        "<value of type const WTF::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("cookies_with_access_result"), in_cookies_with_access_result, 
                        "<value of type WTF::Vector<::network::mojom::blink::CookieAndLineWithAccessResultPtr>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("headers"), in_headers, 
                        "<value of type WTF::Vector<::network::mojom::blink::HttpRawHeaderPairPtr>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("raw_response_headers"), in_raw_response_headers, 
                        "<value of type const WTF::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("resource_address_space"), in_resource_address_space, 
                        "<value of type ::network::mojom::blink::IPAddressSpace>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkServiceClient_OnRawResponse_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkServiceClient_OnRawResponse_Params_Data> params(
          message);
  params.Allocate();
  params->process_id = in_process_id;
  params->routing_id = in_routing_id;
  mojo::internal::MessageFragment<
      typename decltype(params->devtool_request_id)::BaseType> devtool_request_id_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_devtool_request_id, devtool_request_id_fragment);
  params->devtool_request_id.Set(
      devtool_request_id_fragment.is_null() ? nullptr : devtool_request_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->devtool_request_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null devtool_request_id in NetworkServiceClient.OnRawResponse request");
  mojo::internal::MessageFragment<
      typename decltype(params->cookies_with_access_result)::BaseType>
      cookies_with_access_result_fragment(params.message());
  const mojo::internal::ContainerValidateParams cookies_with_access_result_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::CookieAndLineWithAccessResultDataView>>(
      in_cookies_with_access_result, cookies_with_access_result_fragment, &cookies_with_access_result_validate_params);
  params->cookies_with_access_result.Set(
      cookies_with_access_result_fragment.is_null() ? nullptr : cookies_with_access_result_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->cookies_with_access_result.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null cookies_with_access_result in NetworkServiceClient.OnRawResponse request");
  mojo::internal::MessageFragment<
      typename decltype(params->headers)::BaseType>
      headers_fragment(params.message());
  const mojo::internal::ContainerValidateParams headers_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::HttpRawHeaderPairDataView>>(
      in_headers, headers_fragment, &headers_validate_params);
  params->headers.Set(
      headers_fragment.is_null() ? nullptr : headers_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->headers.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null headers in NetworkServiceClient.OnRawResponse request");
  mojo::internal::MessageFragment<
      typename decltype(params->raw_response_headers)::BaseType> raw_response_headers_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_raw_response_headers, raw_response_headers_fragment);
  params->raw_response_headers.Set(
      raw_response_headers_fragment.is_null() ? nullptr : raw_response_headers_fragment.data());
  mojo::internal::Serialize<::network::mojom::IPAddressSpace>(
      in_resource_address_space, &params->resource_address_space);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkServiceClient::Name_);
  message.set_method_name("OnRawResponse");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void NetworkServiceClientProxy::OnPrivateNetworkRequest(
    int32_t in_process_id, int32_t in_routing_id, const WTF::String& in_devtool_request_id, const ::blink::KURL& in_url, bool in_is_warning, ::network::mojom::blink::IPAddressSpace in_resource_address_space, ::network::mojom::blink::ClientSecurityStatePtr in_client_security_state) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::NetworkServiceClient::OnPrivateNetworkRequest", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("process_id"), in_process_id, 
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("routing_id"), in_routing_id, 
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("devtool_request_id"), in_devtool_request_id, 
                        "<value of type const WTF::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url, 
                        "<value of type const ::blink::KURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_warning"), in_is_warning, 
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("resource_address_space"), in_resource_address_space, 
                        "<value of type ::network::mojom::blink::IPAddressSpace>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client_security_state"), in_client_security_state, 
                        "<value of type ::network::mojom::blink::ClientSecurityStatePtr>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkServiceClient_OnPrivateNetworkRequest_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkServiceClient_OnPrivateNetworkRequest_Params_Data> params(
          message);
  params.Allocate();
  params->process_id = in_process_id;
  params->routing_id = in_routing_id;
  mojo::internal::MessageFragment<
      typename decltype(params->devtool_request_id)::BaseType> devtool_request_id_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_devtool_request_id, devtool_request_id_fragment);
  params->devtool_request_id.Set(
      devtool_request_id_fragment.is_null() ? nullptr : devtool_request_id_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_url, url_fragment);
  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->url.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url in NetworkServiceClient.OnPrivateNetworkRequest request");
  params->is_warning = in_is_warning;
  mojo::internal::Serialize<::network::mojom::IPAddressSpace>(
      in_resource_address_space, &params->resource_address_space);
  mojo::internal::MessageFragment<
      typename decltype(params->client_security_state)::BaseType> client_security_state_fragment(
          params.message());
  mojo::internal::Serialize<::network::mojom::ClientSecurityStateDataView>(
      in_client_security_state, client_security_state_fragment);
  params->client_security_state.Set(
      client_security_state_fragment.is_null() ? nullptr : client_security_state_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->client_security_state.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null client_security_state in NetworkServiceClient.OnPrivateNetworkRequest request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkServiceClient::Name_);
  message.set_method_name("OnPrivateNetworkRequest");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void NetworkServiceClientProxy::OnCorsPreflightRequest(
    int32_t in_process_id, int32_t in_render_frame_id, const ::base::UnguessableToken& in_devtool_request_id, const ::network::ResourceRequest& in_request, const ::blink::KURL& in_initiator_url, const WTF::String& in_initiator_devtool_request_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::NetworkServiceClient::OnCorsPreflightRequest", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("process_id"), in_process_id, 
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("render_frame_id"), in_render_frame_id, 
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("devtool_request_id"), in_devtool_request_id, 
                        "<value of type const ::base::UnguessableToken&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("request"), in_request, 
                        "<value of type const ::network::ResourceRequest&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("initiator_url"), in_initiator_url, 
                        "<value of type const ::blink::KURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("initiator_devtool_request_id"), in_initiator_devtool_request_id, 
                        "<value of type const WTF::String&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkServiceClient_OnCorsPreflightRequest_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkServiceClient_OnCorsPreflightRequest_Params_Data> params(
          message);
  params.Allocate();
  params->process_id = in_process_id;
  params->render_frame_id = in_render_frame_id;
  mojo::internal::MessageFragment<
      typename decltype(params->devtool_request_id)::BaseType> devtool_request_id_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
      in_devtool_request_id, devtool_request_id_fragment);
  params->devtool_request_id.Set(
      devtool_request_id_fragment.is_null() ? nullptr : devtool_request_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->devtool_request_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null devtool_request_id in NetworkServiceClient.OnCorsPreflightRequest request");
  mojo::internal::MessageFragment<
      typename decltype(params->request)::BaseType> request_fragment(
          params.message());
  mojo::internal::Serialize<::network::mojom::URLRequestDataView>(
      in_request, request_fragment);
  params->request.Set(
      request_fragment.is_null() ? nullptr : request_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->request.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null request in NetworkServiceClient.OnCorsPreflightRequest request");
  mojo::internal::MessageFragment<
      typename decltype(params->initiator_url)::BaseType> initiator_url_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_initiator_url, initiator_url_fragment);
  params->initiator_url.Set(
      initiator_url_fragment.is_null() ? nullptr : initiator_url_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->initiator_url.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null initiator_url in NetworkServiceClient.OnCorsPreflightRequest request");
  mojo::internal::MessageFragment<
      typename decltype(params->initiator_devtool_request_id)::BaseType> initiator_devtool_request_id_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_initiator_devtool_request_id, initiator_devtool_request_id_fragment);
  params->initiator_devtool_request_id.Set(
      initiator_devtool_request_id_fragment.is_null() ? nullptr : initiator_devtool_request_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->initiator_devtool_request_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null initiator_devtool_request_id in NetworkServiceClient.OnCorsPreflightRequest request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkServiceClient::Name_);
  message.set_method_name("OnCorsPreflightRequest");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void NetworkServiceClientProxy::OnCorsPreflightResponse(
    int32_t in_process_id, int32_t in_render_frame_id, const ::base::UnguessableToken& in_devtool_request_id, const ::blink::KURL& in_url, ::network::mojom::blink::URLResponseHeadPtr in_head) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::NetworkServiceClient::OnCorsPreflightResponse", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("process_id"), in_process_id, 
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("render_frame_id"), in_render_frame_id, 
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("devtool_request_id"), in_devtool_request_id, 
                        "<value of type const ::base::UnguessableToken&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url, 
                        "<value of type const ::blink::KURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("head"), in_head, 
                        "<value of type ::network::mojom::blink::URLResponseHeadPtr>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkServiceClient_OnCorsPreflightResponse_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkServiceClient_OnCorsPreflightResponse_Params_Data> params(
          message);
  params.Allocate();
  params->process_id = in_process_id;
  params->render_frame_id = in_render_frame_id;
  mojo::internal::MessageFragment<
      typename decltype(params->devtool_request_id)::BaseType> devtool_request_id_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
      in_devtool_request_id, devtool_request_id_fragment);
  params->devtool_request_id.Set(
      devtool_request_id_fragment.is_null() ? nullptr : devtool_request_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->devtool_request_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null devtool_request_id in NetworkServiceClient.OnCorsPreflightResponse request");
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_url, url_fragment);
  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->url.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url in NetworkServiceClient.OnCorsPreflightResponse request");
  mojo::internal::MessageFragment<
      typename decltype(params->head)::BaseType> head_fragment(
          params.message());
  mojo::internal::Serialize<::network::mojom::URLResponseHeadDataView>(
      in_head, head_fragment);
  params->head.Set(
      head_fragment.is_null() ? nullptr : head_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->head.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null head in NetworkServiceClient.OnCorsPreflightResponse request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkServiceClient::Name_);
  message.set_method_name("OnCorsPreflightResponse");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void NetworkServiceClientProxy::OnCorsPreflightRequestCompleted(
    int32_t in_process_id, int32_t in_render_frame_id, const ::base::UnguessableToken& in_devtool_request_id, ::network::mojom::blink::URLLoaderCompletionStatusPtr in_status) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::NetworkServiceClient::OnCorsPreflightRequestCompleted", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("process_id"), in_process_id, 
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("render_frame_id"), in_render_frame_id, 
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("devtool_request_id"), in_devtool_request_id, 
                        "<value of type const ::base::UnguessableToken&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status, 
                        "<value of type ::network::mojom::blink::URLLoaderCompletionStatusPtr>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkServiceClient_OnCorsPreflightRequestCompleted_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkServiceClient_OnCorsPreflightRequestCompleted_Params_Data> params(
          message);
  params.Allocate();
  params->process_id = in_process_id;
  params->render_frame_id = in_render_frame_id;
  mojo::internal::MessageFragment<
      typename decltype(params->devtool_request_id)::BaseType> devtool_request_id_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
      in_devtool_request_id, devtool_request_id_fragment);
  params->devtool_request_id.Set(
      devtool_request_id_fragment.is_null() ? nullptr : devtool_request_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->devtool_request_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null devtool_request_id in NetworkServiceClient.OnCorsPreflightRequestCompleted request");
  mojo::internal::MessageFragment<
      typename decltype(params->status)::BaseType> status_fragment(
          params.message());
  mojo::internal::Serialize<::network::mojom::URLLoaderCompletionStatusDataView>(
      in_status, status_fragment);
  params->status.Set(
      status_fragment.is_null() ? nullptr : status_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->status.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null status in NetworkServiceClient.OnCorsPreflightRequestCompleted request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkServiceClient::Name_);
  message.set_method_name("OnCorsPreflightRequestCompleted");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void NetworkServiceClientProxy::OnTrustTokenOperationDone(
    int32_t in_process_id, int32_t in_routing_id, const WTF::String& in_devtool_request_id, ::network::mojom::blink::TrustTokenOperationResultPtr in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::NetworkServiceClient::OnTrustTokenOperationDone", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("process_id"), in_process_id, 
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("routing_id"), in_routing_id, 
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("devtool_request_id"), in_devtool_request_id, 
                        "<value of type const WTF::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result, 
                        "<value of type ::network::mojom::blink::TrustTokenOperationResultPtr>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkServiceClient_OnTrustTokenOperationDone_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkServiceClient_OnTrustTokenOperationDone_Params_Data> params(
          message);
  params.Allocate();
  params->process_id = in_process_id;
  params->routing_id = in_routing_id;
  mojo::internal::MessageFragment<
      typename decltype(params->devtool_request_id)::BaseType> devtool_request_id_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_devtool_request_id, devtool_request_id_fragment);
  params->devtool_request_id.Set(
      devtool_request_id_fragment.is_null() ? nullptr : devtool_request_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->devtool_request_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null devtool_request_id in NetworkServiceClient.OnTrustTokenOperationDone request");
  mojo::internal::MessageFragment<
      typename decltype(params->result)::BaseType> result_fragment(
          params.message());
  mojo::internal::Serialize<::network::mojom::TrustTokenOperationResultDataView>(
      in_result, result_fragment);
  params->result.Set(
      result_fragment.is_null() ? nullptr : result_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->result.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null result in NetworkServiceClient.OnTrustTokenOperationDone request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkServiceClient::Name_);
  message.set_method_name("OnTrustTokenOperationDone");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}
class NetworkServiceClient_OnLoadingStateUpdate_ProxyToResponder {
 public:
  static NetworkServiceClient::OnLoadingStateUpdateCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<NetworkServiceClient_OnLoadingStateUpdate_ProxyToResponder> proxy(
        new NetworkServiceClient_OnLoadingStateUpdate_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&NetworkServiceClient_OnLoadingStateUpdate_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NetworkServiceClient_OnLoadingStateUpdate_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  NetworkServiceClient_OnLoadingStateUpdate_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "NetworkServiceClient::OnLoadingStateUpdateCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(NetworkServiceClient_OnLoadingStateUpdate_ProxyToResponder);
};

bool NetworkServiceClient_OnLoadingStateUpdate_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "network::mojom::NetworkServiceClient::OnLoadingStateUpdateCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::NetworkServiceClient_OnLoadingStateUpdate_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NetworkServiceClient_OnLoadingStateUpdate_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  NetworkServiceClient_OnLoadingStateUpdate_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NetworkServiceClient::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run();
  return true;
}

void NetworkServiceClient_OnLoadingStateUpdate_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "(Impl)network::mojom::NetworkServiceClient::OnLoadingStateUpdateCallback");
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkServiceClient_OnLoadingStateUpdate_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkServiceClient_OnLoadingStateUpdate_ResponseParams_Data> params(
          message);
  params.Allocate();

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)network::mojom::NetworkServiceClient::OnLoadingStateUpdateCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkServiceClient::Name_);
  message.set_method_name("OnLoadingStateUpdate");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool NetworkServiceClientStubDispatch::Accept(
    NetworkServiceClient* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kNetworkServiceClient_OnLoadingStateUpdate_Name: {
      break;
    }
    case internal::kNetworkServiceClient_OnDataUseUpdate_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::NetworkServiceClient::OnDataUseUpdate",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::NetworkServiceClient::OnDataUseUpdate");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::NetworkServiceClient_OnDataUseUpdate_Params_Data* params =
          reinterpret_cast<internal::NetworkServiceClient_OnDataUseUpdate_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      int32_t p_network_traffic_annotation_id_hash{};
      int64_t p_recv_bytes{};
      int64_t p_sent_bytes{};
      NetworkServiceClient_OnDataUseUpdate_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_network_traffic_annotation_id_hash = input_data_view.network_traffic_annotation_id_hash();
      if (success)
        p_recv_bytes = input_data_view.recv_bytes();
      if (success)
        p_sent_bytes = input_data_view.sent_bytes();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkServiceClient::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnDataUseUpdate(
std::move(p_network_traffic_annotation_id_hash), 
std::move(p_recv_bytes), 
std::move(p_sent_bytes));
      return true;
    }
    case internal::kNetworkServiceClient_OnRawRequest_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::NetworkServiceClient::OnRawRequest",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::NetworkServiceClient::OnRawRequest");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::NetworkServiceClient_OnRawRequest_Params_Data* params =
          reinterpret_cast<internal::NetworkServiceClient_OnRawRequest_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      int32_t p_process_id{};
      int32_t p_routing_id{};
      WTF::String p_devtool_request_id{};
      WTF::Vector<::network::mojom::blink::CookieWithAccessResultPtr> p_cookies_with_access_result{};
      WTF::Vector<::network::mojom::blink::HttpRawHeaderPairPtr> p_headers{};
      ::network::mojom::blink::ClientSecurityStatePtr p_client_security_state{};
      NetworkServiceClient_OnRawRequest_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_process_id = input_data_view.process_id();
      if (success)
        p_routing_id = input_data_view.routing_id();
      if (success && !input_data_view.ReadDevtoolRequestId(&p_devtool_request_id))
        success = false;
      if (success && !input_data_view.ReadCookiesWithAccessResult(&p_cookies_with_access_result))
        success = false;
      if (success && !input_data_view.ReadHeaders(&p_headers))
        success = false;
      if (success && !input_data_view.ReadClientSecurityState(&p_client_security_state))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkServiceClient::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnRawRequest(
std::move(p_process_id), 
std::move(p_routing_id), 
std::move(p_devtool_request_id), 
std::move(p_cookies_with_access_result), 
std::move(p_headers), 
std::move(p_client_security_state));
      return true;
    }
    case internal::kNetworkServiceClient_OnRawResponse_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::NetworkServiceClient::OnRawResponse",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::NetworkServiceClient::OnRawResponse");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::NetworkServiceClient_OnRawResponse_Params_Data* params =
          reinterpret_cast<internal::NetworkServiceClient_OnRawResponse_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      int32_t p_process_id{};
      int32_t p_routing_id{};
      WTF::String p_devtool_request_id{};
      WTF::Vector<::network::mojom::blink::CookieAndLineWithAccessResultPtr> p_cookies_with_access_result{};
      WTF::Vector<::network::mojom::blink::HttpRawHeaderPairPtr> p_headers{};
      WTF::String p_raw_response_headers{};
      ::network::mojom::blink::IPAddressSpace p_resource_address_space{};
      NetworkServiceClient_OnRawResponse_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_process_id = input_data_view.process_id();
      if (success)
        p_routing_id = input_data_view.routing_id();
      if (success && !input_data_view.ReadDevtoolRequestId(&p_devtool_request_id))
        success = false;
      if (success && !input_data_view.ReadCookiesWithAccessResult(&p_cookies_with_access_result))
        success = false;
      if (success && !input_data_view.ReadHeaders(&p_headers))
        success = false;
      if (success && !input_data_view.ReadRawResponseHeaders(&p_raw_response_headers))
        success = false;
      if (success && !input_data_view.ReadResourceAddressSpace(&p_resource_address_space))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkServiceClient::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnRawResponse(
std::move(p_process_id), 
std::move(p_routing_id), 
std::move(p_devtool_request_id), 
std::move(p_cookies_with_access_result), 
std::move(p_headers), 
std::move(p_raw_response_headers), 
std::move(p_resource_address_space));
      return true;
    }
    case internal::kNetworkServiceClient_OnPrivateNetworkRequest_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::NetworkServiceClient::OnPrivateNetworkRequest",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::NetworkServiceClient::OnPrivateNetworkRequest");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::NetworkServiceClient_OnPrivateNetworkRequest_Params_Data* params =
          reinterpret_cast<internal::NetworkServiceClient_OnPrivateNetworkRequest_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      int32_t p_process_id{};
      int32_t p_routing_id{};
      WTF::String p_devtool_request_id{};
      ::blink::KURL p_url{};
      bool p_is_warning{};
      ::network::mojom::blink::IPAddressSpace p_resource_address_space{};
      ::network::mojom::blink::ClientSecurityStatePtr p_client_security_state{};
      NetworkServiceClient_OnPrivateNetworkRequest_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_process_id = input_data_view.process_id();
      if (success)
        p_routing_id = input_data_view.routing_id();
      if (success && !input_data_view.ReadDevtoolRequestId(&p_devtool_request_id))
        success = false;
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (success)
        p_is_warning = input_data_view.is_warning();
      if (success && !input_data_view.ReadResourceAddressSpace(&p_resource_address_space))
        success = false;
      if (success && !input_data_view.ReadClientSecurityState(&p_client_security_state))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkServiceClient::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnPrivateNetworkRequest(
std::move(p_process_id), 
std::move(p_routing_id), 
std::move(p_devtool_request_id), 
std::move(p_url), 
std::move(p_is_warning), 
std::move(p_resource_address_space), 
std::move(p_client_security_state));
      return true;
    }
    case internal::kNetworkServiceClient_OnCorsPreflightRequest_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::NetworkServiceClient::OnCorsPreflightRequest",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::NetworkServiceClient::OnCorsPreflightRequest");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::NetworkServiceClient_OnCorsPreflightRequest_Params_Data* params =
          reinterpret_cast<internal::NetworkServiceClient_OnCorsPreflightRequest_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      int32_t p_process_id{};
      int32_t p_render_frame_id{};
      ::base::UnguessableToken p_devtool_request_id{};
      ::network::ResourceRequest p_request{};
      ::blink::KURL p_initiator_url{};
      WTF::String p_initiator_devtool_request_id{};
      NetworkServiceClient_OnCorsPreflightRequest_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_process_id = input_data_view.process_id();
      if (success)
        p_render_frame_id = input_data_view.render_frame_id();
      if (success && !input_data_view.ReadDevtoolRequestId(&p_devtool_request_id))
        success = false;
      if (success && !input_data_view.ReadRequest(&p_request))
        success = false;
      if (success && !input_data_view.ReadInitiatorUrl(&p_initiator_url))
        success = false;
      if (success && !input_data_view.ReadInitiatorDevtoolRequestId(&p_initiator_devtool_request_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkServiceClient::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnCorsPreflightRequest(
std::move(p_process_id), 
std::move(p_render_frame_id), 
std::move(p_devtool_request_id), 
std::move(p_request), 
std::move(p_initiator_url), 
std::move(p_initiator_devtool_request_id));
      return true;
    }
    case internal::kNetworkServiceClient_OnCorsPreflightResponse_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::NetworkServiceClient::OnCorsPreflightResponse",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::NetworkServiceClient::OnCorsPreflightResponse");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::NetworkServiceClient_OnCorsPreflightResponse_Params_Data* params =
          reinterpret_cast<internal::NetworkServiceClient_OnCorsPreflightResponse_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      int32_t p_process_id{};
      int32_t p_render_frame_id{};
      ::base::UnguessableToken p_devtool_request_id{};
      ::blink::KURL p_url{};
      ::network::mojom::blink::URLResponseHeadPtr p_head{};
      NetworkServiceClient_OnCorsPreflightResponse_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_process_id = input_data_view.process_id();
      if (success)
        p_render_frame_id = input_data_view.render_frame_id();
      if (success && !input_data_view.ReadDevtoolRequestId(&p_devtool_request_id))
        success = false;
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (success && !input_data_view.ReadHead(&p_head))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkServiceClient::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnCorsPreflightResponse(
std::move(p_process_id), 
std::move(p_render_frame_id), 
std::move(p_devtool_request_id), 
std::move(p_url), 
std::move(p_head));
      return true;
    }
    case internal::kNetworkServiceClient_OnCorsPreflightRequestCompleted_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::NetworkServiceClient::OnCorsPreflightRequestCompleted",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::NetworkServiceClient::OnCorsPreflightRequestCompleted");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::NetworkServiceClient_OnCorsPreflightRequestCompleted_Params_Data* params =
          reinterpret_cast<internal::NetworkServiceClient_OnCorsPreflightRequestCompleted_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      int32_t p_process_id{};
      int32_t p_render_frame_id{};
      ::base::UnguessableToken p_devtool_request_id{};
      ::network::mojom::blink::URLLoaderCompletionStatusPtr p_status{};
      NetworkServiceClient_OnCorsPreflightRequestCompleted_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_process_id = input_data_view.process_id();
      if (success)
        p_render_frame_id = input_data_view.render_frame_id();
      if (success && !input_data_view.ReadDevtoolRequestId(&p_devtool_request_id))
        success = false;
      if (success && !input_data_view.ReadStatus(&p_status))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkServiceClient::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnCorsPreflightRequestCompleted(
std::move(p_process_id), 
std::move(p_render_frame_id), 
std::move(p_devtool_request_id), 
std::move(p_status));
      return true;
    }
    case internal::kNetworkServiceClient_OnTrustTokenOperationDone_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::NetworkServiceClient::OnTrustTokenOperationDone",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::NetworkServiceClient::OnTrustTokenOperationDone");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::NetworkServiceClient_OnTrustTokenOperationDone_Params_Data* params =
          reinterpret_cast<internal::NetworkServiceClient_OnTrustTokenOperationDone_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      int32_t p_process_id{};
      int32_t p_routing_id{};
      WTF::String p_devtool_request_id{};
      ::network::mojom::blink::TrustTokenOperationResultPtr p_result{};
      NetworkServiceClient_OnTrustTokenOperationDone_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_process_id = input_data_view.process_id();
      if (success)
        p_routing_id = input_data_view.routing_id();
      if (success && !input_data_view.ReadDevtoolRequestId(&p_devtool_request_id))
        success = false;
      if (success && !input_data_view.ReadResult(&p_result))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkServiceClient::Name_, 8, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnTrustTokenOperationDone(
std::move(p_process_id), 
std::move(p_routing_id), 
std::move(p_devtool_request_id), 
std::move(p_result));
      return true;
    }
  }
  return false;
}

// static
bool NetworkServiceClientStubDispatch::AcceptWithResponder(
    NetworkServiceClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kNetworkServiceClient_OnLoadingStateUpdate_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::NetworkServiceClient::OnLoadingStateUpdate",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::NetworkServiceClient::OnLoadingStateUpdate");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::NetworkServiceClient_OnLoadingStateUpdate_Params_Data* params =
          reinterpret_cast<
              internal::NetworkServiceClient_OnLoadingStateUpdate_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      WTF::Vector<LoadInfoPtr> p_infos{};
      NetworkServiceClient_OnLoadingStateUpdate_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadInfos(&p_infos))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkServiceClient::Name_, 0, false);
        return false;
      }
      NetworkServiceClient::OnLoadingStateUpdateCallback callback =
          NetworkServiceClient_OnLoadingStateUpdate_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnLoadingStateUpdate(
std::move(p_infos), std::move(callback));
      return true;
    }
    case internal::kNetworkServiceClient_OnDataUseUpdate_Name: {
      break;
    }
    case internal::kNetworkServiceClient_OnRawRequest_Name: {
      break;
    }
    case internal::kNetworkServiceClient_OnRawResponse_Name: {
      break;
    }
    case internal::kNetworkServiceClient_OnPrivateNetworkRequest_Name: {
      break;
    }
    case internal::kNetworkServiceClient_OnCorsPreflightRequest_Name: {
      break;
    }
    case internal::kNetworkServiceClient_OnCorsPreflightResponse_Name: {
      break;
    }
    case internal::kNetworkServiceClient_OnCorsPreflightRequestCompleted_Name: {
      break;
    }
    case internal::kNetworkServiceClient_OnTrustTokenOperationDone_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kNetworkServiceClientValidationInfo[] = {
    {internal::kNetworkServiceClient_OnLoadingStateUpdate_Name,
     {&internal::NetworkServiceClient_OnLoadingStateUpdate_Params_Data::Validate,
      &internal::NetworkServiceClient_OnLoadingStateUpdate_ResponseParams_Data::Validate}},
    {internal::kNetworkServiceClient_OnDataUseUpdate_Name,
     {&internal::NetworkServiceClient_OnDataUseUpdate_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kNetworkServiceClient_OnRawRequest_Name,
     {&internal::NetworkServiceClient_OnRawRequest_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kNetworkServiceClient_OnRawResponse_Name,
     {&internal::NetworkServiceClient_OnRawResponse_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kNetworkServiceClient_OnPrivateNetworkRequest_Name,
     {&internal::NetworkServiceClient_OnPrivateNetworkRequest_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kNetworkServiceClient_OnCorsPreflightRequest_Name,
     {&internal::NetworkServiceClient_OnCorsPreflightRequest_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kNetworkServiceClient_OnCorsPreflightResponse_Name,
     {&internal::NetworkServiceClient_OnCorsPreflightResponse_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kNetworkServiceClient_OnCorsPreflightRequestCompleted_Name,
     {&internal::NetworkServiceClient_OnCorsPreflightRequestCompleted_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kNetworkServiceClient_OnTrustTokenOperationDone_Name,
     {&internal::NetworkServiceClient_OnTrustTokenOperationDone_Params_Data::Validate,
      nullptr /* no response */}},
};

bool NetworkServiceClientRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::network::mojom::blink::NetworkServiceClient::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kNetworkServiceClientValidationInfo);
}

bool NetworkServiceClientResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::network::mojom::blink::NetworkServiceClient::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kNetworkServiceClientValidationInfo);

}
const char NetworkService::Name_[] = "network.mojom.NetworkService";

class NetworkService_GetTotalNetworkUsages_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NetworkService_GetTotalNetworkUsages_ForwardToCallback(
      NetworkService::GetTotalNetworkUsagesCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  NetworkService::GetTotalNetworkUsagesCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(NetworkService_GetTotalNetworkUsages_ForwardToCallback);
};

class NetworkService_GetNetworkList_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NetworkService_GetNetworkList_ForwardToCallback(
      NetworkService::GetNetworkListCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  NetworkService::GetNetworkListCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(NetworkService_GetNetworkList_ForwardToCallback);
};

class NetworkService_UpdateCRLSet_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NetworkService_UpdateCRLSet_ForwardToCallback(
      NetworkService::UpdateCRLSetCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  NetworkService::UpdateCRLSetCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(NetworkService_UpdateCRLSet_ForwardToCallback);
};

class NetworkService_SetTrustTokenKeyCommitments_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NetworkService_SetTrustTokenKeyCommitments_ForwardToCallback(
      NetworkService::SetTrustTokenKeyCommitmentsCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  NetworkService::SetTrustTokenKeyCommitmentsCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(NetworkService_SetTrustTokenKeyCommitments_ForwardToCallback);
};

NetworkServiceProxy::NetworkServiceProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void NetworkServiceProxy::SetClient(
    ::mojo::PendingRemote<NetworkServiceClient> in_client, NetworkServiceParamsPtr in_params) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::NetworkService::SetClient", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client"), in_client, 
                        "<value of type ::mojo::PendingRemote<NetworkServiceClient>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("params"), in_params, 
                        "<value of type NetworkServiceParamsPtr>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkService_SetClient_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkService_SetClient_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::network::mojom::NetworkServiceClientInterfaceBase>>(
      in_client, &params->client, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->client),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid client in NetworkService.SetClient request");
  mojo::internal::MessageFragment<
      typename decltype(params->params)::BaseType> params_fragment(
          params.message());
  mojo::internal::Serialize<::network::mojom::NetworkServiceParamsDataView>(
      in_params, params_fragment);
  params->params.Set(
      params_fragment.is_null() ? nullptr : params_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->params.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null params in NetworkService.SetClient request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkService::Name_);
  message.set_method_name("SetClient");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void NetworkServiceProxy::StartNetLog(
    ::base::File in_file, ::network::mojom::blink::NetLogCaptureMode in_capture_mode, ::base::Value in_constants) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::NetworkService::StartNetLog", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("file"), in_file, 
                        "<value of type ::base::File>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("capture_mode"), in_capture_mode, 
                        "<value of type ::network::mojom::blink::NetLogCaptureMode>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("constants"), in_constants, 
                        "<value of type ::base::Value>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkService_StartNetLog_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkService_StartNetLog_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->file)::BaseType> file_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::FileDataView>(
      in_file, file_fragment);
  params->file.Set(
      file_fragment.is_null() ? nullptr : file_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->file.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null file in NetworkService.StartNetLog request");
  mojo::internal::Serialize<::network::mojom::NetLogCaptureMode>(
      in_capture_mode, &params->capture_mode);
  mojo::internal::MessageFragment<
      typename decltype(params->constants)::BaseType> constants_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::DictionaryValueDataView>(
      in_constants, constants_fragment);
  params->constants.Set(
      constants_fragment.is_null() ? nullptr : constants_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->constants.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null constants in NetworkService.StartNetLog request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkService::Name_);
  message.set_method_name("StartNetLog");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void NetworkServiceProxy::AttachNetLogProxy(
    ::mojo::PendingRemote<::network::mojom::blink::NetLogProxySource> in_proxy_source, ::mojo::PendingReceiver<::network::mojom::blink::NetLogProxySink> in_proxy_sink) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::NetworkService::AttachNetLogProxy", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("proxy_source"), in_proxy_source, 
                        "<value of type ::mojo::PendingRemote<::network::mojom::blink::NetLogProxySource>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("proxy_sink"), in_proxy_sink, 
                        "<value of type ::mojo::PendingReceiver<::network::mojom::blink::NetLogProxySink>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkService_AttachNetLogProxy_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkService_AttachNetLogProxy_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::network::mojom::NetLogProxySourceInterfaceBase>>(
      in_proxy_source, &params->proxy_source, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->proxy_source),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid proxy_source in NetworkService.AttachNetLogProxy request");
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::network::mojom::NetLogProxySinkInterfaceBase>>(
      in_proxy_sink, &params->proxy_sink, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->proxy_sink),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid proxy_sink in NetworkService.AttachNetLogProxy request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkService::Name_);
  message.set_method_name("AttachNetLogProxy");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void NetworkServiceProxy::SetSSLKeyLogFile(
    ::base::File in_file) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::NetworkService::SetSSLKeyLogFile", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("file"), in_file, 
                        "<value of type ::base::File>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkService_SetSSLKeyLogFile_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkService_SetSSLKeyLogFile_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->file)::BaseType> file_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::FileDataView>(
      in_file, file_fragment);
  params->file.Set(
      file_fragment.is_null() ? nullptr : file_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->file.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null file in NetworkService.SetSSLKeyLogFile request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkService::Name_);
  message.set_method_name("SetSSLKeyLogFile");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void NetworkServiceProxy::CreateNetworkContext(
    ::mojo::PendingReceiver<::network::mojom::blink::NetworkContext> in_context, ::network::mojom::blink::NetworkContextParamsPtr in_params) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::NetworkService::CreateNetworkContext", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("context"), in_context, 
                        "<value of type ::mojo::PendingReceiver<::network::mojom::blink::NetworkContext>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("params"), in_params, 
                        "<value of type ::network::mojom::blink::NetworkContextParamsPtr>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkService_CreateNetworkContext_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkService_CreateNetworkContext_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::network::mojom::NetworkContextInterfaceBase>>(
      in_context, &params->context, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->context),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid context in NetworkService.CreateNetworkContext request");
  mojo::internal::MessageFragment<
      typename decltype(params->params)::BaseType> params_fragment(
          params.message());
  mojo::internal::Serialize<::network::mojom::NetworkContextParamsDataView>(
      in_params, params_fragment);
  params->params.Set(
      params_fragment.is_null() ? nullptr : params_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->params.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null params in NetworkService.CreateNetworkContext request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkService::Name_);
  message.set_method_name("CreateNetworkContext");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void NetworkServiceProxy::ConfigureStubHostResolver(
    bool in_insecure_dns_client_enabled, ::network::mojom::blink::SecureDnsMode in_secure_dns_mode, base::Optional<WTF::Vector<::network::mojom::blink::DnsOverHttpsServerPtr>> in_dns_over_https_servers) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::NetworkService::ConfigureStubHostResolver", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("insecure_dns_client_enabled"), in_insecure_dns_client_enabled, 
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("secure_dns_mode"), in_secure_dns_mode, 
                        "<value of type ::network::mojom::blink::SecureDnsMode>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("dns_over_https_servers"), in_dns_over_https_servers, 
                        "<value of type base::Optional<WTF::Vector<::network::mojom::blink::DnsOverHttpsServerPtr>>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkService_ConfigureStubHostResolver_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkService_ConfigureStubHostResolver_Params_Data> params(
          message);
  params.Allocate();
  params->insecure_dns_client_enabled = in_insecure_dns_client_enabled;
  mojo::internal::Serialize<::network::mojom::SecureDnsMode>(
      in_secure_dns_mode, &params->secure_dns_mode);
  mojo::internal::MessageFragment<
      typename decltype(params->dns_over_https_servers)::BaseType>
      dns_over_https_servers_fragment(params.message());
  const mojo::internal::ContainerValidateParams dns_over_https_servers_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::DnsOverHttpsServerDataView>>(
      in_dns_over_https_servers, dns_over_https_servers_fragment, &dns_over_https_servers_validate_params);
  params->dns_over_https_servers.Set(
      dns_over_https_servers_fragment.is_null() ? nullptr : dns_over_https_servers_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkService::Name_);
  message.set_method_name("ConfigureStubHostResolver");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void NetworkServiceProxy::DisableQuic(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "network::mojom::NetworkService::DisableQuic");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkService_DisableQuic_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkService_DisableQuic_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkService::Name_);
  message.set_method_name("DisableQuic");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void NetworkServiceProxy::SetUpHttpAuth(
    HttpAuthStaticParamsPtr in_http_auth_static_params) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::NetworkService::SetUpHttpAuth", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("http_auth_static_params"), in_http_auth_static_params, 
                        "<value of type HttpAuthStaticParamsPtr>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkService_SetUpHttpAuth_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkService_SetUpHttpAuth_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->http_auth_static_params)::BaseType> http_auth_static_params_fragment(
          params.message());
  mojo::internal::Serialize<::network::mojom::HttpAuthStaticParamsDataView>(
      in_http_auth_static_params, http_auth_static_params_fragment);
  params->http_auth_static_params.Set(
      http_auth_static_params_fragment.is_null() ? nullptr : http_auth_static_params_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->http_auth_static_params.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null http_auth_static_params in NetworkService.SetUpHttpAuth request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkService::Name_);
  message.set_method_name("SetUpHttpAuth");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void NetworkServiceProxy::ConfigureHttpAuthPrefs(
    HttpAuthDynamicParamsPtr in_http_auth_dynamic_params) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::NetworkService::ConfigureHttpAuthPrefs", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("http_auth_dynamic_params"), in_http_auth_dynamic_params, 
                        "<value of type HttpAuthDynamicParamsPtr>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkService_ConfigureHttpAuthPrefs_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkService_ConfigureHttpAuthPrefs_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->http_auth_dynamic_params)::BaseType> http_auth_dynamic_params_fragment(
          params.message());
  mojo::internal::Serialize<::network::mojom::HttpAuthDynamicParamsDataView>(
      in_http_auth_dynamic_params, http_auth_dynamic_params_fragment);
  params->http_auth_dynamic_params.Set(
      http_auth_dynamic_params_fragment.is_null() ? nullptr : http_auth_dynamic_params_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->http_auth_dynamic_params.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null http_auth_dynamic_params in NetworkService.ConfigureHttpAuthPrefs request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkService::Name_);
  message.set_method_name("ConfigureHttpAuthPrefs");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void NetworkServiceProxy::SetRawHeadersAccess(
    int32_t in_process_id, const WTF::Vector<::scoped_refptr<const ::blink::SecurityOrigin>>& in_origins) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::NetworkService::SetRawHeadersAccess", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("process_id"), in_process_id, 
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("origins"), in_origins, 
                        "<value of type const WTF::Vector<::scoped_refptr<const ::blink::SecurityOrigin>>&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkService_SetRawHeadersAccess_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkService_SetRawHeadersAccess_Params_Data> params(
          message);
  params.Allocate();
  params->process_id = in_process_id;
  mojo::internal::MessageFragment<
      typename decltype(params->origins)::BaseType>
      origins_fragment(params.message());
  const mojo::internal::ContainerValidateParams origins_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::url::mojom::OriginDataView>>(
      in_origins, origins_fragment, &origins_validate_params);
  params->origins.Set(
      origins_fragment.is_null() ? nullptr : origins_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->origins.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null origins in NetworkService.SetRawHeadersAccess request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkService::Name_);
  message.set_method_name("SetRawHeadersAccess");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void NetworkServiceProxy::SetMaxConnectionsPerProxy(
    int32_t in_max_connections) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::NetworkService::SetMaxConnectionsPerProxy", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("max_connections"), in_max_connections, 
                        "<value of type int32_t>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkService_SetMaxConnectionsPerProxy_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkService_SetMaxConnectionsPerProxy_Params_Data> params(
          message);
  params.Allocate();
  params->max_connections = in_max_connections;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkService::Name_);
  message.set_method_name("SetMaxConnectionsPerProxy");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void NetworkServiceProxy::GetNetworkChangeManager(
    ::mojo::PendingReceiver<::network::mojom::blink::NetworkChangeManager> in_network_change_manager) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::NetworkService::GetNetworkChangeManager", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("network_change_manager"), in_network_change_manager, 
                        "<value of type ::mojo::PendingReceiver<::network::mojom::blink::NetworkChangeManager>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkService_GetNetworkChangeManager_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkService_GetNetworkChangeManager_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::network::mojom::NetworkChangeManagerInterfaceBase>>(
      in_network_change_manager, &params->network_change_manager, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->network_change_manager),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid network_change_manager in NetworkService.GetNetworkChangeManager request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkService::Name_);
  message.set_method_name("GetNetworkChangeManager");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void NetworkServiceProxy::GetNetworkQualityEstimatorManager(
    ::mojo::PendingReceiver<::network::mojom::blink::NetworkQualityEstimatorManager> in_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::NetworkService::GetNetworkQualityEstimatorManager", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver, 
                        "<value of type ::mojo::PendingReceiver<::network::mojom::blink::NetworkQualityEstimatorManager>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkService_GetNetworkQualityEstimatorManager_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkService_GetNetworkQualityEstimatorManager_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::network::mojom::NetworkQualityEstimatorManagerInterfaceBase>>(
      in_receiver, &params->receiver, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->receiver),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid receiver in NetworkService.GetNetworkQualityEstimatorManager request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkService::Name_);
  message.set_method_name("GetNetworkQualityEstimatorManager");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void NetworkServiceProxy::GetDnsConfigChangeManager(
    ::mojo::PendingReceiver<::network::mojom::blink::DnsConfigChangeManager> in_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::NetworkService::GetDnsConfigChangeManager", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver, 
                        "<value of type ::mojo::PendingReceiver<::network::mojom::blink::DnsConfigChangeManager>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkService_GetDnsConfigChangeManager_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkService_GetDnsConfigChangeManager_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::network::mojom::DnsConfigChangeManagerInterfaceBase>>(
      in_receiver, &params->receiver, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->receiver),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid receiver in NetworkService.GetDnsConfigChangeManager request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkService::Name_);
  message.set_method_name("GetDnsConfigChangeManager");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void NetworkServiceProxy::GetTotalNetworkUsages(
    GetTotalNetworkUsagesCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "network::mojom::NetworkService::GetTotalNetworkUsages");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkService_GetTotalNetworkUsages_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkService_GetTotalNetworkUsages_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkService::Name_);
  message.set_method_name("GetTotalNetworkUsages");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NetworkService_GetTotalNetworkUsages_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void NetworkServiceProxy::GetNetworkList(
    uint32_t in_policy, GetNetworkListCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::NetworkService::GetNetworkList", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("policy"), in_policy, 
                        "<value of type uint32_t>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkService_GetNetworkList_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkService_GetNetworkList_Params_Data> params(
          message);
  params.Allocate();
  params->policy = in_policy;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkService::Name_);
  message.set_method_name("GetNetworkList");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NetworkService_GetNetworkList_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void NetworkServiceProxy::UpdateCRLSet(
    ::base::span<const ::uint8_t> in_crl_set, UpdateCRLSetCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::NetworkService::UpdateCRLSet", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("crl_set"), in_crl_set, 
                        "<value of type ::base::span<const ::uint8_t>>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkService_UpdateCRLSet_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkService_UpdateCRLSet_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->crl_set)::BaseType> crl_set_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::ReadOnlyBufferDataView>(
      in_crl_set, crl_set_fragment);
  params->crl_set.Set(
      crl_set_fragment.is_null() ? nullptr : crl_set_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->crl_set.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null crl_set in NetworkService.UpdateCRLSet request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkService::Name_);
  message.set_method_name("UpdateCRLSet");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NetworkService_UpdateCRLSet_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void NetworkServiceProxy::OnCertDBChanged(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "network::mojom::NetworkService::OnCertDBChanged");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkService_OnCertDBChanged_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkService_OnCertDBChanged_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkService::Name_);
  message.set_method_name("OnCertDBChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void NetworkServiceProxy::SetCryptConfig(
    CryptConfigPtr in_crypt_config) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::NetworkService::SetCryptConfig", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("crypt_config"), in_crypt_config, 
                        "<value of type CryptConfigPtr>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkService_SetCryptConfig_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkService_SetCryptConfig_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->crypt_config)::BaseType> crypt_config_fragment(
          params.message());
  mojo::internal::Serialize<::network::mojom::CryptConfigDataView>(
      in_crypt_config, crypt_config_fragment);
  params->crypt_config.Set(
      crypt_config_fragment.is_null() ? nullptr : crypt_config_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->crypt_config.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null crypt_config in NetworkService.SetCryptConfig request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkService::Name_);
  message.set_method_name("SetCryptConfig");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void NetworkServiceProxy::AddAllowedRequestInitiatorForPlugin(
    int32_t in_process_id, const ::scoped_refptr<const ::blink::SecurityOrigin>& in_allowed_request_initiator) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::NetworkService::AddAllowedRequestInitiatorForPlugin", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("process_id"), in_process_id, 
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("allowed_request_initiator"), in_allowed_request_initiator, 
                        "<value of type const ::scoped_refptr<const ::blink::SecurityOrigin>&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkService_AddAllowedRequestInitiatorForPlugin_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkService_AddAllowedRequestInitiatorForPlugin_Params_Data> params(
          message);
  params.Allocate();
  params->process_id = in_process_id;
  mojo::internal::MessageFragment<
      typename decltype(params->allowed_request_initiator)::BaseType> allowed_request_initiator_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::OriginDataView>(
      in_allowed_request_initiator, allowed_request_initiator_fragment);
  params->allowed_request_initiator.Set(
      allowed_request_initiator_fragment.is_null() ? nullptr : allowed_request_initiator_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->allowed_request_initiator.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null allowed_request_initiator in NetworkService.AddAllowedRequestInitiatorForPlugin request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkService::Name_);
  message.set_method_name("AddAllowedRequestInitiatorForPlugin");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void NetworkServiceProxy::RemoveSecurityExceptionsForPlugin(
    int32_t in_process_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::NetworkService::RemoveSecurityExceptionsForPlugin", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("process_id"), in_process_id, 
                        "<value of type int32_t>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkService_RemoveSecurityExceptionsForPlugin_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkService_RemoveSecurityExceptionsForPlugin_Params_Data> params(
          message);
  params.Allocate();
  params->process_id = in_process_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkService::Name_);
  message.set_method_name("RemoveSecurityExceptionsForPlugin");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void NetworkServiceProxy::OnMemoryPressure(
    ::mojo_base::mojom::blink::MemoryPressureLevel in_memory_pressure_level) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::NetworkService::OnMemoryPressure", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("memory_pressure_level"), in_memory_pressure_level, 
                        "<value of type ::mojo_base::mojom::blink::MemoryPressureLevel>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkService_OnMemoryPressure_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkService_OnMemoryPressure_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::mojo_base::mojom::MemoryPressureLevel>(
      in_memory_pressure_level, &params->memory_pressure_level);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkService::Name_);
  message.set_method_name("OnMemoryPressure");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void NetworkServiceProxy::OnPeerToPeerConnectionsCountChange(
    uint32_t in_count) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::NetworkService::OnPeerToPeerConnectionsCountChange", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("count"), in_count, 
                        "<value of type uint32_t>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkService_OnPeerToPeerConnectionsCountChange_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkService_OnPeerToPeerConnectionsCountChange_Params_Data> params(
          message);
  params.Allocate();
  params->count = in_count;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkService::Name_);
  message.set_method_name("OnPeerToPeerConnectionsCountChange");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void NetworkServiceProxy::SetEnvironment(
    WTF::Vector<EnvironmentVariablePtr> in_environment) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::NetworkService::SetEnvironment", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("environment"), in_environment, 
                        "<value of type WTF::Vector<EnvironmentVariablePtr>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkService_SetEnvironment_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkService_SetEnvironment_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->environment)::BaseType>
      environment_fragment(params.message());
  const mojo::internal::ContainerValidateParams environment_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::EnvironmentVariableDataView>>(
      in_environment, environment_fragment, &environment_validate_params);
  params->environment.Set(
      environment_fragment.is_null() ? nullptr : environment_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->environment.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null environment in NetworkService.SetEnvironment request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkService::Name_);
  message.set_method_name("SetEnvironment");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void NetworkServiceProxy::SetTrustTokenKeyCommitments(
    const WTF::String& in_raw_commitments, SetTrustTokenKeyCommitmentsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::NetworkService::SetTrustTokenKeyCommitments", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("raw_commitments"), in_raw_commitments, 
                        "<value of type const WTF::String&>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkService_SetTrustTokenKeyCommitments_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkService_SetTrustTokenKeyCommitments_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->raw_commitments)::BaseType> raw_commitments_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_raw_commitments, raw_commitments_fragment);
  params->raw_commitments.Set(
      raw_commitments_fragment.is_null() ? nullptr : raw_commitments_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->raw_commitments.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null raw_commitments in NetworkService.SetTrustTokenKeyCommitments request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkService::Name_);
  message.set_method_name("SetTrustTokenKeyCommitments");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NetworkService_SetTrustTokenKeyCommitments_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void NetworkServiceProxy::ClearSCTAuditingCache(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "network::mojom::NetworkService::ClearSCTAuditingCache");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkService_ClearSCTAuditingCache_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkService_ClearSCTAuditingCache_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkService::Name_);
  message.set_method_name("ClearSCTAuditingCache");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void NetworkServiceProxy::ConfigureSCTAuditing(
    bool in_enabled, double in_sampling_rate, const ::blink::KURL& in_report_uri, const ::net::MutableNetworkTrafficAnnotationTag& in_traffic_annotation, ::mojo::PendingRemote<::network::mojom::blink::URLLoaderFactory> in_factory) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::NetworkService::ConfigureSCTAuditing", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("enabled"), in_enabled, 
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("sampling_rate"), in_sampling_rate, 
                        "<value of type double>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("report_uri"), in_report_uri, 
                        "<value of type const ::blink::KURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("traffic_annotation"), in_traffic_annotation, 
                        "<value of type const ::net::MutableNetworkTrafficAnnotationTag&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("factory"), in_factory, 
                        "<value of type ::mojo::PendingRemote<::network::mojom::blink::URLLoaderFactory>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkService_ConfigureSCTAuditing_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkService_ConfigureSCTAuditing_Params_Data> params(
          message);
  params.Allocate();
  params->enabled = in_enabled;
  params->sampling_rate = in_sampling_rate;
  mojo::internal::MessageFragment<
      typename decltype(params->report_uri)::BaseType> report_uri_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_report_uri, report_uri_fragment);
  params->report_uri.Set(
      report_uri_fragment.is_null() ? nullptr : report_uri_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->report_uri.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null report_uri in NetworkService.ConfigureSCTAuditing request");
  mojo::internal::MessageFragment<
      typename decltype(params->traffic_annotation)::BaseType> traffic_annotation_fragment(
          params.message());
  mojo::internal::Serialize<::network::mojom::MutableNetworkTrafficAnnotationTagDataView>(
      in_traffic_annotation, traffic_annotation_fragment);
  params->traffic_annotation.Set(
      traffic_annotation_fragment.is_null() ? nullptr : traffic_annotation_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->traffic_annotation.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null traffic_annotation in NetworkService.ConfigureSCTAuditing request");
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::network::mojom::URLLoaderFactoryInterfaceBase>>(
      in_factory, &params->factory, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->factory),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid factory in NetworkService.ConfigureSCTAuditing request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkService::Name_);
  message.set_method_name("ConfigureSCTAuditing");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void NetworkServiceProxy::BindTestInterface(
    ::mojo::PendingReceiver<::network::mojom::blink::NetworkServiceTest> in_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::NetworkService::BindTestInterface", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver, 
                        "<value of type ::mojo::PendingReceiver<::network::mojom::blink::NetworkServiceTest>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkService_BindTestInterface_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkService_BindTestInterface_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::network::mojom::NetworkServiceTestInterfaceBase>>(
      in_receiver, &params->receiver, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->receiver),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid receiver in NetworkService.BindTestInterface request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkService::Name_);
  message.set_method_name("BindTestInterface");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void NetworkServiceProxy::SetPreloadedFirstPartySets(
    const WTF::String& in_raw_sets) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::NetworkService::SetPreloadedFirstPartySets", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("raw_sets"), in_raw_sets, 
                        "<value of type const WTF::String&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkService_SetPreloadedFirstPartySets_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkService_SetPreloadedFirstPartySets_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->raw_sets)::BaseType> raw_sets_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_raw_sets, raw_sets_fragment);
  params->raw_sets.Set(
      raw_sets_fragment.is_null() ? nullptr : raw_sets_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->raw_sets.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null raw_sets in NetworkService.SetPreloadedFirstPartySets request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkService::Name_);
  message.set_method_name("SetPreloadedFirstPartySets");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}
class NetworkService_GetTotalNetworkUsages_ProxyToResponder {
 public:
  static NetworkService::GetTotalNetworkUsagesCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<NetworkService_GetTotalNetworkUsages_ProxyToResponder> proxy(
        new NetworkService_GetTotalNetworkUsages_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&NetworkService_GetTotalNetworkUsages_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NetworkService_GetTotalNetworkUsages_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  NetworkService_GetTotalNetworkUsages_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "NetworkService::GetTotalNetworkUsagesCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      WTF::Vector<::network::mojom::blink::NetworkUsagePtr> in_total_network_usages);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(NetworkService_GetTotalNetworkUsages_ProxyToResponder);
};

bool NetworkService_GetTotalNetworkUsages_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "network::mojom::NetworkService::GetTotalNetworkUsagesCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::NetworkService_GetTotalNetworkUsages_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NetworkService_GetTotalNetworkUsages_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  WTF::Vector<::network::mojom::blink::NetworkUsagePtr> p_total_network_usages{};
  NetworkService_GetTotalNetworkUsages_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadTotalNetworkUsages(&p_total_network_usages))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NetworkService::Name_, 14, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_total_network_usages));
  return true;
}

void NetworkService_GetTotalNetworkUsages_ProxyToResponder::Run(
    WTF::Vector<::network::mojom::blink::NetworkUsagePtr> in_total_network_usages) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)network::mojom::NetworkService::GetTotalNetworkUsagesCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("total_network_usages"), in_total_network_usages, 
                        "<value of type WTF::Vector<::network::mojom::blink::NetworkUsagePtr>>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkService_GetTotalNetworkUsages_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkService_GetTotalNetworkUsages_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->total_network_usages)::BaseType>
      total_network_usages_fragment(params.message());
  const mojo::internal::ContainerValidateParams total_network_usages_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::NetworkUsageDataView>>(
      in_total_network_usages, total_network_usages_fragment, &total_network_usages_validate_params);
  params->total_network_usages.Set(
      total_network_usages_fragment.is_null() ? nullptr : total_network_usages_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->total_network_usages.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null total_network_usages in ");

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)network::mojom::NetworkService::GetTotalNetworkUsagesCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkService::Name_);
  message.set_method_name("GetTotalNetworkUsages");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class NetworkService_GetNetworkList_ProxyToResponder {
 public:
  static NetworkService::GetNetworkListCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<NetworkService_GetNetworkList_ProxyToResponder> proxy(
        new NetworkService_GetNetworkList_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&NetworkService_GetNetworkList_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NetworkService_GetNetworkList_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  NetworkService_GetNetworkList_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "NetworkService::GetNetworkListCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      const base::Optional<WTF::Vector<::net::NetworkInterface>>& in_networks);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(NetworkService_GetNetworkList_ProxyToResponder);
};

bool NetworkService_GetNetworkList_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "network::mojom::NetworkService::GetNetworkListCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::NetworkService_GetNetworkList_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NetworkService_GetNetworkList_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  base::Optional<WTF::Vector<::net::NetworkInterface>> p_networks{};
  NetworkService_GetNetworkList_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadNetworks(&p_networks))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NetworkService::Name_, 15, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_networks));
  return true;
}

void NetworkService_GetNetworkList_ProxyToResponder::Run(
    const base::Optional<WTF::Vector<::net::NetworkInterface>>& in_networks) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)network::mojom::NetworkService::GetNetworkListCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("networks"), in_networks, 
                        "<value of type const base::Optional<WTF::Vector<::net::NetworkInterface>>&>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkService_GetNetworkList_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkService_GetNetworkList_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->networks)::BaseType>
      networks_fragment(params.message());
  const mojo::internal::ContainerValidateParams networks_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::NetworkInterfaceDataView>>(
      in_networks, networks_fragment, &networks_validate_params);
  params->networks.Set(
      networks_fragment.is_null() ? nullptr : networks_fragment.data());

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)network::mojom::NetworkService::GetNetworkListCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkService::Name_);
  message.set_method_name("GetNetworkList");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class NetworkService_UpdateCRLSet_ProxyToResponder {
 public:
  static NetworkService::UpdateCRLSetCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<NetworkService_UpdateCRLSet_ProxyToResponder> proxy(
        new NetworkService_UpdateCRLSet_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&NetworkService_UpdateCRLSet_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NetworkService_UpdateCRLSet_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  NetworkService_UpdateCRLSet_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "NetworkService::UpdateCRLSetCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(NetworkService_UpdateCRLSet_ProxyToResponder);
};

bool NetworkService_UpdateCRLSet_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "network::mojom::NetworkService::UpdateCRLSetCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::NetworkService_UpdateCRLSet_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NetworkService_UpdateCRLSet_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  NetworkService_UpdateCRLSet_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NetworkService::Name_, 16, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run();
  return true;
}

void NetworkService_UpdateCRLSet_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "(Impl)network::mojom::NetworkService::UpdateCRLSetCallback");
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkService_UpdateCRLSet_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkService_UpdateCRLSet_ResponseParams_Data> params(
          message);
  params.Allocate();

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)network::mojom::NetworkService::UpdateCRLSetCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkService::Name_);
  message.set_method_name("UpdateCRLSet");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class NetworkService_SetTrustTokenKeyCommitments_ProxyToResponder {
 public:
  static NetworkService::SetTrustTokenKeyCommitmentsCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<NetworkService_SetTrustTokenKeyCommitments_ProxyToResponder> proxy(
        new NetworkService_SetTrustTokenKeyCommitments_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&NetworkService_SetTrustTokenKeyCommitments_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NetworkService_SetTrustTokenKeyCommitments_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  NetworkService_SetTrustTokenKeyCommitments_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "NetworkService::SetTrustTokenKeyCommitmentsCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(NetworkService_SetTrustTokenKeyCommitments_ProxyToResponder);
};

bool NetworkService_SetTrustTokenKeyCommitments_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "network::mojom::NetworkService::SetTrustTokenKeyCommitmentsCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::NetworkService_SetTrustTokenKeyCommitments_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NetworkService_SetTrustTokenKeyCommitments_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  NetworkService_SetTrustTokenKeyCommitments_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NetworkService::Name_, 24, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run();
  return true;
}

void NetworkService_SetTrustTokenKeyCommitments_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "(Impl)network::mojom::NetworkService::SetTrustTokenKeyCommitmentsCallback");
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkService_SetTrustTokenKeyCommitments_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkService_SetTrustTokenKeyCommitments_ResponseParams_Data> params(
          message);
  params.Allocate();

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)network::mojom::NetworkService::SetTrustTokenKeyCommitmentsCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkService::Name_);
  message.set_method_name("SetTrustTokenKeyCommitments");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool NetworkServiceStubDispatch::Accept(
    NetworkService* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kNetworkService_SetClient_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::NetworkService::SetClient",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::NetworkService::SetClient");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::NetworkService_SetClient_Params_Data* params =
          reinterpret_cast<internal::NetworkService_SetClient_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingRemote<NetworkServiceClient> p_client{};
      NetworkServiceParamsPtr p_params{};
      NetworkService_SetClient_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_client =
            input_data_view.TakeClient<decltype(p_client)>();
      }
      if (success && !input_data_view.ReadParams(&p_params))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkService::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetClient(
std::move(p_client), 
std::move(p_params));
      return true;
    }
    case internal::kNetworkService_StartNetLog_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::NetworkService::StartNetLog",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::NetworkService::StartNetLog");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::NetworkService_StartNetLog_Params_Data* params =
          reinterpret_cast<internal::NetworkService_StartNetLog_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::base::File p_file{};
      ::network::mojom::blink::NetLogCaptureMode p_capture_mode{};
      ::base::Value p_constants{};
      NetworkService_StartNetLog_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadFile(&p_file))
        success = false;
      if (success && !input_data_view.ReadCaptureMode(&p_capture_mode))
        success = false;
      if (success && !input_data_view.ReadConstants(&p_constants))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkService::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->StartNetLog(
std::move(p_file), 
std::move(p_capture_mode), 
std::move(p_constants));
      return true;
    }
    case internal::kNetworkService_AttachNetLogProxy_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::NetworkService::AttachNetLogProxy",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::NetworkService::AttachNetLogProxy");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::NetworkService_AttachNetLogProxy_Params_Data* params =
          reinterpret_cast<internal::NetworkService_AttachNetLogProxy_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingRemote<::network::mojom::blink::NetLogProxySource> p_proxy_source{};
      ::mojo::PendingReceiver<::network::mojom::blink::NetLogProxySink> p_proxy_sink{};
      NetworkService_AttachNetLogProxy_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_proxy_source =
            input_data_view.TakeProxySource<decltype(p_proxy_source)>();
      }
      if (success) {
        p_proxy_sink =
            input_data_view.TakeProxySink<decltype(p_proxy_sink)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkService::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AttachNetLogProxy(
std::move(p_proxy_source), 
std::move(p_proxy_sink));
      return true;
    }
    case internal::kNetworkService_SetSSLKeyLogFile_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::NetworkService::SetSSLKeyLogFile",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::NetworkService::SetSSLKeyLogFile");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::NetworkService_SetSSLKeyLogFile_Params_Data* params =
          reinterpret_cast<internal::NetworkService_SetSSLKeyLogFile_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::base::File p_file{};
      NetworkService_SetSSLKeyLogFile_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadFile(&p_file))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkService::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetSSLKeyLogFile(
std::move(p_file));
      return true;
    }
    case internal::kNetworkService_CreateNetworkContext_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::NetworkService::CreateNetworkContext",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::NetworkService::CreateNetworkContext");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::NetworkService_CreateNetworkContext_Params_Data* params =
          reinterpret_cast<internal::NetworkService_CreateNetworkContext_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingReceiver<::network::mojom::blink::NetworkContext> p_context{};
      ::network::mojom::blink::NetworkContextParamsPtr p_params{};
      NetworkService_CreateNetworkContext_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_context =
            input_data_view.TakeContext<decltype(p_context)>();
      }
      if (success && !input_data_view.ReadParams(&p_params))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkService::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateNetworkContext(
std::move(p_context), 
std::move(p_params));
      return true;
    }
    case internal::kNetworkService_ConfigureStubHostResolver_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::NetworkService::ConfigureStubHostResolver",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::NetworkService::ConfigureStubHostResolver");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::NetworkService_ConfigureStubHostResolver_Params_Data* params =
          reinterpret_cast<internal::NetworkService_ConfigureStubHostResolver_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      bool p_insecure_dns_client_enabled{};
      ::network::mojom::blink::SecureDnsMode p_secure_dns_mode{};
      base::Optional<WTF::Vector<::network::mojom::blink::DnsOverHttpsServerPtr>> p_dns_over_https_servers{};
      NetworkService_ConfigureStubHostResolver_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_insecure_dns_client_enabled = input_data_view.insecure_dns_client_enabled();
      if (success && !input_data_view.ReadSecureDnsMode(&p_secure_dns_mode))
        success = false;
      if (success && !input_data_view.ReadDnsOverHttpsServers(&p_dns_over_https_servers))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkService::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ConfigureStubHostResolver(
std::move(p_insecure_dns_client_enabled), 
std::move(p_secure_dns_mode), 
std::move(p_dns_over_https_servers));
      return true;
    }
    case internal::kNetworkService_DisableQuic_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::NetworkService::DisableQuic",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::NetworkService::DisableQuic");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::NetworkService_DisableQuic_Params_Data* params =
          reinterpret_cast<internal::NetworkService_DisableQuic_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      NetworkService_DisableQuic_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkService::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DisableQuic();
      return true;
    }
    case internal::kNetworkService_SetUpHttpAuth_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::NetworkService::SetUpHttpAuth",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::NetworkService::SetUpHttpAuth");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::NetworkService_SetUpHttpAuth_Params_Data* params =
          reinterpret_cast<internal::NetworkService_SetUpHttpAuth_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      HttpAuthStaticParamsPtr p_http_auth_static_params{};
      NetworkService_SetUpHttpAuth_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadHttpAuthStaticParams(&p_http_auth_static_params))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkService::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetUpHttpAuth(
std::move(p_http_auth_static_params));
      return true;
    }
    case internal::kNetworkService_ConfigureHttpAuthPrefs_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::NetworkService::ConfigureHttpAuthPrefs",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::NetworkService::ConfigureHttpAuthPrefs");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::NetworkService_ConfigureHttpAuthPrefs_Params_Data* params =
          reinterpret_cast<internal::NetworkService_ConfigureHttpAuthPrefs_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      HttpAuthDynamicParamsPtr p_http_auth_dynamic_params{};
      NetworkService_ConfigureHttpAuthPrefs_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadHttpAuthDynamicParams(&p_http_auth_dynamic_params))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkService::Name_, 8, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ConfigureHttpAuthPrefs(
std::move(p_http_auth_dynamic_params));
      return true;
    }
    case internal::kNetworkService_SetRawHeadersAccess_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::NetworkService::SetRawHeadersAccess",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::NetworkService::SetRawHeadersAccess");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::NetworkService_SetRawHeadersAccess_Params_Data* params =
          reinterpret_cast<internal::NetworkService_SetRawHeadersAccess_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      int32_t p_process_id{};
      WTF::Vector<::scoped_refptr<const ::blink::SecurityOrigin>> p_origins{};
      NetworkService_SetRawHeadersAccess_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_process_id = input_data_view.process_id();
      if (success && !input_data_view.ReadOrigins(&p_origins))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkService::Name_, 9, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetRawHeadersAccess(
std::move(p_process_id), 
std::move(p_origins));
      return true;
    }
    case internal::kNetworkService_SetMaxConnectionsPerProxy_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::NetworkService::SetMaxConnectionsPerProxy",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::NetworkService::SetMaxConnectionsPerProxy");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::NetworkService_SetMaxConnectionsPerProxy_Params_Data* params =
          reinterpret_cast<internal::NetworkService_SetMaxConnectionsPerProxy_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      int32_t p_max_connections{};
      NetworkService_SetMaxConnectionsPerProxy_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_max_connections = input_data_view.max_connections();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkService::Name_, 10, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetMaxConnectionsPerProxy(
std::move(p_max_connections));
      return true;
    }
    case internal::kNetworkService_GetNetworkChangeManager_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::NetworkService::GetNetworkChangeManager",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::NetworkService::GetNetworkChangeManager");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::NetworkService_GetNetworkChangeManager_Params_Data* params =
          reinterpret_cast<internal::NetworkService_GetNetworkChangeManager_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingReceiver<::network::mojom::blink::NetworkChangeManager> p_network_change_manager{};
      NetworkService_GetNetworkChangeManager_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_network_change_manager =
            input_data_view.TakeNetworkChangeManager<decltype(p_network_change_manager)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkService::Name_, 11, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetNetworkChangeManager(
std::move(p_network_change_manager));
      return true;
    }
    case internal::kNetworkService_GetNetworkQualityEstimatorManager_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::NetworkService::GetNetworkQualityEstimatorManager",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::NetworkService::GetNetworkQualityEstimatorManager");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::NetworkService_GetNetworkQualityEstimatorManager_Params_Data* params =
          reinterpret_cast<internal::NetworkService_GetNetworkQualityEstimatorManager_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingReceiver<::network::mojom::blink::NetworkQualityEstimatorManager> p_receiver{};
      NetworkService_GetNetworkQualityEstimatorManager_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkService::Name_, 12, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetNetworkQualityEstimatorManager(
std::move(p_receiver));
      return true;
    }
    case internal::kNetworkService_GetDnsConfigChangeManager_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::NetworkService::GetDnsConfigChangeManager",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::NetworkService::GetDnsConfigChangeManager");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::NetworkService_GetDnsConfigChangeManager_Params_Data* params =
          reinterpret_cast<internal::NetworkService_GetDnsConfigChangeManager_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingReceiver<::network::mojom::blink::DnsConfigChangeManager> p_receiver{};
      NetworkService_GetDnsConfigChangeManager_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkService::Name_, 13, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetDnsConfigChangeManager(
std::move(p_receiver));
      return true;
    }
    case internal::kNetworkService_GetTotalNetworkUsages_Name: {
      break;
    }
    case internal::kNetworkService_GetNetworkList_Name: {
      break;
    }
    case internal::kNetworkService_UpdateCRLSet_Name: {
      break;
    }
    case internal::kNetworkService_OnCertDBChanged_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::NetworkService::OnCertDBChanged",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::NetworkService::OnCertDBChanged");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::NetworkService_OnCertDBChanged_Params_Data* params =
          reinterpret_cast<internal::NetworkService_OnCertDBChanged_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      NetworkService_OnCertDBChanged_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkService::Name_, 17, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnCertDBChanged();
      return true;
    }
    case internal::kNetworkService_SetCryptConfig_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::NetworkService::SetCryptConfig",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::NetworkService::SetCryptConfig");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::NetworkService_SetCryptConfig_Params_Data* params =
          reinterpret_cast<internal::NetworkService_SetCryptConfig_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      CryptConfigPtr p_crypt_config{};
      NetworkService_SetCryptConfig_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadCryptConfig(&p_crypt_config))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkService::Name_, 18, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetCryptConfig(
std::move(p_crypt_config));
      return true;
    }
    case internal::kNetworkService_AddAllowedRequestInitiatorForPlugin_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::NetworkService::AddAllowedRequestInitiatorForPlugin",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::NetworkService::AddAllowedRequestInitiatorForPlugin");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::NetworkService_AddAllowedRequestInitiatorForPlugin_Params_Data* params =
          reinterpret_cast<internal::NetworkService_AddAllowedRequestInitiatorForPlugin_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      int32_t p_process_id{};
      ::scoped_refptr<const ::blink::SecurityOrigin> p_allowed_request_initiator{};
      NetworkService_AddAllowedRequestInitiatorForPlugin_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_process_id = input_data_view.process_id();
      if (success && !input_data_view.ReadAllowedRequestInitiator(&p_allowed_request_initiator))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkService::Name_, 19, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AddAllowedRequestInitiatorForPlugin(
std::move(p_process_id), 
std::move(p_allowed_request_initiator));
      return true;
    }
    case internal::kNetworkService_RemoveSecurityExceptionsForPlugin_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::NetworkService::RemoveSecurityExceptionsForPlugin",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::NetworkService::RemoveSecurityExceptionsForPlugin");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::NetworkService_RemoveSecurityExceptionsForPlugin_Params_Data* params =
          reinterpret_cast<internal::NetworkService_RemoveSecurityExceptionsForPlugin_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      int32_t p_process_id{};
      NetworkService_RemoveSecurityExceptionsForPlugin_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_process_id = input_data_view.process_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkService::Name_, 20, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RemoveSecurityExceptionsForPlugin(
std::move(p_process_id));
      return true;
    }
    case internal::kNetworkService_OnMemoryPressure_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::NetworkService::OnMemoryPressure",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::NetworkService::OnMemoryPressure");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::NetworkService_OnMemoryPressure_Params_Data* params =
          reinterpret_cast<internal::NetworkService_OnMemoryPressure_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo_base::mojom::blink::MemoryPressureLevel p_memory_pressure_level{};
      NetworkService_OnMemoryPressure_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadMemoryPressureLevel(&p_memory_pressure_level))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkService::Name_, 21, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnMemoryPressure(
std::move(p_memory_pressure_level));
      return true;
    }
    case internal::kNetworkService_OnPeerToPeerConnectionsCountChange_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::NetworkService::OnPeerToPeerConnectionsCountChange",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::NetworkService::OnPeerToPeerConnectionsCountChange");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::NetworkService_OnPeerToPeerConnectionsCountChange_Params_Data* params =
          reinterpret_cast<internal::NetworkService_OnPeerToPeerConnectionsCountChange_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      uint32_t p_count{};
      NetworkService_OnPeerToPeerConnectionsCountChange_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_count = input_data_view.count();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkService::Name_, 22, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnPeerToPeerConnectionsCountChange(
std::move(p_count));
      return true;
    }
    case internal::kNetworkService_SetEnvironment_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::NetworkService::SetEnvironment",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::NetworkService::SetEnvironment");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::NetworkService_SetEnvironment_Params_Data* params =
          reinterpret_cast<internal::NetworkService_SetEnvironment_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      WTF::Vector<EnvironmentVariablePtr> p_environment{};
      NetworkService_SetEnvironment_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadEnvironment(&p_environment))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkService::Name_, 23, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetEnvironment(
std::move(p_environment));
      return true;
    }
    case internal::kNetworkService_SetTrustTokenKeyCommitments_Name: {
      break;
    }
    case internal::kNetworkService_ClearSCTAuditingCache_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::NetworkService::ClearSCTAuditingCache",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::NetworkService::ClearSCTAuditingCache");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::NetworkService_ClearSCTAuditingCache_Params_Data* params =
          reinterpret_cast<internal::NetworkService_ClearSCTAuditingCache_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      NetworkService_ClearSCTAuditingCache_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkService::Name_, 25, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ClearSCTAuditingCache();
      return true;
    }
    case internal::kNetworkService_ConfigureSCTAuditing_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::NetworkService::ConfigureSCTAuditing",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::NetworkService::ConfigureSCTAuditing");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::NetworkService_ConfigureSCTAuditing_Params_Data* params =
          reinterpret_cast<internal::NetworkService_ConfigureSCTAuditing_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      bool p_enabled{};
      double p_sampling_rate{};
      ::blink::KURL p_report_uri{};
      ::net::MutableNetworkTrafficAnnotationTag p_traffic_annotation{};
      ::mojo::PendingRemote<::network::mojom::blink::URLLoaderFactory> p_factory{};
      NetworkService_ConfigureSCTAuditing_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_enabled = input_data_view.enabled();
      if (success)
        p_sampling_rate = input_data_view.sampling_rate();
      if (success && !input_data_view.ReadReportUri(&p_report_uri))
        success = false;
      if (success && !input_data_view.ReadTrafficAnnotation(&p_traffic_annotation))
        success = false;
      if (success) {
        p_factory =
            input_data_view.TakeFactory<decltype(p_factory)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkService::Name_, 26, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ConfigureSCTAuditing(
std::move(p_enabled), 
std::move(p_sampling_rate), 
std::move(p_report_uri), 
std::move(p_traffic_annotation), 
std::move(p_factory));
      return true;
    }
    case internal::kNetworkService_BindTestInterface_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::NetworkService::BindTestInterface",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::NetworkService::BindTestInterface");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::NetworkService_BindTestInterface_Params_Data* params =
          reinterpret_cast<internal::NetworkService_BindTestInterface_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingReceiver<::network::mojom::blink::NetworkServiceTest> p_receiver{};
      NetworkService_BindTestInterface_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkService::Name_, 27, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BindTestInterface(
std::move(p_receiver));
      return true;
    }
    case internal::kNetworkService_SetPreloadedFirstPartySets_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::NetworkService::SetPreloadedFirstPartySets",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::NetworkService::SetPreloadedFirstPartySets");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::NetworkService_SetPreloadedFirstPartySets_Params_Data* params =
          reinterpret_cast<internal::NetworkService_SetPreloadedFirstPartySets_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      WTF::String p_raw_sets{};
      NetworkService_SetPreloadedFirstPartySets_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadRawSets(&p_raw_sets))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkService::Name_, 28, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetPreloadedFirstPartySets(
std::move(p_raw_sets));
      return true;
    }
  }
  return false;
}

// static
bool NetworkServiceStubDispatch::AcceptWithResponder(
    NetworkService* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kNetworkService_SetClient_Name: {
      break;
    }
    case internal::kNetworkService_StartNetLog_Name: {
      break;
    }
    case internal::kNetworkService_AttachNetLogProxy_Name: {
      break;
    }
    case internal::kNetworkService_SetSSLKeyLogFile_Name: {
      break;
    }
    case internal::kNetworkService_CreateNetworkContext_Name: {
      break;
    }
    case internal::kNetworkService_ConfigureStubHostResolver_Name: {
      break;
    }
    case internal::kNetworkService_DisableQuic_Name: {
      break;
    }
    case internal::kNetworkService_SetUpHttpAuth_Name: {
      break;
    }
    case internal::kNetworkService_ConfigureHttpAuthPrefs_Name: {
      break;
    }
    case internal::kNetworkService_SetRawHeadersAccess_Name: {
      break;
    }
    case internal::kNetworkService_SetMaxConnectionsPerProxy_Name: {
      break;
    }
    case internal::kNetworkService_GetNetworkChangeManager_Name: {
      break;
    }
    case internal::kNetworkService_GetNetworkQualityEstimatorManager_Name: {
      break;
    }
    case internal::kNetworkService_GetDnsConfigChangeManager_Name: {
      break;
    }
    case internal::kNetworkService_GetTotalNetworkUsages_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::NetworkService::GetTotalNetworkUsages",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::NetworkService::GetTotalNetworkUsages");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::NetworkService_GetTotalNetworkUsages_Params_Data* params =
          reinterpret_cast<
              internal::NetworkService_GetTotalNetworkUsages_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      NetworkService_GetTotalNetworkUsages_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkService::Name_, 14, false);
        return false;
      }
      NetworkService::GetTotalNetworkUsagesCallback callback =
          NetworkService_GetTotalNetworkUsages_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetTotalNetworkUsages(std::move(callback));
      return true;
    }
    case internal::kNetworkService_GetNetworkList_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::NetworkService::GetNetworkList",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::NetworkService::GetNetworkList");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::NetworkService_GetNetworkList_Params_Data* params =
          reinterpret_cast<
              internal::NetworkService_GetNetworkList_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      uint32_t p_policy{};
      NetworkService_GetNetworkList_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_policy = input_data_view.policy();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkService::Name_, 15, false);
        return false;
      }
      NetworkService::GetNetworkListCallback callback =
          NetworkService_GetNetworkList_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetNetworkList(
std::move(p_policy), std::move(callback));
      return true;
    }
    case internal::kNetworkService_UpdateCRLSet_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::NetworkService::UpdateCRLSet",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::NetworkService::UpdateCRLSet");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::NetworkService_UpdateCRLSet_Params_Data* params =
          reinterpret_cast<
              internal::NetworkService_UpdateCRLSet_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::base::span<const ::uint8_t> p_crl_set{};
      NetworkService_UpdateCRLSet_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadCrlSet(&p_crl_set))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkService::Name_, 16, false);
        return false;
      }
      NetworkService::UpdateCRLSetCallback callback =
          NetworkService_UpdateCRLSet_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateCRLSet(
std::move(p_crl_set), std::move(callback));
      return true;
    }
    case internal::kNetworkService_OnCertDBChanged_Name: {
      break;
    }
    case internal::kNetworkService_SetCryptConfig_Name: {
      break;
    }
    case internal::kNetworkService_AddAllowedRequestInitiatorForPlugin_Name: {
      break;
    }
    case internal::kNetworkService_RemoveSecurityExceptionsForPlugin_Name: {
      break;
    }
    case internal::kNetworkService_OnMemoryPressure_Name: {
      break;
    }
    case internal::kNetworkService_OnPeerToPeerConnectionsCountChange_Name: {
      break;
    }
    case internal::kNetworkService_SetEnvironment_Name: {
      break;
    }
    case internal::kNetworkService_SetTrustTokenKeyCommitments_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::NetworkService::SetTrustTokenKeyCommitments",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::NetworkService::SetTrustTokenKeyCommitments");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::NetworkService_SetTrustTokenKeyCommitments_Params_Data* params =
          reinterpret_cast<
              internal::NetworkService_SetTrustTokenKeyCommitments_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      WTF::String p_raw_commitments{};
      NetworkService_SetTrustTokenKeyCommitments_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadRawCommitments(&p_raw_commitments))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkService::Name_, 24, false);
        return false;
      }
      NetworkService::SetTrustTokenKeyCommitmentsCallback callback =
          NetworkService_SetTrustTokenKeyCommitments_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetTrustTokenKeyCommitments(
std::move(p_raw_commitments), std::move(callback));
      return true;
    }
    case internal::kNetworkService_ClearSCTAuditingCache_Name: {
      break;
    }
    case internal::kNetworkService_ConfigureSCTAuditing_Name: {
      break;
    }
    case internal::kNetworkService_BindTestInterface_Name: {
      break;
    }
    case internal::kNetworkService_SetPreloadedFirstPartySets_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kNetworkServiceValidationInfo[] = {
    {internal::kNetworkService_SetClient_Name,
     {&internal::NetworkService_SetClient_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kNetworkService_StartNetLog_Name,
     {&internal::NetworkService_StartNetLog_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kNetworkService_AttachNetLogProxy_Name,
     {&internal::NetworkService_AttachNetLogProxy_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kNetworkService_SetSSLKeyLogFile_Name,
     {&internal::NetworkService_SetSSLKeyLogFile_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kNetworkService_CreateNetworkContext_Name,
     {&internal::NetworkService_CreateNetworkContext_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kNetworkService_ConfigureStubHostResolver_Name,
     {&internal::NetworkService_ConfigureStubHostResolver_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kNetworkService_DisableQuic_Name,
     {&internal::NetworkService_DisableQuic_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kNetworkService_SetUpHttpAuth_Name,
     {&internal::NetworkService_SetUpHttpAuth_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kNetworkService_ConfigureHttpAuthPrefs_Name,
     {&internal::NetworkService_ConfigureHttpAuthPrefs_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kNetworkService_SetRawHeadersAccess_Name,
     {&internal::NetworkService_SetRawHeadersAccess_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kNetworkService_SetMaxConnectionsPerProxy_Name,
     {&internal::NetworkService_SetMaxConnectionsPerProxy_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kNetworkService_GetNetworkChangeManager_Name,
     {&internal::NetworkService_GetNetworkChangeManager_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kNetworkService_GetNetworkQualityEstimatorManager_Name,
     {&internal::NetworkService_GetNetworkQualityEstimatorManager_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kNetworkService_GetDnsConfigChangeManager_Name,
     {&internal::NetworkService_GetDnsConfigChangeManager_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kNetworkService_GetTotalNetworkUsages_Name,
     {&internal::NetworkService_GetTotalNetworkUsages_Params_Data::Validate,
      &internal::NetworkService_GetTotalNetworkUsages_ResponseParams_Data::Validate}},
    {internal::kNetworkService_GetNetworkList_Name,
     {&internal::NetworkService_GetNetworkList_Params_Data::Validate,
      &internal::NetworkService_GetNetworkList_ResponseParams_Data::Validate}},
    {internal::kNetworkService_UpdateCRLSet_Name,
     {&internal::NetworkService_UpdateCRLSet_Params_Data::Validate,
      &internal::NetworkService_UpdateCRLSet_ResponseParams_Data::Validate}},
    {internal::kNetworkService_OnCertDBChanged_Name,
     {&internal::NetworkService_OnCertDBChanged_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kNetworkService_SetCryptConfig_Name,
     {&internal::NetworkService_SetCryptConfig_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kNetworkService_AddAllowedRequestInitiatorForPlugin_Name,
     {&internal::NetworkService_AddAllowedRequestInitiatorForPlugin_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kNetworkService_RemoveSecurityExceptionsForPlugin_Name,
     {&internal::NetworkService_RemoveSecurityExceptionsForPlugin_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kNetworkService_OnMemoryPressure_Name,
     {&internal::NetworkService_OnMemoryPressure_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kNetworkService_OnPeerToPeerConnectionsCountChange_Name,
     {&internal::NetworkService_OnPeerToPeerConnectionsCountChange_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kNetworkService_SetEnvironment_Name,
     {&internal::NetworkService_SetEnvironment_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kNetworkService_SetTrustTokenKeyCommitments_Name,
     {&internal::NetworkService_SetTrustTokenKeyCommitments_Params_Data::Validate,
      &internal::NetworkService_SetTrustTokenKeyCommitments_ResponseParams_Data::Validate}},
    {internal::kNetworkService_ClearSCTAuditingCache_Name,
     {&internal::NetworkService_ClearSCTAuditingCache_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kNetworkService_ConfigureSCTAuditing_Name,
     {&internal::NetworkService_ConfigureSCTAuditing_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kNetworkService_BindTestInterface_Name,
     {&internal::NetworkService_BindTestInterface_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kNetworkService_SetPreloadedFirstPartySets_Name,
     {&internal::NetworkService_SetPreloadedFirstPartySets_Params_Data::Validate,
      nullptr /* no response */}},
};

bool NetworkServiceRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::network::mojom::blink::NetworkService::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kNetworkServiceValidationInfo);
}

bool NetworkServiceResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::network::mojom::blink::NetworkService::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kNetworkServiceValidationInfo);

}
}  // namespace blink
}  // namespace mojom
}  // namespace network

namespace mojo {


// static
bool StructTraits<::network::mojom::blink::LoadInfo::DataView, ::network::mojom::blink::LoadInfoPtr>::Read(
    ::network::mojom::blink::LoadInfo::DataView input,
    ::network::mojom::blink::LoadInfoPtr* output) {
  bool success = true;
  ::network::mojom::blink::LoadInfoPtr result(::network::mojom::blink::LoadInfo::New());
  
      if (success)
        result->process_id = input.process_id();
      if (success)
        result->routing_id = input.routing_id();
      if (success && !input.ReadHost(&result->host))
        success = false;
      if (success)
        result->load_state = input.load_state();
      if (success && !input.ReadStateParam(&result->state_param))
        success = false;
      if (success)
        result->upload_position = input.upload_position();
      if (success)
        result->upload_size = input.upload_size();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::blink::HttpAuthStaticParams::DataView, ::network::mojom::blink::HttpAuthStaticParamsPtr>::Read(
    ::network::mojom::blink::HttpAuthStaticParams::DataView input,
    ::network::mojom::blink::HttpAuthStaticParamsPtr* output) {
  bool success = true;
  ::network::mojom::blink::HttpAuthStaticParamsPtr result(::network::mojom::blink::HttpAuthStaticParams::New());
  
      if (success && !input.ReadSupportedSchemes(&result->supported_schemes))
        success = false;
      if (success && !input.ReadGssapiLibraryName(&result->gssapi_library_name))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::blink::HttpAuthDynamicParams::DataView, ::network::mojom::blink::HttpAuthDynamicParamsPtr>::Read(
    ::network::mojom::blink::HttpAuthDynamicParams::DataView input,
    ::network::mojom::blink::HttpAuthDynamicParamsPtr* output) {
  bool success = true;
  ::network::mojom::blink::HttpAuthDynamicParamsPtr result(::network::mojom::blink::HttpAuthDynamicParams::New());
  
      if (success && !input.ReadServerAllowlist(&result->server_allowlist))
        success = false;
      if (success && !input.ReadDelegateAllowlist(&result->delegate_allowlist))
        success = false;
      if (success)
        result->delegate_by_kdc_policy = input.delegate_by_kdc_policy();
      if (success)
        result->negotiate_disable_cname_lookup = input.negotiate_disable_cname_lookup();
      if (success)
        result->enable_negotiate_port = input.enable_negotiate_port();
      if (success)
        result->ntlm_v2_enabled = input.ntlm_v2_enabled();
      if (success && !input.ReadAndroidNegotiateAccountType(&result->android_negotiate_account_type))
        success = false;
      if (success)
        result->allow_gssapi_library_load = input.allow_gssapi_library_load();
      if (success)
        result->basic_over_http_enabled = input.basic_over_http_enabled();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::blink::CryptConfig::DataView, ::network::mojom::blink::CryptConfigPtr>::Read(
    ::network::mojom::blink::CryptConfig::DataView input,
    ::network::mojom::blink::CryptConfigPtr* output) {
  bool success = true;
  ::network::mojom::blink::CryptConfigPtr result(::network::mojom::blink::CryptConfig::New());
  
      if (success && !input.ReadStore(&result->store))
        success = false;
      if (success && !input.ReadProductName(&result->product_name))
        success = false;
      if (success)
        result->should_use_preference = input.should_use_preference();
      if (success && !input.ReadUserDataPath(&result->user_data_path))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::blink::EnvironmentVariable::DataView, ::network::mojom::blink::EnvironmentVariablePtr>::Read(
    ::network::mojom::blink::EnvironmentVariable::DataView input,
    ::network::mojom::blink::EnvironmentVariablePtr* output) {
  bool success = true;
  ::network::mojom::blink::EnvironmentVariablePtr result(::network::mojom::blink::EnvironmentVariable::New());
  
      if (success && !input.ReadName(&result->name))
        success = false;
      if (success && !input.ReadValue(&result->value))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::blink::NetworkServiceParams::DataView, ::network::mojom::blink::NetworkServiceParamsPtr>::Read(
    ::network::mojom::blink::NetworkServiceParams::DataView input,
    ::network::mojom::blink::NetworkServiceParamsPtr* output) {
  bool success = true;
  ::network::mojom::blink::NetworkServiceParamsPtr result(::network::mojom::blink::NetworkServiceParams::New());
  
      if (success && !input.ReadInitialConnectionType(&result->initial_connection_type))
        success = false;
      if (success && !input.ReadInitialConnectionSubtype(&result->initial_connection_subtype))
        success = false;
      if (success && !input.ReadEnvironment(&result->environment))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif