// services/network/public/mojom/network_service.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "services/network/public/mojom/network_service.mojom-shared.h"

#include <utility>

#include "base/stl_util.h"  // for base::size()
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/network/public/mojom/network_service.mojom-params-data.h"
namespace network {
namespace mojom {

namespace internal {


// static
bool LoadInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 56, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const LoadInfo_Data* object = static_cast<const LoadInfo_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->host, 3, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams host_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->host, validation_context,
                                         &host_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->state_param, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->state_param, validation_context))
    return false;

  return true;
}

LoadInfo_Data::LoadInfo_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool HttpAuthStaticParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const HttpAuthStaticParams_Data* object = static_cast<const HttpAuthStaticParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->supported_schemes, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams supported_schemes_validate_params(
      0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr));
  if (!mojo::internal::ValidateContainer(object->supported_schemes, validation_context,
                                         &supported_schemes_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->gssapi_library_name, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams gssapi_library_name_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->gssapi_library_name, validation_context,
                                         &gssapi_library_name_validate_params)) {
    return false;
  }

  return true;
}

HttpAuthStaticParams_Data::HttpAuthStaticParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool HttpAuthDynamicParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const HttpAuthDynamicParams_Data* object = static_cast<const HttpAuthDynamicParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->server_allowlist, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams server_allowlist_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->server_allowlist, validation_context,
                                         &server_allowlist_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->delegate_allowlist, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams delegate_allowlist_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->delegate_allowlist, validation_context,
                                         &delegate_allowlist_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->android_negotiate_account_type, 7, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams android_negotiate_account_type_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->android_negotiate_account_type, validation_context,
                                         &android_negotiate_account_type_validate_params)) {
    return false;
  }

  return true;
}

HttpAuthDynamicParams_Data::HttpAuthDynamicParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CryptConfig_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const CryptConfig_Data* object = static_cast<const CryptConfig_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->store, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams store_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->store, validation_context,
                                         &store_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->product_name, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams product_name_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->product_name, validation_context,
                                         &product_name_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->user_data_path, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->user_data_path, validation_context))
    return false;

  return true;
}

CryptConfig_Data::CryptConfig_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool EnvironmentVariable_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const EnvironmentVariable_Data* object = static_cast<const EnvironmentVariable_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->name, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams name_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->name, validation_context,
                                         &name_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->value, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams value_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->value, validation_context,
                                         &value_validate_params)) {
    return false;
  }

  return true;
}

EnvironmentVariable_Data::EnvironmentVariable_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkServiceParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const NetworkServiceParams_Data* object = static_cast<const NetworkServiceParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::network::mojom::internal::ConnectionType_Data
        ::Validate(object->initial_connection_type, validation_context))
    return false;


  if (!::network::mojom::internal::ConnectionSubtype_Data
        ::Validate(object->initial_connection_subtype, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->environment, 3, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams environment_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->environment, validation_context,
                                         &environment_validate_params)) {
    return false;
  }

  return true;
}

NetworkServiceParams_Data::NetworkServiceParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkServiceClient_OnLoadingStateUpdate_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const NetworkServiceClient_OnLoadingStateUpdate_Params_Data* object = static_cast<const NetworkServiceClient_OnLoadingStateUpdate_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->infos, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams infos_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->infos, validation_context,
                                         &infos_validate_params)) {
    return false;
  }

  return true;
}

NetworkServiceClient_OnLoadingStateUpdate_Params_Data::NetworkServiceClient_OnLoadingStateUpdate_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkServiceClient_OnLoadingStateUpdate_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const NetworkServiceClient_OnLoadingStateUpdate_ResponseParams_Data* object = static_cast<const NetworkServiceClient_OnLoadingStateUpdate_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

NetworkServiceClient_OnLoadingStateUpdate_ResponseParams_Data::NetworkServiceClient_OnLoadingStateUpdate_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkServiceClient_OnDataUseUpdate_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const NetworkServiceClient_OnDataUseUpdate_Params_Data* object = static_cast<const NetworkServiceClient_OnDataUseUpdate_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

NetworkServiceClient_OnDataUseUpdate_Params_Data::NetworkServiceClient_OnDataUseUpdate_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkServiceClient_OnRawRequest_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 48, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const NetworkServiceClient_OnRawRequest_Params_Data* object = static_cast<const NetworkServiceClient_OnRawRequest_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->devtool_request_id, 3, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams devtool_request_id_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->devtool_request_id, validation_context,
                                         &devtool_request_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->cookies_with_access_result, 4, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams cookies_with_access_result_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->cookies_with_access_result, validation_context,
                                         &cookies_with_access_result_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->headers, 5, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams headers_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->headers, validation_context,
                                         &headers_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->client_security_state, validation_context))
    return false;

  return true;
}

NetworkServiceClient_OnRawRequest_Params_Data::NetworkServiceClient_OnRawRequest_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkServiceClient_OnRawResponse_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 56, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const NetworkServiceClient_OnRawResponse_Params_Data* object = static_cast<const NetworkServiceClient_OnRawResponse_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->devtool_request_id, 3, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams devtool_request_id_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->devtool_request_id, validation_context,
                                         &devtool_request_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->cookies_with_access_result, 4, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams cookies_with_access_result_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->cookies_with_access_result, validation_context,
                                         &cookies_with_access_result_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->headers, 5, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams headers_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->headers, validation_context,
                                         &headers_validate_params)) {
    return false;
  }

  const mojo::internal::ContainerValidateParams raw_response_headers_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->raw_response_headers, validation_context,
                                         &raw_response_headers_validate_params)) {
    return false;
  }


  if (!::network::mojom::internal::IPAddressSpace_Data
        ::Validate(object->resource_address_space, validation_context))
    return false;

  return true;
}

NetworkServiceClient_OnRawResponse_Params_Data::NetworkServiceClient_OnRawResponse_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkServiceClient_OnPrivateNetworkRequest_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 48, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const NetworkServiceClient_OnPrivateNetworkRequest_Params_Data* object = static_cast<const NetworkServiceClient_OnPrivateNetworkRequest_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  const mojo::internal::ContainerValidateParams devtool_request_id_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->devtool_request_id, validation_context,
                                         &devtool_request_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;


  if (!::network::mojom::internal::IPAddressSpace_Data
        ::Validate(object->resource_address_space, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->client_security_state, 7, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->client_security_state, validation_context))
    return false;

  return true;
}

NetworkServiceClient_OnPrivateNetworkRequest_Params_Data::NetworkServiceClient_OnPrivateNetworkRequest_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkServiceClient_OnCorsPreflightRequest_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 48, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const NetworkServiceClient_OnCorsPreflightRequest_Params_Data* object = static_cast<const NetworkServiceClient_OnCorsPreflightRequest_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->devtool_request_id, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->devtool_request_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->request, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->request, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->initiator_url, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->initiator_url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->initiator_devtool_request_id, 6, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams initiator_devtool_request_id_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->initiator_devtool_request_id, validation_context,
                                         &initiator_devtool_request_id_validate_params)) {
    return false;
  }

  return true;
}

NetworkServiceClient_OnCorsPreflightRequest_Params_Data::NetworkServiceClient_OnCorsPreflightRequest_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkServiceClient_OnCorsPreflightResponse_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const NetworkServiceClient_OnCorsPreflightResponse_Params_Data* object = static_cast<const NetworkServiceClient_OnCorsPreflightResponse_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->devtool_request_id, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->devtool_request_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->head, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->head, validation_context))
    return false;

  return true;
}

NetworkServiceClient_OnCorsPreflightResponse_Params_Data::NetworkServiceClient_OnCorsPreflightResponse_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkServiceClient_OnCorsPreflightRequestCompleted_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const NetworkServiceClient_OnCorsPreflightRequestCompleted_Params_Data* object = static_cast<const NetworkServiceClient_OnCorsPreflightRequestCompleted_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->devtool_request_id, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->devtool_request_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->status, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->status, validation_context))
    return false;

  return true;
}

NetworkServiceClient_OnCorsPreflightRequestCompleted_Params_Data::NetworkServiceClient_OnCorsPreflightRequestCompleted_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkServiceClient_OnTrustTokenOperationDone_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const NetworkServiceClient_OnTrustTokenOperationDone_Params_Data* object = static_cast<const NetworkServiceClient_OnTrustTokenOperationDone_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->devtool_request_id, 3, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams devtool_request_id_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->devtool_request_id, validation_context,
                                         &devtool_request_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->result, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->result, validation_context))
    return false;

  return true;
}

NetworkServiceClient_OnTrustTokenOperationDone_Params_Data::NetworkServiceClient_OnTrustTokenOperationDone_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkService_SetClient_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const NetworkService_SetClient_Params_Data* object = static_cast<const NetworkService_SetClient_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->client, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->client,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->params, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->params, validation_context))
    return false;

  return true;
}

NetworkService_SetClient_Params_Data::NetworkService_SetClient_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkService_StartNetLog_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const NetworkService_StartNetLog_Params_Data* object = static_cast<const NetworkService_StartNetLog_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->file, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->file, validation_context))
    return false;


  if (!::network::mojom::internal::NetLogCaptureMode_Data
        ::Validate(object->capture_mode, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->constants, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->constants, validation_context))
    return false;

  return true;
}

NetworkService_StartNetLog_Params_Data::NetworkService_StartNetLog_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkService_AttachNetLogProxy_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const NetworkService_AttachNetLogProxy_Params_Data* object = static_cast<const NetworkService_AttachNetLogProxy_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->proxy_source, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->proxy_source,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->proxy_sink, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->proxy_sink,
                                                 validation_context)) {
    return false;
  }

  return true;
}

NetworkService_AttachNetLogProxy_Params_Data::NetworkService_AttachNetLogProxy_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkService_SetSSLKeyLogFile_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const NetworkService_SetSSLKeyLogFile_Params_Data* object = static_cast<const NetworkService_SetSSLKeyLogFile_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->file, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->file, validation_context))
    return false;

  return true;
}

NetworkService_SetSSLKeyLogFile_Params_Data::NetworkService_SetSSLKeyLogFile_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkService_CreateNetworkContext_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const NetworkService_CreateNetworkContext_Params_Data* object = static_cast<const NetworkService_CreateNetworkContext_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->context, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->context,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->params, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->params, validation_context))
    return false;

  return true;
}

NetworkService_CreateNetworkContext_Params_Data::NetworkService_CreateNetworkContext_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkService_ConfigureStubHostResolver_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const NetworkService_ConfigureStubHostResolver_Params_Data* object = static_cast<const NetworkService_ConfigureStubHostResolver_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::network::mojom::internal::SecureDnsMode_Data
        ::Validate(object->secure_dns_mode, validation_context))
    return false;

  const mojo::internal::ContainerValidateParams dns_over_https_servers_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->dns_over_https_servers, validation_context,
                                         &dns_over_https_servers_validate_params)) {
    return false;
  }

  return true;
}

NetworkService_ConfigureStubHostResolver_Params_Data::NetworkService_ConfigureStubHostResolver_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkService_DisableQuic_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const NetworkService_DisableQuic_Params_Data* object = static_cast<const NetworkService_DisableQuic_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

NetworkService_DisableQuic_Params_Data::NetworkService_DisableQuic_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkService_SetUpHttpAuth_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const NetworkService_SetUpHttpAuth_Params_Data* object = static_cast<const NetworkService_SetUpHttpAuth_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->http_auth_static_params, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->http_auth_static_params, validation_context))
    return false;

  return true;
}

NetworkService_SetUpHttpAuth_Params_Data::NetworkService_SetUpHttpAuth_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkService_ConfigureHttpAuthPrefs_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const NetworkService_ConfigureHttpAuthPrefs_Params_Data* object = static_cast<const NetworkService_ConfigureHttpAuthPrefs_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->http_auth_dynamic_params, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->http_auth_dynamic_params, validation_context))
    return false;

  return true;
}

NetworkService_ConfigureHttpAuthPrefs_Params_Data::NetworkService_ConfigureHttpAuthPrefs_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkService_SetRawHeadersAccess_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const NetworkService_SetRawHeadersAccess_Params_Data* object = static_cast<const NetworkService_SetRawHeadersAccess_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->origins, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams origins_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->origins, validation_context,
                                         &origins_validate_params)) {
    return false;
  }

  return true;
}

NetworkService_SetRawHeadersAccess_Params_Data::NetworkService_SetRawHeadersAccess_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkService_SetMaxConnectionsPerProxy_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const NetworkService_SetMaxConnectionsPerProxy_Params_Data* object = static_cast<const NetworkService_SetMaxConnectionsPerProxy_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

NetworkService_SetMaxConnectionsPerProxy_Params_Data::NetworkService_SetMaxConnectionsPerProxy_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkService_GetNetworkChangeManager_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const NetworkService_GetNetworkChangeManager_Params_Data* object = static_cast<const NetworkService_GetNetworkChangeManager_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->network_change_manager, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->network_change_manager,
                                                 validation_context)) {
    return false;
  }

  return true;
}

NetworkService_GetNetworkChangeManager_Params_Data::NetworkService_GetNetworkChangeManager_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkService_GetNetworkQualityEstimatorManager_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const NetworkService_GetNetworkQualityEstimatorManager_Params_Data* object = static_cast<const NetworkService_GetNetworkQualityEstimatorManager_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->receiver, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->receiver,
                                                 validation_context)) {
    return false;
  }

  return true;
}

NetworkService_GetNetworkQualityEstimatorManager_Params_Data::NetworkService_GetNetworkQualityEstimatorManager_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkService_GetDnsConfigChangeManager_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const NetworkService_GetDnsConfigChangeManager_Params_Data* object = static_cast<const NetworkService_GetDnsConfigChangeManager_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->receiver, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->receiver,
                                                 validation_context)) {
    return false;
  }

  return true;
}

NetworkService_GetDnsConfigChangeManager_Params_Data::NetworkService_GetDnsConfigChangeManager_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkService_GetTotalNetworkUsages_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const NetworkService_GetTotalNetworkUsages_Params_Data* object = static_cast<const NetworkService_GetTotalNetworkUsages_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

NetworkService_GetTotalNetworkUsages_Params_Data::NetworkService_GetTotalNetworkUsages_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkService_GetTotalNetworkUsages_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const NetworkService_GetTotalNetworkUsages_ResponseParams_Data* object = static_cast<const NetworkService_GetTotalNetworkUsages_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->total_network_usages, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams total_network_usages_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->total_network_usages, validation_context,
                                         &total_network_usages_validate_params)) {
    return false;
  }

  return true;
}

NetworkService_GetTotalNetworkUsages_ResponseParams_Data::NetworkService_GetTotalNetworkUsages_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkService_GetNetworkList_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const NetworkService_GetNetworkList_Params_Data* object = static_cast<const NetworkService_GetNetworkList_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

NetworkService_GetNetworkList_Params_Data::NetworkService_GetNetworkList_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkService_GetNetworkList_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const NetworkService_GetNetworkList_ResponseParams_Data* object = static_cast<const NetworkService_GetNetworkList_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  const mojo::internal::ContainerValidateParams networks_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->networks, validation_context,
                                         &networks_validate_params)) {
    return false;
  }

  return true;
}

NetworkService_GetNetworkList_ResponseParams_Data::NetworkService_GetNetworkList_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkService_UpdateCRLSet_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const NetworkService_UpdateCRLSet_Params_Data* object = static_cast<const NetworkService_UpdateCRLSet_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->crl_set, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->crl_set, validation_context))
    return false;

  return true;
}

NetworkService_UpdateCRLSet_Params_Data::NetworkService_UpdateCRLSet_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkService_UpdateCRLSet_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const NetworkService_UpdateCRLSet_ResponseParams_Data* object = static_cast<const NetworkService_UpdateCRLSet_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

NetworkService_UpdateCRLSet_ResponseParams_Data::NetworkService_UpdateCRLSet_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkService_OnCertDBChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const NetworkService_OnCertDBChanged_Params_Data* object = static_cast<const NetworkService_OnCertDBChanged_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

NetworkService_OnCertDBChanged_Params_Data::NetworkService_OnCertDBChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkService_SetCryptConfig_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const NetworkService_SetCryptConfig_Params_Data* object = static_cast<const NetworkService_SetCryptConfig_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->crypt_config, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->crypt_config, validation_context))
    return false;

  return true;
}

NetworkService_SetCryptConfig_Params_Data::NetworkService_SetCryptConfig_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkService_AddAllowedRequestInitiatorForPlugin_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const NetworkService_AddAllowedRequestInitiatorForPlugin_Params_Data* object = static_cast<const NetworkService_AddAllowedRequestInitiatorForPlugin_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->allowed_request_initiator, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->allowed_request_initiator, validation_context))
    return false;

  return true;
}

NetworkService_AddAllowedRequestInitiatorForPlugin_Params_Data::NetworkService_AddAllowedRequestInitiatorForPlugin_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkService_RemoveSecurityExceptionsForPlugin_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const NetworkService_RemoveSecurityExceptionsForPlugin_Params_Data* object = static_cast<const NetworkService_RemoveSecurityExceptionsForPlugin_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

NetworkService_RemoveSecurityExceptionsForPlugin_Params_Data::NetworkService_RemoveSecurityExceptionsForPlugin_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkService_OnMemoryPressure_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const NetworkService_OnMemoryPressure_Params_Data* object = static_cast<const NetworkService_OnMemoryPressure_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::mojo_base::mojom::internal::MemoryPressureLevel_Data
        ::Validate(object->memory_pressure_level, validation_context))
    return false;

  return true;
}

NetworkService_OnMemoryPressure_Params_Data::NetworkService_OnMemoryPressure_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkService_OnPeerToPeerConnectionsCountChange_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const NetworkService_OnPeerToPeerConnectionsCountChange_Params_Data* object = static_cast<const NetworkService_OnPeerToPeerConnectionsCountChange_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

NetworkService_OnPeerToPeerConnectionsCountChange_Params_Data::NetworkService_OnPeerToPeerConnectionsCountChange_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkService_SetEnvironment_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const NetworkService_SetEnvironment_Params_Data* object = static_cast<const NetworkService_SetEnvironment_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->environment, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams environment_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->environment, validation_context,
                                         &environment_validate_params)) {
    return false;
  }

  return true;
}

NetworkService_SetEnvironment_Params_Data::NetworkService_SetEnvironment_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkService_SetTrustTokenKeyCommitments_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const NetworkService_SetTrustTokenKeyCommitments_Params_Data* object = static_cast<const NetworkService_SetTrustTokenKeyCommitments_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->raw_commitments, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams raw_commitments_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->raw_commitments, validation_context,
                                         &raw_commitments_validate_params)) {
    return false;
  }

  return true;
}

NetworkService_SetTrustTokenKeyCommitments_Params_Data::NetworkService_SetTrustTokenKeyCommitments_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkService_SetTrustTokenKeyCommitments_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const NetworkService_SetTrustTokenKeyCommitments_ResponseParams_Data* object = static_cast<const NetworkService_SetTrustTokenKeyCommitments_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

NetworkService_SetTrustTokenKeyCommitments_ResponseParams_Data::NetworkService_SetTrustTokenKeyCommitments_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkService_ClearSCTAuditingCache_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const NetworkService_ClearSCTAuditingCache_Params_Data* object = static_cast<const NetworkService_ClearSCTAuditingCache_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

NetworkService_ClearSCTAuditingCache_Params_Data::NetworkService_ClearSCTAuditingCache_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkService_ConfigureSCTAuditing_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 48, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const NetworkService_ConfigureSCTAuditing_Params_Data* object = static_cast<const NetworkService_ConfigureSCTAuditing_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->report_uri, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->report_uri, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->traffic_annotation, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->traffic_annotation, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->factory, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->factory,
                                                 validation_context)) {
    return false;
  }

  return true;
}

NetworkService_ConfigureSCTAuditing_Params_Data::NetworkService_ConfigureSCTAuditing_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkService_BindTestInterface_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const NetworkService_BindTestInterface_Params_Data* object = static_cast<const NetworkService_BindTestInterface_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->receiver, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->receiver,
                                                 validation_context)) {
    return false;
  }

  return true;
}

NetworkService_BindTestInterface_Params_Data::NetworkService_BindTestInterface_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkService_SetPreloadedFirstPartySets_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const NetworkService_SetPreloadedFirstPartySets_Params_Data* object = static_cast<const NetworkService_SetPreloadedFirstPartySets_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->raw_sets, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams raw_sets_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->raw_sets, validation_context,
                                         &raw_sets_validate_params)) {
    return false;
  }

  return true;
}

NetworkService_SetPreloadedFirstPartySets_Params_Data::NetworkService_SetPreloadedFirstPartySets_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace network
