// services/network/public/mojom/network_service.mojom-test-utils.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif


#include "services/network/public/mojom/network_service.mojom-test-utils.h"

#include <utility>

#include "base/bind.h"
#include "base/run_loop.h"
#include "mojo/public/mojom/base/file.mojom.h"
#include "mojo/public/mojom/base/file_path.mojom.h"
#include "mojo/public/mojom/base/memory_pressure_level.mojom.h"
#include "mojo/public/mojom/base/read_only_buffer.mojom.h"
#include "mojo/public/mojom/base/string16.mojom.h"
#include "mojo/public/mojom/base/time.mojom.h"
#include "mojo/public/mojom/base/unguessable_token.mojom.h"
#include "mojo/public/mojom/base/values.mojom.h"
#include "services/network/public/mojom/cookie_manager.mojom.h"
#include "services/network/public/mojom/host_resolver.mojom.h"
#include "services/network/public/mojom/http_raw_headers.mojom.h"
#include "services/network/public/mojom/mutable_network_traffic_annotation_tag.mojom.h"
#include "services/network/public/mojom/net_log.mojom.h"
#include "services/network/public/mojom/network_change_manager.mojom.h"
#include "services/network/public/mojom/network_context.mojom.h"
#include "services/network/public/mojom/ip_address_space.mojom.h"
#include "services/network/public/mojom/network_interface.mojom.h"
#include "services/network/public/mojom/network_param.mojom.h"
#include "services/network/public/mojom/network_quality_estimator_manager.mojom.h"
#include "services/network/public/mojom/network_service_test.mojom.h"
#include "services/network/public/mojom/trust_tokens.mojom.h"
#include "services/network/public/mojom/url_loader.mojom.h"
#include "services/network/public/mojom/url_loader_factory.mojom.h"
#include "services/network/public/mojom/url_response_head.mojom.h"
#include "services/network/public/mojom/client_security_state.mojom.h"
#include "url/mojom/origin.mojom.h"
#include "url/mojom/url.mojom.h"


#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_NETWORK_SERVICE_MOJOM_JUMBO_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_NETWORK_SERVICE_MOJOM_JUMBO_H_
#include "components/content_settings/core/common/content_settings_param_traits.h"
#endif


namespace network {
namespace mojom {


void NetworkServiceClientInterceptorForTesting::OnLoadingStateUpdate(std::vector<LoadInfoPtr> infos, OnLoadingStateUpdateCallback callback) {
  GetForwardingInterface()->OnLoadingStateUpdate(std::move(infos), std::move(callback));
}
void NetworkServiceClientInterceptorForTesting::OnDataUseUpdate(int32_t network_traffic_annotation_id_hash, int64_t recv_bytes, int64_t sent_bytes) {
  GetForwardingInterface()->OnDataUseUpdate(std::move(network_traffic_annotation_id_hash), std::move(recv_bytes), std::move(sent_bytes));
}
void NetworkServiceClientInterceptorForTesting::OnRawRequest(int32_t process_id, int32_t routing_id, const std::string& devtool_request_id, const std::vector<::net::CookieWithAccessResult>& cookies_with_access_result, std::vector<::network::mojom::HttpRawHeaderPairPtr> headers, ::network::mojom::ClientSecurityStatePtr client_security_state) {
  GetForwardingInterface()->OnRawRequest(std::move(process_id), std::move(routing_id), std::move(devtool_request_id), std::move(cookies_with_access_result), std::move(headers), std::move(client_security_state));
}
void NetworkServiceClientInterceptorForTesting::OnRawResponse(int32_t process_id, int32_t routing_id, const std::string& devtool_request_id, const std::vector<::net::CookieAndLineWithAccessResult>& cookies_with_access_result, std::vector<::network::mojom::HttpRawHeaderPairPtr> headers, const base::Optional<std::string>& raw_response_headers, ::network::mojom::IPAddressSpace resource_address_space) {
  GetForwardingInterface()->OnRawResponse(std::move(process_id), std::move(routing_id), std::move(devtool_request_id), std::move(cookies_with_access_result), std::move(headers), std::move(raw_response_headers), std::move(resource_address_space));
}
void NetworkServiceClientInterceptorForTesting::OnPrivateNetworkRequest(int32_t process_id, int32_t routing_id, const base::Optional<std::string>& devtool_request_id, const ::GURL& url, bool is_warning, ::network::mojom::IPAddressSpace resource_address_space, ::network::mojom::ClientSecurityStatePtr client_security_state) {
  GetForwardingInterface()->OnPrivateNetworkRequest(std::move(process_id), std::move(routing_id), std::move(devtool_request_id), std::move(url), std::move(is_warning), std::move(resource_address_space), std::move(client_security_state));
}
void NetworkServiceClientInterceptorForTesting::OnCorsPreflightRequest(int32_t process_id, int32_t render_frame_id, const ::base::UnguessableToken& devtool_request_id, const ::network::ResourceRequest& request, const ::GURL& initiator_url, const std::string& initiator_devtool_request_id) {
  GetForwardingInterface()->OnCorsPreflightRequest(std::move(process_id), std::move(render_frame_id), std::move(devtool_request_id), std::move(request), std::move(initiator_url), std::move(initiator_devtool_request_id));
}
void NetworkServiceClientInterceptorForTesting::OnCorsPreflightResponse(int32_t process_id, int32_t render_frame_id, const ::base::UnguessableToken& devtool_request_id, const ::GURL& url, ::network::mojom::URLResponseHeadPtr head) {
  GetForwardingInterface()->OnCorsPreflightResponse(std::move(process_id), std::move(render_frame_id), std::move(devtool_request_id), std::move(url), std::move(head));
}
void NetworkServiceClientInterceptorForTesting::OnCorsPreflightRequestCompleted(int32_t process_id, int32_t render_frame_id, const ::base::UnguessableToken& devtool_request_id, const ::network::URLLoaderCompletionStatus& status) {
  GetForwardingInterface()->OnCorsPreflightRequestCompleted(std::move(process_id), std::move(render_frame_id), std::move(devtool_request_id), std::move(status));
}
void NetworkServiceClientInterceptorForTesting::OnTrustTokenOperationDone(int32_t process_id, int32_t routing_id, const std::string& devtool_request_id, ::network::mojom::TrustTokenOperationResultPtr result) {
  GetForwardingInterface()->OnTrustTokenOperationDone(std::move(process_id), std::move(routing_id), std::move(devtool_request_id), std::move(result));
}
NetworkServiceClientAsyncWaiter::NetworkServiceClientAsyncWaiter(
    NetworkServiceClient* proxy) : proxy_(proxy) {}

NetworkServiceClientAsyncWaiter::~NetworkServiceClientAsyncWaiter() = default;

void NetworkServiceClientAsyncWaiter::OnLoadingStateUpdate(
    std::vector<LoadInfoPtr> infos) {
  base::RunLoop loop;
  proxy_->OnLoadingStateUpdate(std::move(infos),
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}



void NetworkServiceInterceptorForTesting::SetClient(::mojo::PendingRemote<NetworkServiceClient> client, NetworkServiceParamsPtr params) {
  GetForwardingInterface()->SetClient(std::move(client), std::move(params));
}
void NetworkServiceInterceptorForTesting::StartNetLog(::base::File file, ::net::NetLogCaptureMode capture_mode, ::base::Value constants) {
  GetForwardingInterface()->StartNetLog(std::move(file), std::move(capture_mode), std::move(constants));
}
void NetworkServiceInterceptorForTesting::AttachNetLogProxy(::mojo::PendingRemote<::network::mojom::NetLogProxySource> proxy_source, ::mojo::PendingReceiver<::network::mojom::NetLogProxySink> proxy_sink) {
  GetForwardingInterface()->AttachNetLogProxy(std::move(proxy_source), std::move(proxy_sink));
}
void NetworkServiceInterceptorForTesting::SetSSLKeyLogFile(::base::File file) {
  GetForwardingInterface()->SetSSLKeyLogFile(std::move(file));
}
void NetworkServiceInterceptorForTesting::CreateNetworkContext(::mojo::PendingReceiver<::network::mojom::NetworkContext> context, ::network::mojom::NetworkContextParamsPtr params) {
  GetForwardingInterface()->CreateNetworkContext(std::move(context), std::move(params));
}
void NetworkServiceInterceptorForTesting::ConfigureStubHostResolver(bool insecure_dns_client_enabled, ::net::SecureDnsMode secure_dns_mode, base::Optional<std::vector<::network::mojom::DnsOverHttpsServerPtr>> dns_over_https_servers) {
  GetForwardingInterface()->ConfigureStubHostResolver(std::move(insecure_dns_client_enabled), std::move(secure_dns_mode), std::move(dns_over_https_servers));
}
void NetworkServiceInterceptorForTesting::DisableQuic() {
  GetForwardingInterface()->DisableQuic();
}
void NetworkServiceInterceptorForTesting::SetUpHttpAuth(HttpAuthStaticParamsPtr http_auth_static_params) {
  GetForwardingInterface()->SetUpHttpAuth(std::move(http_auth_static_params));
}
void NetworkServiceInterceptorForTesting::ConfigureHttpAuthPrefs(HttpAuthDynamicParamsPtr http_auth_dynamic_params) {
  GetForwardingInterface()->ConfigureHttpAuthPrefs(std::move(http_auth_dynamic_params));
}
void NetworkServiceInterceptorForTesting::SetRawHeadersAccess(int32_t process_id, const std::vector<::url::Origin>& origins) {
  GetForwardingInterface()->SetRawHeadersAccess(std::move(process_id), std::move(origins));
}
void NetworkServiceInterceptorForTesting::SetMaxConnectionsPerProxy(int32_t max_connections) {
  GetForwardingInterface()->SetMaxConnectionsPerProxy(std::move(max_connections));
}
void NetworkServiceInterceptorForTesting::GetNetworkChangeManager(::mojo::PendingReceiver<::network::mojom::NetworkChangeManager> network_change_manager) {
  GetForwardingInterface()->GetNetworkChangeManager(std::move(network_change_manager));
}
void NetworkServiceInterceptorForTesting::GetNetworkQualityEstimatorManager(::mojo::PendingReceiver<::network::mojom::NetworkQualityEstimatorManager> receiver) {
  GetForwardingInterface()->GetNetworkQualityEstimatorManager(std::move(receiver));
}
void NetworkServiceInterceptorForTesting::GetDnsConfigChangeManager(::mojo::PendingReceiver<::network::mojom::DnsConfigChangeManager> receiver) {
  GetForwardingInterface()->GetDnsConfigChangeManager(std::move(receiver));
}
void NetworkServiceInterceptorForTesting::GetTotalNetworkUsages(GetTotalNetworkUsagesCallback callback) {
  GetForwardingInterface()->GetTotalNetworkUsages(std::move(callback));
}
void NetworkServiceInterceptorForTesting::GetNetworkList(uint32_t policy, GetNetworkListCallback callback) {
  GetForwardingInterface()->GetNetworkList(std::move(policy), std::move(callback));
}
void NetworkServiceInterceptorForTesting::UpdateCRLSet(::base::span<const ::uint8_t> crl_set, UpdateCRLSetCallback callback) {
  GetForwardingInterface()->UpdateCRLSet(std::move(crl_set), std::move(callback));
}
void NetworkServiceInterceptorForTesting::OnCertDBChanged() {
  GetForwardingInterface()->OnCertDBChanged();
}
void NetworkServiceInterceptorForTesting::SetCryptConfig(CryptConfigPtr crypt_config) {
  GetForwardingInterface()->SetCryptConfig(std::move(crypt_config));
}
void NetworkServiceInterceptorForTesting::AddAllowedRequestInitiatorForPlugin(int32_t process_id, const ::url::Origin& allowed_request_initiator) {
  GetForwardingInterface()->AddAllowedRequestInitiatorForPlugin(std::move(process_id), std::move(allowed_request_initiator));
}
void NetworkServiceInterceptorForTesting::RemoveSecurityExceptionsForPlugin(int32_t process_id) {
  GetForwardingInterface()->RemoveSecurityExceptionsForPlugin(std::move(process_id));
}
void NetworkServiceInterceptorForTesting::OnMemoryPressure(::base::MemoryPressureListener::MemoryPressureLevel memory_pressure_level) {
  GetForwardingInterface()->OnMemoryPressure(std::move(memory_pressure_level));
}
void NetworkServiceInterceptorForTesting::OnPeerToPeerConnectionsCountChange(uint32_t count) {
  GetForwardingInterface()->OnPeerToPeerConnectionsCountChange(std::move(count));
}
void NetworkServiceInterceptorForTesting::SetEnvironment(std::vector<EnvironmentVariablePtr> environment) {
  GetForwardingInterface()->SetEnvironment(std::move(environment));
}
void NetworkServiceInterceptorForTesting::SetTrustTokenKeyCommitments(const std::string& raw_commitments, SetTrustTokenKeyCommitmentsCallback callback) {
  GetForwardingInterface()->SetTrustTokenKeyCommitments(std::move(raw_commitments), std::move(callback));
}
void NetworkServiceInterceptorForTesting::ClearSCTAuditingCache() {
  GetForwardingInterface()->ClearSCTAuditingCache();
}
void NetworkServiceInterceptorForTesting::ConfigureSCTAuditing(bool enabled, double sampling_rate, const ::GURL& report_uri, const ::net::MutableNetworkTrafficAnnotationTag& traffic_annotation, ::mojo::PendingRemote<::network::mojom::URLLoaderFactory> factory) {
  GetForwardingInterface()->ConfigureSCTAuditing(std::move(enabled), std::move(sampling_rate), std::move(report_uri), std::move(traffic_annotation), std::move(factory));
}
void NetworkServiceInterceptorForTesting::BindTestInterface(::mojo::PendingReceiver<::network::mojom::NetworkServiceTest> receiver) {
  GetForwardingInterface()->BindTestInterface(std::move(receiver));
}
void NetworkServiceInterceptorForTesting::SetPreloadedFirstPartySets(const std::string& raw_sets) {
  GetForwardingInterface()->SetPreloadedFirstPartySets(std::move(raw_sets));
}
NetworkServiceAsyncWaiter::NetworkServiceAsyncWaiter(
    NetworkService* proxy) : proxy_(proxy) {}

NetworkServiceAsyncWaiter::~NetworkServiceAsyncWaiter() = default;

void NetworkServiceAsyncWaiter::GetTotalNetworkUsages(
    std::vector<::network::mojom::NetworkUsagePtr>* out_total_network_usages) {
  base::RunLoop loop;
  proxy_->GetTotalNetworkUsages(
      base::BindOnce(
          [](base::RunLoop* loop,
             std::vector<::network::mojom::NetworkUsagePtr>* out_total_network_usages
,
             std::vector<::network::mojom::NetworkUsagePtr> total_network_usages) {*out_total_network_usages = std::move(total_network_usages);
            loop->Quit();
          },
          &loop,
          out_total_network_usages));
  loop.Run();
}
void NetworkServiceAsyncWaiter::GetNetworkList(
    uint32_t policy, base::Optional<std::vector<::net::NetworkInterface>>* out_networks) {
  base::RunLoop loop;
  proxy_->GetNetworkList(std::move(policy),
      base::BindOnce(
          [](base::RunLoop* loop,
             base::Optional<std::vector<::net::NetworkInterface>>* out_networks
,
             const base::Optional<std::vector<::net::NetworkInterface>>& networks) {*out_networks = std::move(networks);
            loop->Quit();
          },
          &loop,
          out_networks));
  loop.Run();
}
void NetworkServiceAsyncWaiter::UpdateCRLSet(
    ::base::span<const ::uint8_t> crl_set) {
  base::RunLoop loop;
  proxy_->UpdateCRLSet(std::move(crl_set),
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}
void NetworkServiceAsyncWaiter::SetTrustTokenKeyCommitments(
    const std::string& raw_commitments) {
  base::RunLoop loop;
  proxy_->SetTrustTokenKeyCommitments(std::move(raw_commitments),
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}





}  // namespace mojom
}  // namespace network

#if defined(__clang__)
#pragma clang diagnostic pop
#endif