// services/network/public/mojom/quic_transport.mojom-blink-test-utils.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif


#include "services/network/public/mojom/quic_transport.mojom-blink-test-utils.h"

#include <utility>

#include "base/bind.h"
#include "base/run_loop.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"
#include "mojo/public/mojom/base/read_only_buffer.mojom-blink.h"
#include "mojo/public/mojom/base/time.mojom-blink.h"
#include "url/mojom/url.mojom-blink.h"


#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_QUIC_TRANSPORT_MOJOM_BLINK_JUMBO_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_QUIC_TRANSPORT_MOJOM_BLINK_JUMBO_H_
#endif


namespace network {
namespace mojom {
namespace blink {


void QuicTransportInterceptorForTesting::SendDatagram(::base::span<const ::uint8_t> data, SendDatagramCallback callback) {
  GetForwardingInterface()->SendDatagram(std::move(data), std::move(callback));
}
void QuicTransportInterceptorForTesting::CreateStream(::mojo::ScopedDataPipeConsumerHandle readable, ::mojo::ScopedDataPipeProducerHandle writable, CreateStreamCallback callback) {
  GetForwardingInterface()->CreateStream(std::move(readable), std::move(writable), std::move(callback));
}
void QuicTransportInterceptorForTesting::AcceptBidirectionalStream(AcceptBidirectionalStreamCallback callback) {
  GetForwardingInterface()->AcceptBidirectionalStream(std::move(callback));
}
void QuicTransportInterceptorForTesting::AcceptUnidirectionalStream(AcceptUnidirectionalStreamCallback callback) {
  GetForwardingInterface()->AcceptUnidirectionalStream(std::move(callback));
}
void QuicTransportInterceptorForTesting::SendFin(uint32_t stream_id) {
  GetForwardingInterface()->SendFin(std::move(stream_id));
}
void QuicTransportInterceptorForTesting::AbortStream(uint32_t stream_id, uint64_t code) {
  GetForwardingInterface()->AbortStream(std::move(stream_id), std::move(code));
}
void QuicTransportInterceptorForTesting::SetOutgoingDatagramExpirationDuration(::base::TimeDelta duration) {
  GetForwardingInterface()->SetOutgoingDatagramExpirationDuration(std::move(duration));
}
QuicTransportAsyncWaiter::QuicTransportAsyncWaiter(
    QuicTransport* proxy) : proxy_(proxy) {}

QuicTransportAsyncWaiter::~QuicTransportAsyncWaiter() = default;

void QuicTransportAsyncWaiter::SendDatagram(
    ::base::span<const ::uint8_t> data, bool* out_result) {
  base::RunLoop loop;
  proxy_->SendDatagram(std::move(data),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_result
,
             bool result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}
void QuicTransportAsyncWaiter::CreateStream(
    ::mojo::ScopedDataPipeConsumerHandle readable, ::mojo::ScopedDataPipeProducerHandle writable, bool* out_succeeded, uint32_t* out_stream_id) {
  base::RunLoop loop;
  proxy_->CreateStream(std::move(readable),std::move(writable),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_succeeded
,
             uint32_t* out_stream_id
,
             bool succeeded,
             uint32_t stream_id) {*out_succeeded = std::move(succeeded);*out_stream_id = std::move(stream_id);
            loop->Quit();
          },
          &loop,
          out_succeeded,
          out_stream_id));
  loop.Run();
}
void QuicTransportAsyncWaiter::AcceptBidirectionalStream(
    uint32_t* out_stream_id, ::mojo::ScopedDataPipeConsumerHandle* out_readable, ::mojo::ScopedDataPipeProducerHandle* out_writable) {
  base::RunLoop loop;
  proxy_->AcceptBidirectionalStream(
      base::BindOnce(
          [](base::RunLoop* loop,
             uint32_t* out_stream_id
,
             ::mojo::ScopedDataPipeConsumerHandle* out_readable
,
             ::mojo::ScopedDataPipeProducerHandle* out_writable
,
             uint32_t stream_id,
             ::mojo::ScopedDataPipeConsumerHandle readable,
             ::mojo::ScopedDataPipeProducerHandle writable) {*out_stream_id = std::move(stream_id);*out_readable = std::move(readable);*out_writable = std::move(writable);
            loop->Quit();
          },
          &loop,
          out_stream_id,
          out_readable,
          out_writable));
  loop.Run();
}
void QuicTransportAsyncWaiter::AcceptUnidirectionalStream(
    uint32_t* out_stream_id, ::mojo::ScopedDataPipeConsumerHandle* out_readable) {
  base::RunLoop loop;
  proxy_->AcceptUnidirectionalStream(
      base::BindOnce(
          [](base::RunLoop* loop,
             uint32_t* out_stream_id
,
             ::mojo::ScopedDataPipeConsumerHandle* out_readable
,
             uint32_t stream_id,
             ::mojo::ScopedDataPipeConsumerHandle readable) {*out_stream_id = std::move(stream_id);*out_readable = std::move(readable);
            loop->Quit();
          },
          &loop,
          out_stream_id,
          out_readable));
  loop.Run();
}



void QuicTransportClientInterceptorForTesting::OnDatagramReceived(::base::span<const ::uint8_t> data) {
  GetForwardingInterface()->OnDatagramReceived(std::move(data));
}
void QuicTransportClientInterceptorForTesting::OnIncomingStreamClosed(uint32_t stream_id, bool fin_received) {
  GetForwardingInterface()->OnIncomingStreamClosed(std::move(stream_id), std::move(fin_received));
}
QuicTransportClientAsyncWaiter::QuicTransportClientAsyncWaiter(
    QuicTransportClient* proxy) : proxy_(proxy) {}

QuicTransportClientAsyncWaiter::~QuicTransportClientAsyncWaiter() = default;




void QuicTransportHandshakeClientInterceptorForTesting::OnConnectionEstablished(::mojo::PendingRemote<QuicTransport> transport, ::mojo::PendingReceiver<QuicTransportClient> client) {
  GetForwardingInterface()->OnConnectionEstablished(std::move(transport), std::move(client));
}
void QuicTransportHandshakeClientInterceptorForTesting::OnHandshakeFailed(QuicTransportErrorPtr error) {
  GetForwardingInterface()->OnHandshakeFailed(std::move(error));
}
QuicTransportHandshakeClientAsyncWaiter::QuicTransportHandshakeClientAsyncWaiter(
    QuicTransportHandshakeClient* proxy) : proxy_(proxy) {}

QuicTransportHandshakeClientAsyncWaiter::~QuicTransportHandshakeClientAsyncWaiter() = default;






}  // namespace blink
}  // namespace mojom
}  // namespace network

#if defined(__clang__)
#pragma clang diagnostic pop
#endif