// services/network/public/mojom/quic_transport.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "services/network/public/mojom/quic_transport.mojom-shared.h"

#include <utility>

#include "base/stl_util.h"  // for base::size()
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/network/public/mojom/quic_transport.mojom-params-data.h"
namespace network {
namespace mojom {

namespace internal {


// static
bool QuicTransportError_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const QuicTransportError_Data* object = static_cast<const QuicTransportError_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->details, 3, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams details_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->details, validation_context,
                                         &details_validate_params)) {
    return false;
  }

  return true;
}

QuicTransportError_Data::QuicTransportError_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool QuicTransportCertificateFingerprint_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const QuicTransportCertificateFingerprint_Data* object = static_cast<const QuicTransportCertificateFingerprint_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->algorithm, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams algorithm_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->algorithm, validation_context,
                                         &algorithm_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->fingerprint, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams fingerprint_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->fingerprint, validation_context,
                                         &fingerprint_validate_params)) {
    return false;
  }

  return true;
}

QuicTransportCertificateFingerprint_Data::QuicTransportCertificateFingerprint_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool QuicTransport_SendDatagram_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const QuicTransport_SendDatagram_Params_Data* object = static_cast<const QuicTransport_SendDatagram_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->data, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->data, validation_context))
    return false;

  return true;
}

QuicTransport_SendDatagram_Params_Data::QuicTransport_SendDatagram_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool QuicTransport_SendDatagram_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const QuicTransport_SendDatagram_ResponseParams_Data* object = static_cast<const QuicTransport_SendDatagram_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

QuicTransport_SendDatagram_ResponseParams_Data::QuicTransport_SendDatagram_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool QuicTransport_CreateStream_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const QuicTransport_CreateStream_Params_Data* object = static_cast<const QuicTransport_CreateStream_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->readable, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->readable,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterface(object->writable,
                                                 validation_context)) {
    return false;
  }

  return true;
}

QuicTransport_CreateStream_Params_Data::QuicTransport_CreateStream_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool QuicTransport_CreateStream_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const QuicTransport_CreateStream_ResponseParams_Data* object = static_cast<const QuicTransport_CreateStream_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

QuicTransport_CreateStream_ResponseParams_Data::QuicTransport_CreateStream_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool QuicTransport_AcceptBidirectionalStream_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const QuicTransport_AcceptBidirectionalStream_Params_Data* object = static_cast<const QuicTransport_AcceptBidirectionalStream_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

QuicTransport_AcceptBidirectionalStream_Params_Data::QuicTransport_AcceptBidirectionalStream_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool QuicTransport_AcceptBidirectionalStream_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const QuicTransport_AcceptBidirectionalStream_ResponseParams_Data* object = static_cast<const QuicTransport_AcceptBidirectionalStream_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->readable, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->readable,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->writable, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->writable,
                                                 validation_context)) {
    return false;
  }

  return true;
}

QuicTransport_AcceptBidirectionalStream_ResponseParams_Data::QuicTransport_AcceptBidirectionalStream_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool QuicTransport_AcceptUnidirectionalStream_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const QuicTransport_AcceptUnidirectionalStream_Params_Data* object = static_cast<const QuicTransport_AcceptUnidirectionalStream_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

QuicTransport_AcceptUnidirectionalStream_Params_Data::QuicTransport_AcceptUnidirectionalStream_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool QuicTransport_AcceptUnidirectionalStream_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const QuicTransport_AcceptUnidirectionalStream_ResponseParams_Data* object = static_cast<const QuicTransport_AcceptUnidirectionalStream_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->readable, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->readable,
                                                 validation_context)) {
    return false;
  }

  return true;
}

QuicTransport_AcceptUnidirectionalStream_ResponseParams_Data::QuicTransport_AcceptUnidirectionalStream_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool QuicTransport_SendFin_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const QuicTransport_SendFin_Params_Data* object = static_cast<const QuicTransport_SendFin_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

QuicTransport_SendFin_Params_Data::QuicTransport_SendFin_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool QuicTransport_AbortStream_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const QuicTransport_AbortStream_Params_Data* object = static_cast<const QuicTransport_AbortStream_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

QuicTransport_AbortStream_Params_Data::QuicTransport_AbortStream_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool QuicTransport_SetOutgoingDatagramExpirationDuration_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const QuicTransport_SetOutgoingDatagramExpirationDuration_Params_Data* object = static_cast<const QuicTransport_SetOutgoingDatagramExpirationDuration_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->duration, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->duration, validation_context))
    return false;

  return true;
}

QuicTransport_SetOutgoingDatagramExpirationDuration_Params_Data::QuicTransport_SetOutgoingDatagramExpirationDuration_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool QuicTransportClient_OnDatagramReceived_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const QuicTransportClient_OnDatagramReceived_Params_Data* object = static_cast<const QuicTransportClient_OnDatagramReceived_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->data, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->data, validation_context))
    return false;

  return true;
}

QuicTransportClient_OnDatagramReceived_Params_Data::QuicTransportClient_OnDatagramReceived_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool QuicTransportClient_OnIncomingStreamClosed_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const QuicTransportClient_OnIncomingStreamClosed_Params_Data* object = static_cast<const QuicTransportClient_OnIncomingStreamClosed_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

QuicTransportClient_OnIncomingStreamClosed_Params_Data::QuicTransportClient_OnIncomingStreamClosed_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool QuicTransportHandshakeClient_OnConnectionEstablished_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const QuicTransportHandshakeClient_OnConnectionEstablished_Params_Data* object = static_cast<const QuicTransportHandshakeClient_OnConnectionEstablished_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->transport, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->transport,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->client, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->client,
                                                 validation_context)) {
    return false;
  }

  return true;
}

QuicTransportHandshakeClient_OnConnectionEstablished_Params_Data::QuicTransportHandshakeClient_OnConnectionEstablished_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool QuicTransportHandshakeClient_OnHandshakeFailed_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const QuicTransportHandshakeClient_OnHandshakeFailed_Params_Data* object = static_cast<const QuicTransportHandshakeClient_OnHandshakeFailed_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateStruct(object->error, validation_context))
    return false;

  return true;
}

QuicTransportHandshakeClient_OnHandshakeFailed_Params_Data::QuicTransportHandshakeClient_OnHandshakeFailed_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace network
