// services/network/public/mojom/quic_transport.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/network/public/mojom/quic_transport.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "services/network/public/mojom/quic_transport.mojom-params-data.h"
#include "services/network/public/mojom/quic_transport.mojom-shared-message-ids.h"

#include "services/network/public/mojom/quic_transport.mojom-import-headers.h"


#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_QUIC_TRANSPORT_MOJOM_JUMBO_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_QUIC_TRANSPORT_MOJOM_JUMBO_H_
#endif
namespace network {
namespace mojom {
QuicTransportError::QuicTransportError()
    : net_error(0),
      quic_error(0),
      details(),
      safe_to_report_details(false) {}

QuicTransportError::QuicTransportError(
    int32_t net_error_in,
    int32_t quic_error_in,
    const std::string& details_in,
    bool safe_to_report_details_in)
    : net_error(std::move(net_error_in)),
      quic_error(std::move(quic_error_in)),
      details(std::move(details_in)),
      safe_to_report_details(std::move(safe_to_report_details_in)) {}

QuicTransportError::~QuicTransportError() = default;

void QuicTransportError::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "net_error"), this->net_error, 
      "<value of type int32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "quic_error"), this->quic_error, 
      "<value of type int32_t>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "details"), this->details, 
      "<value of type const std::string&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "safe_to_report_details"), this->safe_to_report_details, 
      "<value of type bool>");
}

bool QuicTransportError::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
QuicTransportCertificateFingerprint::QuicTransportCertificateFingerprint()
    : algorithm(),
      fingerprint() {}

QuicTransportCertificateFingerprint::QuicTransportCertificateFingerprint(
    const std::string& algorithm_in,
    const std::string& fingerprint_in)
    : algorithm(std::move(algorithm_in)),
      fingerprint(std::move(fingerprint_in)) {}

QuicTransportCertificateFingerprint::~QuicTransportCertificateFingerprint() = default;
size_t QuicTransportCertificateFingerprint::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->algorithm);
  seed = mojo::internal::Hash(seed, this->fingerprint);
  return seed;
}

void QuicTransportCertificateFingerprint::WriteIntoTracedValue(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "algorithm"), this->algorithm, 
      "<value of type const std::string&>");
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "fingerprint"), this->fingerprint, 
      "<value of type const std::string&>");
}

bool QuicTransportCertificateFingerprint::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
const char QuicTransport::Name_[] = "network.mojom.QuicTransport";

class QuicTransport_SendDatagram_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  QuicTransport_SendDatagram_ForwardToCallback(
      QuicTransport::SendDatagramCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  QuicTransport::SendDatagramCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(QuicTransport_SendDatagram_ForwardToCallback);
};

class QuicTransport_CreateStream_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  QuicTransport_CreateStream_ForwardToCallback(
      QuicTransport::CreateStreamCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  QuicTransport::CreateStreamCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(QuicTransport_CreateStream_ForwardToCallback);
};

class QuicTransport_AcceptBidirectionalStream_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  QuicTransport_AcceptBidirectionalStream_ForwardToCallback(
      QuicTransport::AcceptBidirectionalStreamCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  QuicTransport::AcceptBidirectionalStreamCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(QuicTransport_AcceptBidirectionalStream_ForwardToCallback);
};

class QuicTransport_AcceptUnidirectionalStream_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  QuicTransport_AcceptUnidirectionalStream_ForwardToCallback(
      QuicTransport::AcceptUnidirectionalStreamCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  QuicTransport::AcceptUnidirectionalStreamCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(QuicTransport_AcceptUnidirectionalStream_ForwardToCallback);
};

QuicTransportProxy::QuicTransportProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void QuicTransportProxy::SendDatagram(
    ::base::span<const ::uint8_t> in_data, SendDatagramCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::QuicTransport::SendDatagram", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("data"), in_data, 
                        "<value of type ::base::span<const ::uint8_t>>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kQuicTransport_SendDatagram_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::QuicTransport_SendDatagram_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->data)::BaseType> data_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::ReadOnlyBufferDataView>(
      in_data, data_fragment);
  params->data.Set(
      data_fragment.is_null() ? nullptr : data_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->data.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null data in QuicTransport.SendDatagram request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(QuicTransport::Name_);
  message.set_method_name("SendDatagram");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new QuicTransport_SendDatagram_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void QuicTransportProxy::CreateStream(
    ::mojo::ScopedDataPipeConsumerHandle in_readable, ::mojo::ScopedDataPipeProducerHandle in_writable, CreateStreamCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::QuicTransport::CreateStream", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("readable"), in_readable, 
                        "<value of type ::mojo::ScopedDataPipeConsumerHandle>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("writable"), in_writable, 
                        "<value of type ::mojo::ScopedDataPipeProducerHandle>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kQuicTransport_CreateStream_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::QuicTransport_CreateStream_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::ScopedDataPipeConsumerHandle>(
      in_readable, &params->readable, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->readable),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid readable in QuicTransport.CreateStream request");
  mojo::internal::Serialize<mojo::ScopedDataPipeProducerHandle>(
      in_writable, &params->writable, &params.message());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(QuicTransport::Name_);
  message.set_method_name("CreateStream");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new QuicTransport_CreateStream_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void QuicTransportProxy::AcceptBidirectionalStream(
    AcceptBidirectionalStreamCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "network::mojom::QuicTransport::AcceptBidirectionalStream");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kQuicTransport_AcceptBidirectionalStream_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::QuicTransport_AcceptBidirectionalStream_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(QuicTransport::Name_);
  message.set_method_name("AcceptBidirectionalStream");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new QuicTransport_AcceptBidirectionalStream_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void QuicTransportProxy::AcceptUnidirectionalStream(
    AcceptUnidirectionalStreamCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "network::mojom::QuicTransport::AcceptUnidirectionalStream");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kQuicTransport_AcceptUnidirectionalStream_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::QuicTransport_AcceptUnidirectionalStream_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(QuicTransport::Name_);
  message.set_method_name("AcceptUnidirectionalStream");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new QuicTransport_AcceptUnidirectionalStream_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void QuicTransportProxy::SendFin(
    uint32_t in_stream_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::QuicTransport::SendFin", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("stream_id"), in_stream_id, 
                        "<value of type uint32_t>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kQuicTransport_SendFin_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::QuicTransport_SendFin_Params_Data> params(
          message);
  params.Allocate();
  params->stream_id = in_stream_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(QuicTransport::Name_);
  message.set_method_name("SendFin");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void QuicTransportProxy::AbortStream(
    uint32_t in_stream_id, uint64_t in_code) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::QuicTransport::AbortStream", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("stream_id"), in_stream_id, 
                        "<value of type uint32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("code"), in_code, 
                        "<value of type uint64_t>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kQuicTransport_AbortStream_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::QuicTransport_AbortStream_Params_Data> params(
          message);
  params.Allocate();
  params->stream_id = in_stream_id;
  params->code = in_code;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(QuicTransport::Name_);
  message.set_method_name("AbortStream");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void QuicTransportProxy::SetOutgoingDatagramExpirationDuration(
    ::base::TimeDelta in_duration) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::QuicTransport::SetOutgoingDatagramExpirationDuration", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("duration"), in_duration, 
                        "<value of type ::base::TimeDelta>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kQuicTransport_SetOutgoingDatagramExpirationDuration_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::QuicTransport_SetOutgoingDatagramExpirationDuration_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->duration)::BaseType> duration_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
      in_duration, duration_fragment);
  params->duration.Set(
      duration_fragment.is_null() ? nullptr : duration_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->duration.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null duration in QuicTransport.SetOutgoingDatagramExpirationDuration request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(QuicTransport::Name_);
  message.set_method_name("SetOutgoingDatagramExpirationDuration");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}
class QuicTransport_SendDatagram_ProxyToResponder {
 public:
  static QuicTransport::SendDatagramCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<QuicTransport_SendDatagram_ProxyToResponder> proxy(
        new QuicTransport_SendDatagram_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&QuicTransport_SendDatagram_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~QuicTransport_SendDatagram_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  QuicTransport_SendDatagram_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "QuicTransport::SendDatagramCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_result);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(QuicTransport_SendDatagram_ProxyToResponder);
};

bool QuicTransport_SendDatagram_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "network::mojom::QuicTransport::SendDatagramCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::QuicTransport_SendDatagram_ResponseParams_Data* params =
      reinterpret_cast<
          internal::QuicTransport_SendDatagram_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  bool p_result{};
  QuicTransport_SendDatagram_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_result = input_data_view.result();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        QuicTransport::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_result));
  return true;
}

void QuicTransport_SendDatagram_ProxyToResponder::Run(
    bool in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)network::mojom::QuicTransport::SendDatagramCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result, 
                        "<value of type bool>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kQuicTransport_SendDatagram_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::QuicTransport_SendDatagram_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->result = in_result;

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)network::mojom::QuicTransport::SendDatagramCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(QuicTransport::Name_);
  message.set_method_name("SendDatagram");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class QuicTransport_CreateStream_ProxyToResponder {
 public:
  static QuicTransport::CreateStreamCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<QuicTransport_CreateStream_ProxyToResponder> proxy(
        new QuicTransport_CreateStream_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&QuicTransport_CreateStream_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~QuicTransport_CreateStream_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  QuicTransport_CreateStream_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "QuicTransport::CreateStreamCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_succeeded, uint32_t in_stream_id);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(QuicTransport_CreateStream_ProxyToResponder);
};

bool QuicTransport_CreateStream_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "network::mojom::QuicTransport::CreateStreamCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::QuicTransport_CreateStream_ResponseParams_Data* params =
      reinterpret_cast<
          internal::QuicTransport_CreateStream_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  bool p_succeeded{};
  uint32_t p_stream_id{};
  QuicTransport_CreateStream_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_succeeded = input_data_view.succeeded();
  if (success)
    p_stream_id = input_data_view.stream_id();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        QuicTransport::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_succeeded), 
std::move(p_stream_id));
  return true;
}

void QuicTransport_CreateStream_ProxyToResponder::Run(
    bool in_succeeded, uint32_t in_stream_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)network::mojom::QuicTransport::CreateStreamCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("succeeded"), in_succeeded, 
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("stream_id"), in_stream_id, 
                        "<value of type uint32_t>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kQuicTransport_CreateStream_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::QuicTransport_CreateStream_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->succeeded = in_succeeded;
  params->stream_id = in_stream_id;

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)network::mojom::QuicTransport::CreateStreamCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(QuicTransport::Name_);
  message.set_method_name("CreateStream");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class QuicTransport_AcceptBidirectionalStream_ProxyToResponder {
 public:
  static QuicTransport::AcceptBidirectionalStreamCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<QuicTransport_AcceptBidirectionalStream_ProxyToResponder> proxy(
        new QuicTransport_AcceptBidirectionalStream_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&QuicTransport_AcceptBidirectionalStream_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~QuicTransport_AcceptBidirectionalStream_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  QuicTransport_AcceptBidirectionalStream_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "QuicTransport::AcceptBidirectionalStreamCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      uint32_t in_stream_id, ::mojo::ScopedDataPipeConsumerHandle in_readable, ::mojo::ScopedDataPipeProducerHandle in_writable);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(QuicTransport_AcceptBidirectionalStream_ProxyToResponder);
};

bool QuicTransport_AcceptBidirectionalStream_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "network::mojom::QuicTransport::AcceptBidirectionalStreamCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::QuicTransport_AcceptBidirectionalStream_ResponseParams_Data* params =
      reinterpret_cast<
          internal::QuicTransport_AcceptBidirectionalStream_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  uint32_t p_stream_id{};
  ::mojo::ScopedDataPipeConsumerHandle p_readable{};
  ::mojo::ScopedDataPipeProducerHandle p_writable{};
  QuicTransport_AcceptBidirectionalStream_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_stream_id = input_data_view.stream_id();
  if (success)
    p_readable = input_data_view.TakeReadable();
  if (success)
    p_writable = input_data_view.TakeWritable();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        QuicTransport::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_stream_id), 
std::move(p_readable), 
std::move(p_writable));
  return true;
}

void QuicTransport_AcceptBidirectionalStream_ProxyToResponder::Run(
    uint32_t in_stream_id, ::mojo::ScopedDataPipeConsumerHandle in_readable, ::mojo::ScopedDataPipeProducerHandle in_writable) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)network::mojom::QuicTransport::AcceptBidirectionalStreamCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("stream_id"), in_stream_id, 
                        "<value of type uint32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("readable"), in_readable, 
                        "<value of type ::mojo::ScopedDataPipeConsumerHandle>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("writable"), in_writable, 
                        "<value of type ::mojo::ScopedDataPipeProducerHandle>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kQuicTransport_AcceptBidirectionalStream_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::QuicTransport_AcceptBidirectionalStream_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->stream_id = in_stream_id;
  mojo::internal::Serialize<mojo::ScopedDataPipeConsumerHandle>(
      in_readable, &params->readable, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->readable),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid readable in ");
  mojo::internal::Serialize<mojo::ScopedDataPipeProducerHandle>(
      in_writable, &params->writable, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->writable),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid writable in ");

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)network::mojom::QuicTransport::AcceptBidirectionalStreamCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(QuicTransport::Name_);
  message.set_method_name("AcceptBidirectionalStream");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class QuicTransport_AcceptUnidirectionalStream_ProxyToResponder {
 public:
  static QuicTransport::AcceptUnidirectionalStreamCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<QuicTransport_AcceptUnidirectionalStream_ProxyToResponder> proxy(
        new QuicTransport_AcceptUnidirectionalStream_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&QuicTransport_AcceptUnidirectionalStream_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~QuicTransport_AcceptUnidirectionalStream_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  QuicTransport_AcceptUnidirectionalStream_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "QuicTransport::AcceptUnidirectionalStreamCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      uint32_t in_stream_id, ::mojo::ScopedDataPipeConsumerHandle in_readable);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(QuicTransport_AcceptUnidirectionalStream_ProxyToResponder);
};

bool QuicTransport_AcceptUnidirectionalStream_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "network::mojom::QuicTransport::AcceptUnidirectionalStreamCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::QuicTransport_AcceptUnidirectionalStream_ResponseParams_Data* params =
      reinterpret_cast<
          internal::QuicTransport_AcceptUnidirectionalStream_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  uint32_t p_stream_id{};
  ::mojo::ScopedDataPipeConsumerHandle p_readable{};
  QuicTransport_AcceptUnidirectionalStream_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_stream_id = input_data_view.stream_id();
  if (success)
    p_readable = input_data_view.TakeReadable();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        QuicTransport::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_stream_id), 
std::move(p_readable));
  return true;
}

void QuicTransport_AcceptUnidirectionalStream_ProxyToResponder::Run(
    uint32_t in_stream_id, ::mojo::ScopedDataPipeConsumerHandle in_readable) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)network::mojom::QuicTransport::AcceptUnidirectionalStreamCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("stream_id"), in_stream_id, 
                        "<value of type uint32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("readable"), in_readable, 
                        "<value of type ::mojo::ScopedDataPipeConsumerHandle>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kQuicTransport_AcceptUnidirectionalStream_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::QuicTransport_AcceptUnidirectionalStream_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->stream_id = in_stream_id;
  mojo::internal::Serialize<mojo::ScopedDataPipeConsumerHandle>(
      in_readable, &params->readable, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->readable),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid readable in ");

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)network::mojom::QuicTransport::AcceptUnidirectionalStreamCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(QuicTransport::Name_);
  message.set_method_name("AcceptUnidirectionalStream");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool QuicTransportStubDispatch::Accept(
    QuicTransport* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kQuicTransport_SendDatagram_Name: {
      break;
    }
    case internal::kQuicTransport_CreateStream_Name: {
      break;
    }
    case internal::kQuicTransport_AcceptBidirectionalStream_Name: {
      break;
    }
    case internal::kQuicTransport_AcceptUnidirectionalStream_Name: {
      break;
    }
    case internal::kQuicTransport_SendFin_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::QuicTransport::SendFin",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::QuicTransport::SendFin");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::QuicTransport_SendFin_Params_Data* params =
          reinterpret_cast<internal::QuicTransport_SendFin_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      uint32_t p_stream_id{};
      QuicTransport_SendFin_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_stream_id = input_data_view.stream_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            QuicTransport::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SendFin(
std::move(p_stream_id));
      return true;
    }
    case internal::kQuicTransport_AbortStream_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::QuicTransport::AbortStream",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::QuicTransport::AbortStream");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::QuicTransport_AbortStream_Params_Data* params =
          reinterpret_cast<internal::QuicTransport_AbortStream_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      uint32_t p_stream_id{};
      uint64_t p_code{};
      QuicTransport_AbortStream_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_stream_id = input_data_view.stream_id();
      if (success)
        p_code = input_data_view.code();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            QuicTransport::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AbortStream(
std::move(p_stream_id), 
std::move(p_code));
      return true;
    }
    case internal::kQuicTransport_SetOutgoingDatagramExpirationDuration_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::QuicTransport::SetOutgoingDatagramExpirationDuration",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::QuicTransport::SetOutgoingDatagramExpirationDuration");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::QuicTransport_SetOutgoingDatagramExpirationDuration_Params_Data* params =
          reinterpret_cast<internal::QuicTransport_SetOutgoingDatagramExpirationDuration_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::base::TimeDelta p_duration{};
      QuicTransport_SetOutgoingDatagramExpirationDuration_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadDuration(&p_duration))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            QuicTransport::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetOutgoingDatagramExpirationDuration(
std::move(p_duration));
      return true;
    }
  }
  return false;
}

// static
bool QuicTransportStubDispatch::AcceptWithResponder(
    QuicTransport* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kQuicTransport_SendDatagram_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::QuicTransport::SendDatagram",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::QuicTransport::SendDatagram");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::QuicTransport_SendDatagram_Params_Data* params =
          reinterpret_cast<
              internal::QuicTransport_SendDatagram_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::base::span<const ::uint8_t> p_data{};
      QuicTransport_SendDatagram_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadData(&p_data))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            QuicTransport::Name_, 0, false);
        return false;
      }
      QuicTransport::SendDatagramCallback callback =
          QuicTransport_SendDatagram_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SendDatagram(
std::move(p_data), std::move(callback));
      return true;
    }
    case internal::kQuicTransport_CreateStream_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::QuicTransport::CreateStream",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::QuicTransport::CreateStream");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::QuicTransport_CreateStream_Params_Data* params =
          reinterpret_cast<
              internal::QuicTransport_CreateStream_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::mojo::ScopedDataPipeConsumerHandle p_readable{};
      ::mojo::ScopedDataPipeProducerHandle p_writable{};
      QuicTransport_CreateStream_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_readable = input_data_view.TakeReadable();
      if (success)
        p_writable = input_data_view.TakeWritable();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            QuicTransport::Name_, 1, false);
        return false;
      }
      QuicTransport::CreateStreamCallback callback =
          QuicTransport_CreateStream_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateStream(
std::move(p_readable), 
std::move(p_writable), std::move(callback));
      return true;
    }
    case internal::kQuicTransport_AcceptBidirectionalStream_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::QuicTransport::AcceptBidirectionalStream",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::QuicTransport::AcceptBidirectionalStream");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::QuicTransport_AcceptBidirectionalStream_Params_Data* params =
          reinterpret_cast<
              internal::QuicTransport_AcceptBidirectionalStream_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      QuicTransport_AcceptBidirectionalStream_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            QuicTransport::Name_, 2, false);
        return false;
      }
      QuicTransport::AcceptBidirectionalStreamCallback callback =
          QuicTransport_AcceptBidirectionalStream_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AcceptBidirectionalStream(std::move(callback));
      return true;
    }
    case internal::kQuicTransport_AcceptUnidirectionalStream_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::QuicTransport::AcceptUnidirectionalStream",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::QuicTransport::AcceptUnidirectionalStream");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::QuicTransport_AcceptUnidirectionalStream_Params_Data* params =
          reinterpret_cast<
              internal::QuicTransport_AcceptUnidirectionalStream_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      QuicTransport_AcceptUnidirectionalStream_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            QuicTransport::Name_, 3, false);
        return false;
      }
      QuicTransport::AcceptUnidirectionalStreamCallback callback =
          QuicTransport_AcceptUnidirectionalStream_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AcceptUnidirectionalStream(std::move(callback));
      return true;
    }
    case internal::kQuicTransport_SendFin_Name: {
      break;
    }
    case internal::kQuicTransport_AbortStream_Name: {
      break;
    }
    case internal::kQuicTransport_SetOutgoingDatagramExpirationDuration_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kQuicTransportValidationInfo[] = {
    {internal::kQuicTransport_SendDatagram_Name,
     {&internal::QuicTransport_SendDatagram_Params_Data::Validate,
      &internal::QuicTransport_SendDatagram_ResponseParams_Data::Validate}},
    {internal::kQuicTransport_CreateStream_Name,
     {&internal::QuicTransport_CreateStream_Params_Data::Validate,
      &internal::QuicTransport_CreateStream_ResponseParams_Data::Validate}},
    {internal::kQuicTransport_AcceptBidirectionalStream_Name,
     {&internal::QuicTransport_AcceptBidirectionalStream_Params_Data::Validate,
      &internal::QuicTransport_AcceptBidirectionalStream_ResponseParams_Data::Validate}},
    {internal::kQuicTransport_AcceptUnidirectionalStream_Name,
     {&internal::QuicTransport_AcceptUnidirectionalStream_Params_Data::Validate,
      &internal::QuicTransport_AcceptUnidirectionalStream_ResponseParams_Data::Validate}},
    {internal::kQuicTransport_SendFin_Name,
     {&internal::QuicTransport_SendFin_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kQuicTransport_AbortStream_Name,
     {&internal::QuicTransport_AbortStream_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kQuicTransport_SetOutgoingDatagramExpirationDuration_Name,
     {&internal::QuicTransport_SetOutgoingDatagramExpirationDuration_Params_Data::Validate,
      nullptr /* no response */}},
};

bool QuicTransportRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::network::mojom::QuicTransport::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kQuicTransportValidationInfo);
}

bool QuicTransportResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::network::mojom::QuicTransport::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kQuicTransportValidationInfo);

}
const char QuicTransportClient::Name_[] = "network.mojom.QuicTransportClient";

QuicTransportClientProxy::QuicTransportClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void QuicTransportClientProxy::OnDatagramReceived(
    ::base::span<const ::uint8_t> in_data) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::QuicTransportClient::OnDatagramReceived", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("data"), in_data, 
                        "<value of type ::base::span<const ::uint8_t>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kQuicTransportClient_OnDatagramReceived_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::QuicTransportClient_OnDatagramReceived_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->data)::BaseType> data_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::ReadOnlyBufferDataView>(
      in_data, data_fragment);
  params->data.Set(
      data_fragment.is_null() ? nullptr : data_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->data.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null data in QuicTransportClient.OnDatagramReceived request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(QuicTransportClient::Name_);
  message.set_method_name("OnDatagramReceived");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void QuicTransportClientProxy::OnIncomingStreamClosed(
    uint32_t in_stream_id, bool in_fin_received) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::QuicTransportClient::OnIncomingStreamClosed", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("stream_id"), in_stream_id, 
                        "<value of type uint32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("fin_received"), in_fin_received, 
                        "<value of type bool>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kQuicTransportClient_OnIncomingStreamClosed_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::QuicTransportClient_OnIncomingStreamClosed_Params_Data> params(
          message);
  params.Allocate();
  params->stream_id = in_stream_id;
  params->fin_received = in_fin_received;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(QuicTransportClient::Name_);
  message.set_method_name("OnIncomingStreamClosed");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool QuicTransportClientStubDispatch::Accept(
    QuicTransportClient* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kQuicTransportClient_OnDatagramReceived_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::QuicTransportClient::OnDatagramReceived",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::QuicTransportClient::OnDatagramReceived");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::QuicTransportClient_OnDatagramReceived_Params_Data* params =
          reinterpret_cast<internal::QuicTransportClient_OnDatagramReceived_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::base::span<const ::uint8_t> p_data{};
      QuicTransportClient_OnDatagramReceived_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadData(&p_data))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            QuicTransportClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnDatagramReceived(
std::move(p_data));
      return true;
    }
    case internal::kQuicTransportClient_OnIncomingStreamClosed_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::QuicTransportClient::OnIncomingStreamClosed",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::QuicTransportClient::OnIncomingStreamClosed");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::QuicTransportClient_OnIncomingStreamClosed_Params_Data* params =
          reinterpret_cast<internal::QuicTransportClient_OnIncomingStreamClosed_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      uint32_t p_stream_id{};
      bool p_fin_received{};
      QuicTransportClient_OnIncomingStreamClosed_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_stream_id = input_data_view.stream_id();
      if (success)
        p_fin_received = input_data_view.fin_received();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            QuicTransportClient::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnIncomingStreamClosed(
std::move(p_stream_id), 
std::move(p_fin_received));
      return true;
    }
  }
  return false;
}

// static
bool QuicTransportClientStubDispatch::AcceptWithResponder(
    QuicTransportClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kQuicTransportClient_OnDatagramReceived_Name: {
      break;
    }
    case internal::kQuicTransportClient_OnIncomingStreamClosed_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kQuicTransportClientValidationInfo[] = {
    {internal::kQuicTransportClient_OnDatagramReceived_Name,
     {&internal::QuicTransportClient_OnDatagramReceived_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kQuicTransportClient_OnIncomingStreamClosed_Name,
     {&internal::QuicTransportClient_OnIncomingStreamClosed_Params_Data::Validate,
      nullptr /* no response */}},
};

bool QuicTransportClientRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::network::mojom::QuicTransportClient::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kQuicTransportClientValidationInfo);
}

const char QuicTransportHandshakeClient::Name_[] = "network.mojom.QuicTransportHandshakeClient";

QuicTransportHandshakeClientProxy::QuicTransportHandshakeClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void QuicTransportHandshakeClientProxy::OnConnectionEstablished(
    ::mojo::PendingRemote<QuicTransport> in_transport, ::mojo::PendingReceiver<QuicTransportClient> in_client) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::QuicTransportHandshakeClient::OnConnectionEstablished", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("transport"), in_transport, 
                        "<value of type ::mojo::PendingRemote<QuicTransport>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client"), in_client, 
                        "<value of type ::mojo::PendingReceiver<QuicTransportClient>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kQuicTransportHandshakeClient_OnConnectionEstablished_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::QuicTransportHandshakeClient_OnConnectionEstablished_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::network::mojom::QuicTransportInterfaceBase>>(
      in_transport, &params->transport, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->transport),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid transport in QuicTransportHandshakeClient.OnConnectionEstablished request");
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::network::mojom::QuicTransportClientInterfaceBase>>(
      in_client, &params->client, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->client),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid client in QuicTransportHandshakeClient.OnConnectionEstablished request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(QuicTransportHandshakeClient::Name_);
  message.set_method_name("OnConnectionEstablished");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void QuicTransportHandshakeClientProxy::OnHandshakeFailed(
    const base::Optional<::net::QuicTransportError>& in_error) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::QuicTransportHandshakeClient::OnHandshakeFailed", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), in_error, 
                        "<value of type const base::Optional<::net::QuicTransportError>&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kQuicTransportHandshakeClient_OnHandshakeFailed_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::QuicTransportHandshakeClient_OnHandshakeFailed_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->error)::BaseType> error_fragment(
          params.message());
  mojo::internal::Serialize<::network::mojom::QuicTransportErrorDataView>(
      in_error, error_fragment);
  params->error.Set(
      error_fragment.is_null() ? nullptr : error_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(QuicTransportHandshakeClient::Name_);
  message.set_method_name("OnHandshakeFailed");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool QuicTransportHandshakeClientStubDispatch::Accept(
    QuicTransportHandshakeClient* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kQuicTransportHandshakeClient_OnConnectionEstablished_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::QuicTransportHandshakeClient::OnConnectionEstablished",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::QuicTransportHandshakeClient::OnConnectionEstablished");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::QuicTransportHandshakeClient_OnConnectionEstablished_Params_Data* params =
          reinterpret_cast<internal::QuicTransportHandshakeClient_OnConnectionEstablished_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingRemote<QuicTransport> p_transport{};
      ::mojo::PendingReceiver<QuicTransportClient> p_client{};
      QuicTransportHandshakeClient_OnConnectionEstablished_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_transport =
            input_data_view.TakeTransport<decltype(p_transport)>();
      }
      if (success) {
        p_client =
            input_data_view.TakeClient<decltype(p_client)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            QuicTransportHandshakeClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnConnectionEstablished(
std::move(p_transport), 
std::move(p_client));
      return true;
    }
    case internal::kQuicTransportHandshakeClient_OnHandshakeFailed_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::QuicTransportHandshakeClient::OnHandshakeFailed",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::QuicTransportHandshakeClient::OnHandshakeFailed");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::QuicTransportHandshakeClient_OnHandshakeFailed_Params_Data* params =
          reinterpret_cast<internal::QuicTransportHandshakeClient_OnHandshakeFailed_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      base::Optional<::net::QuicTransportError> p_error{};
      QuicTransportHandshakeClient_OnHandshakeFailed_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadError(&p_error))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            QuicTransportHandshakeClient::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnHandshakeFailed(
std::move(p_error));
      return true;
    }
  }
  return false;
}

// static
bool QuicTransportHandshakeClientStubDispatch::AcceptWithResponder(
    QuicTransportHandshakeClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kQuicTransportHandshakeClient_OnConnectionEstablished_Name: {
      break;
    }
    case internal::kQuicTransportHandshakeClient_OnHandshakeFailed_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kQuicTransportHandshakeClientValidationInfo[] = {
    {internal::kQuicTransportHandshakeClient_OnConnectionEstablished_Name,
     {&internal::QuicTransportHandshakeClient_OnConnectionEstablished_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kQuicTransportHandshakeClient_OnHandshakeFailed_Name,
     {&internal::QuicTransportHandshakeClient_OnHandshakeFailed_Params_Data::Validate,
      nullptr /* no response */}},
};

bool QuicTransportHandshakeClientRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::network::mojom::QuicTransportHandshakeClient::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kQuicTransportHandshakeClientValidationInfo);
}

}  // namespace mojom
}  // namespace network

namespace mojo {


// static
bool StructTraits<::network::mojom::QuicTransportError::DataView, ::network::mojom::QuicTransportErrorPtr>::Read(
    ::network::mojom::QuicTransportError::DataView input,
    ::network::mojom::QuicTransportErrorPtr* output) {
  bool success = true;
  ::network::mojom::QuicTransportErrorPtr result(::network::mojom::QuicTransportError::New());
  
      if (success)
        result->net_error = input.net_error();
      if (success)
        result->quic_error = input.quic_error();
      if (success && !input.ReadDetails(&result->details))
        success = false;
      if (success)
        result->safe_to_report_details = input.safe_to_report_details();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::QuicTransportCertificateFingerprint::DataView, ::network::mojom::QuicTransportCertificateFingerprintPtr>::Read(
    ::network::mojom::QuicTransportCertificateFingerprint::DataView input,
    ::network::mojom::QuicTransportCertificateFingerprintPtr* output) {
  bool success = true;
  ::network::mojom::QuicTransportCertificateFingerprintPtr result(::network::mojom::QuicTransportCertificateFingerprint::New());
  
      if (success && !input.ReadAlgorithm(&result->algorithm))
        success = false;
      if (success && !input.ReadFingerprint(&result->fingerprint))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif