// services/network/public/mojom/referrer_policy.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "services/network/public/mojom/referrer_policy.mojom-shared.h"

#include <utility>

#include "base/stl_util.h"  // for base::size()
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/network/public/mojom/referrer_policy.mojom-params-data.h"
namespace network {
namespace mojom {

std::string ReferrerPolicyToString(ReferrerPolicy value) {
  switch(value) {
    case ReferrerPolicy::kAlways:
      return "ReferrerPolicy::kAlways";
    case ReferrerPolicy::kDefault:
      return "ReferrerPolicy::kDefault";
    case ReferrerPolicy::kNoReferrerWhenDowngrade:
      return "ReferrerPolicy::kNoReferrerWhenDowngrade";
    case ReferrerPolicy::kNever:
      return "ReferrerPolicy::kNever";
    case ReferrerPolicy::kOrigin:
      return "ReferrerPolicy::kOrigin";
    case ReferrerPolicy::kOriginWhenCrossOrigin:
      return "ReferrerPolicy::kOriginWhenCrossOrigin";
    case ReferrerPolicy::kStrictOriginWhenCrossOrigin:
      return "ReferrerPolicy::kStrictOriginWhenCrossOrigin";
    case ReferrerPolicy::kSameOrigin:
      return "ReferrerPolicy::kSameOrigin";
    case ReferrerPolicy::kStrictOrigin:
      return "ReferrerPolicy::kStrictOrigin";
    default:
      return base::StringPrintf("Unknown ReferrerPolicy value: %i", static_cast<int32_t>(value));
  }
}

std::ostream& operator<<(std::ostream& os, ReferrerPolicy value) {
  return os << ReferrerPolicyToString(value);
}

namespace internal {

}  // namespace internal
}  // namespace mojom
}  // namespace network

namespace perfetto {

// static
void TraceFormatTraits<::network::mojom::ReferrerPolicy>::WriteIntoTracedValue(
   perfetto::TracedValue context, ::network::mojom::ReferrerPolicy value) {
  return std::move(context).WriteString(::network::mojom::ReferrerPolicyToString(value));
}

} // namespace perfetto
